/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class FireworkUtil {
    private static final String KEY_FIREWORK_OWNER = "Heroes$FireworkCrossbowOwner";
    private static final String DISPENSED_FIREWORK_NAME = "Heroes$DispenserFirework";

    public static boolean fireworkWasDispensed(Firework firework) {
        FireworkMeta meta = firework.getFireworkMeta();
        return meta.hasDisplayName() && meta.getDisplayName().equals(DISPENSED_FIREWORK_NAME);
    }

    public static void setFireworkFromDispenser(ItemStack fireworkItemStack) {
        if (FireworkUtil.invalidFireworkItemStack(fireworkItemStack)) {
            return;
        }
        ItemMeta meta = fireworkItemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(DISPENSED_FIREWORK_NAME);
            fireworkItemStack.setItemMeta(meta);
        }
    }

    public static void setFireworkFromCrossbower(Firework firework, Player player) {
        firework.setMetadata(KEY_FIREWORK_OWNER, (MetadataValue)new FixedMetadataValue((Plugin)Heroes.getInstance(), (Object)player.getName()));
    }

    @Nullable
    public static String getFireworkCrossbowerName(Firework firework) {
        return firework.hasMetadata(KEY_FIREWORK_OWNER) ? ((MetadataValue)firework.getMetadata(KEY_FIREWORK_OWNER).get(0)).toString() : null;
    }

    public static boolean invalidFireworkItemStack(ItemStack fireworkItemStack) {
        return fireworkItemStack == null || fireworkItemStack.getType() != Material.FIREWORK_ROCKET || fireworkItemStack.getAmount() == 0;
    }

    private static String hideText(String input) {
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            builder.append('\u00a7').append(c);
        }
        return builder.toString();
    }

    private static String stripColor(String input) {
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (c == '\u00a7') continue;
            builder.append(c);
        }
        return builder.toString();
    }
}

