/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.util.RegionUtil;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FireBlockManager {
    private final Heroes plugin;
    private FireListener fireListener;
    private Set<Block> temporaryFireBlocks = new HashSet<Block>();

    public FireBlockManager(Heroes plugin) {
        this.plugin = plugin;
    }

    public void setBlocksOnFireIfAble(Iterable<Block> blocks) {
        for (Block block : blocks) {
            this.setBlockOnFireIfAble(block, 1.0, true);
        }
    }

    public void setBlocksOnFireIfAble(Iterable<Block> blocks, boolean validateCanPvP) {
        if (validateCanPvP) {
            for (Block block : blocks) {
                this.setBlockOnFireIfAble(block, 1.0, true);
            }
        } else {
            for (Block block : blocks) {
                this.setBlockOnFireIfAble(block, 1.0, false);
            }
        }
    }

    public void setBlocksOnFireIfAble(Iterable<Block> blocks, double lifetimePercentModifier) {
        for (Block block : blocks) {
            this.setBlockOnFireIfAble(block, lifetimePercentModifier, true);
        }
    }

    public void setBlocksOnFireIfAble(Iterable<Block> blocks, double lifetimePercentModifier, boolean validateCanPvP) {
        if (validateCanPvP) {
            for (Block block : blocks) {
                this.setBlockOnFireIfAble(block, lifetimePercentModifier, true);
            }
        } else {
            for (Block block : blocks) {
                this.setBlockOnFireIfAble(block, lifetimePercentModifier, false);
            }
        }
    }

    public void setBlockOnFireIfAble(Block block) {
        this.setBlockOnFireIfAble(block, 1.0, true);
    }

    public void setBlockOnFireIfAble(Block block, boolean validateCanPvP) {
        this.setBlockOnFireIfAble(block, 1.0, validateCanPvP);
    }

    public void setBlockOnFireIfAble(Block block, double lifetimePercentModifier) {
        this.setBlockOnFireIfAble(block, lifetimePercentModifier, true);
    }

    public void setBlockOnFireIfAble(Block block, double lifetimePercentModifier, boolean validateCanPvP) {
        if (block == null || block.getType() != Material.AIR) {
            return;
        }
        if (validateCanPvP && RegionUtil.IsNoPvPRegion(block.getLocation())) {
            return;
        }
        this.setBlockOnFire(block, lifetimePercentModifier);
    }

    private void setBlockOnFire(final Block block, double lifetimePercentModifier) {
        this.lazyLoadFireListener();
        block.setType(Material.FIRE);
        this.temporaryFireBlocks.add(block);
        int maxFireAge = 15;
        int ticksBeforeAgeCheck = 4;
        double fireAgeDecreaseChance = 3.33;
        double averageDurationTicks = 199.8;
        int burnTicks = (int)(199.8 * lifetimePercentModifier);
        new BukkitRunnable(){

            public void run() {
                FireBlockManager.this.temporaryFireBlocks.remove(block);
                if (block.getType() == Material.FIRE) {
                    block.setType(Material.AIR);
                }
            }
        }.runTaskLater((Plugin)Heroes.getInstance(), (long)burnTicks);
    }

    private void lazyLoadFireListener() {
        if (this.fireListener == null) {
            this.fireListener = new FireListener(this.plugin);
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this.fireListener, (Plugin)this.plugin);
        }
    }

    public class FireListener
    implements Listener {
        private final Heroes plugin;

        public FireListener(Heroes plugin) {
            this.plugin = plugin;
        }

        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void onEntityCombustByBlockEvent(EntityCombustByBlockEvent event) {
            if (!event.getEntityType().equals((Object)EntityType.DROPPED_ITEM) || FireBlockManager.this.temporaryFireBlocks.isEmpty()) {
                return;
            }
            Entity burningItem = event.getEntity();
            Block sourceBlock = event.getCombuster();
            if (sourceBlock == null) {
                sourceBlock = burningItem.getLocation().getBlock();
            }
            Block burningBlock = sourceBlock;
            boolean isNearAValidBlock = false;
            if (FireBlockManager.this.temporaryFireBlocks.contains(burningBlock)) {
                isNearAValidBlock = true;
            } else {
                for (BlockFace face : BlockFace.values()) {
                    if (face == BlockFace.SELF || !FireBlockManager.this.temporaryFireBlocks.contains(burningBlock = sourceBlock.getRelative(face))) continue;
                    isNearAValidBlock = true;
                    break;
                }
            }
            if (!isNearAValidBlock) {
                return;
            }
            if (burningItem instanceof Damageable) {
                Damageable burningItemWithHP = (Damageable)burningItem;
                burningItemWithHP.setHealth(burningItemWithHP.getMaxHealth());
            }
            burningItem.setFireTicks(-1);
            burningItem.setInvulnerable(true);
            event.setDuration(0);
            event.setCancelled(true);
        }
    }
}

