/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.util.MaterialUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public class EquipmentUtil {
    public static String getAreNotTrainedItemUseMessage(Hero hero, Material material, boolean offhand, boolean armor) {
        return EquipmentUtil.getAreNotTrainedItemUseMessage(hero, material, offhand, armor, Heroes.properties.notTrainedMessageIncludeRequiredClassLevels);
    }

    public static String getAreNotTrainedItemUseMessage(Hero hero, Material material, boolean offhand, boolean armor, boolean includeRequiredClassLevels) {
        String requiredClassLevelsString;
        String message = "You are not trained to use a " + ChatColor.ITALIC + MaterialUtil.getFriendlyName(material) + ChatColor.RESET + " in that slot.";
        if (includeRequiredClassLevels && EquipmentUtil.isAllowedItemLevelRestricted(hero, material, offhand, armor) && !"".equals(requiredClassLevelsString = EquipmentUtil.constructItemRequiredClassLevelsString(hero, material, offhand, armor))) {
            message = message + " Requires " + requiredClassLevelsString + "!";
        }
        return message;
    }

    public static String getCannotUseWeaponMessage(Hero hero, Material material) {
        return EquipmentUtil.getCannotUseWeaponMessage(hero, material, Heroes.properties.notTrainedMessageIncludeRequiredClassLevels);
    }

    public static String getCannotUseWeaponMessage(Hero hero, Material material, boolean includeRequiredClassLevels) {
        String requiredClassLevelsString;
        String message = ChatColor.RED + hero.getName() + " cannot use weapon '" + MaterialUtil.getFriendlyName(material) + "'.";
        if (includeRequiredClassLevels && hero.isAllowedWeaponLevelRestricted(material) && !"".equals(requiredClassLevelsString = EquipmentUtil.constructItemRequiredClassLevelsString(hero, material, false, false))) {
            message = message + " Requires " + requiredClassLevelsString + "!";
        }
        return message;
    }

    public static String constructItemRequiredClassLevelsString(Hero hero, Material itemType, boolean offhand, boolean armor) {
        List<RequiredClassLevel> requiredClassLevels = EquipmentUtil.getItemRequiredClassLevels(hero, itemType, offhand, armor);
        if (requiredClassLevels.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean moreThanOne = requiredClassLevels.size() > 1;
        for (int i = 0; i < requiredClassLevels.size(); ++i) {
            RequiredClassLevel requiredClassLevel = requiredClassLevels.get(i);
            if (moreThanOne && i > 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append("Level ").append(requiredClassLevel.getLevel()).append(" ").append(requiredClassLevel.getHeroClass().getName());
        }
        return stringBuilder.toString();
    }

    public static List<RequiredClassLevel> getItemRequiredClassLevels(Hero hero, Material itemType, boolean offhand, boolean armor) {
        ArrayList<RequiredClassLevel> requiredClassLevels = new ArrayList<RequiredClassLevel>(3);
        if (!EquipmentUtil.isAllowedItemLevelRestricted(hero, itemType, offhand, armor)) {
            return requiredClassLevels;
        }
        ArrayList<HeroClass> heroClasses = new ArrayList<HeroClass>(3);
        heroClasses.add(hero.getHeroClass());
        heroClasses.add(hero.getSecondaryClass());
        heroClasses.add(hero.getRaceClass());
        for (HeroClass heroClass : heroClasses) {
            if (!EquipmentUtil.isAllowedItemLevelRestricted(hero, heroClass, itemType, offhand, armor) || EquipmentUtil.isAllowedItem(hero, heroClass, itemType, offhand, armor)) continue;
            int requiredLevel = EquipmentUtil.getAllowedItemLevel(hero, heroClass, itemType, offhand, armor);
            requiredClassLevels.add(new RequiredClassLevel(requiredLevel, heroClass));
        }
        return requiredClassLevels;
    }

    private static boolean isAllowedItemLevelRestricted(Hero hero, Material itemType, boolean offhand, boolean armor) {
        if (offhand) {
            return hero.isAllowedOffhandLevelRestricted(itemType);
        }
        if (armor) {
            return hero.isAllowedArmorLevelRestricted(itemType);
        }
        return hero.isAllowedWeaponLevelRestricted(itemType);
    }

    private static boolean isAllowedItemLevelRestricted(Hero hero, HeroClass heroClass, Material itemType, boolean offhand, boolean armor) {
        if (offhand) {
            return hero.isAllowedOffhandLevelRestricted(heroClass, itemType);
        }
        if (armor) {
            return hero.isAllowedArmorLevelRestricted(heroClass, itemType);
        }
        return hero.isAllowedWeaponLevelRestricted(heroClass, itemType);
    }

    private static boolean isAllowedItem(Hero hero, HeroClass heroClass, Material itemType, boolean offhand, boolean armor) {
        if (offhand) {
            return hero.isAllowedOffhand(heroClass, itemType);
        }
        if (armor) {
            return hero.isAllowedArmor(heroClass, itemType);
        }
        return hero.isAllowedWeapon(heroClass, itemType);
    }

    private static int getAllowedItemLevel(Hero hero, HeroClass heroClass, Material itemType, boolean offhand, boolean armor) {
        if (offhand) {
            return hero.getAllowedOffhandLevel(heroClass, itemType);
        }
        if (armor) {
            return hero.getAllowedArmorLevel(heroClass, itemType);
        }
        return hero.getAllowedWeaponLevel(heroClass, itemType);
    }

    public static class RequiredClassLevel {
        private int requiredLevel;
        private HeroClass heroClass;

        public RequiredClassLevel(int requiredLevel, HeroClass heroClass) {
            this.requiredLevel = requiredLevel;
            this.heroClass = heroClass;
        }

        public int getLevel() {
            return this.requiredLevel;
        }

        public HeroClass getHeroClass() {
            return this.heroClass;
        }
    }
}

