/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClassManager;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.util.Properties;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    protected final Heroes plugin;
    protected static File classConfigFolder;
    protected static File expConfigFile;
    protected static File damageConfigFile;
    protected static File recipesConfigFile;
    protected static File storageConfigFile;
    protected static File standardEffectsConfigFile;
    protected static File databaseConfigFile;
    private static Configuration damageConfig;
    private static Configuration expConfig;
    private static Configuration standardEffectsConfig;
    private static Configuration databaseConfig;

    public ConfigManager(Heroes plugin) {
        this.plugin = plugin;
        File dataFolder = plugin.getDataFolder();
        classConfigFolder = new File(dataFolder + File.separator + "classes");
        expConfigFile = new File(dataFolder, "experience.yml");
        damageConfigFile = new File(dataFolder, "damages.yml");
        recipesConfigFile = new File(dataFolder, "recipes.yml");
        storageConfigFile = new File(dataFolder, "storage.yml");
        standardEffectsConfigFile = new File(dataFolder, "standard-effects.yml");
        databaseConfigFile = new File(dataFolder, "database.yml");
    }

    public void load() throws Exception {
        this.checkForConfig(expConfigFile);
        this.checkForConfig(damageConfigFile);
        this.checkForConfig(recipesConfigFile);
        this.checkForConfig(standardEffectsConfigFile);
        this.checkForConfig(databaseConfigFile);
        if (!classConfigFolder.exists()) {
            if (classConfigFolder.mkdirs()) {
                this.checkForConfig(new File(classConfigFolder, "admin.yml"));
                this.checkForConfig(new File(classConfigFolder, "citizen.yml"));
                this.checkForConfig(new File(classConfigFolder, "rogue.yml"));
                this.checkForConfig(new File(classConfigFolder, "cleric.yml"));
                this.checkForConfig(new File(classConfigFolder, "mage.yml"));
                this.checkForConfig(new File(classConfigFolder, "warrior.yml"));
                this.checkForConfig(new File(classConfigFolder, "crafter.yml"));
                this.checkForConfig(new File(classConfigFolder, "enchanter.yml"));
                this.checkForConfig(new File(classConfigFolder, "human.yml"));
                this.checkForConfig(new File(classConfigFolder, "elf.yml"));
                this.checkForConfig(new File(classConfigFolder, "orc.yml"));
                this.checkForConfig(new File(classConfigFolder, "dwarf.yml"));
                this.checkForConfig(new File(classConfigFolder, "ApprenticeMage.yml"));
                this.checkForConfig(new File(classConfigFolder, "MasterMage.yml"));
            } else {
                Heroes.log(Level.SEVERE, "Can't make plugin directories and files! Please fix file permissions!");
                this.plugin.onDisable();
            }
        }
        this.plugin.setSkillConfigs(new SkillConfigManager(this.plugin));
        this.plugin.getSkillConfigs().load();
    }

    public boolean loadManagers() {
        YamlConfiguration defConfig;
        damageConfig = YamlConfiguration.loadConfiguration((File)damageConfigFile);
        InputStream defConfigStream = this.plugin.getResource("defaults" + File.separator + "damages.yml");
        if (defConfigStream != null) {
            defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            damageConfig.setDefaults((Configuration)defConfig);
        }
        this.plugin.getDamageManager().load(damageConfig);
        expConfig = YamlConfiguration.loadConfiguration((File)expConfigFile);
        defConfigStream = this.plugin.getResource("defaults" + File.separator + "experience.yml");
        if (defConfigStream != null) {
            defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            expConfig.setDefaults((Configuration)defConfig);
        }
        this.loadExperience();
        Heroes.log(Level.INFO, "Skipped loading recipes as they are currently in development for 1.13.X and are disabled.");
        Properties.enableRecipes = false;
        standardEffectsConfig = YamlConfiguration.loadConfiguration((File)standardEffectsConfigFile);
        defConfigStream = this.plugin.getResource("defaults" + File.separator + "standard-effects.yml");
        if (defConfigStream != null) {
            defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            standardEffectsConfig.setDefaults((Configuration)defConfig);
        }
        this.loadStandardEffects();
        Heroes.log(Level.INFO, "---- Loading classes, expect verbose logging. ----");
        HeroClassManager heroClassManager = new HeroClassManager(this.plugin);
        if (!heroClassManager.loadClasses(classConfigFolder)) {
            return false;
        }
        databaseConfig = YamlConfiguration.loadConfiguration((File)databaseConfigFile);
        defConfigStream = this.plugin.getResource("defaults" + File.separator + "database.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig2 = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            databaseConfig.setDefaults((Configuration)defConfig2);
        }
        this.plugin.setClassManager(heroClassManager);
        return true;
    }

    public boolean reload() {
        try {
            this.plugin.getCharacterManager().shutdown();
            this.plugin.getSkillConfigs().reload();
            damageConfig = null;
            expConfig = null;
            standardEffectsConfig = null;
            this.plugin.setClassManager(null);
            this.plugin.reloadConfig();
            Heroes.properties.load(this.plugin);
            this.loadManagers();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                this.plugin.getCharacterManager().performSkillChecks(hero);
                hero.rebuildAttributes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Heroes.log(Level.SEVERE, "Critical error encountered while reloading. Disabling...");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            return false;
        }
        Heroes.log(Level.INFO, "Reloaded Configuration");
        return true;
    }

    public void checkForConfig(File config) {
        if (config.exists()) {
            return;
        }
        Heroes.log(Level.WARNING, "File " + config.getName() + " not found - generating defaults.");
        config.getParentFile().mkdir();
        try (InputStream src = ConfigManager.class.getResourceAsStream("/defaults/" + config.getName());){
            Files.copy(src, config.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadExperience() {
        this.loadKillingExp(expConfig.getConfigurationSection("killing"));
        Heroes.properties.miningExp = this.loadMaterialExperience(expConfig.getConfigurationSection("mining"));
        Heroes.properties.smeltingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("smelting"));
        Heroes.properties.farmingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("farming"));
        Heroes.properties.loggingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("logging"));
        Heroes.properties.craftingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("crafting"));
        Heroes.properties.buildingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("building"));
        Heroes.properties.fishingExp = expConfig.getDouble("fishing", 0.0);
        Heroes.properties.shearExp = expConfig.getDouble("shearing", 0.0);
        Heroes.properties.tameExp = expConfig.getDouble("taming", 0.0);
        Heroes.properties.breedingExp = expConfig.getDouble("breeding", 0.0);
        ConfigurationSection brewingExpSection = expConfig.getConfigurationSection("brewing");
        if (brewingExpSection != null) {
            Heroes.properties.brewingPotionExp = brewingExpSection.getDouble("potion", 0.0);
            Heroes.properties.brewingSplashPotionExp = brewingExpSection.getDouble("splash-potion", 0.0);
            Heroes.properties.brewingLingeringPotionExp = brewingExpSection.getDouble("lingering-potion", 0.0);
        } else {
            Heroes.properties.brewingPotionExp = 0.0;
            Heroes.properties.brewingSplashPotionExp = 0.0;
            Heroes.properties.brewingLingeringPotionExp = 0.0;
        }
    }

    private void loadKillingExp(ConfigurationSection section) {
        if (section == null) {
            Heroes.log(Level.WARNING, "No Experience Section Killing defined!");
            return;
        }
        Set keys = section.getKeys(false);
        boolean errored = false;
        if (keys != null && !keys.isEmpty()) {
            for (String item : keys) {
                try {
                    double exp = section.getDouble(item, 0.0);
                    if (item.equalsIgnoreCase("Player")) {
                        Heroes.properties.playerKillingExp = exp;
                        continue;
                    }
                    EntityType type = EntityType.valueOf((String)item.toUpperCase(Locale.ENGLISH));
                    if (type == null) {
                        throw new IllegalArgumentException();
                    }
                    Heroes.properties.creatureKillingExp.put(type, exp);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid creature type (" + item + ") found in experience.yml.");
                    errored = true;
                }
            }
        } else {
            Heroes.log(Level.WARNING, "No Experience Section Killing defined!");
        }
        if (errored) {
            Heroes.log(Level.WARNING, "Remember, creature-names are case-sensitive, and must be exactly the same as found in the defaults!");
        }
    }

    private Map<Material, Double> loadMaterialExperience(ConfigurationSection section) {
        HashMap<Material, Double> expMap = new HashMap<Material, Double>();
        if (section != null) {
            Set keys = section.getKeys(false);
            for (String item : keys) {
                double exp = section.getDouble(item, 0.0);
                Material type = Material.matchMaterial((String)item.toUpperCase());
                if (type != null) {
                    expMap.put(type, exp);
                    continue;
                }
                Heroes.log(Level.WARNING, "Invalid material type (" + item + ") found in experience.yml.");
            }
        }
        return expMap;
    }

    private void loadStandardEffects() {
        this.loadStandardBleedingEffect(standardEffectsConfig.getConfigurationSection("Bleeding"));
        this.loadStandardDeepWoundEffect(standardEffectsConfig.getConfigurationSection("DeepWound"));
        this.loadStandardSlownessEffect(standardEffectsConfig.getConfigurationSection("Slowness"));
        this.loadStandardSwiftnessEffect(standardEffectsConfig.getConfigurationSection("Swiftness"));
    }

    private void loadStandardBleedingEffect(ConfigurationSection section) {
        if (section != null) {
            Heroes.properties.standardEffectBleedingApplyText = this.processEffectText(section.getString("apply-text"));
            Heroes.properties.standardEffectBleedingRemoveText = this.processEffectText(section.getString("remove-text"));
            Heroes.properties.standardEffectBleedingMaxStacks = section.getInt("max-stacks");
            Heroes.properties.standardEffectBleedingDamagePerStack = section.getDouble("damage-per-stack");
            Heroes.properties.standardEffectBleedingPeriod = section.getLong("period");
            Heroes.properties.standardEffectBleedingParticleCount = section.getInt("particle-count");
        }
    }

    private void loadStandardDeepWoundEffect(ConfigurationSection section) {
        if (section != null) {
            Heroes.properties.standardEffectDeepWoundApplyText = this.processEffectText(section.getString("apply-text"));
            Heroes.properties.standardEffectDeepWoundRemoveText = this.processEffectText(section.getString("remove-text"));
            Heroes.properties.standardEffectDeepWoundPercentMaxHealthReduction = section.getDouble("percent-max-health-reduction");
        }
    }

    private void loadStandardSlownessEffect(ConfigurationSection section) {
        if (section != null) {
            Heroes.properties.standardEffectSlownessApplyText = this.processEffectText(section.getString("apply-text"));
            Heroes.properties.standardEffectSlownessRemoveText = this.processEffectText(section.getString("remove-text"));
        }
    }

    private void loadStandardSwiftnessEffect(ConfigurationSection section) {
        if (section != null) {
            Heroes.properties.standardEffectSwiftnessApplyText = this.processEffectText(section.getString("apply-text"));
            Heroes.properties.standardEffectSwiftnessRemoveText = this.processEffectText(section.getString("remove-text"));
        }
    }

    private String processEffectText(String text) {
        return text != null ? text.replace("%target%", "$1").replace("%applier%", "$2").replace("%skill%", "$3") : null;
    }
}

