/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.Hero;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class ArmorUtil {
    private static double INVALID_REDUCTION = -1.0;

    public static double getEnchantMitigation(LivingEntity entity, EntityDamageEvent.DamageCause cause) {
        if (entity == null) {
            return 0.0;
        }
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return 0.0;
        }
        return Enchant.getMitigation(Heroes.getInstance().getDamageManager(), cause, equipment);
    }

    public static double getCustomArmorMitigation(LivingEntity defender, EntityDamageEvent event) {
        return ArmorUtil.getCustomArmorMitigation(Heroes.getInstance(), defender, event);
    }

    public static double getCustomArmorMitigation(Heroes plugin, LivingEntity defender, EntityDamageEvent event) {
        Hero hero;
        double maximumDamageReduction = -1.0;
        double perArmorDamageReduction = -1.0;
        if (defender instanceof Player && (hero = plugin.getCharacterManager().getHero((Player)defender)).hasMitigationDamageCause(event.getCause())) {
            maximumDamageReduction = hero.getMaxDamageReduction();
            perArmorDamageReduction = hero.getPerArmorDamageReduction();
        }
        if (maximumDamageReduction == INVALID_REDUCTION && perArmorDamageReduction == INVALID_REDUCTION && ArmorUtil.isGlobalMitigationOverrideApplicableTo(event.getCause())) {
            maximumDamageReduction = Heroes.properties.maximumDamageReduction;
            perArmorDamageReduction = Heroes.properties.perArmorDamageReduction;
        }
        if (maximumDamageReduction == INVALID_REDUCTION && perArmorDamageReduction == INVALID_REDUCTION) {
            return 0.0;
        }
        double baseDamage = event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        double blockDamage = event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        return ArmorUtil.getCustomMitigation(defender, maximumDamageReduction, perArmorDamageReduction, baseDamage, blockDamage) * -1.0;
    }

    public static boolean isGlobalMitigationOverrideApplicableTo(EntityDamageEvent.DamageCause cause) {
        switch (cause) {
            case BLOCK_EXPLOSION: 
            case CONTACT: 
            case ENTITY_ATTACK: 
            case ENTITY_EXPLOSION: 
            case ENTITY_SWEEP_ATTACK: 
            case FALLING_BLOCK: 
            case FIRE: 
            case HOT_FLOOR: 
            case LAVA: 
            case LIGHTNING: 
            case PROJECTILE: {
                return true;
            }
        }
        return false;
    }

    private static double getCustomMitigation(LivingEntity defender, double maximumDamageReduction, double perArmorDamageReduction, double baseDamage) {
        return ArmorUtil.getCustomMitigation(defender, maximumDamageReduction, perArmorDamageReduction, baseDamage, 0.0);
    }

    private static double getCustomMitigation(LivingEntity defender, double maximumDamageReduction, double perArmorDamageReduction, double baseDamage, double blockDamage) {
        double armorPoints;
        AttributeInstance armorAttribute = defender.getAttribute(Attribute.GENERIC_ARMOR);
        double d = armorPoints = armorAttribute != null ? armorAttribute.getValue() : 0.0;
        if (armorPoints == 0.0) {
            return 0.0;
        }
        double mitigationPercent = Math.min(maximumDamageReduction, armorPoints * perArmorDamageReduction);
        return mitigationPercent * -(baseDamage + blockDamage);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Enchant {
        PROTECTION(Enchantment.PROTECTION_ENVIRONMENTAL){

            @Override
            public boolean appliesTo(EntityDamageEvent.DamageCause cause) {
                return true;
            }
        }
        ,
        FIRE_PROTECTION(Enchantment.PROTECTION_FIRE){

            @Override
            public boolean appliesTo(EntityDamageEvent.DamageCause cause) {
                return cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.LAVA || cause == EntityDamageEvent.DamageCause.HOT_FLOOR;
            }
        }
        ,
        BLAST_PROTECTION(Enchantment.PROTECTION_EXPLOSIONS){

            @Override
            public boolean appliesTo(EntityDamageEvent.DamageCause cause) {
                return cause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || cause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
            }
        }
        ,
        PROJECTILE_PROTECTION(Enchantment.PROTECTION_PROJECTILE){

            @Override
            public boolean appliesTo(EntityDamageEvent.DamageCause cause) {
                return cause == EntityDamageEvent.DamageCause.PROJECTILE;
            }
        }
        ,
        FEATHER_FALLING(Enchantment.PROTECTION_FALL){

            @Override
            public boolean appliesTo(EntityDamageEvent.DamageCause cause) {
                return cause == EntityDamageEvent.DamageCause.FALL;
            }
        };

        private static final Map<Enchantment, Enchant> enchantsByType;
        private final Enchantment enchantment;

        private Enchant(Enchantment enchantment) {
            this.enchantment = enchantment;
        }

        public Enchantment getEnchantment() {
            return this.enchantment;
        }

        public abstract boolean appliesTo(EntityDamageEvent.DamageCause var1);

        public static double getMitigation(CharacterDamageManager dm, EntityDamageEvent.DamageCause cause, ItemStack item) {
            if (item == null) {
                return 0.0;
            }
            double protectionFactor = 0.0;
            for (Map.Entry enchantment : item.getEnchantments().entrySet()) {
                Double enchantProtection;
                Enchant enchant;
                if (!enchantsByType.containsKey(enchantment.getKey()) || !(enchant = enchantsByType.get(enchantment.getKey())).appliesTo(cause) || (enchantProtection = dm.getEnchantmentProtection(enchant.enchantment)) == null) continue;
                protectionFactor += enchantProtection * (double)((Integer)enchantment.getValue()).intValue();
            }
            return protectionFactor;
        }

        public static double getMitigation(CharacterDamageManager dm, EntityDamageEvent.DamageCause cause, EntityEquipment equipment) {
            return Enchant.getMitigation(dm, cause, equipment.getHelmet()) + Enchant.getMitigation(dm, cause, equipment.getChestplate()) + Enchant.getMitigation(dm, cause, equipment.getLeggings()) + Enchant.getMitigation(dm, cause, equipment.getBoots());
        }

        static {
            enchantsByType = new HashMap<Enchantment, Enchant>();
            for (Enchant enchant : Enchant.values()) {
                enchantsByType.put(enchant.getEnchantment(), enchant);
            }
        }
    }
}

