/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.ui.scoreboard;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.feature.scoreboard.config.ScoreboardPartyConfig;
import com.herocraftonline.heroes.ui.HeroUIComponent;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class PartyComponent
extends HeroUIComponent
implements ManagedScoreboard.Component {
    public static PartyComponent SELF = new PartyComponent();
    public ScoreboardPartyConfig config;

    @Override
    public void render(Player player, List<String> rows) {
        if (!PartyComponent.has(player)) {
            return;
        }
        Hero hero = PartyComponent.get(player);
        if (hero.getParty() != null) {
            rows.add(this.config.title);
            int remainder = 6;
            for (Hero member : hero.getParty().getMembers()) {
                if (remainder-- < 0) break;
                int percentage = (int)(member.getPlayer().getHealth() / member.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * 100.0);
                ChatColor color = percentage >= 70 ? ChatColor.DARK_GREEN : (percentage >= 50 ? ChatColor.YELLOW : (percentage >= 30 ? ChatColor.GOLD : ChatColor.RED));
                rows.add(this.config.memberFormat.replace("{0}", member.getName()).replace("{1}", member.getPlayer().getDisplayName()).replace("{2}", String.valueOf(color)).replace("{3}", String.valueOf((int)member.getPlayer().getHealth() + " / " + (int)member.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())));
            }
        }
    }

    @Override
    public String getName() {
        return "Party";
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled;
    }
}

