/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.ui.scoreboard;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.feature.scoreboard.config.ScoreboardHeroInfoConfig;
import com.herocraftonline.heroes.ui.HeroUIComponent;
import com.herocraftonline.heroes.ui.UIUtil;
import java.util.List;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class HeroInfoComponent
extends HeroUIComponent
implements ManagedScoreboard.Component {
    public static HeroInfoComponent SELF = new HeroInfoComponent();
    public ScoreboardHeroInfoConfig config;

    @Override
    public boolean isEnabled() {
        return this.config.enabled;
    }

    @Override
    public void render(Player player, List<String> rows) {
        if (!HeroInfoComponent.has(player)) {
            return;
        }
        Hero hero = HeroInfoComponent.get(player);
        rows.add(this.config.title);
        if (this.config.classEnabled) {
            String classFormat = this.config.classFormatLong;
            boolean showPrimary = this.config.showPrimary;
            boolean showSecondary = this.config.showSecondary;
            boolean showRace = this.config.showRace;
            HeroClass primaryClass = hero.getHeroClass();
            HeroClass secondaryClass = hero.getSecondaryClass();
            HeroClass raceClass = hero.getRaceClass();
            if (showPrimary && primaryClass != null && primaryClass.getName().length() > this.config.classFormatLongLength || showSecondary && secondaryClass != null && secondaryClass.getName().length() > this.config.classFormatLongLength || showRace && raceClass != null && raceClass.getName().length() > this.config.classFormatLongLength) {
                classFormat = this.config.classFormatShort;
            }
            if (showPrimary && primaryClass != null) {
                rows.add(classFormat.replace("{0}", primaryClass.getName()).replace("{1}", String.valueOf(hero.getHeroLevel(primaryClass))).replace("{2}", UIUtil.formatExperiencePercentage(hero, primaryClass)));
            }
            if (showSecondary && secondaryClass != null) {
                rows.add(classFormat.replace("{0}", secondaryClass.getName()).replace("{1}", String.valueOf(hero.getHeroLevel(secondaryClass))).replace("{2}", UIUtil.formatExperiencePercentage(hero, secondaryClass)));
            }
            if (showRace && raceClass != null) {
                rows.add(classFormat.replace("{0}", raceClass.getName()).replace("{1}", String.valueOf(hero.getHeroLevel(raceClass))).replace("{2}", UIUtil.formatExperiencePercentage(hero, raceClass)));
            }
        }
        if (this.config.healthEnabled && this.config.manaEnabled) {
            String health = this.config.healthFormat.replace("{0}", String.valueOf((int)Math.ceil(player.getHealth()))).replace("{1}", String.valueOf((int)Math.ceil(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())));
            String mana = this.config.manaFormat.replace("{0}", String.valueOf(hero.getMana())).replace("{1}", String.valueOf(hero.getMaxMana()));
            if (this.config.mergeHealthAndManaWhenLow && player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() < (double)this.config.mergeHealthAndManaWhenLowThreshold) {
                rows.add(health + " " + mana);
            } else {
                rows.add(health);
                rows.add(mana);
            }
        } else {
            if (this.config.healthEnabled) {
                rows.add(this.config.healthFormat.replace("{0}", String.valueOf((int)Math.ceil(player.getHealth()))).replace("{1}", String.valueOf((int)Math.ceil(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()))));
            }
            if (this.config.manaEnabled) {
                rows.add(this.config.manaFormat.replace("{0}", String.valueOf(hero.getMana())).replace("{1}", String.valueOf(hero.getMaxMana())));
            }
        }
        if (this.config.staminaEnabled && this.config.shieldEnabled) {
            String stamina = this.config.staminaFormat.replace("{0}", String.valueOf(hero.getStamina())).replace("{1}", String.valueOf(hero.getMaxStamina()));
            String shield = this.config.shieldFormat.replace("{0}", String.valueOf((int)Math.ceil(hero.getShield()))).replace("{1}", String.valueOf(hero.getMaxShield()));
            if (this.config.mergeStaminaAndShieldWhenLow && hero.getMaxStamina() < this.config.mergeStaminaAndShieldWhenLowThreshold) {
                rows.add(stamina + " " + shield);
            } else {
                rows.add(stamina);
                rows.add(shield);
            }
        } else {
            if (this.config.staminaEnabled) {
                rows.add(this.config.staminaFormat.replace("{0}", String.valueOf(hero.getStamina())).replace("{1}", String.valueOf(hero.getMaxStamina())));
            }
            if (this.config.shieldEnabled) {
                rows.add(this.config.shieldFormat.replace("{0}", String.valueOf((int)Math.ceil(hero.getShield()))).replace("{1}", String.valueOf(hero.getMaxShield())));
            }
        }
    }

    @Override
    public String getName() {
        return "Hero Info";
    }
}

