/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.ui;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import org.bukkit.ChatColor;

public class UIUtil {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;

    public static String getCooldownName(String name) {
        switch (name.toLowerCase()) {
            case "arrowstorm": {
                return "Arrow Storm";
            }
            case "class-change": {
                return "Class Change";
            }
            case "prof-change": {
                return "Prof Change";
            }
            case "race-change": {
                return "Race Change";
            }
            case "reborn": {
                return "Reborn";
            }
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String formatExperiencePercentage(Hero hero, HeroClass clazz) {
        return UIUtil.formatExperiencePercentage((float)hero.getExpPercent(clazz));
    }

    public static String formatExperiencePercentage(float percentage) {
        String string = String.format("%.2f", Float.valueOf(percentage));
        if (percentage >= 70.0f) {
            return ChatColor.GREEN + string;
        }
        if (percentage >= 50.0f) {
            return ChatColor.GOLD + string;
        }
        if (percentage >= 30.0f) {
            return ChatColor.YELLOW + string;
        }
        return ChatColor.RED + string;
    }

    public static String formatTime(long ms) {
        if ((ms -= System.currentTimeMillis()) > 86400000L) {
            return ms / 86400000L + "d";
        }
        if (ms > 3600000L) {
            return ms / 3600000L + "h";
        }
        if (ms > 60000L) {
            return ms / 60000L + "m";
        }
        if (ms > 1000L) {
            return String.valueOf(ms / 1000L) + "s";
        }
        return "";
    }

    public static ChatColor colorForTime(String string) {
        if (string.endsWith("d")) {
            return ChatColor.RED;
        }
        if (string.endsWith("h")) {
            return ChatColor.GOLD;
        }
        if (string.endsWith("m")) {
            return ChatColor.YELLOW;
        }
        return ChatColor.GREEN;
    }
}

