/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.ui;

import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.ui.scoreboard.HeroInfoComponent;
import com.herocraftonline.heroes.ui.scoreboard.PartyComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public abstract class HeroUIComponent {
    public static CharacterManager manager;

    public static boolean has(Player player) {
        return manager.containsHero(player);
    }

    public static Hero get(Player player) {
        return manager.getHero(player);
    }

    public static enum Scoreboard {
        HERO_INFO("Hero Info", HeroInfoComponent.SELF),
        PARTY("Party", PartyComponent.SELF);

        private final String friendly;
        private final ManagedScoreboard.Component component;

        private Scoreboard(String friendly, ManagedScoreboard.Component component) {
            this.friendly = friendly;
            this.component = component;
        }

        public ManagedScoreboard.Component component() {
            return this.component;
        }

        public String toString() {
            return this.friendly;
        }

        public static String toString(ManagedScoreboard scoreboard) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (ManagedScoreboard.Component component : scoreboard.getComponents()) {
                if (!first) {
                    builder.append(ChatColor.WHITE).append(", ");
                }
                builder.append(ChatColor.GRAY).append(component.getName());
                first = false;
            }
            return builder.toString();
        }
    }
}

