/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.ui;

import com.google.common.collect.Maps;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CustomNameManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class EntityHealthDisplay
implements Listener {
    private static final long DISPLAY_TIME = 200L;
    private static final Map<Integer, Integer> taskMap = Maps.newHashMap();

    @EventHandler
    public void processEntityDeath(EntityDeathEvent event) {
        EntityHealthDisplay.remove(event.getEntity());
    }

    public static void render(final LivingEntity entity) {
        if (entity instanceof Player) {
            return;
        }
        EntityHealthDisplay.cancelTask(entity);
        int health = (int)Math.ceil(entity.getHealth());
        int maxHealth = (int)Math.ceil(entity.getMaxHealth());
        CustomNameManager.storeCustomName(entity);
        entity.setCustomName(CustomNameManager.getCustomName(entity) + CustomNameManager.HEALTH_IDENTIFIER + health + "/" + maxHealth);
        entity.setCustomNameVisible(true);
        taskMap.put(entity.getEntityId(), Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Heroes.getInstance(), new Runnable(){

            @Override
            public void run() {
                EntityHealthDisplay.remove(entity);
            }
        }, 200L));
    }

    public static void remove(LivingEntity entity) {
        if (entity instanceof Player) {
            return;
        }
        CustomNameManager.restoreOriginalName(entity);
        EntityHealthDisplay.cancelTask(entity);
    }

    private static void cancelTask(LivingEntity entity) {
        if (taskMap.containsKey(entity.getEntityId())) {
            Bukkit.getScheduler().cancelTask(taskMap.remove(entity.getEntityId()).intValue());
        }
    }
}

