/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.ui;

import com.google.common.collect.Sets;
import com.herocraftonline.heroes.ui.HeroUIComponent;
import com.herocraftonline.heroes.ui.UIUtil;
import java.util.Map;
import java.util.TreeSet;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.ui.ActionBar;

public class CooldownActionBarComponent
extends HeroUIComponent
implements ActionBar.ActionBarComponent {
    public static CooldownActionBarComponent SELF = new CooldownActionBarComponent();

    private CooldownActionBarComponent() {
    }

    @Override
    public String render(Player player, ActionBar bar) {
        if (!CooldownActionBarComponent.has(player)) {
            return null;
        }
        boolean hasOne = false;
        StringBuilder builder = new StringBuilder();
        Map<String, Long> cooldowns = CooldownActionBarComponent.get(player).getCooldowns();
        TreeSet keys = Sets.newTreeSet(cooldowns.keySet());
        for (String key : keys) {
            String time;
            long value = cooldowns.get(key);
            if (value - System.currentTimeMillis() < 0L || (time = UIUtil.formatTime(value)).isEmpty()) continue;
            if (hasOne) {
                builder.append(ChatColor.WHITE).append(" | ");
            }
            builder.append(ChatColor.AQUA).append(UIUtil.getCooldownName(key)).append(ChatColor.WHITE).append(": ").append(UIUtil.colorForTime(time)).append(time);
            hasOne = true;
        }
        if (!hasOne) {
            if (bar.get().size() == 1) {
                return null;
            }
            return ChatColor.GRAY + "No active cooldowns";
        }
        return builder.toString();
    }

    @Override
    public String getName() {
        return "Cooldowns";
    }

    @Override
    public boolean canOverridePlayer() {
        return false;
    }

    @Override
    public int length() {
        return 5;
    }
}

