/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.storage.managers;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.annotation.ThreadSafe;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.storage.Storage;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class YMLStorage
extends Storage {
    private final File legacyPlayerFolder;
    private final File playerFolder;
    private final Map<UUID, Hero> toSave = new ConcurrentHashMap<UUID, Hero>();
    private final int SAVE_INTERVAL = 6000;
    private final BukkitTask id;

    public YMLStorage(Heroes plugin) {
        super(plugin, "YMLStorage");
        this.legacyPlayerFolder = new File(plugin.getDataFolder(), "players");
        this.checkForLegacyFile();
        this.playerFolder = new File(plugin.getDataFolder(), "playerdata");
        this.playerFolder.mkdirs();
        BukkitScheduler bukkitScheduler = Bukkit.getServer().getScheduler();
        HeroSaveThread heroSaveThread = new HeroSaveThread();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.id = bukkitScheduler.runTaskTimerAsynchronously((Plugin)plugin, (Runnable)heroSaveThread, 6000L, 6000L);
    }

    @Override
    public Hero loadHero(Player player) {
        if (this.toSave.containsKey(player.getUniqueId())) {
            Hero hero = this.toSave.get(player.getUniqueId());
            hero.setPlayer(player);
            return hero;
        }
        File playerFile = new File(this.playerFolder, player.getUniqueId() + ".yml");
        return this.loadHeroFromFile(playerFile, player);
    }

    @Override
    public Hero loadLegacyHero(Player player) {
        Hero hero;
        block8: {
            if (this.toSave.containsKey(player.getUniqueId())) {
                Hero hero2 = this.toSave.get(player.getUniqueId());
                hero2.setPlayer(player);
                return hero2;
            }
            File pFolder = new File(this.legacyPlayerFolder, player.getName().toLowerCase().substring(0, 1));
            hero = null;
            if (pFolder.exists()) {
                try {
                    File playerFile = new File(pFolder, player.getName() + ".yml");
                    if (!playerFile.exists()) break block8;
                    hero = this.loadHeroFromFile(playerFile, player);
                    if (!playerFile.delete()) {
                        throw new IOException("Could not delete file!");
                    }
                    if (pFolder.listFiles().length == 0 && !pFolder.delete()) {
                        throw new IOException("Could not delete folder directory");
                    }
                }
                catch (IOException e) {
                    Heroes.log(Level.WARNING, "Encountered IO Exception! " + e);
                    Heroes.debugLog(Level.SEVERE, TextUtil.formatStackTrace(e));
                }
                catch (SecurityException e) {
                    Heroes.log(Level.SEVERE, "Could not load legacy hero data as encountered SecurityException! " + e.getMessage());
                    Heroes.debugLog(Level.SEVERE, TextUtil.formatStackTrace(e));
                }
            } else {
                this.checkForLegacyFile();
            }
        }
        return hero;
    }

    private void checkForLegacyFile() {
        if (this.legacyPlayerFolder.exists() && this.legacyPlayerFolder.listFiles().length == 0) {
            try {
                if (this.legacyPlayerFolder.delete()) {
                    Heroes.properties.loadFromLegacyConfiguration = false;
                } else {
                    Heroes.log(Level.WARNING, "Failed could not delete legacy player folder!");
                }
            }
            catch (SecurityException e) {
                Heroes.log(Level.WARNING, "Could not remove legacy data folder due to SecurityException!" + e);
            }
        }
    }

    private Hero loadHeroFromFile(File playerFile, Player player) {
        if (playerFile.exists()) {
            YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
            HeroClass playerClass = this.loadClass(player, (Configuration)playerConfig);
            if (playerClass == null) {
                Heroes.log(Level.INFO, "Invalid class found for " + player.getName() + ". Resetting player.");
                return this.createNewHero(player);
            }
            HeroClass secondClass = this.loadSecondaryClass(player, (Configuration)playerConfig);
            HeroClass raceClass = this.loadRaceClass(player, (Configuration)playerConfig);
            Hero playerHero = new Hero(this.plugin, player, this, playerClass, secondClass, raceClass);
            this.loadAttributes(playerHero, playerConfig.getConfigurationSection("attributes"));
            this.loadAllocationPoints(playerHero, playerConfig.getConfigurationSection("allocation-points"));
            this.loadCooldowns(playerHero, playerConfig.getConfigurationSection("cooldowns"));
            this.loadExperience(playerHero, playerConfig.getConfigurationSection("experience"));
            this.loadMasteries(playerHero, playerConfig.getConfigurationSection("mastered"));
            this.loadBinds(playerHero, playerConfig.getConfigurationSection("binds"));
            this.loadSkillSettings(playerHero, playerConfig.getConfigurationSection("skill-settings"));
            playerHero.setMana(playerConfig.getInt("mana", 0));
            playerHero.setStamina(playerConfig.getInt("stamina", 1000));
            playerHero.setVerboseExp(playerConfig.getBoolean("verbose-exp", true));
            playerHero.setVerboseMana(playerConfig.getBoolean("verbose-mana", false));
            playerHero.setVerboseStamina(playerConfig.getBoolean("verbose-stamina", true));
            playerHero.setVerboseSkills(playerConfig.getBoolean("verbose-skills", false));
            playerHero.setSuppressedSkills(playerConfig.getStringList("suppressed"));
            return playerHero;
        }
        return null;
    }

    @Override
    public void saveHero(Hero hero, boolean now) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        try {
            this.doSave(hero);
        }
        catch (IOException e) {
            Heroes.log(Level.SEVERE, "There was a problem saving the Hero: " + hero.getName());
            this.toSave.put(hero.getPlayer().getUniqueId(), hero);
        }
    }

    @ThreadSafe
    public boolean doSave(Hero hero) throws IOException {
        String name = hero.getPlayer().getUniqueId().toString();
        File playerFile = new File(this.playerFolder, name + ".yml");
        YamlConfiguration playerConfig = new YamlConfiguration();
        playerConfig.set("class", (Object)hero.getHeroClass().toString());
        if (hero.getSecondaryClass() != null) {
            playerConfig.set("secondary-class", (Object)hero.getSecondaryClass().toString());
        }
        if (hero.getRaceClass() != null) {
            playerConfig.set("race-class", (Object)hero.getRaceClass().toString());
        }
        playerConfig.set("verbose-exp", (Object)hero.isVerboseExp());
        playerConfig.set("verbose-mana", (Object)hero.isVerboseMana());
        playerConfig.set("verbose-stamina", (Object)hero.isVerboseStamina());
        playerConfig.set("verbose-skills", (Object)hero.isVerboseSkills());
        playerConfig.set("suppressed", new ArrayList<String>(hero.getSuppressedSkills()));
        playerConfig.set("mana", (Object)hero.getMana());
        playerConfig.set("stamina", (Object)hero.getStamina());
        this.saveAttributes(hero, playerConfig.createSection("attributes"));
        this.saveAllocationPoints(hero, playerConfig.createSection("allocation-points"));
        this.saveSkillSettings(hero, playerConfig.createSection("skill-settings"));
        this.saveCooldowns(hero, playerConfig.createSection("cooldowns"));
        this.saveExperience(hero, playerConfig.createSection("experience"));
        this.saveMasteries(hero, playerConfig.createSection("mastered"));
        this.saveBinds(hero, playerConfig.createSection("binds"));
        playerConfig.save(playerFile);
        return true;
    }

    private void loadBinds(Hero hero, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        Set bindKeys = section.getKeys(false);
        if (bindKeys != null && bindKeys.size() > 0) {
            for (String material : bindKeys) {
                try {
                    Material item = Material.valueOf((String)material);
                    String bind = section.getString(material, "");
                    if (bind.length() <= 0) continue;
                    hero.bind(item, bind.split(" "));
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, material + " isn't a valid Item to bind a Skill to.");
                }
            }
        }
    }

    private HeroClass loadClass(Player player, Configuration config) {
        HeroClass playerClass = null;
        HeroClass defaultClass = this.plugin.getClassManager().getDefaultClass();
        if (config.getString("class") != null) {
            playerClass = this.plugin.getClassManager().getClass(config.getString("class"));
            if (playerClass == null) {
                playerClass = defaultClass;
            } else if (!playerClass.isPrimary()) {
                playerClass = defaultClass;
            }
        } else {
            playerClass = defaultClass;
        }
        return playerClass;
    }

    private HeroClass loadSecondaryClass(Player player, Configuration config) {
        HeroClass playerClass = null;
        HeroClass defaultProf = this.plugin.getClassManager().getDefaultProfession();
        if (!(config.getString("secondary-class") == null || (playerClass = this.plugin.getClassManager().getClass(config.getString("secondary-class"))) != null && playerClass.isSecondary())) {
            playerClass = defaultProf;
        }
        return playerClass;
    }

    private HeroClass loadRaceClass(Player player, Configuration config) {
        HeroClass playerClass = null;
        HeroClass defaultRace = this.plugin.getClassManager().getDefaultRace();
        if (!(config.getString("race-class") == null || (playerClass = this.plugin.getClassManager().getClass(config.getString("race-class"))) != null && playerClass.isRace())) {
            playerClass = defaultRace;
        }
        return playerClass;
    }

    private void loadCooldowns(Hero hero, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        Set storedCooldowns = section.getKeys(false);
        if (storedCooldowns != null) {
            long time = System.currentTimeMillis();
            for (String skillName : storedCooldowns) {
                try {
                    long cooldown = Long.valueOf(section.getString(skillName, "0"));
                    if (!hero.hasAccessToSkill(skillName) || cooldown <= time) continue;
                    hero.setCooldown(skillName, cooldown);
                }
                catch (NumberFormatException e) {}
            }
        }
    }

    private void loadExperience(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Set expList = section.getKeys(false);
        if (expList != null) {
            for (String className : expList) {
                double exp = section.getDouble(className, 0.0);
                HeroClass heroClass = this.plugin.getClassManager().getClass(className);
                if (heroClass == null || hero.getExperience(heroClass) != 0.0) continue;
                if (exp > (double)Properties.maxExp) {
                    exp = Properties.maxExp;
                }
                hero.setExperience(heroClass, exp);
            }
        }
    }

    private void loadMasteries(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Set masteredList = section.getKeys(false);
        if (masteredList != null) {
            for (String className : masteredList) {
                HeroClass heroClass = this.plugin.getClassManager().getClass(className);
                if (heroClass == null || hero.hasMastered(heroClass)) continue;
                hero.setMastered(heroClass);
            }
        }
    }

    private void loadSkillSettings(Hero hero, ConfigurationSection section) {
        if (section == null || section.getKeys(false) == null) {
            return;
        }
        for (String skill : section.getKeys(false)) {
            if (!section.isConfigurationSection(skill)) continue;
            ConfigurationSection skillSection = section.getConfigurationSection(skill);
            for (String key : skillSection.getKeys(true)) {
                if (skillSection.isConfigurationSection(key)) continue;
                hero.setSkillSetting(skill, key, skillSection.get(key));
            }
        }
    }

    private void loadAllocationPoints(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Set allocationPointList = section.getKeys(false);
        if (allocationPointList != null) {
            for (String className : allocationPointList) {
                int numPoints = section.getInt(className, 0);
                HeroClass heroClass = this.plugin.getClassManager().getClass(className);
                if (heroClass == null || !heroClass.isPrimary()) continue;
                hero.setAllocationPoints(heroClass, numPoints);
            }
        }
    }

    private void loadAttributes(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        for (String classNode : section.getKeys(false)) {
            HeroClass heroClass = this.plugin.getClassManager().getClass(classNode);
            if (heroClass == null || !heroClass.isPrimary()) continue;
            ConfigurationSection attributeSection = section.getConfigurationSection(classNode);
            for (String attributeNode : attributeSection.getKeys(true)) {
                AttributeType type = AttributeType.matchAttribute(attributeNode);
                if (type == null) continue;
                int value = attributeSection.getInt(attributeNode);
                hero.setAllocatedAttribute(heroClass, type, value);
            }
        }
    }

    private void saveAllocationPoints(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Map<String, AtomicInteger> allocationPointsMap = hero.getAllocationPointsMap();
        for (Map.Entry<String, AtomicInteger> entry : allocationPointsMap.entrySet()) {
            section.set(entry.getKey(), (Object)entry.getValue().get());
        }
    }

    private void saveAttributes(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Map<String, AttributeSet> allocatedAttributeMap = hero.getAllocatedAttributesMap();
        for (Map.Entry<String, AttributeSet> allocatedAttributeMapEntry : allocatedAttributeMap.entrySet()) {
            ConfigurationSection heroClassSubSection = section.createSection(allocatedAttributeMapEntry.getKey());
            AttributeSet attributes = allocatedAttributeMapEntry.getValue();
            heroClassSubSection.set(AttributeType.STRENGTH.toString(), (Object)attributes.getStrengthValue());
            heroClassSubSection.set(AttributeType.CONSTITUTION.toString(), (Object)attributes.getConstitutionValue());
            heroClassSubSection.set(AttributeType.ENDURANCE.toString(), (Object)attributes.getEnduranceValue());
            heroClassSubSection.set(AttributeType.DEXTERITY.toString(), (Object)attributes.getDexterityValue());
            heroClassSubSection.set(AttributeType.INTELLECT.toString(), (Object)attributes.getIntellectValue());
            heroClassSubSection.set(AttributeType.WISDOM.toString(), (Object)attributes.getWisdomValue());
            heroClassSubSection.set(AttributeType.CHARISMA.toString(), (Object)attributes.getCharismaValue());
        }
    }

    private void saveBinds(Hero hero, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        Map<Material, String[]> binds = hero.getBinds();
        for (Material material : binds.keySet()) {
            String[] bindArgs = binds.get(material);
            StringBuilder bind = new StringBuilder();
            for (String arg : bindArgs) {
                bind.append(arg).append(" ");
            }
            section.set(material.toString(), (Object)bind.toString().substring(0, bind.toString().length() - 1));
        }
    }

    private void saveCooldowns(Hero hero, ConfigurationSection section) {
        if (section == null) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.SEVERE, "Could not create cooldown section for " + hero.getName());
            }
            return;
        }
        long time = System.currentTimeMillis();
        Map<String, Long> cooldowns = hero.getCooldowns();
        for (Map.Entry<String, Long> entry : cooldowns.entrySet()) {
            String skillName = entry.getKey();
            Long cooldown = entry.getValue();
            if (cooldown <= time) continue;
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, hero.getName() + ": - " + skillName + " @ " + cooldown);
            }
            section.set(skillName, (Object)cooldown.toString());
        }
    }

    private void saveExperience(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Map<String, Double> expMap = hero.getExperienceMap();
        for (Map.Entry<String, Double> entry : expMap.entrySet()) {
            section.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    private void saveMasteries(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        List<String> mastered = hero.getMasteredClasses();
        for (String masteredClass : mastered) {
            section.set(masteredClass, (Object)true);
        }
    }

    private void saveSkillSettings(Hero hero, ConfigurationSection config) {
        for (Map.Entry<String, ConfigurationSection> entry : hero.getSkillSettings().entrySet()) {
            for (String key : entry.getValue().getKeys(true)) {
                if (entry.getValue().isConfigurationSection(key)) continue;
                config.set(entry.getKey() + "." + key, entry.getValue().get(key));
            }
        }
    }

    @Override
    public void shutdown() {
        this.id.cancel();
        Collection<Hero> unsaved = this.plugin.getCharacterManager().getHeroes();
        Iterator<Map.Entry<UUID, Hero>> iter = this.toSave.entrySet().iterator();
        while (iter.hasNext()) {
            Hero hero = iter.next().getValue();
            try {
                this.doSave(hero);
                unsaved.remove(hero);
            }
            catch (Exception e) {
                Heroes.log(Level.SEVERE, "There was a problem saving the hero: " + hero.getName());
                continue;
            }
            iter.remove();
        }
        for (Hero hero : unsaved) {
            try {
                this.doSave(hero);
            }
            catch (IOException e) {
                Heroes.log(Level.SEVERE, "There was a problem saving the hero: " + hero.getName());
            }
        }
    }

    @Override
    public void saveHeroXP(Hero hero, HeroClass hc) {
        this.saveHero(hero, true);
    }

    @Override
    public void saveHeroClass(Hero hero, HeroClass hc, boolean secondary, boolean race) {
    }

    @Override
    public void destroyHeroBind(Hero hero, Material material) {
    }

    @Override
    public void saveHeroBind(Hero hero, Material material, String[] skills) {
    }

    @Override
    public void clearHeroBinds(Hero hero) {
    }

    @Override
    public void saveHeroSkillSettings(Hero hero, String skillName, String node, Object val) {
    }

    @Override
    public void saveHeroAttribute(Hero hero, HeroClass heroClass, AttributeType attributeType, int value) {
    }

    @Override
    public void resetHeroAttribute(Hero hero) {
    }

    @Override
    public void saveHeroCooldown(Hero hero, String name, long cooldown) {
    }

    @Override
    public void clearHeroCooldowns(Hero hero) {
    }

    @Override
    public void removeHeroCooldown(Hero hero, String name) {
    }

    @Override
    public void saveHeroAllocationPoint(Hero hero, HeroClass heroClass, int value) {
    }

    @Override
    public void resetHeroAllocationPoint(Hero hero) {
    }

    @Override
    public void addHeroSuppressedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void removeHeroSuppressedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void addHeroLearnedSkill(HeroSkill heroSkill) {
    }

    @Override
    public void loadHeroLearnedSkill(HeroSkill heroSkill) {
    }

    @Override
    public void removeHeroLearnedSkill(HeroSkill heroSkill) {
    }

    @Override
    public void addHeroPreparedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void removeHeroPreparedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void resetHeroExperience(Hero hero) {
    }

    @Override
    public void resetHeroMasteries(Hero hero) {
    }

    @Override
    public void setHeroClassMastered(Hero hero, HeroClass heroClass) {
    }

    @Override
    public void setHeroVerboseExp(Hero hero, boolean value) {
    }

    @Override
    public void setHeroVerboseMana(Hero hero, boolean isVerbose) {
    }

    @Override
    public void setHeroVerboseStamina(Hero hero, boolean isVerbose) {
    }

    @Override
    public void setHeroVerboseSkills(Hero hero, boolean isVerbose) {
    }

    @Override
    public void createHero(Hero hero) {
        this.saveHero(hero, true);
    }

    @Override
    public void updatePlayerMetadata(String playerName, UUID uuid, InetAddress address) {
    }

    @Override
    public int getHeroID(UUID uuid) {
        return 0;
    }

    protected class HeroSaveThread
    implements Runnable {
        protected HeroSaveThread() {
        }

        @Override
        public void run() {
            if (YMLStorage.this.toSave.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<UUID, Hero>> iter = YMLStorage.this.toSave.entrySet().iterator();
            while (iter.hasNext()) {
                Hero hero = iter.next().getValue();
                try {
                    YMLStorage.this.doSave(hero);
                }
                catch (Exception e) {
                    Heroes.log(Level.SEVERE, "There was a problem saving the Hero: " + hero.getName());
                    e.printStackTrace();
                    continue;
                }
                iter.remove();
            }
        }
    }
}

