/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.storage.managers;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.storage.Storage;
import com.herocraftonline.heroes.util.TextUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class SQLStorage
extends Storage {
    private final HikariDataSource ds;
    private final int SAVE_INTERVAL = 1200;
    private final BukkitTask id;
    private final ConcurrentHashMap<String, Integer> classMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, String> classMapInverted = new ConcurrentHashMap();
    private static final List<String> CREATE_TABLE_SQL = Arrays.asList("CREATE TABLE IF NOT EXISTS HC_HeroMeta (HeroID INTEGER NOT NULL AUTO_INCREMENT,UUID VARCHAR(36) ,UserName VARCHAR(32) NOT NULL ,JoinDate DATETIME ,LastLogin DATETIME ,LastServerJoined VARCHAR(32) ,TimePlayed DATETIME ,PRIMARY KEY (UserName), UNIQUE KEY (HeroID), UNIQUE KEY (UUID))", "CREATE TABLE IF NOT EXISTS HC_PlayerIP (HeroID INTEGER NOT NULL AUTO_INCREMENT,Octet1 TINYINT UNSIGNED, Octet2 TINYINT UNSIGNED, Octet3 TINYINT UNSIGNED, Octet4 TINYINT UNSIGNED, LastJoin DATETIME, PRIMARY KEY (HeroID,Octet1,Octet2,Octet3,Octet4), FOREIGN KEY (HeroID) references HC_HeroMeta(HeroID)) ", "CREATE TABLE IF NOT EXISTS RPG_ClassIndex (ClassID INT NOT NULL AUTO_INCREMENT,ClassName VARCHAR(32) NOT NULL ,PRIMARY KEY (ClassName), UNIQUE KEY (ClassID))", "CREATE TABLE IF NOT EXISTS `RPG_HeroInfo` (  `HeroID` INT(11) NOT NULL,  `Mana` INT NOT NULL,  `Stamina` INT NOT NULL,  `CurrentPrimary` INT NOT NULL,  `CurrentProfession` INT,  `CurrentRace` INT,  `VerboseExp` TINYINT(1) NOT NULL DEFAULT true,  `VerboseMana` TINYINT(1) NOT NULL DEFAULT true,  `VerboseStamina` TINYINT(1) NOT NULL DEFAULT true,  `VerboseSkills` TINYINT(1) NOT NULL DEFAULT true,  PRIMARY KEY (`HeroID`),  INDEX `fk_RPG_HeroInfo_RPG_ClassIndex1_idx` (`CurrentPrimary` ASC),  INDEX `fk_RPG_HeroInfo_RPG_ClassIndex2_idx` (`CurrentProfession` ASC),  INDEX `fk_RPG_HeroInfo_RPG_ClassIndex3_idx` (`CurrentRace` ASC),  CONSTRAINT `fk_RPG_HeroInfo_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`),  CONSTRAINT `fk_RPG_HeroInfo_RPG_ClassIndex1`    FOREIGN KEY (`CurrentPrimary`)    REFERENCES `RPG_ClassIndex` (`ClassID`),  CONSTRAINT `fk_RPG_HeroInfo_RPG_ClassIndex2`    FOREIGN KEY (`CurrentProfession`)    REFERENCES `RPG_ClassIndex` (`ClassID`),  CONSTRAINT `fk_RPG_HeroInfo_RPG_ClassIndex3`    FOREIGN KEY (`CurrentRace`)    REFERENCES `RPG_ClassIndex` (`ClassID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS RPG_PlayerBinds (HeroID INTEGER NOT NULL,SkillName VARCHAR(255) NOT NULL ,ToolID VARCHAR(32) NOT NULL ,PRIMARY KEY (HeroID,ToolID),FOREIGN KEY (HeroID) references HC_HeroMeta(HeroID))", "CREATE TABLE IF NOT EXISTS `RPG_PlayerClasses` (  `HeroID` INT NOT NULL,  `ClassID` INT NOT NULL,  `Exp` DOUBLE NOT NULL,Mastery BOOL DEFAULT false,   INDEX `fk_RPG_PlayerClass_HC_HeroMeta1_idx` (`HeroID` ASC),  PRIMARY KEY (`HeroID`, `ClassID`),  INDEX `fk_RPG_PlayerClass_RPG_ClassIndex1_idx` (`ClassID` ASC),  CONSTRAINT `fk_RPG_PlayerClass_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`),  CONSTRAINT `fk_RPG_PlayerClass_RPG_ClassIndex1`    FOREIGN KEY (`ClassID`)    REFERENCES `RPG_ClassIndex` (`ClassID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_PlayerCooldowns` (  `HeroID` INT(11) NOT NULL,  `SkillName` VARCHAR(32) NOT NULL,  `CooldownTime` LONG NOT NULL,  INDEX `fk_RPG_PlayerCooldowns_HC_HeroMeta1_idx` (`HeroID` ASC),  PRIMARY KEY (`HeroID`, `SkillName`),  CONSTRAINT `fk_RPG_PlayerCooldowns_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_Attribute` (  `HeroID` INT NOT NULL,  `Type` VARCHAR(45) NOT NULL,  `Value` INT NOT NULL,  INDEX `fk_RPG_Attribute_HC_HeroMeta1_idx` (`HeroID` ASC),  PRIMARY KEY (`HeroID`, `Type`),  CONSTRAINT `fk_RPG_Attribute_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_AllocationPoints` (  `HeroID` INT(11) NOT NULL,  `ClassID` INT NOT NULL,  `Points` INT NOT NULL,  PRIMARY KEY (`HeroID`, `ClassID`),  INDEX `fk_RPG_AllocationPoints_RPG_ClassIndex1_idx` (`ClassID` ASC),  CONSTRAINT `fk_RPG_AllocationPoints_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`),  CONSTRAINT `fk_RPG_AllocationPoints_RPG_ClassIndex1`    FOREIGN KEY (`ClassID`)    REFERENCES `RPG_ClassIndex` (`ClassID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_SkillSettings` (  `HeroID` INT(11) NOT NULL,  `SkillName` VARCHAR(45) NOT NULL,  `SkillKey` VARCHAR(45) NOT NULL,  `Value` BLOB NOT NULL,  INDEX `fk_RPG_SkillSettings_HC_HeroMeta1_idx` (`HeroID` ASC),  PRIMARY KEY (`HeroID`, `SkillName`, `SkillKey`),  CONSTRAINT `fk_RPG_SkillSettings_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_SuppressedSkill` (  `HeroID` INT(11) NOT NULL,  `Skill` VARCHAR(32) NOT NULL,  CONSTRAINT `fk_RPG_SuppressedSkills_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_LearnedSkills` (  `HeroID` INT NOT NULL,  `ClassID` INT NOT NULL,  `Skill` VARCHAR(32) NOT NULL,Level INT NOT NULL,   INDEX `fk_RPG_LearnedSkill_HC_HeroMeta1_idx` (`HeroID` ASC),  PRIMARY KEY (`HeroID`, `ClassID`, `Skill`),  INDEX `fk_RPG_LearnedSkill_RPG_ClassIndex1_idx` (`ClassID` ASC),  CONSTRAINT `fk_RPG_LearnedSkill_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`),  CONSTRAINT `fk_RPG_LearnedSkill_RPG_ClassIndex1`    FOREIGN KEY (`ClassID`)    REFERENCES `RPG_ClassIndex` (`ClassID`))ENGINE = InnoDB;", "CREATE TABLE IF NOT EXISTS `RPG_PreparedSkills` (  `HeroID` INT(11) NOT NULL,  `Skill` VARCHAR(32) NOT NULL,  CONSTRAINT `fk_RPG_PreparedSkills_HC_HeroMeta1`    FOREIGN KEY (`HeroID`)    REFERENCES `HC_HeroMeta` (`HeroID`),  UNIQUE INDEX `uk_RPG_PreparedSkills1` (`HeroID`,`Skill`))ENGINE = InnoDB;");
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public SQLStorage(Heroes plugin) {
        super(plugin, "SQLStorage");
        HikariConfig config = new HikariConfig();
        YamlConfiguration database = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "database.yml"));
        config.setMaximumPoolSize(database.getInt("database.poolsize", 10));
        String localHost = database.getString("database.url");
        String port = database.getString("database.port");
        String databaseName = database.getString("database.db");
        config.setJdbcUrl("jdbc:mysql://" + localHost + ":" + port + "/" + databaseName);
        config.setUsername(database.getString("database.username"));
        config.setPassword(database.getString("database.password"));
        config.addDataSourceProperty("autoDeserialize", true);
        this.ds = new HikariDataSource(config);
        for (String createTableSql : CREATE_TABLE_SQL) {
            try {
                Connection connection = this.ds.getConnection();
                try {
                    PreparedStatement statement = connection.prepareStatement(createTableSql);
                    try {
                        statement.executeUpdate();
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        BukkitScheduler bukkitScheduler = Bukkit.getServer().getScheduler();
        HeroSaveTask heroSaveTask = new HeroSaveTask();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.id = bukkitScheduler.runTaskTimerAsynchronously((Plugin)plugin, (Runnable)heroSaveTask, 1200L, 1200L);
    }

    private int getClassID(String name) {
        if (!this.classMap.containsKey(name)) {
            int id;
            ResultSet set;
            PreparedStatement statement;
            Connection connection;
            try {
                connection = this.ds.getConnection();
                try {
                    statement = connection.prepareStatement("SELECT * FROM RPG_ClassIndex WHERE ClassName=?");
                    try {
                        statement.setString(1, name);
                        set = statement.executeQuery();
                        try {
                            if (set.next()) {
                                id = set.getInt("ClassID");
                                this.classMap.put(name, id);
                                this.classMapInverted.put(id, name);
                            }
                        }
                        finally {
                            if (set != null) {
                                set.close();
                            }
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!this.classMap.containsKey(name)) {
                try {
                    connection = this.ds.getConnection();
                    try {
                        statement = connection.prepareStatement("INSERT INTO RPG_ClassIndex(ClassName) VALUES (?) ON DUPLICATE KEY UPDATE ClassName=VALUES(ClassName)", 1);
                        try {
                            statement.setString(1, name);
                            statement.executeUpdate();
                            set = statement.getGeneratedKeys();
                            try {
                                if (set.next()) {
                                    id = set.getInt(1);
                                    this.classMap.put(name, id);
                                    this.classMapInverted.put(id, name);
                                }
                            }
                            finally {
                                if (set != null) {
                                    set.close();
                                }
                            }
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.classMap.containsKey(name) ? this.classMap.get(name) : 0;
    }

    private String getClassName(int id) {
        if (this.classMapInverted.containsKey(id)) {
            return this.classMapInverted.get(id);
        }
        String name = null;
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_ClassIndex WHERE ClassID=?");){
            statement.setInt(1, id);
            try (ResultSet set = statement.executeQuery();){
                if (set.next()) {
                    name = set.getString("ClassName");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return name;
    }

    @Override
    public void saveHeroXP(final Hero hero, final HeroClass hc) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_PlayerClasses(HeroID, ClassID, Exp, Mastery) VALUES(?,?,?,?)ON DUPLICATE KEY UPDATE Exp=VALUES(Exp), Mastery=VALUES(Mastery)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setInt(2, SQLStorage.this.getClassID(hc.getName()));
                statement.setDouble(3, hero.getExperience(hc));
                statement.setBoolean(4, hero.hasMastered(hc));
                return statement;
            }
        });
    }

    @Override
    public void saveHeroClass(final Hero hero, final HeroClass hc, final boolean secondary, final boolean race) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement(race ? "UPDATE RPG_HeroInfo SET CurrentRace=? WHERE HeroID=?" : (secondary ? "UPDATE RPG_HeroInfo SET CurrentProfession=? WHERE HeroID=?" : "UPDATE RPG_HeroInfo SET CurrentPrimary=? WHERE HeroID=?"));
                statement.setInt(1, SQLStorage.this.getClassID(hc.getName()));
                statement.setInt(2, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void destroyHeroBind(final Hero hero, final Material material) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_PlayerBinds WHERE HeroID=? AND ToolID=?");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, material.name());
                return statement;
            }
        });
    }

    @Override
    public void saveHeroBind(final Hero hero, final Material material, final String[] skills) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_PlayerBinds(HeroID, SkillName, ToolID) VALUES (?,?,?) ON DUPLICATE KEY UPDATE SkillName=VALUES(SkillName)");
                statement.setInt(1, hero.getDatabaseID());
                Object bindsString = null;
                for (String value : skills) {
                    bindsString = bindsString == null ? value : (String)bindsString + "," + value;
                }
                statement.setString(2, (String)bindsString);
                statement.setString(3, material.name());
                return statement;
            }
        });
    }

    @Override
    public void clearHeroBinds(final Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_PlayerBinds WHERE HeroID=?");
                statement.setInt(1, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void saveHeroSkillSettings(final Hero hero, final String skillName, final String node, final Object val) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_SkillSettings(HeroID, SkillName, SkillKey, Value) VALUES(?,?,?,?)ON DUPLICATE KEY UPDATE Value=VALUES(Value)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, skillName);
                statement.setString(3, node);
                statement.setObject(4, val);
                return statement;
            }
        });
    }

    @Override
    public void saveHeroAttribute(final Hero hero, HeroClass heroClass, final AttributeType attributeType, final int value) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_Attribute(HeroID, Type, Value) VALUES(?,?,?)ON DUPLICATE KEY UPDATE Value=VALUES(Value)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, attributeType.name());
                statement.setInt(3, value);
                return statement;
            }
        });
    }

    @Override
    public void resetHeroAttribute(final Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_Attribute SET Value=0 WHERE HeroID=?");
                statement.setInt(1, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void saveHeroCooldown(final Hero hero, final String name, final long cooldown) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_PlayerCooldowns(HeroID, SkillName, CooldownTime) VALUES (?,?,?) ON DUPLICATE KEY UPDATE CooldownTime=VALUES(CooldownTime)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, name);
                statement.setLong(3, cooldown);
                return statement;
            }
        });
    }

    @Override
    public void clearHeroCooldowns(final Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_PlayerCooldowns WHERE HeroID=?");
                statement.setInt(1, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void removeHeroCooldown(final Hero hero, final String name) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_PlayerCooldowns WHERE HeroID=? AND SkillName=?");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, name);
                return statement;
            }
        });
    }

    @Override
    public void saveHeroAllocationPoint(final Hero hero, final HeroClass heroClass, final int value) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_AllocationPoints(HeroID, ClassID, Points) VALUES(?,?,?)ON DUPLICATE KEY UPDATE Points=VALUES(Points)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setInt(2, SQLStorage.this.getClassID(heroClass.getName()));
                statement.setInt(3, value);
                return statement;
            }
        });
    }

    @Override
    public void resetHeroAllocationPoint(final Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_AllocationPoints SET Points=0 WHERE HeroID=?");
                statement.setInt(1, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void addHeroSuppressedSkill(final Hero hero, final Skill skill) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        final Future<Boolean> found = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Boolean found = false;
                try (Connection connection = SQLStorage.this.ds.getConnection();
                     PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_SuppressedSkill WHERE HeroID=? AND Skill=?", 1005, 1008);){
                    statement.setInt(1, hero.getDatabaseID());
                    statement.setString(2, skill.getName());
                    try (ResultSet set = statement.executeQuery();){
                        found = set.first();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return found;
            }
        });
        this.executor.submit(new DbUpdate(){

            @Override
            public void run() {
                try {
                    if (!((Boolean)found.get()).booleanValue()) {
                        super.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_SuppressedSkill(HeroID,Skill) VALUES(?,?)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, skill.getName());
                return statement;
            }
        });
    }

    @Override
    public void removeHeroSuppressedSkill(final Hero hero, final Skill skill) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_SuppressedSkill WHERE HeroID=? AND Skill=?");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, skill.getName());
                return statement;
            }
        });
    }

    @Override
    public void addHeroLearnedSkill(final HeroSkill heroSkill) {
        if (this.isPlayerNotToSave(heroSkill.getHero().getPlayer())) {
            return;
        }
        this.executor.submit(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_LearnedSkills(HeroID, ClassID, Skill, Level) VALUES(?,?,?,?)ON DUPLICATE KEY UPDATE Skill=VALUES(Skill), Level=VALUES(Level)");
                statement.setInt(1, heroSkill.getHero().getDatabaseID());
                statement.setInt(2, SQLStorage.this.getClassID(heroSkill.getHeroClass().getName()));
                statement.setString(3, heroSkill.getSkill().getName().toLowerCase());
                statement.setInt(4, heroSkill.getLevel());
                return statement;
            }
        });
    }

    @Override
    public void loadHeroLearnedSkill(HeroSkill heroSkill) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_LearnedSkills WHERE HeroID=? AND ClassID=? AND Skill=?");){
            statement.setInt(1, heroSkill.getHero().getDatabaseID());
            statement.setInt(2, this.getClassID(heroSkill.getHeroClass().getName()));
            statement.setString(3, heroSkill.getSkill().getName().toLowerCase());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    heroSkill.setLearned(true);
                    heroSkill.setLevel(set.getInt("Level"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeHeroLearnedSkill(final HeroSkill heroSkill) {
        if (this.isPlayerNotToSave(heroSkill.getHero().getPlayer())) {
            return;
        }
        this.executor.submit(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_LearnedSkills WHERE HeroID=? AND ClassID=? AND Skill=?");
                statement.setInt(1, heroSkill.getHero().getDatabaseID());
                statement.setInt(2, SQLStorage.this.getClassID(heroSkill.getHeroClass().getName()));
                statement.setString(3, heroSkill.getSkill().getName().toLowerCase());
                return statement;
            }
        });
    }

    @Override
    public void addHeroPreparedSkill(final Hero hero, final Skill skill) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.submit(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("INSERT IGNORE INTO RPG_PreparedSkills(HeroID,Skill) VALUES(?,?)");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, skill.getName());
                return statement;
            }
        });
    }

    @Override
    public void removeHeroPreparedSkill(final Hero hero, final Skill skill) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM RPG_PreparedSkills WHERE HeroID=? AND Skill=?");
                statement.setInt(1, hero.getDatabaseID());
                statement.setString(2, skill.getName());
                return statement;
            }
        });
    }

    @Override
    public void resetHeroExperience(final Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_PlayerClasses SET Exp=0 WHERE HeroID=?");
                statement.setInt(1, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void resetHeroMasteries(final Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_PlayerClasses SET Mastery=FALSE WHERE HeroID=?");
                statement.setInt(1, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void setHeroClassMastered(final Hero hero, final HeroClass heroClass) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_PlayerClasses SET Mastery=? WHERE HeroID=? AND ClassID=?");
                statement.setBoolean(1, true);
                statement.setInt(2, hero.getDatabaseID());
                statement.setInt(3, SQLStorage.this.getClassID(heroClass.getName()));
                return statement;
            }
        });
    }

    @Override
    public void setHeroVerboseExp(final Hero hero, final boolean value) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_HeroInfo SET VerboseExp=? WHERE HeroID=?");
                statement.setBoolean(1, value);
                statement.setInt(2, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void setHeroVerboseMana(final Hero hero, final boolean isVerbose) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_HeroInfo SET VerboseMana=? WHERE HeroID=?");
                statement.setBoolean(1, isVerbose);
                statement.setInt(2, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void setHeroVerboseStamina(final Hero hero, final boolean isVerbose) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_HeroInfo SET VerboseStamina=? WHERE HeroID=?");
                statement.setBoolean(1, isVerbose);
                statement.setInt(2, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void setHeroVerboseSkills(final Hero hero, final boolean isVerbose) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        this.executor.execute(new DbUpdate(){

            @Override
            PreparedStatement prepareUpdate(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement("UPDATE RPG_HeroInfo SET VerboseSkills=? WHERE HeroID=?", 1005, 1008);
                statement.setBoolean(1, isVerbose);
                statement.setInt(2, hero.getDatabaseID());
                return statement;
            }
        });
    }

    @Override
    public void createHero(Hero hero) {
        if (this.isPlayerNotToSave(hero.getPlayer())) {
            return;
        }
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO RPG_HeroInfo(HeroID,Mana,Stamina, CurrentPrimary, CurrentProfession, CurrentRace, VerboseExp, VerboseMana, VerboseStamina, VerboseSkills) VALUES (?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE Mana=VALUES(Mana), Stamina=VALUES(Stamina), CurrentPrimary=VALUES(CurrentPrimary), CurrentProfession=VALUES(CurrentProfession), CurrentRace=VALUES(CurrentRace), VerboseExp=VALUES(VerboseExp), VerboseMana=VALUES(VerboseMana), VerboseStamina=VALUES(VerboseStamina), VerboseSkills=VALUES(VerboseSkills)", 1005, 1008);){
            statement.setInt(1, hero.getDatabaseID());
            statement.setInt(2, hero.getMana());
            statement.setInt(3, hero.getStamina());
            statement.setInt(4, this.getClassID(hero.getHeroClass().getName()));
            statement.setInt(5, this.getClassID(hero.getSecondaryClass().getName()));
            statement.setInt(6, this.getClassID(hero.getRaceClass().getName()));
            statement.setBoolean(7, hero.isVerboseExp());
            statement.setBoolean(8, hero.isVerboseMana());
            statement.setBoolean(9, hero.isVerboseStamina());
            statement.setBoolean(10, hero.isVerboseSkills());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatePlayerMetadata(String playerName, UUID uuid, InetAddress address) {
        ResultSet set;
        PreparedStatement statement;
        Connection connection;
        int id = -1;
        try {
            connection = this.ds.getConnection();
            try {
                statement = connection.prepareStatement("SELECT * FROM HC_HeroMeta a JOIN HC_HeroMeta b ON a.HeroID=b.HeroID WHERE b.UUID=? limit 1", 1005, 1008);
                try {
                    statement.setString(1, uuid.toString());
                    set = statement.executeQuery();
                    try {
                        if (set.next()) {
                            id = set.getInt("HeroID");
                        }
                    }
                    finally {
                        if (set != null) {
                            set.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (id > 0) {
            try {
                connection = this.ds.getConnection();
                try {
                    statement = connection.prepareStatement("UPDATE HC_HeroMeta SET LastLogin=? WHERE HeroID=?");
                    try {
                        statement.setDate(1, new Date(System.currentTimeMillis()));
                        statement.setInt(2, id);
                        statement.executeUpdate();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                connection = this.ds.getConnection();
                try {
                    statement = connection.prepareStatement("INSERT INTO HC_HeroMeta(UUID, UserName, JoinDate, LastLogin, TimePlayed) VALUES (?,?,?,?,?)", 1);
                    try {
                        statement.setString(1, uuid.toString());
                        statement.setString(2, playerName);
                        statement.setDate(3, new Date(System.currentTimeMillis()));
                        statement.setDate(4, new Date(System.currentTimeMillis()));
                        statement.setDate(5, new Date(0L));
                        statement.executeUpdate();
                        set = statement.getGeneratedKeys();
                        try {
                            set.next();
                            id = set.getInt(1);
                        }
                        finally {
                            if (set != null) {
                                set.close();
                            }
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            connection = this.ds.getConnection();
            try {
                statement = connection.prepareStatement("INSERT INTO HC_PlayerIP(HeroID,Octet1, Octet2, Octet3, Octet4, LastJoin) VALUES(?,?,?,?,?,?)ON DUPLICATE KEY UPDATE LastJoin=VALUES(LastJoin)");
                try {
                    byte[] ip = address.getAddress();
                    statement.setInt(1, id);
                    statement.setInt(2, ip[0] & 0xFF);
                    statement.setInt(3, ip[1] & 0xFF);
                    statement.setInt(4, ip[2] & 0xFF);
                    statement.setInt(5, ip[3] & 0xFF);
                    statement.setDate(6, new Date(System.currentTimeMillis()));
                    statement.executeUpdate();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getHeroID(UUID uuid) {
        int id = -1;
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM HC_HeroMeta a JOIN HC_HeroMeta b ON a.HeroID=b.HeroID WHERE b.UUID=? limit 1", 1005, 1007);){
            statement.setString(1, uuid.toString());
            try (ResultSet set = statement.executeQuery();){
                set.first();
                id = set.getInt("HeroID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    @Override
    public Hero loadLegacyHero(Player player) {
        return null;
    }

    @Override
    public Hero loadHero(Player player) {
        Hero hero = null;
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_HeroInfo a JOIN HC_HeroMeta b ON a.HeroID=b.HeroID WHERE b.UUID=?", 1005, 1008);){
            statement.setString(1, player.getUniqueId().toString());
            try (ResultSet set = statement.executeQuery();){
                if (set.first()) {
                    HeroClass primary = this.plugin.getClassManager().getClass(this.getClassName(set.getInt("CurrentPrimary")));
                    HeroClass secondary = this.plugin.getClassManager().getClass(this.getClassName(set.getInt("CurrentProfession")));
                    HeroClass race = this.plugin.getClassManager().getClass(this.getClassName(set.getInt("CurrentRace")));
                    int heroID = set.getInt("HeroID");
                    hero = new Hero(this.plugin, player, this, primary, secondary, race, heroID);
                    this.loadAttributes(hero);
                    this.loadAllocationPoints(hero);
                    this.loadCooldowns(hero);
                    this.loadExperience(hero);
                    this.loadBinds(hero);
                    this.loadSkillSettings(hero);
                    this.loadSuppressedSkills(hero);
                    this.loadPreparedSkills(hero);
                    hero.rebuildAttributes();
                    hero.setMana(set.getInt("Mana"));
                    hero.setStamina(set.getInt("Stamina"));
                    hero.setVerboseStamina(set.getBoolean("VerboseStamina"));
                    hero.setVerboseSkills(set.getBoolean("VerboseSkills"));
                    hero.setVerboseMana(set.getBoolean("VerboseMana"));
                    hero.setVerboseExp(set.getBoolean("VerboseExp"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return hero;
    }

    @Override
    public void saveHero(Hero hero, boolean now) {
    }

    private void loadExperience(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_PlayerClasses WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    HeroClass heroClass = this.plugin.getClassManager().getClass(this.getClassName(set.getInt("ClassID")));
                    hero.setExperience(heroClass, set.getInt("Exp"));
                    if (!set.getBoolean("Mastery")) continue;
                    hero.setMastered(heroClass);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadCooldowns(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_PlayerCooldowns WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    hero.setCooldown(set.getString("SkillName"), set.getLong("CooldownTime"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadBinds(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_PlayerBinds WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    hero.bind(Material.getMaterial((String)set.getString("ToolID")), set.getString("SkillName").split(","));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadAttributes(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_Attribute WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    AttributeType attributeType = AttributeType.matchAttribute(set.getString("Type"));
                    if (attributeType == null) continue;
                    hero.setAllocatedAttribute(attributeType, set.getInt("Value"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadAllocationPoints(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_AllocationPoints WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    HeroClass heroClass = this.plugin.getClassManager().getClass(this.getClassName(set.getInt("ClassID")));
                    hero.setAllocationPoints(heroClass, set.getInt("Points"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadSkillSettings(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_SkillSettings WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    hero.setSkillSetting(set.getString("SkillName"), set.getString("SkillKey"), set.getObject("Value"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadSuppressedSkills(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_SuppressedSkill WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    hero.setSuppressed(this.plugin.getSkillManager().getSkill(set.getString("Skill")), true);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadPreparedSkills(Hero hero) {
        try (Connection connection = this.ds.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM RPG_PreparedSkills WHERE HeroID=?");){
            statement.setInt(1, hero.getDatabaseID());
            try (ResultSet set = statement.executeQuery();){
                while (set.next()) {
                    hero.setSkillPrepared(this.plugin.getSkillManager().getSkill(set.getString("Skill")), true);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        Bukkit.getScheduler().cancelTask(this.id.getTaskId());
        this.executor.execute(new HeroSaveTask());
        this.executor.shutdown();
    }

    protected class HeroSaveTask
    implements Runnable {
        protected HeroSaveTask() {
        }

        @Override
        public void run() {
            for (Hero hero : Heroes.getInstance().getCharacterManager().getHeroes()) {
                try {
                    Connection connection = SQLStorage.this.ds.getConnection();
                    try {
                        PreparedStatement statement = connection.prepareStatement("UPDATE RPG_HeroInfo SET Mana=?, Stamina=? WHERE HeroID=?");
                        try {
                            statement.setInt(1, hero.getMana());
                            statement.setInt(2, hero.getStamina());
                            statement.setInt(3, hero.getDatabaseID());
                            statement.executeUpdate();
                        }
                        finally {
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    System.out.println("A error occured while saving " + hero.getName());
                }
            }
        }
    }

    abstract class DbUpdate
    implements Runnable {
        DbUpdate() {
        }

        @Override
        public void run() {
            try (Connection connection = SQLStorage.this.ds.getConnection();
                 PreparedStatement statement = this.prepareUpdate(connection);){
                statement.executeUpdate();
            }
            catch (SQLException e) {
                Heroes.log(Level.SEVERE, e + "\n " + TextUtil.formatStackTrace(e));
            }
        }

        abstract PreparedStatement prepareUpdate(Connection var1) throws SQLException;
    }
}

