/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.storage;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.storage.Storage;
import com.herocraftonline.heroes.storage.managers.SQLStorage;
import com.herocraftonline.heroes.storage.managers.YMLStorage;
import com.herocraftonline.heroes.util.TextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class StorageManager
extends URLClassLoader {
    private final Map<String, Storage> storageHandlers = new HashMap<String, Storage>();
    private final Heroes plugin;
    private final Map<String, File> storageFiles = new HashMap<String, File>();
    private final String configuredStorage;

    public StorageManager(Heroes plugin) {
        super(((URLClassLoader)((Object)((Object)plugin)).getClass().getClassLoader()).getURLs(), ((Object)((Object)plugin)).getClass().getClassLoader());
        this.plugin = plugin;
        File dir = new File(plugin.getDataFolder(), "storage");
        dir.mkdir();
        this.configuredStorage = Heroes.properties.storageType;
        try {
            switch (this.configuredStorage) {
                case "yml": {
                    this.storageHandlers.put("yml", new YMLStorage(plugin));
                    break;
                }
                case "sql": {
                    this.storageHandlers.put("sql", new SQLStorage(plugin));
                    break;
                }
                default: {
                    Heroes.log(Level.WARNING, "|||||||||||||||||||||||||||||||||||||||||||||||||||||");
                    Heroes.log(Level.WARNING, "|| ------------------- WARNING ------------------- ||");
                    Heroes.log(Level.WARNING, "|| YOU ARE ATTEMPTING TO USE " + this.configuredStorage + " ||");
                    Heroes.log(Level.WARNING, "|| WHICH IS NOT YML! WE DO NOT PROVIDE ANY SUPPORT ||");
                    Heroes.log(Level.WARNING, "|| FOR THIRD PARTY STORAGE SYSTEMS! IF YOU HAVE    ||");
                    Heroes.log(Level.WARNING, "|| ISSUES, CONTACT THE DEVELOPER OF THE STORAGE    ||");
                    Heroes.log(Level.WARNING, "|| PLUGIN!               -Heroes Dev               ||");
                    Heroes.log(Level.WARNING, "|||||||||||||||||||||||||||||||||||||||||||||||||||||");
                    String[] list = dir.list();
                    if (list == null) {
                        throw new IllegalArgumentException("There is no storage jar called " + Heroes.properties.storageType + "!");
                    }
                    for (String storageFile : dir.list()) {
                        if (!storageFile.contains(".jar")) continue;
                        File file = new File(dir, storageFile);
                        String name = storageFile.toLowerCase().replace(".jar", "");
                        if (this.storageFiles.containsKey(name)) {
                            Heroes.log(Level.SEVERE, "Duplicate Storage jar found! Please remove " + storageFile + " or " + this.storageFiles.get(name).getName());
                            continue;
                        }
                        if (Heroes.properties.debug) {
                            Heroes.log(Level.INFO, "Loading " + storageFile);
                        }
                        this.storageFiles.put(name, file);
                        try {
                            this.addURL(file.toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            Heroes.log(Level.SEVERE, "Storage jar provided gave MalformedURLException!" + e);
                            Heroes.debugLog(Level.SEVERE, TextUtil.formatStackTrace(e));
                        }
                    }
                    this.initializeStorage(Heroes.properties.storageType);
                    break;
                }
            }
        }
        catch (Exception e) {
            Heroes.log(Level.SEVERE, "Encountered issues loading storage type " + this.configuredStorage + ", check your config! \n" + e.getMessage() + "\nDisabling plugin..");
            Heroes.debugLog(Level.SEVERE, TextUtil.formatStackTrace(e));
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    private void initializeStorage(String storageType) {
        if (this.isListed(storageType.toLowerCase())) {
            this.loadStorage(storageType);
        } else {
            Heroes.log(Level.SEVERE, "There is no storage jar called " + Heroes.properties.storageType + "! Disabling Heroes!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    public void addStorage(Storage storage) {
        this.storageHandlers.put(storage.getName().toLowerCase(), storage);
    }

    public Storage getStorage() {
        return this.storageHandlers.get(this.configuredStorage.toLowerCase());
    }

    private boolean isListed(String name) {
        return this.storageFiles.containsKey(name.toLowerCase());
    }

    private boolean loadStorage(String name) {
        Storage storage = this.loadStorage(this.storageFiles.get(name.toLowerCase()));
        if (storage == null) {
            return false;
        }
        this.addStorage(storage);
        return true;
    }

    private Storage loadStorage(File file) {
        try {
            String mainClass;
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> entries = jarFile.entries();
                mainClass = null;
                while (entries.hasMoreElements()) {
                    JarEntry element = entries.nextElement();
                    if (!element.getName().equalsIgnoreCase("storage.info")) continue;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(element)));
                    mainClass = reader.readLine().substring(12);
                    break;
                }
            }
            if (mainClass != null) {
                Class<?> clazz = Class.forName(mainClass, true, this);
                Class<Storage> storageClass = clazz.asSubclass(Storage.class);
                Constructor<Storage> ctor = storageClass.getConstructor(((Object)((Object)this.plugin)).getClass());
                return ctor.newInstance(new Object[]{this.plugin});
            }
            throw new IllegalArgumentException();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Heroes.log(Level.WARNING, "Unable to load " + file.getName() + " storage was written for a previous Heroes version, please check the debug.log for more information!");
            if (Heroes.properties.debug) {
                Heroes.debugThrow(this.getClass().toString(), "loadStorage", e);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            Heroes.log(Level.SEVERE, "Could not detect the proper storage class to load for: " + file.getName());
            return null;
        }
        catch (Exception e) {
            Heroes.log(Level.INFO, "The storage " + file.getName() + " failed to load for an unknown reason.");
            if (Heroes.properties.debug) {
                Heroes.debugLog.getLogger().throwing(this.getClass().getName(), "loadStorage", e);
            }
            return null;
        }
    }
}

