/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.storage;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.nms.NMSHandler;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public abstract class Storage {
    protected Heroes plugin;
    protected String name;
    protected List<UUID> playerNotToSave = new ArrayList<UUID>();

    public Storage(Heroes plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Hero createNewHero(Player player) {
        HeroClass defaultRace = this.plugin.getClassManager().getDefaultRace();
        if (defaultRace == null) {
            defaultRace = this.plugin.getClassManager().getDefaultProfession();
        }
        Hero hero = new Hero(this.plugin, player, this, this.plugin.getClassManager().getDefaultClass(), this.plugin.getClassManager().getDefaultProfession(), defaultRace, this.getHeroID(player.getUniqueId()));
        hero.resetMaxHP();
        this.plugin.getStorageManager().getStorage().createHero(hero);
        player.setHealth(hero.getMaxHealth());
        NMSHandler.getInterface().setAbsorptionHearts(player, hero.getScaledMaxShield());
        hero.setMana(hero.getMaxMana());
        hero.setStamina(hero.getMaxStamina());
        hero.setVerboseExp(Heroes.properties.defaultVerboseExp);
        hero.setVerboseMana(Heroes.properties.defaultVerboseMana);
        hero.setVerboseStamina(Heroes.properties.defaultVerboseStamina);
        hero.setVerboseSkills(Heroes.properties.defaultVerboseSkills);
        return hero;
    }

    public List<UUID> getPlayerNotToSave() {
        return Collections.unmodifiableList(this.playerNotToSave);
    }

    public void addPlayerNotToSave(Player player) {
        this.playerNotToSave.add(player.getUniqueId());
    }

    public void removePlayerNotToSave(Player player) {
        this.playerNotToSave.remove(player.getUniqueId());
    }

    public boolean isPlayerNotToSave(Player player) {
        return this.playerNotToSave.contains(player.getUniqueId());
    }

    public abstract Hero loadHero(Player var1);

    public void savePlayer(Player player) {
        this.saveHero(Heroes.getInstance().getCharacterManager().getHero(player), true);
    }

    @Deprecated
    public abstract void saveHero(Hero var1, boolean var2);

    public abstract void shutdown();

    public abstract void saveHeroXP(Hero var1, HeroClass var2);

    public abstract void saveHeroClass(Hero var1, HeroClass var2, boolean var3, boolean var4);

    public abstract void destroyHeroBind(Hero var1, Material var2);

    public abstract void saveHeroBind(Hero var1, Material var2, String[] var3);

    public abstract void clearHeroBinds(Hero var1);

    public abstract void saveHeroSkillSettings(Hero var1, String var2, String var3, Object var4);

    public abstract void saveHeroAttribute(Hero var1, HeroClass var2, AttributeType var3, int var4);

    public abstract void resetHeroAttribute(Hero var1);

    public abstract void saveHeroCooldown(Hero var1, String var2, long var3);

    public abstract void clearHeroCooldowns(Hero var1);

    public abstract void removeHeroCooldown(Hero var1, String var2);

    public abstract void saveHeroAllocationPoint(Hero var1, HeroClass var2, int var3);

    public abstract void resetHeroAllocationPoint(Hero var1);

    public abstract void addHeroSuppressedSkill(Hero var1, Skill var2);

    public abstract void removeHeroSuppressedSkill(Hero var1, Skill var2);

    public abstract void addHeroLearnedSkill(HeroSkill var1);

    public abstract void loadHeroLearnedSkill(HeroSkill var1);

    public abstract void removeHeroLearnedSkill(HeroSkill var1);

    public abstract void addHeroPreparedSkill(Hero var1, Skill var2);

    public abstract void removeHeroPreparedSkill(Hero var1, Skill var2);

    public abstract void resetHeroExperience(Hero var1);

    public abstract void resetHeroMasteries(Hero var1);

    public abstract void setHeroClassMastered(Hero var1, HeroClass var2);

    public abstract void setHeroVerboseExp(Hero var1, boolean var2);

    public abstract void setHeroVerboseMana(Hero var1, boolean var2);

    public abstract void setHeroVerboseStamina(Hero var1, boolean var2);

    public abstract void setHeroVerboseSkills(Hero var1, boolean var2);

    public abstract void createHero(Hero var1);

    public abstract void updatePlayerMetadata(String var1, UUID var2, InetAddress var3);

    public abstract int getHeroID(UUID var1);

    public abstract Hero loadLegacyHero(Player var1);
}

