/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics.collision;

import com.herocraftonline.heroes.nms.physics.collision.Sphere;
import com.herocraftonline.heroes.nms.versions.physics.collision.AABB_v1_13_R2;
import com.herocraftonline.heroes.nms.versions.physics.collision.BaseColliderVolume_v1_13_R2;
import net.minecraft.server.v1_13_R2.AxisAlignedBB;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class Sphere_v1_13_R2
extends BaseColliderVolume_v1_13_R2
implements Sphere {
    private final double cX;
    private final double cY;
    private final double cZ;
    private final double radius;
    private final AABB_v1_13_R2 bounds;

    public static boolean aabbOverlap(AxisAlignedBB nmsAABB, double cX, double cY, double cZ, double radius) {
        double distanceSq = NumberConversions.square((double)radius);
        if (cX < nmsAABB.minX) {
            distanceSq -= NumberConversions.square((double)(cX - nmsAABB.minX));
        } else if (cX > nmsAABB.maxX) {
            distanceSq -= NumberConversions.square((double)(cX - nmsAABB.maxX));
        }
        if (cY < nmsAABB.minY) {
            distanceSq -= NumberConversions.square((double)(cY - nmsAABB.minY));
        } else if (cY > nmsAABB.maxY) {
            distanceSq -= NumberConversions.square((double)(cY - nmsAABB.maxY));
        }
        if (cZ < nmsAABB.minZ) {
            distanceSq -= NumberConversions.square((double)(cZ - nmsAABB.minZ));
        } else if (cZ > nmsAABB.maxZ) {
            distanceSq -= NumberConversions.square((double)(cZ - nmsAABB.maxZ));
        }
        return distanceSq > 0.0;
    }

    public Sphere_v1_13_R2(double cX, double cY, double cZ, double radius) {
        this.cX = cX;
        this.cY = cY;
        this.cZ = cZ;
        this.radius = Math.abs(radius);
        this.bounds = AABB_v1_13_R2.createGeneric(cX - radius, cY - radius, cZ - radius, cX + radius, cY + radius, cZ + radius);
    }

    @Override
    public AABB_v1_13_R2 getBounds() {
        return this.bounds;
    }

    @Override
    public boolean postBoundsOverlapsWithAABB(AxisAlignedBB nmsAABB) {
        return Sphere_v1_13_R2.aabbOverlap(nmsAABB, this.cX, this.cY, this.cZ, this.radius);
    }

    @Override
    public double getCenterX() {
        return this.cX;
    }

    @Override
    public double getCenterY() {
        return this.cY;
    }

    @Override
    public double getCenterZ() {
        return this.cZ;
    }

    @Override
    public Vector getCenter() {
        return new Vector(this.cX, this.cY, this.cZ);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public Sphere_v1_13_R2 offset(double x, double y, double z) {
        return new Sphere_v1_13_R2(this.cX + x, this.cY + y, this.cZ + z, this.radius);
    }

    @Override
    public Sphere_v1_13_R2 offset(Vector vector) {
        return this.offset(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public Sphere_v1_13_R2 expand(double amount) {
        return new Sphere_v1_13_R2(this.cX, this.cY, this.cZ, this.radius + amount);
    }

    @Override
    public Sphere_v1_13_R2 contract(double amount) {
        return new Sphere_v1_13_R2(this.cX, this.cY, this.cZ, this.radius - amount);
    }

    @Override
    public boolean containsPoint(double x, double y, double z) {
        return NumberConversions.square((double)(x - this.cX)) + NumberConversions.square((double)(y - this.cY)) + NumberConversions.square((double)(z - this.cZ)) <= NumberConversions.square((double)this.radius);
    }

    @Override
    public boolean containsPoint(Vector point) {
        return this.containsPoint(point.getX(), point.getY(), point.getZ());
    }
}

