/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics.collision;

import com.herocraftonline.heroes.nms.physics.collision.Sphere;
import com.herocraftonline.heroes.nms.versions.physics.collision.AxisAlignedBoundingBox;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_BaseColliderVolume;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class R_Sphere
extends R_BaseColliderVolume
implements Sphere {
    private final double cX;
    private final double cY;
    private final double cZ;
    private final double radius;
    private final AxisAlignedBoundingBox bounds;

    public static boolean aabbOverlap(AxisAlignedBoundingBox AABB2, double cX, double cY, double cZ, double radius) {
        double distanceSq = NumberConversions.square((double)radius);
        double minX = AABB2.getMinX();
        double minY = AABB2.getMinY();
        double minZ = AABB2.getMinZ();
        double maxX = AABB2.getMaxX();
        double maxY = AABB2.getMaxY();
        double maxZ = AABB2.getMaxZ();
        if (cX < minX) {
            distanceSq -= NumberConversions.square((double)(cX - minX));
        } else if (cX > maxX) {
            distanceSq -= NumberConversions.square((double)(cX - maxX));
        }
        if (cY < minY) {
            distanceSq -= NumberConversions.square((double)(cY - minY));
        } else if (cY > maxY) {
            distanceSq -= NumberConversions.square((double)(cY - maxY));
        }
        if (cZ < minZ) {
            distanceSq -= NumberConversions.square((double)(cZ - minZ));
        } else if (cZ > maxZ) {
            distanceSq -= NumberConversions.square((double)(cZ - maxZ));
        }
        return distanceSq > 0.0;
    }

    public R_Sphere(double cX, double cY, double cZ, double radius) {
        this.cX = cX;
        this.cY = cY;
        this.cZ = cZ;
        this.radius = Math.abs(radius);
        this.bounds = new AxisAlignedBoundingBox(cX - radius, cY - radius, cZ - radius, cX + radius, cY + radius, cZ + radius);
    }

    @Override
    public AxisAlignedBoundingBox getBounds() {
        return this.bounds;
    }

    @Override
    public boolean postBoundsOverlapsWithAABB(AxisAlignedBoundingBox nmsAABB) {
        return R_Sphere.aabbOverlap(nmsAABB, this.cX, this.cY, this.cZ, this.radius);
    }

    @Override
    public double getCenterX() {
        return this.cX;
    }

    @Override
    public double getCenterY() {
        return this.cY;
    }

    @Override
    public double getCenterZ() {
        return this.cZ;
    }

    @Override
    public Vector getCenter() {
        return new Vector(this.cX, this.cY, this.cZ);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public R_Sphere offset(double x, double y, double z) {
        return new R_Sphere(this.cX + x, this.cY + y, this.cZ + z, this.radius);
    }

    @Override
    public R_Sphere offset(Vector vector) {
        return this.offset(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public R_Sphere expand(double amount) {
        return new R_Sphere(this.cX, this.cY, this.cZ, this.radius + amount);
    }

    @Override
    public R_Sphere contract(double amount) {
        return new R_Sphere(this.cX, this.cY, this.cZ, this.radius - amount);
    }

    @Override
    public boolean containsPoint(double x, double y, double z) {
        return NumberConversions.square((double)(x - this.cX)) + NumberConversions.square((double)(y - this.cY)) + NumberConversions.square((double)(z - this.cZ)) <= NumberConversions.square((double)this.radius);
    }

    @Override
    public boolean containsPoint(Vector point) {
        return this.containsPoint(point.getX(), point.getY(), point.getZ());
    }
}

