/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics.collision;

import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.versions.physics.collision.AxisAlignedBoundingBox;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_BaseColliderVolume;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_Sphere;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class R_Capsule
extends R_BaseColliderVolume
implements Capsule {
    private final double x1;
    private final double y1;
    private final double z1;
    private final double x2;
    private final double y2;
    private final double z2;
    private final double radius;
    private final AxisAlignedBoundingBox bounds;

    public static boolean aabbOverlapTest(AxisAlignedBoundingBox nmsAABB, double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        double tN;
        double sN;
        double D;
        Vector c2;
        Vector c1;
        Double cornerZ;
        Double cornerY;
        Double cornerX;
        Vector start = new Vector(x1, y1, z1);
        Vector end = new Vector(x2, y2, z2);
        AxisAlignedBoundingBox expandedAABB = nmsAABB.expand(radius);
        Vector mop = expandedAABB.intersectLine(start, end);
        double minX = expandedAABB.getMinX();
        double minY = expandedAABB.getMinY();
        double minZ = expandedAABB.getMinZ();
        double maxX = expandedAABB.getMaxX();
        double maxY = expandedAABB.getMaxY();
        double maxZ = expandedAABB.getMaxZ();
        if (mop == null) {
            if (expandedAABB.getBoundingBox().contains(start) && expandedAABB.getBoundingBox().contains(end)) {
                if (nmsAABB.intersectLine(start, end) != null) {
                    return true;
                }
                if (R_Sphere.aabbOverlap(nmsAABB, x1, y1, z1, radius) || R_Sphere.aabbOverlap(nmsAABB, x2, y2, z2, radius)) {
                    return true;
                }
                if (R_Sphere.aabbOverlap(nmsAABB, x1 + (x2 - x1) * 0.25, y1 + (y2 - y1) * 0.25, z1 + (z2 - z1) * 0.25, radius) || R_Sphere.aabbOverlap(nmsAABB, x1 + (x2 - x1) * 0.5, y1 + (y2 - y1) * 0.5, z1 + (z2 - z1) * 0.5, radius) || R_Sphere.aabbOverlap(nmsAABB, x1 + (x2 - x1) * 0.75, y1 + (y2 - y1) * 0.75, z1 + (z2 - z1) * 0.75, radius)) {
                    return true;
                }
                return R_Capsule.pointTest(minX, minY, minZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(minX, minY, maxZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(minX, maxY, minZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(minX, maxY, maxZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(maxX, minY, minZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(maxX, minY, maxZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(maxX, maxY, minZ, x1, y1, z1, x2, y2, z2, radius) || R_Capsule.pointTest(maxX, maxY, maxZ, x1, y1, z1, x2, y2, z2, radius);
            }
            return false;
        }
        int uf = 0;
        int vf = 0;
        if (mop.getX() < minX) {
            uf |= 1;
            cornerX = minX;
        } else if (mop.getX() > maxX) {
            vf |= 1;
            cornerX = maxX;
        } else {
            cornerX = null;
        }
        if (mop.getY() < minY) {
            uf |= 2;
            cornerY = minY;
        } else if (mop.getY() > maxY) {
            vf |= 2;
            cornerY = maxY;
        } else {
            cornerY = null;
        }
        if (mop.getZ() < minZ) {
            uf |= 4;
            cornerZ = minZ;
        } else if (mop.getZ() > maxZ) {
            vf |= 4;
            cornerZ = maxZ;
        } else {
            cornerZ = null;
        }
        int m = uf | vf;
        if (m == 7) {
            return R_Capsule.pointTest(cornerX, cornerY, cornerZ, x1, y1, z1, x2, y2, z2, radius);
        }
        if ((m & m - 1) == 0) {
            return true;
        }
        if (cornerX == null) {
            c1 = new Vector(minX, cornerY.doubleValue(), cornerZ.doubleValue());
            c2 = new Vector(maxX, cornerY.doubleValue(), cornerZ.doubleValue());
        } else if (cornerY == null) {
            c1 = new Vector(cornerX.doubleValue(), minY, cornerZ.doubleValue());
            c2 = new Vector(cornerX.doubleValue(), maxY, cornerZ.doubleValue());
        } else if (cornerZ == null) {
            c1 = new Vector(cornerX.doubleValue(), cornerY.doubleValue(), minZ);
            c2 = new Vector(cornerX.doubleValue(), cornerY.doubleValue(), maxZ);
        } else {
            throw new RuntimeException("THIS SHOULDN'T HAPPEN!");
        }
        Vector u = new Vector(x2 - x1, y2 - y1, z2 - z1);
        Vector v = c2.subtract(c1);
        Vector w = new Vector(x1, y1, z1).subtract(c1);
        double a = u.dot(u);
        double b = u.dot(v);
        double c = v.dot(v);
        double d = u.dot(w);
        double e = v.dot(w);
        double sD = D = a * c - b * b;
        double tD = D;
        if (D < Vector.getEpsilon()) {
            sN = 0.0;
            sD = 1.0;
            tN = e;
            tD = c;
        } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0) {
                sN = 0.0;
                tN = e;
                tD = c;
            } else if (sN > sD) {
                sN = sD;
                tN = e + b;
                tD = c;
            }
        }
        if (tN < 0.0) {
            tN = 0.0;
            if (-d < 0.0) {
                sN = 0.0;
            } else if (-d > a) {
                sN = sD;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            tN = tD;
            if (-d + b < 0.0) {
                sN = 0.0;
            } else if (-d + b > a) {
                sN = sD;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        double sc = Math.abs(sN) < Vector.getEpsilon() ? 0.0 : sN / sD;
        double tc = Math.abs(tN) < Vector.getEpsilon() ? 0.0 : tN / tD;
        Vector dP = w.clone().add(u.clone().multiply(sc)).subtract(v.clone().multiply(tc));
        return dP.lengthSquared() <= NumberConversions.square((double)radius);
    }

    public static boolean pointTest(double pX, double pY, double pZ, double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double cdx = pX - x1;
        double cdy = pY - y1;
        double cdz = pZ - z1;
        double radiusSq = NumberConversions.square((double)radius);
        double lengthSq = NumberConversions.square((double)dx) + NumberConversions.square((double)dy) + NumberConversions.square((double)dz);
        double dot = cdx * dx + cdy * dy + cdz * dz;
        if (dot < 0.0) {
            return NumberConversions.square((double)(pX - x1)) + NumberConversions.square((double)(pY - y1)) + NumberConversions.square((double)(pZ - z1)) <= radiusSq;
        }
        if (dot > lengthSq) {
            return NumberConversions.square((double)(pX - x2)) + NumberConversions.square((double)(pY - y2)) + NumberConversions.square((double)(pZ - z2)) <= radiusSq;
        }
        return NumberConversions.square((double)cdx) + NumberConversions.square((double)cdy) + NumberConversions.square((double)cdz) - NumberConversions.square((double)dot) / lengthSq <= radiusSq;
    }

    public R_Capsule(double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.radius = Math.abs(radius);
        this.bounds = new AxisAlignedBoundingBox(Math.min(x1, x2) - radius, Math.min(y1, y2) - radius, Math.min(z1, z2) - radius, Math.max(x1, x2) + radius, Math.max(y1, y2) + radius, Math.max(z1, z2) + radius);
    }

    @Override
    public AxisAlignedBoundingBox getBounds() {
        return this.bounds;
    }

    @Override
    public boolean postBoundsOverlapsWithAABB(AxisAlignedBoundingBox nmsAABB) {
        return R_Capsule.aabbOverlapTest(nmsAABB, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius);
    }

    @Override
    public double getX1() {
        return this.x1;
    }

    @Override
    public double getY1() {
        return this.y1;
    }

    @Override
    public double getZ1() {
        return this.z1;
    }

    @Override
    public Vector getPoint1() {
        return new Vector(this.x1, this.y1, this.z1);
    }

    @Override
    public double getX2() {
        return this.x2;
    }

    @Override
    public double getY2() {
        return this.y2;
    }

    @Override
    public double getZ2() {
        return this.z2;
    }

    @Override
    public Vector getPoint2() {
        return new Vector(this.x2, this.y2, this.z2);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public R_Capsule offset(double x, double y, double z) {
        return new R_Capsule(this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z, this.radius);
    }

    @Override
    public R_Capsule offset(Vector vector) {
        return this.offset(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public boolean containsPoint(double x, double y, double z) {
        return R_Capsule.pointTest(x, y, z, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius);
    }

    @Override
    public boolean containsPoint(Vector point) {
        return this.containsPoint(point.getX(), point.getY(), point.getZ());
    }

    @Override
    public R_Capsule expand(double amount) {
        return new R_Capsule(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius + amount);
    }

    @Override
    public R_Capsule contract(double amount) {
        return new R_Capsule(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius - amount);
    }
}

