/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics.collision;

import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.versions.physics.collision.AABB_v1_13_R1;
import com.herocraftonline.heroes.nms.versions.physics.collision.BaseColliderVolume_v1_13_R1;
import com.herocraftonline.heroes.nms.versions.physics.collision.Sphere_v1_13_R1;
import net.minecraft.server.v1_13_R2.AxisAlignedBB;
import net.minecraft.server.v1_13_R2.MovingObjectPosition;
import net.minecraft.server.v1_13_R2.Vec3D;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class Capsule_v1_13_R1
extends BaseColliderVolume_v1_13_R1
implements Capsule {
    private final double x1;
    private final double y1;
    private final double z1;
    private final double x2;
    private final double y2;
    private final double z2;
    private final double radius;
    private final AABB_v1_13_R1 bounds;

    public static boolean aabbOverlapTest(AxisAlignedBB nmsAABB, double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        double tN;
        double sN;
        double D;
        Vector c2;
        Vector c1;
        Double cornerZ;
        Double cornerY;
        Double cornerX;
        Vec3D nmsStart = new Vec3D(x1, y1, z1);
        Vec3D nmsEnd = new Vec3D(x2, y2, z2);
        AxisAlignedBB expandedAABB = nmsAABB.grow(radius, radius, radius);
        MovingObjectPosition mop = expandedAABB.b(nmsStart, nmsEnd);
        if (mop == null) {
            if (expandedAABB.b(nmsStart) && expandedAABB.b(nmsEnd)) {
                if (nmsAABB.b(nmsStart, nmsEnd) != null) {
                    return true;
                }
                if (Sphere_v1_13_R1.aabbOverlap(nmsAABB, x1, y1, z1, radius) || Sphere_v1_13_R1.aabbOverlap(nmsAABB, x2, y2, z2, radius)) {
                    return true;
                }
                if (Sphere_v1_13_R1.aabbOverlap(nmsAABB, x1 + (x2 - x1) * 0.25, y1 + (y2 - y1) * 0.25, z1 + (z2 - z1) * 0.25, radius) || Sphere_v1_13_R1.aabbOverlap(nmsAABB, x1 + (x2 - x1) * 0.5, y1 + (y2 - y1) * 0.5, z1 + (z2 - z1) * 0.5, radius) || Sphere_v1_13_R1.aabbOverlap(nmsAABB, x1 + (x2 - x1) * 0.75, y1 + (y2 - y1) * 0.75, z1 + (z2 - z1) * 0.75, radius)) {
                    return true;
                }
                return Capsule_v1_13_R1.pointTest(nmsAABB.a, nmsAABB.b, nmsAABB.c, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.a, nmsAABB.b, nmsAABB.f, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.a, nmsAABB.e, nmsAABB.c, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.a, nmsAABB.e, nmsAABB.f, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.d, nmsAABB.b, nmsAABB.c, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.d, nmsAABB.b, nmsAABB.f, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.d, nmsAABB.e, nmsAABB.c, x1, y1, z1, x2, y2, z2, radius) || Capsule_v1_13_R1.pointTest(nmsAABB.d, nmsAABB.e, nmsAABB.f, x1, y1, z1, x2, y2, z2, radius);
            }
            return false;
        }
        int uf = 0;
        int vf = 0;
        if (mop.pos.x < nmsAABB.a) {
            uf |= 1;
            cornerX = nmsAABB.a;
        } else if (mop.pos.x > nmsAABB.d) {
            vf |= 1;
            cornerX = nmsAABB.d;
        } else {
            cornerX = null;
        }
        if (mop.pos.y < nmsAABB.b) {
            uf |= 2;
            cornerY = nmsAABB.b;
        } else if (mop.pos.y > nmsAABB.e) {
            vf |= 2;
            cornerY = nmsAABB.e;
        } else {
            cornerY = null;
        }
        if (mop.pos.z < nmsAABB.c) {
            uf |= 4;
            cornerZ = nmsAABB.c;
        } else if (mop.pos.z > nmsAABB.f) {
            vf |= 4;
            cornerZ = nmsAABB.f;
        } else {
            cornerZ = null;
        }
        int m = uf | vf;
        if (m == 7) {
            return Capsule_v1_13_R1.pointTest(cornerX, cornerY, cornerZ, x1, y1, z1, x2, y2, z2, radius);
        }
        if ((m & m - 1) == 0) {
            return true;
        }
        if (cornerX == null) {
            c1 = new Vector(nmsAABB.a, cornerY.doubleValue(), cornerZ.doubleValue());
            c2 = new Vector(nmsAABB.d, cornerY.doubleValue(), cornerZ.doubleValue());
        } else if (cornerY == null) {
            c1 = new Vector(cornerX.doubleValue(), nmsAABB.b, cornerZ.doubleValue());
            c2 = new Vector(cornerX.doubleValue(), nmsAABB.e, cornerZ.doubleValue());
        } else if (cornerZ == null) {
            c1 = new Vector(cornerX.doubleValue(), cornerY.doubleValue(), nmsAABB.c);
            c2 = new Vector(cornerX.doubleValue(), cornerY.doubleValue(), nmsAABB.f);
        } else {
            throw new RuntimeException("THIS SHOULDN'T HAPPEN!");
        }
        Vector u = new Vector(x2 - x1, y2 - y1, z2 - z1);
        Vector v = c2.subtract(c1);
        Vector w = new Vector(x1, y1, z1).subtract(c1);
        double a = u.dot(u);
        double b = u.dot(v);
        double c = v.dot(v);
        double d = u.dot(w);
        double e = v.dot(w);
        double sD = D = a * c - b * b;
        double tD = D;
        if (D < Vector.getEpsilon()) {
            sN = 0.0;
            sD = 1.0;
            tN = e;
            tD = c;
        } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0) {
                sN = 0.0;
                tN = e;
                tD = c;
            } else if (sN > sD) {
                sN = sD;
                tN = e + b;
                tD = c;
            }
        }
        if (tN < 0.0) {
            tN = 0.0;
            if (-d < 0.0) {
                sN = 0.0;
            } else if (-d > a) {
                sN = sD;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            tN = tD;
            if (-d + b < 0.0) {
                sN = 0.0;
            } else if (-d + b > a) {
                sN = sD;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        double sc = Math.abs(sN) < Vector.getEpsilon() ? 0.0 : sN / sD;
        double tc = Math.abs(tN) < Vector.getEpsilon() ? 0.0 : tN / tD;
        Vector dP = w.clone().add(u.clone().multiply(sc)).subtract(v.clone().multiply(tc));
        return dP.lengthSquared() <= NumberConversions.square((double)radius);
    }

    public static boolean pointTest(double pX, double pY, double pZ, double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double cdx = pX - x1;
        double cdy = pY - y1;
        double cdz = pZ - z1;
        double radiusSq = NumberConversions.square((double)radius);
        double lengthSq = NumberConversions.square((double)dx) + NumberConversions.square((double)dy) + NumberConversions.square((double)dz);
        double dot = cdx * dx + cdy * dy + cdz * dz;
        if (dot < 0.0) {
            return NumberConversions.square((double)(pX - x1)) + NumberConversions.square((double)(pY - y1)) + NumberConversions.square((double)(pZ - z1)) <= radiusSq;
        }
        if (dot > lengthSq) {
            return NumberConversions.square((double)(pX - x2)) + NumberConversions.square((double)(pY - y2)) + NumberConversions.square((double)(pZ - z2)) <= radiusSq;
        }
        return NumberConversions.square((double)cdx) + NumberConversions.square((double)cdy) + NumberConversions.square((double)cdz) - NumberConversions.square((double)dot) / lengthSq <= radiusSq;
    }

    public Capsule_v1_13_R1(double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.radius = Math.abs(radius);
        this.bounds = AABB_v1_13_R1.createGeneric(Math.min(x1, x2) - radius, Math.min(y1, y2) - radius, Math.min(z1, z2) - radius, Math.max(x1, x2) + radius, Math.max(y1, y2) + radius, Math.max(z1, z2) + radius);
    }

    @Override
    public AABB_v1_13_R1 getBounds() {
        return this.bounds;
    }

    @Override
    public boolean postBoundsOverlapsWithAABB(AxisAlignedBB nmsAABB) {
        return Capsule_v1_13_R1.aabbOverlapTest(nmsAABB, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius);
    }

    @Override
    public double getX1() {
        return this.x1;
    }

    @Override
    public double getY1() {
        return this.y1;
    }

    @Override
    public double getZ1() {
        return this.z1;
    }

    @Override
    public Vector getPoint1() {
        return new Vector(this.x1, this.y1, this.z1);
    }

    @Override
    public double getX2() {
        return this.x2;
    }

    @Override
    public double getY2() {
        return this.y2;
    }

    @Override
    public double getZ2() {
        return this.z2;
    }

    @Override
    public Vector getPoint2() {
        return new Vector(this.x2, this.y2, this.z2);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public Capsule_v1_13_R1 offset(double x, double y, double z) {
        return new Capsule_v1_13_R1(this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z, this.radius);
    }

    @Override
    public Capsule_v1_13_R1 offset(Vector vector) {
        return this.offset(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public boolean containsPoint(double x, double y, double z) {
        return Capsule_v1_13_R1.pointTest(x, y, z, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius);
    }

    @Override
    public boolean containsPoint(Vector point) {
        return this.containsPoint(point.getX(), point.getY(), point.getZ());
    }

    @Override
    public Capsule_v1_13_R1 expand(double amount) {
        return new Capsule_v1_13_R1(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius + amount);
    }

    @Override
    public Capsule_v1_13_R1 contract(double amount) {
        return new Capsule_v1_13_R1(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.radius - amount);
    }
}

