/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics.collision;

import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.versions.physics.R_RayCastHit;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_BaseColliderVolume;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class AxisAlignedBoundingBox
extends R_BaseColliderVolume
implements AABB {
    private final BoundingBox aabb;

    public AxisAlignedBoundingBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.aabb = new BoundingBox(x1, y1, z1, x2, y2, z2);
    }

    public AxisAlignedBoundingBox(Vector corner1, Vector corner2) {
        this.aabb = BoundingBox.of((Vector)corner1, (Vector)corner2);
    }

    public AxisAlignedBoundingBox(BoundingBox aabb) {
        this.aabb = aabb;
    }

    public BoundingBox getBoundingBox() {
        return this.aabb;
    }

    public AxisAlignedBoundingBox convertFromAABB(AABB aabb) {
        return new AxisAlignedBoundingBox(aabb.getMinX(), aabb.getMinY(), aabb.getMinZ(), aabb.getMaxX(), aabb.getMaxY(), aabb.getMaxZ());
    }

    public static AxisAlignedBoundingBox createGenericFromEntity(Entity entity) {
        return new AxisAlignedBoundingBox(entity.getBoundingBox());
    }

    @Override
    public double getMinX() {
        return this.aabb.getMinX();
    }

    @Override
    public double getMinY() {
        return this.aabb.getMinY();
    }

    @Override
    public double getMinZ() {
        return this.aabb.getMinZ();
    }

    @Override
    public Vector getMin() {
        return this.aabb.getMin();
    }

    @Override
    public double getMaxX() {
        return this.aabb.getMaxX();
    }

    @Override
    public double getMaxY() {
        return this.aabb.getMaxY();
    }

    @Override
    public double getMaxZ() {
        return this.aabb.getMaxZ();
    }

    @Override
    public Vector getMax() {
        return this.aabb.getMax();
    }

    @Override
    public double getCenterX() {
        return this.aabb.getCenterX();
    }

    @Override
    public double getCenterY() {
        return this.aabb.getCenterY();
    }

    @Override
    public double getCenterZ() {
        return this.aabb.getCenterZ();
    }

    @Override
    public Vector getCenter() {
        return this.aabb.getCenter();
    }

    @Override
    public AxisAlignedBoundingBox extend(double x, double y, double z) {
        return new AxisAlignedBoundingBox(this.aabb.expandDirectional(x, y, z));
    }

    @Override
    public AxisAlignedBoundingBox extend(Vector vector) {
        return new AxisAlignedBoundingBox(this.aabb.expandDirectional(vector));
    }

    @Override
    public AxisAlignedBoundingBox getBounds() {
        return this;
    }

    @Override
    public boolean postBoundsOverlapsWithAABB(AxisAlignedBoundingBox nmsAABB) {
        return this.aabb.overlaps(nmsAABB.getBoundingBox());
    }

    @Override
    public AxisAlignedBoundingBox offset(double x, double y, double z) {
        return new AxisAlignedBoundingBox(this.getMinX() + x, this.getMinY() + y, this.getMinZ() + z, this.getMaxX() + x, this.getMaxY() + y, this.getMaxZ() + z);
    }

    @Override
    public AxisAlignedBoundingBox offset(Vector vector) {
        return this.offset(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public boolean containsPoint(double x, double y, double z) {
        return this.aabb.contains(x, y, z);
    }

    @Override
    public boolean containsPoint(Vector point) {
        return this.aabb.contains(point);
    }

    @Override
    public AxisAlignedBoundingBox contract(double x, double y, double z) {
        return new AxisAlignedBoundingBox(this.aabb.expand(-x, -y, -z));
    }

    @Override
    public AxisAlignedBoundingBox contract(double value) {
        return new AxisAlignedBoundingBox(this.aabb.expand(-value));
    }

    public AxisAlignedBoundingBox expand(double amount) {
        return new AxisAlignedBoundingBox(this.aabb.expand(amount));
    }

    @Override
    public AxisAlignedBoundingBox combine(AABB other) {
        return new AxisAlignedBoundingBox(this.aabb.union(this.convertFromAABB(other).getBoundingBox()));
    }

    @Nullable
    public Vector intersectLine(Vector start, Vector end) {
        Vector ray = end.subtract(start);
        RayTraceResult result = this.aabb.rayTrace(start, ray, (double)NumberConversions.ceil((double)(ray.length() + 0.5)));
        return result != null ? result.getHitPosition() : null;
    }

    @Override
    public R_RayCastHit rayCast(Vector start, Vector end) {
        return new R_RayCastHit(this.aabb.rayTrace(start, end.subtract(start), start.distance(end)));
    }
}

