/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics;

import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.versions.physics.NMSPhysics_v1_16_R2;
import net.minecraft.server.v1_16_R2.EnumDirection;
import net.minecraft.server.v1_16_R2.MovingObjectPosition;
import net.minecraft.server.v1_16_R2.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R2.MovingObjectPositionEntity;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class RayCastHit_v1_16_R2
implements RayCastHit {
    private final MovingObjectPosition handle;

    public RayCastHit_v1_16_R2(MovingObjectPosition handle) {
        this.handle = handle;
    }

    @Override
    public double getPointX() {
        return this.handle.getPos().x;
    }

    @Override
    public double getPointY() {
        return this.handle.getPos().y;
    }

    @Override
    public double getPointZ() {
        return this.handle.getPos().z;
    }

    @Override
    public Vector getPoint() {
        return NMSPhysics_v1_16_R2.vecNmsToBukkit(this.handle.getPos());
    }

    @Override
    public RayCastHit.Result getResult() {
        if (this.isUnknown()) {
            return RayCastHit.Result.UNKNOWN;
        }
        switch (this.handle.getType()) {
            case BLOCK: {
                return RayCastHit.Result.BLOCK;
            }
            case ENTITY: {
                return RayCastHit.Result.ENTITY;
            }
        }
        throw new RuntimeException("THIS SHOULDN'T HAPPEN!");
    }

    @Override
    public boolean isBlock() {
        return this.handle.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK;
    }

    @Override
    public boolean isUnknown() {
        return this.handle.getType() == null;
    }

    @Override
    public boolean isEntity() {
        return this.handle.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY;
    }

    @Override
    public int getBlockX() {
        return (int)Math.round(this.handle.getPos().getX());
    }

    @Override
    public int getBlockY() {
        return (int)Math.round(this.handle.getPos().getY());
    }

    @Override
    public int getBlockZ() {
        return (int)Math.round(this.handle.getPos().getZ());
    }

    @Override
    public Block getBlock(World world) {
        return world.getBlockAt(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    @Override
    public Entity getEntity() {
        return this.isEntity() ? ((MovingObjectPositionEntity)this.handle).getEntity().getBukkitEntity() : null;
    }

    @Override
    public BlockFace getFace() {
        EnumDirection direction = null;
        if (this.handle instanceof MovingObjectPositionBlock) {
            direction = ((MovingObjectPositionBlock)this.handle).getDirection();
        }
        if (direction == null) {
            throw new RuntimeException("THIS SHOULDN'T HAPPEN! (1)");
        }
        switch (direction) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        throw new RuntimeException("THIS SHOULDN'T HAPPEN! (2)");
    }
}

