/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics;

import com.herocraftonline.heroes.nms.physics.RayCastHit;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class R_RayCastHit
implements RayCastHit {
    private final RayTraceResult rayTrace;

    public R_RayCastHit(RayTraceResult trace) {
        this.rayTrace = trace;
    }

    @Override
    public double getPointX() {
        return this.rayTrace.getHitPosition().getX();
    }

    @Override
    public double getPointY() {
        return this.rayTrace.getHitPosition().getY();
    }

    @Override
    public double getPointZ() {
        return this.rayTrace.getHitPosition().getZ();
    }

    @Override
    public Vector getPoint() {
        return this.rayTrace.getHitPosition();
    }

    @Override
    public RayCastHit.Result getResult() {
        if (this.isEntity()) {
            return RayCastHit.Result.ENTITY;
        }
        if (this.isBlock()) {
            return RayCastHit.Result.BLOCK;
        }
        return RayCastHit.Result.UNKNOWN;
    }

    @Override
    public boolean isBlock() {
        return this.rayTrace.getHitBlock() != null || this.rayTrace.getHitBlockFace() != null;
    }

    @Override
    public boolean isUnknown() {
        return this.rayTrace.getHitBlock() == null && this.rayTrace.getHitEntity() == null;
    }

    @Override
    public boolean isEntity() {
        return this.rayTrace.getHitEntity() != null;
    }

    @Override
    public int getBlockX() {
        return this.rayTrace.getHitPosition().getBlockX();
    }

    @Override
    public int getBlockY() {
        return this.rayTrace.getHitPosition().getBlockY();
    }

    @Override
    public int getBlockZ() {
        return this.rayTrace.getHitPosition().getBlockZ();
    }

    @Override
    public Block getBlock(World world) {
        return this.isBlock() ? this.rayTrace.getHitBlock() : world.getBlockAt(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.rayTrace.getHitEntity();
    }

    @Override
    @Nullable
    public BlockFace getFace() {
        return this.rayTrace.getHitBlockFace();
    }
}

