/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics;

import com.herocraftonline.heroes.nms.physics.FluidCollision;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.physics.collision.ColliderVolume;
import com.herocraftonline.heroes.nms.physics.collision.Sphere;
import com.herocraftonline.heroes.nms.versions.physics.R_RayCastHit;
import com.herocraftonline.heroes.nms.versions.physics.collision.AxisAlignedBoundingBox;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_BaseColliderVolume;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_Capsule;
import com.herocraftonline.heroes.nms.versions.physics.collision.R_Sphere;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class RAVINPhysics
extends NMSPhysics {
    private static final int BLOCK_ITERATION_LIMIT = 512;
    private static final FluidCollisionMode DEFAULT_FLUID_COLLISION_OPTION = FluidCollisionMode.ALWAYS;

    public static FluidCollisionMode fluidCollisionToBukkit(FluidCollision fluidCollision) {
        if (fluidCollision != null) {
            switch (fluidCollision) {
                case NEVER: {
                    return FluidCollisionMode.NEVER;
                }
                case SOURCE_ONLY: {
                    return FluidCollisionMode.SOURCE_ONLY;
                }
                case ALWAYS: {
                    return FluidCollisionMode.ALWAYS;
                }
            }
        }
        return DEFAULT_FLUID_COLLISION_OPTION;
    }

    @Deprecated
    public static RayTraceResult processRayCastOnBlock(Block block, Vector start, Vector end, FluidCollisionMode fluidCollisionMode) {
        Location startLoc = new Location(block.getWorld(), start.getX(), start.getY(), start.getZ());
        Vector direction = RAVINPhysics.calculateDirection(start, end);
        return block.rayTrace(startLoc, direction, start.distance(end), fluidCollisionMode);
    }

    @Deprecated
    public static RayTraceResult processRayCastOnFluid(Block fluid, Location position, Vector start, Vector end) {
        return RAVINPhysics.processRayCastOnBlock(fluid, start, end, FluidCollisionMode.ALWAYS);
    }

    private static Vector calculateDirection(Vector start, Vector end) {
        Vector dV = start.clone().subtract(end);
        float yaw = RAVINPhysics.calculateYaw(dV);
        float pitch = RAVINPhysics.calculatePitch(dV);
        double x = Math.sin(pitch) * Math.cos(yaw);
        double y = Math.sin(pitch) * Math.sin(yaw);
        double z = Math.cos(pitch);
        return new Vector(x, z, y);
    }

    private static float calculateYaw(Vector dV) {
        return (float)Math.atan2(dV.getZ(), dV.getX());
    }

    private static float calculatePitch(Vector dV) {
        return (float)(Math.atan2(Math.sqrt(dV.getZ() * dV.getZ() + dV.getX() * dV.getX()), dV.getY()) + Math.PI);
    }

    private static List<AABB> aabbListNmsToBukkit(List<BoundingBox> nmsAABBs) {
        ArrayList<AABB> aabbs = new ArrayList<AABB>(nmsAABBs.size());
        for (BoundingBox nmsAABB : nmsAABBs) {
            aabbs.add(new AxisAlignedBoundingBox(nmsAABB));
        }
        return aabbs;
    }

    @Override
    public AABB createAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AxisAlignedBoundingBox(x1, y1, z1, x2, y2, z2);
    }

    @Override
    public AABB getEntityAABB(Entity entity) {
        return new AxisAlignedBoundingBox(entity.getBoundingBox());
    }

    @Override
    @Deprecated
    public List<AABB> getBlockAABB(Block block) {
        ArrayList<BoundingBox> box = new ArrayList<BoundingBox>();
        box.add(block.getBoundingBox());
        return RAVINPhysics.aabbListNmsToBukkit(box);
    }

    private static BlockIterator rayCastBlockIterator(World world, Vector start, Vector end) {
        Vector direction = RAVINPhysics.calculateDirection(start, end);
        return new BlockIterator(world, start, direction, 0.0, NumberConversions.ceil((double)start.distance(end)));
    }

    @Override
    public Sphere createSphere(double cX, double cY, double cZ, double radius) {
        return new R_Sphere(cX, cY, cZ, radius);
    }

    @Override
    public Capsule createCapsule(double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        return new R_Capsule(x1, y1, z1, x2, y2, z2, radius);
    }

    @Override
    public RayCastHit rayCastBlock(Block block, Vector start, Vector end, FluidCollision fluidCollision, boolean ignoreNonCollidable) {
        FluidCollisionMode fluidCollisionMode = RAVINPhysics.fluidCollisionToBukkit(fluidCollision);
        RayTraceResult result = this.rayCastBlockRaw(block, start, end, fluidCollisionMode, ignoreNonCollidable);
        return result != null ? new R_RayCastHit(result) : null;
    }

    private RayTraceResult rayCastBlockRaw(Block block, Vector start, Vector end, FluidCollisionMode fluidCollisionMode, boolean ignoreNonCollidable) {
        RayTraceResult rayTraceResult = null;
        if (block.isPassable() && !ignoreNonCollidable || !block.isEmpty()) {
            double distance = start.distance(end);
            Vector direction = RAVINPhysics.calculateDirection(start, end);
            rayTraceResult = block.getBoundingBox().rayTrace(start, direction, distance);
        }
        return rayTraceResult;
    }

    @Override
    public RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, FluidCollision fluidCollision, boolean ignoreNonCollidable) {
        Vector direction;
        FluidCollisionMode fluidCollisionBukkit = RAVINPhysics.fluidCollisionToBukkit(fluidCollision);
        Location startLoc = new Location(world, start.getX(), start.getY(), start.getZ());
        RayTraceResult trace = world.rayTraceBlocks(startLoc, direction = RAVINPhysics.calculateDirection(start, end), start.distance(end), fluidCollisionBukkit, ignoreNonCollidable);
        return trace != null ? new R_RayCastHit(trace) : null;
    }

    @Override
    public Iterator<RayCastHit> rayCastBlocksAll(final World world, final Vector start, final Vector end, final Predicate<Block> filter, final FluidCollision fluidCollision, final boolean ignoreNonCollidable) {
        return new Iterator<RayCastHit>(){
            private final BlockRayCastIterator iterator;
            {
                this.iterator = new BlockRayCastIterator(world, start, end, filter, RAVINPhysics.fluidCollisionToBukkit(fluidCollision), ignoreNonCollidable);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public RayCastHit next() {
                RayTraceResult mop = this.iterator.next();
                return new R_RayCastHit(mop);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator remove");
            }
        };
    }

    @Deprecated
    private RayTraceResult rayCastBlocksRaw(World world, Vector start, Vector end, Predicate<Block> filter, FluidCollisionMode nmsFluidCollision, boolean ignoreNonCollidable) {
        if (filter == null) {
            filter = b -> true;
        }
        BlockIterator iterator = RAVINPhysics.rayCastBlockIterator(world, start, end);
        RayTraceResult rayCast = null;
        int iterationCount = 0;
        while (rayCast == null && iterator.hasNext()) {
            Block block = iterator.next();
            if (filter.test(block)) {
                rayCast = this.rayCastBlockRaw(block, start, end, nmsFluidCollision, ignoreNonCollidable);
            }
            if (++iterationCount < 512) continue;
            throw new RuntimeException("[RAY-CASTING] - Block iteration limit reached");
        }
        return rayCast;
    }

    @Override
    public List<Entity> getEntitiesInVolume(World world, Entity source, ColliderVolume volume, Predicate<Entity> filter) {
        R_BaseColliderVolume baseVolume = (R_BaseColliderVolume)volume;
        Predicate<Entity> nmsFilter = baseVolume instanceof AxisAlignedBoundingBox ? (filter != null ? filter : e -> true) : (filter != null ? e -> baseVolume.overlapsWithAABB(this.getEntityAABB((Entity)e), true) && filter.test((Entity)e) : e -> baseVolume.overlapsWithAABB(this.getEntityAABB((Entity)e), true));
        return this.getEntitiesInAABB(world, baseVolume.getBounds(), nmsFilter);
    }

    @Override
    public RayCastHit rayCastEntity(Entity entity, Vector start, Vector end) {
        RayTraceResult trace = this.rayCastEntityRaw(entity, start, end);
        return trace != null ? new R_RayCastHit(trace) : null;
    }

    @Override
    public RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter) {
        if (!(source instanceof Player)) {
            throw new IllegalArgumentException("Entity source HAS TO BE Player");
        }
        Location eyeLoc = ((Player)source).getEyeLocation();
        RayTraceResult trace = world.rayTraceEntities(eyeLoc, eyeLoc.getDirection(), start.distance(end), 1.0, filter);
        return trace != null ? new R_RayCastHit(trace) : null;
    }

    @Override
    public Iterator<RayCastHit> rayCastEntitiesAll(final World world, final Entity source, final Vector start, final Vector end, final Predicate<Entity> filter) {
        return new Iterator<RayCastHit>(){
            private final EntityRayCastIterator iterator;
            {
                this.iterator = new EntityRayCastIterator(world, source, start, end, filter);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public RayCastHit next() {
                RayTraceResult trace = this.iterator.next().getRayTraceResult();
                return new R_RayCastHit(trace);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator remove");
            }
        };
    }

    private List<Entity> getEntitiesInAABB(World world, AxisAlignedBoundingBox aabb, Predicate<Entity> filter) {
        Collection entityColl = world.getNearbyEntities(aabb.getBoundingBox(), filter);
        ArrayList<Entity> list = entityColl instanceof List ? (ArrayList<Entity>)entityColl : new ArrayList<Entity>(entityColl);
        return list;
    }

    private RayTraceResult rayCastEntityRaw(Entity entity, Vector start, Vector end) {
        double distance = start.distance(end);
        Vector direction = RAVINPhysics.calculateDirection(start, end);
        return entity.getBoundingBox().rayTrace(start, direction, distance);
    }

    private List<Entity> getEntitiesInRayBounds(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter) {
        AxisAlignedBoundingBox nmsAABB = new AxisAlignedBoundingBox(start, end);
        return this.getEntitiesInAABB(world, nmsAABB, filter);
    }

    @Deprecated
    private RayTraceResult rayCastEntitiesRaw(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter) {
        List<Entity> nmsEntities = this.getEntitiesInRayBounds(world, source, start, end, filter);
        double currentDistanceSq = Double.MAX_VALUE;
        RayTraceResult closestTrace = null;
        for (Entity nmsEntity : nmsEntities) {
            double distanceSq;
            RayTraceResult trace = this.rayCastEntityRaw(nmsEntity, start, end);
            if (trace == null || !((distanceSq = trace.getHitPosition().distance(start)) < currentDistanceSq)) continue;
            closestTrace = trace;
            currentDistanceSq = distanceSq;
        }
        return closestTrace;
    }

    @Override
    public RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision, boolean blockIgnoreNonCollidable) {
        Location eyeLoc;
        FluidCollisionMode fluidCollisionMode = RAVINPhysics.fluidCollisionToBukkit(blockFluidCollision);
        if (source instanceof Player) {
            eyeLoc = ((Player)source).getEyeLocation();
        } else {
            Vector dV = start.clone().subtract(end);
            eyeLoc = new Location(world, start.getX(), start.getY(), start.getZ(), RAVINPhysics.calculateYaw(dV), RAVINPhysics.calculatePitch(dV));
        }
        RayTraceResult trace = world.rayTrace(eyeLoc, eyeLoc.getDirection(), start.distance(end), fluidCollisionMode, blockIgnoreNonCollidable, 0.0, entityFilter);
        return trace != null ? new R_RayCastHit(trace) : null;
    }

    @Override
    public Iterator<RayCastHit> rayCastAll(World world, Entity source, final Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision, boolean blockIgnoreNonCollidable) {
        FluidCollisionMode nmsFluidCollision = RAVINPhysics.fluidCollisionToBukkit(blockFluidCollision);
        final BlockRayCastIterator blockIterator = new BlockRayCastIterator(world, start, end, blockFilter, nmsFluidCollision, blockIgnoreNonCollidable);
        final EntityRayCastIterator entityIterator = new EntityRayCastIterator(world, source, start, end, entityFilter);
        return new Iterator<RayCastHit>(){
            private RayTraceResult blockTrace;
            private double currentBlockDistanceSq;
            private HitEntity hitEntity;
            private RayTraceResult currentTrace;

            @Override
            public boolean hasNext() {
                return this.currentTrace != null || this.findNext();
            }

            @Override
            public RayCastHit next() {
                if (this.hasNext()) {
                    RayTraceResult next = this.currentTrace;
                    this.currentTrace = null;
                    return new R_RayCastHit(next);
                }
                throw new NoSuchElementException("iterator next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator remove");
            }

            private boolean findNext() {
                if (this.blockTrace == null && blockIterator.hasNext()) {
                    this.blockTrace = blockIterator.next();
                    this.currentBlockDistanceSq = this.blockTrace.getHitPosition().distance(start);
                }
                if (this.hitEntity == null && entityIterator.hasNext()) {
                    this.hitEntity = entityIterator.next();
                }
                if (this.blockTrace != null) {
                    if (this.hitEntity != null) {
                        if (this.currentBlockDistanceSq < this.hitEntity.getDistanceSquared()) {
                            this.selectBlock();
                        } else {
                            this.selectEntity();
                        }
                    } else {
                        this.selectBlock();
                    }
                } else if (this.hitEntity != null) {
                    this.selectEntity();
                } else {
                    return false;
                }
                return true;
            }

            private void selectBlock() {
                this.currentTrace = this.blockTrace;
                this.blockTrace = null;
            }

            private void selectEntity() {
                this.currentTrace = this.hitEntity.getRayTraceResult();
                this.hitEntity = null;
            }
        };
    }

    private final class BlockRayCastIterator
    implements Iterator<RayTraceResult> {
        private final World world;
        private final Vector start;
        private final Vector end;
        private final FluidCollisionMode fluidCollision;
        private final boolean ignoreNonCollidable;
        private final BlockIterator iterator;
        private final Predicate<Block> filter;
        private RayTraceResult currentTrace;
        private Block block;
        private int iterationCount;

        public BlockRayCastIterator(World world, Vector start, Vector end, Predicate<Block> filter, FluidCollisionMode fluidCollision, boolean ignoreNonCollidable) {
            this.world = world;
            this.start = start;
            this.end = end;
            this.fluidCollision = fluidCollision;
            this.ignoreNonCollidable = ignoreNonCollidable;
            this.iterator = RAVINPhysics.rayCastBlockIterator(world, start, end);
            this.filter = filter != null ? filter : b -> true;
        }

        @Override
        public boolean hasNext() {
            return this.currentTrace != null || this.findNext();
        }

        @Override
        public RayTraceResult next() {
            if (this.hasNext()) {
                RayTraceResult next = this.currentTrace;
                this.currentTrace = null;
                return next;
            }
            throw new NoSuchElementException("BlockRayCastIterator next()");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("BlockRayCastIterator remove()");
        }

        private boolean findNext() {
            while (this.iterator.hasNext()) {
                this.block = this.iterator.next();
                if (this.filter.test(this.block)) {
                    this.currentTrace = RAVINPhysics.this.rayCastBlockRaw(this.block, this.start, this.end, this.fluidCollision, this.ignoreNonCollidable);
                    if (this.currentTrace != null) {
                        return true;
                    }
                }
                if (++this.iterationCount < 512) continue;
                throw new RuntimeException("[RAY-CASTING] - Block iteration limit reached");
            }
            return false;
        }
    }

    private class EntityRayCastIterator
    implements Iterator<HitEntity> {
        private final Iterator<HitEntity> iterator;

        public EntityRayCastIterator(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter) {
            List<Entity> entities = RAVINPhysics.this.getEntitiesInRayBounds(world, source, start, end, filter);
            TreeSet<HitEntity> hitEntities = new TreeSet<HitEntity>();
            for (Entity entity : entities) {
                RayTraceResult trace = RAVINPhysics.this.rayCastEntityRaw(entity, start, end);
                if (trace == null) continue;
                double distanceSq = trace.getHitPosition().distance(start);
                hitEntities.add(new HitEntity(trace, distanceSq));
            }
            this.iterator = hitEntities.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public HitEntity next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("iterator remove");
        }
    }

    private static class HitEntity
    implements Comparable<HitEntity> {
        private final RayTraceResult trace;
        private final double distanceSq;

        public HitEntity(RayTraceResult trace, double distanceSq) {
            this.trace = trace;
            this.distanceSq = distanceSq;
        }

        public RayTraceResult getRayTraceResult() {
            return this.trace;
        }

        public double getDistanceSquared() {
            return this.distanceSq;
        }

        @Override
        public int compareTo(HitEntity o) {
            return Double.compare(this.distanceSq, o.distanceSq);
        }
    }
}

