/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions.physics;

import com.herocraftonline.heroes.nms.physics.FluidCollision;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.physics.collision.ColliderVolume;
import com.herocraftonline.heroes.nms.physics.collision.Sphere;
import com.herocraftonline.heroes.nms.versions.physics.RayCastHit_v1_16_R2;
import com.herocraftonline.heroes.nms.versions.physics.collision.AABB_v1_16_R2;
import com.herocraftonline.heroes.nms.versions.physics.collision.BaseColliderVolume_v1_16_R2;
import com.herocraftonline.heroes.nms.versions.physics.collision.Capsule_v1_16_R2;
import com.herocraftonline.heroes.nms.versions.physics.collision.Sphere_v1_16_R2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.server.v1_16_R2.AxisAlignedBB;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.Fluid;
import net.minecraft.server.v1_16_R2.IBlockAccess;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.MovingObjectPosition;
import net.minecraft.server.v1_16_R2.MovingObjectPositionEntity;
import net.minecraft.server.v1_16_R2.RayTrace;
import net.minecraft.server.v1_16_R2.Vec3D;
import net.minecraft.server.v1_16_R2.VoxelShape;
import net.minecraft.server.v1_16_R2.VoxelShapes;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class NMSPhysics_v1_16_R2
extends NMSPhysics {
    private static final int BLOCK_ITERATION_LIMIT = 512;
    private static final RayTrace.FluidCollisionOption DEFAULT_FLUID_COLLISION_OPTION = RayTrace.FluidCollisionOption.NONE;

    public static Vec3D vecBukkitToNms(Vector v) {
        return new Vec3D(v.getX(), v.getY(), v.getZ());
    }

    public static Vector vecNmsToBukkit(Vec3D v) {
        return new Vector(v.x, v.y, v.z);
    }

    public static RayTrace.FluidCollisionOption fluidCollisionToNMS(FluidCollision fluidCollision) {
        RayTrace.FluidCollisionOption result = DEFAULT_FLUID_COLLISION_OPTION;
        if (fluidCollision != null) {
            switch (fluidCollision) {
                case NEVER: {
                    return RayTrace.FluidCollisionOption.NONE;
                }
                case SOURCE_ONLY: {
                    return RayTrace.FluidCollisionOption.SOURCE_ONLY;
                }
                case ALWAYS: {
                    return RayTrace.FluidCollisionOption.ANY;
                }
            }
        }
        return result;
    }

    public static Fluid getFluidData(net.minecraft.server.v1_16_R2.World nmsWorld, BlockPosition position) {
        return nmsWorld.getFluid(position);
    }

    public static boolean testFluidCollision(Fluid fluid, RayTrace.FluidCollisionOption nmsFluidCollision) {
        return nmsFluidCollision.a(fluid);
    }

    public static MovingObjectPosition processRayCastOnBlock(IBlockData blockData, net.minecraft.server.v1_16_R2.World nmsWorld, BlockPosition position, Vec3D nmsStart, Vec3D nmsEnd) {
        return blockData.getShape((IBlockAccess)nmsWorld, position).rayTrace(nmsStart, nmsEnd, position);
    }

    public static MovingObjectPosition processRayCastOnFluid(Fluid fluid, BlockPosition position, Vec3D nmsStart, Vec3D nmsEnd) {
        VoxelShape shape = VoxelShapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluid.e(), (double)1.0);
        return shape.rayTrace(nmsStart, nmsEnd, position);
    }

    private static List<Entity> entityListNmsToBukkit(List<net.minecraft.server.v1_16_R2.Entity> nmsEntities) {
        ArrayList<Entity> entities = new ArrayList<Entity>(nmsEntities.size());
        for (net.minecraft.server.v1_16_R2.Entity nmsEntity : nmsEntities) {
            entities.add((Entity)nmsEntity.getBukkitEntity());
        }
        return entities;
    }

    private static List<AABB> aabbListNmsToBukkit(List<AxisAlignedBB> nmsAABBs) {
        ArrayList<AABB> aabbs = new ArrayList<AABB>(nmsAABBs.size());
        for (AxisAlignedBB nmsAABB : nmsAABBs) {
            aabbs.add(AABB_v1_16_R2.createGeneric(nmsAABB));
        }
        return aabbs;
    }

    @Override
    public AABB createAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return AABB_v1_16_R2.createGeneric(x1, y1, z1, x2, y2, z2);
    }

    @Override
    public AABB getEntityAABB(Entity entity) {
        return AABB_v1_16_R2.createGenericFromEntity(((CraftEntity)entity).getHandle());
    }

    @Override
    public List<AABB> getBlockAABB(Block block) {
        WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition position = new BlockPosition(block.getX(), block.getY(), block.getZ());
        return NMSPhysics_v1_16_R2.aabbListNmsToBukkit(this.getBlockAABBRaw((net.minecraft.server.v1_16_R2.World)nmsWorld, position));
    }

    private List<AxisAlignedBB> getBlockAABBRaw(net.minecraft.server.v1_16_R2.World nmsWorld, BlockPosition position) {
        return nmsWorld.getType(position).getShape((IBlockAccess)nmsWorld, position).d();
    }

    private static BlockIterator rayCastBlockIterator(World world, Vector start, Vector end) {
        Vector ray = end.subtract(start);
        return new BlockIterator(world, start, ray, 0.0, NumberConversions.ceil((double)(ray.length() + 0.5)));
    }

    private static BlockIterator rayCastBlockIterator(net.minecraft.server.v1_16_R2.World nmsWorld, Vec3D nmsStart, Vec3D nmsEnd) {
        return NMSPhysics_v1_16_R2.rayCastBlockIterator((World)nmsWorld.getWorld(), NMSPhysics_v1_16_R2.vecNmsToBukkit(nmsStart), NMSPhysics_v1_16_R2.vecNmsToBukkit(nmsEnd));
    }

    @Override
    public Sphere createSphere(double cX, double cY, double cZ, double radius) {
        return new Sphere_v1_16_R2(cX, cY, cZ, radius);
    }

    @Override
    public Capsule createCapsule(double x1, double y1, double z1, double x2, double y2, double z2, double radius) {
        return new Capsule_v1_16_R2(x1, y1, z1, x2, y2, z2, radius);
    }

    @Override
    public RayCastHit rayCastBlock(Block block, Vector start, Vector end, FluidCollision fluidCollision, boolean ignoreNonCollidable) {
        RayTrace.FluidCollisionOption nmsFluidCollision;
        Vec3D nmsEnd;
        Vec3D nmsStart;
        BlockPosition position;
        WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        MovingObjectPosition mop = this.rayCastBlockRaw((net.minecraft.server.v1_16_R2.World)nmsWorld, position = new BlockPosition(block.getX(), block.getY(), block.getZ()), nmsStart = NMSPhysics_v1_16_R2.vecBukkitToNms(start), nmsEnd = NMSPhysics_v1_16_R2.vecBukkitToNms(end), nmsFluidCollision = NMSPhysics_v1_16_R2.fluidCollisionToNMS(fluidCollision), ignoreNonCollidable);
        return mop != null ? new RayCastHit_v1_16_R2(mop) : null;
    }

    @Override
    public RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, FluidCollision fluidCollision, boolean ignoreNonCollidable) {
        RayTrace.FluidCollisionOption nmsFluidCollision;
        Vec3D nmsEnd;
        Vec3D nmsStart;
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        MovingObjectPosition mop = this.rayCastBlocksRaw((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsStart = NMSPhysics_v1_16_R2.vecBukkitToNms(start), nmsEnd = NMSPhysics_v1_16_R2.vecBukkitToNms(end), filter, nmsFluidCollision = NMSPhysics_v1_16_R2.fluidCollisionToNMS(fluidCollision), ignoreNonCollidable);
        return mop != null ? new RayCastHit_v1_16_R2(mop) : null;
    }

    @Override
    public Iterator<RayCastHit> rayCastBlocksAll(final World world, final Vector start, final Vector end, final Predicate<Block> filter, final FluidCollision fluidCollision, final boolean ignoreNonCollidable) {
        return new Iterator<RayCastHit>(){
            private final BlockRayCastIterator iterator;
            {
                this.iterator = new BlockRayCastIterator((net.minecraft.server.v1_16_R2.World)((CraftWorld)world).getHandle(), NMSPhysics_v1_16_R2.vecBukkitToNms(start), NMSPhysics_v1_16_R2.vecBukkitToNms(end), filter, NMSPhysics_v1_16_R2.fluidCollisionToNMS(fluidCollision), ignoreNonCollidable);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public RayCastHit next() {
                MovingObjectPosition mop = this.iterator.next();
                return new RayCastHit_v1_16_R2(mop);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator remove");
            }
        };
    }

    private MovingObjectPosition rayCastBlockRaw(net.minecraft.server.v1_16_R2.World nmsWorld, BlockPosition position, Vec3D nmsStart, Vec3D nmsEnd, RayTrace.FluidCollisionOption nmsFluidCollision, boolean ignoreNonCollidable) {
        IBlockData blockData = nmsWorld.getType(position);
        net.minecraft.server.v1_16_R2.Block nmsBlock = blockData.getBlock();
        Fluid fluid = NMSPhysics_v1_16_R2.getFluidData(nmsWorld, position);
        MovingObjectPosition mop = null;
        if (!ignoreNonCollidable || !blockData.getCollisionShape((IBlockAccess)nmsWorld, position).isEmpty()) {
            boolean notFluidOrAir = nmsBlock.b(blockData, (IBlockAccess)nmsWorld, position);
            boolean fluidTest = NMSPhysics_v1_16_R2.testFluidCollision(fluid, nmsFluidCollision);
            if (notFluidOrAir || fluidTest) {
                if (notFluidOrAir) {
                    mop = NMSPhysics_v1_16_R2.processRayCastOnBlock(blockData, nmsWorld, position, nmsStart, nmsEnd);
                }
                if (mop == null && fluidTest) {
                    mop = NMSPhysics_v1_16_R2.processRayCastOnFluid(fluid, position, nmsStart, nmsEnd);
                }
            }
        }
        return mop;
    }

    private MovingObjectPosition rayCastBlocksRaw(net.minecraft.server.v1_16_R2.World nmsWorld, Vec3D nmsStart, Vec3D nmsEnd, Predicate<Block> filter, RayTrace.FluidCollisionOption nmsFluidCollision, boolean ignoreNonCollidable) {
        if (filter == null) {
            filter = b -> true;
        }
        BlockIterator iterator = NMSPhysics_v1_16_R2.rayCastBlockIterator(nmsWorld, nmsStart, nmsEnd);
        MovingObjectPosition mop = null;
        int iterationCount = 0;
        while (mop == null && iterator.hasNext()) {
            Block block = iterator.next();
            if (filter.test(block)) {
                BlockPosition position = new BlockPosition(block.getX(), block.getY(), block.getZ());
                mop = this.rayCastBlockRaw(nmsWorld, position, nmsStart, nmsEnd, nmsFluidCollision, ignoreNonCollidable);
            }
            if (++iterationCount < 512) continue;
            return mop;
        }
        return mop;
    }

    @Override
    public List<Entity> getEntitiesInVolume(World world, Entity source, ColliderVolume volume, Predicate<Entity> filter) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_16_R2.Entity nmsSource = source != null ? ((CraftEntity)source).getHandle() : null;
        BaseColliderVolume_v1_16_R2 baseVolume = (BaseColliderVolume_v1_16_R2)volume;
        Predicate<net.minecraft.server.v1_16_R2.Entity> nmsFilter = baseVolume instanceof AABB_v1_16_R2 ? (filter != null ? e -> filter.test((Entity)e.getBukkitEntity()) : e -> true) : (filter != null ? e -> baseVolume.overlapsWithAABB(e.getBoundingBox(), true) && filter.test((Entity)e.getBukkitEntity()) : e -> baseVolume.overlapsWithAABB(e.getBoundingBox(), true));
        return NMSPhysics_v1_16_R2.entityListNmsToBukkit(this.getEntitiesInAABB((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsSource, baseVolume.getBounds().getHandle(), nmsFilter));
    }

    @Override
    public RayCastHit rayCastEntity(Entity entity, Vector start, Vector end) {
        Vec3D nmsEnd;
        Vec3D nmsStart;
        net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        MovingObjectPosition mop = this.rayCastEntityRaw(nmsEntity, nmsStart = NMSPhysics_v1_16_R2.vecBukkitToNms(start), nmsEnd = NMSPhysics_v1_16_R2.vecBukkitToNms(end));
        return mop != null ? new RayCastHit_v1_16_R2(mop) : null;
    }

    @Override
    public RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_16_R2.Entity nmsSource = source != null ? ((CraftEntity)source).getHandle() : null;
        Vec3D nmsStart = NMSPhysics_v1_16_R2.vecBukkitToNms(start);
        Vec3D nmsEnd = NMSPhysics_v1_16_R2.vecBukkitToNms(end);
        MovingObjectPosition mop = this.rayCastEntitiesRaw((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsSource, nmsStart, nmsEnd, filter);
        return mop != null ? new RayCastHit_v1_16_R2(mop) : null;
    }

    @Override
    public Iterator<RayCastHit> rayCastEntitiesAll(final World world, final Entity source, final Vector start, final Vector end, final Predicate<Entity> filter) {
        return new Iterator<RayCastHit>(){
            private final EntityRayCastIterator iterator;
            {
                this.iterator = new EntityRayCastIterator((net.minecraft.server.v1_16_R2.World)((CraftWorld)world).getHandle(), source != null ? ((CraftEntity)source).getHandle() : null, NMSPhysics_v1_16_R2.vecBukkitToNms(start), NMSPhysics_v1_16_R2.vecBukkitToNms(end), filter);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public RayCastHit next() {
                MovingObjectPosition mop = this.iterator.next().getMovingObjectPosition();
                return new RayCastHit_v1_16_R2(mop);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator remove");
            }
        };
    }

    private List<net.minecraft.server.v1_16_R2.Entity> getEntitiesInAABB(net.minecraft.server.v1_16_R2.World nmsWorld, net.minecraft.server.v1_16_R2.Entity nmsSource, AxisAlignedBB nmsAABB, Predicate<net.minecraft.server.v1_16_R2.Entity> nmsFilter) {
        return nmsWorld.getEntities(nmsSource, nmsAABB, nmsFilter);
    }

    private MovingObjectPosition rayCastEntityRaw(net.minecraft.server.v1_16_R2.Entity nmsEntity, Vec3D nmsStart, Vec3D nmsEnd) {
        Optional vec3d = nmsEntity.getBoundingBox().b(nmsStart, nmsEnd);
        if (vec3d.isPresent()) {
            return new MovingObjectPositionEntity(nmsEntity, (Vec3D)vec3d.get());
        }
        return null;
    }

    private List<net.minecraft.server.v1_16_R2.Entity> getEntitiesInRayBounds(net.minecraft.server.v1_16_R2.World nmsWorld, net.minecraft.server.v1_16_R2.Entity nmsSource, Vec3D nmsStart, Vec3D nmsEnd, Predicate<Entity> filter) {
        AxisAlignedBB nmsAABB = new AxisAlignedBB(nmsStart.x, nmsStart.y, nmsStart.z, nmsEnd.x, nmsEnd.y, nmsEnd.z);
        Predicate<net.minecraft.server.v1_16_R2.Entity> nmsFilter = filter != null ? entity -> filter.test((Entity)entity.getBukkitEntity()) : null;
        return this.getEntitiesInAABB(nmsWorld, nmsSource, nmsAABB, nmsFilter);
    }

    private MovingObjectPosition rayCastEntitiesRaw(net.minecraft.server.v1_16_R2.World nmsWorld, net.minecraft.server.v1_16_R2.Entity nmsSource, Vec3D nmsStart, Vec3D nmsEnd, Predicate<Entity> filter) {
        List<net.minecraft.server.v1_16_R2.Entity> nmsEntities = this.getEntitiesInRayBounds(nmsWorld, nmsSource, nmsStart, nmsEnd, filter);
        double currentDistanceSq = Double.MAX_VALUE;
        MovingObjectPosition closestMop = null;
        for (net.minecraft.server.v1_16_R2.Entity nmsEntity : nmsEntities) {
            double distanceSq;
            MovingObjectPosition mop = this.rayCastEntityRaw(nmsEntity, nmsStart, nmsEnd);
            if (mop == null || !((distanceSq = NumberConversions.square((double)(mop.getPos().x - nmsStart.x)) + NumberConversions.square((double)(mop.getPos().y - nmsStart.y)) + NumberConversions.square((double)(mop.getPos().z - nmsStart.z))) < currentDistanceSq)) continue;
            closestMop = mop;
            currentDistanceSq = distanceSq;
        }
        return closestMop;
    }

    @Override
    public RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision, boolean blockIgnoreNonCollidable) {
        MovingObjectPosition entityMop;
        RayTrace.FluidCollisionOption nmsFluidCollision;
        Vec3D nmsEnd;
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_16_R2.Entity nmsSource = source != null ? ((CraftEntity)source).getHandle() : null;
        Vec3D nmsStart = NMSPhysics_v1_16_R2.vecBukkitToNms(start);
        MovingObjectPosition blockMop = this.rayCastBlocksRaw((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsStart, nmsEnd = NMSPhysics_v1_16_R2.vecBukkitToNms(end), blockFilter, nmsFluidCollision = NMSPhysics_v1_16_R2.fluidCollisionToNMS(blockFluidCollision), blockIgnoreNonCollidable);
        if (blockMop != null) {
            nmsEnd = blockMop.getPos();
        }
        return (entityMop = this.rayCastEntitiesRaw((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsSource, nmsStart, nmsEnd, entityFilter)) != null ? new RayCastHit_v1_16_R2(entityMop) : (blockMop != null ? new RayCastHit_v1_16_R2(blockMop) : null);
    }

    @Override
    public Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision, boolean blockIgnoreNonCollidable) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        net.minecraft.server.v1_16_R2.Entity nmsSource = source != null ? ((CraftEntity)source).getHandle() : null;
        final Vec3D nmsStart = NMSPhysics_v1_16_R2.vecBukkitToNms(start);
        Vec3D nmsEnd = NMSPhysics_v1_16_R2.vecBukkitToNms(end);
        RayTrace.FluidCollisionOption nmsFluidCollision = NMSPhysics_v1_16_R2.fluidCollisionToNMS(blockFluidCollision);
        final BlockRayCastIterator blockIterator = new BlockRayCastIterator((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsStart, nmsEnd, blockFilter, nmsFluidCollision, blockIgnoreNonCollidable);
        final EntityRayCastIterator entityIterator = new EntityRayCastIterator((net.minecraft.server.v1_16_R2.World)nmsWorld, nmsSource, nmsStart, nmsEnd, entityFilter);
        return new Iterator<RayCastHit>(){
            private MovingObjectPosition blockMop;
            private double currentBlockDistanceSq;
            private HitEntity hitEntity;
            private MovingObjectPosition currentMop;

            @Override
            public boolean hasNext() {
                return this.currentMop != null || this.findNext();
            }

            @Override
            public RayCastHit next() {
                if (this.hasNext()) {
                    MovingObjectPosition next = this.currentMop;
                    this.currentMop = null;
                    return new RayCastHit_v1_16_R2(next);
                }
                throw new NoSuchElementException("iterator next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("iterator remove");
            }

            private boolean findNext() {
                if (this.blockMop == null && blockIterator.hasNext()) {
                    this.blockMop = blockIterator.next();
                    this.currentBlockDistanceSq = NumberConversions.square((double)(this.blockMop.getPos().x - nmsStart.x)) + NumberConversions.square((double)(this.blockMop.getPos().y - nmsStart.y)) + NumberConversions.square((double)(this.blockMop.getPos().z - nmsStart.z));
                }
                if (this.hitEntity == null && entityIterator.hasNext()) {
                    this.hitEntity = entityIterator.next();
                }
                if (this.blockMop != null) {
                    if (this.hitEntity != null) {
                        if (this.currentBlockDistanceSq < this.hitEntity.getDistanceSquared()) {
                            this.selectBlock();
                        } else {
                            this.selectEntity();
                        }
                    } else {
                        this.selectBlock();
                    }
                } else if (this.hitEntity != null) {
                    this.selectEntity();
                } else {
                    return false;
                }
                return true;
            }

            private void selectBlock() {
                this.currentMop = this.blockMop;
                this.blockMop = null;
            }

            private void selectEntity() {
                this.currentMop = this.hitEntity.getMovingObjectPosition();
                this.hitEntity = null;
            }
        };
    }

    private final class BlockRayCastIterator
    implements Iterator<MovingObjectPosition> {
        private final net.minecraft.server.v1_16_R2.World nmsWorld;
        private final Vec3D nmsStart;
        private final Vec3D nmsEnd;
        private final RayTrace.FluidCollisionOption nmsFluidCollision;
        private final boolean ignoreNonCollidable;
        private final BlockIterator iterator;
        private final Predicate<Block> filter;
        private MovingObjectPosition currentMop;
        private Block block;
        private int iterationCount;

        public BlockRayCastIterator(net.minecraft.server.v1_16_R2.World nmsWorld, Vec3D nmsStart, Vec3D nmsEnd, Predicate<Block> filter, RayTrace.FluidCollisionOption nmsFluidCollision, boolean ignoreNonCollidable) {
            this.nmsWorld = nmsWorld;
            this.nmsStart = nmsStart;
            this.nmsEnd = nmsEnd;
            this.nmsFluidCollision = nmsFluidCollision;
            this.ignoreNonCollidable = ignoreNonCollidable;
            this.iterator = NMSPhysics_v1_16_R2.rayCastBlockIterator(nmsWorld, nmsStart, nmsEnd);
            this.filter = filter != null ? filter : b -> true;
        }

        @Override
        public boolean hasNext() {
            return this.currentMop != null || this.findNext();
        }

        @Override
        public MovingObjectPosition next() {
            if (this.hasNext()) {
                MovingObjectPosition next = this.currentMop;
                this.currentMop = null;
                return next;
            }
            throw new NoSuchElementException("iterator next");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("iterator remove");
        }

        private boolean findNext() {
            while (this.iterator.hasNext()) {
                this.block = this.iterator.next();
                if (this.filter.test(this.block)) {
                    BlockPosition position = new BlockPosition(this.block.getX(), this.block.getY(), this.block.getZ());
                    this.currentMop = NMSPhysics_v1_16_R2.this.rayCastBlockRaw(this.nmsWorld, position, this.nmsStart, this.nmsEnd, this.nmsFluidCollision, this.ignoreNonCollidable);
                    if (this.currentMop != null) {
                        return true;
                    }
                }
                if (++this.iterationCount < 512) continue;
                return false;
            }
            return false;
        }
    }

    private class EntityRayCastIterator
    implements Iterator<HitEntity> {
        private final Iterator<HitEntity> iterator;

        public EntityRayCastIterator(net.minecraft.server.v1_16_R2.World nmsWorld, net.minecraft.server.v1_16_R2.Entity nmsSource, Vec3D nmsStart, Vec3D nmsEnd, Predicate<Entity> filter) {
            List<net.minecraft.server.v1_16_R2.Entity> nmsEntities = NMSPhysics_v1_16_R2.this.getEntitiesInRayBounds(nmsWorld, nmsSource, nmsStart, nmsEnd, filter);
            TreeSet<HitEntity> hitEntities = new TreeSet<HitEntity>();
            for (net.minecraft.server.v1_16_R2.Entity nmsEntity : nmsEntities) {
                MovingObjectPosition mop = NMSPhysics_v1_16_R2.this.rayCastEntityRaw(nmsEntity, nmsStart, nmsEnd);
                if (mop == null) continue;
                double distanceSq = NumberConversions.square((double)(mop.getPos().x - nmsStart.x)) + NumberConversions.square((double)(mop.getPos().y - nmsStart.y)) + NumberConversions.square((double)(mop.getPos().z - nmsStart.z));
                hitEntities.add(new HitEntity(mop, distanceSq));
            }
            this.iterator = hitEntities.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public HitEntity next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("iterator remove");
        }
    }

    private static class HitEntity
    implements Comparable<HitEntity> {
        private final MovingObjectPosition mop;
        private final double distanceSq;

        public HitEntity(MovingObjectPosition mop, double distanceSq) {
            this.mop = mop;
            this.distanceSq = distanceSq;
        }

        public MovingObjectPosition getMovingObjectPosition() {
            return this.mop;
        }

        public double getDistanceSquared() {
            return this.distanceSq;
        }

        @Override
        public int compareTo(HitEntity o) {
            return Double.compare(this.distanceSq, o.distanceSq);
        }
    }
}

