/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions;

import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.attribute.ICharacterAttribute;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.versions.CharacterAttribute_v1_16_R2;
import com.herocraftonline.heroes.nms.versions.physics.NMSPhysics_v1_16_R2;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.server.v1_16_R2.DataWatcher;
import net.minecraft.server.v1_16_R2.DataWatcherObject;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityLiving;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.MathHelper;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R2.SoundEffect;
import net.minecraft.server.v1_16_R2.SoundEffects;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class Handler_v1_16_R2
extends NMSHandler {
    protected static final Material[][] armorCategories = new Material[][]{{Material.NETHERITE_HELMET, Material.DIAMOND_HELMET, Material.IRON_HELMET, Material.GOLDEN_HELMET, Material.CHAINMAIL_HELMET, Material.LEATHER_HELMET}, {Material.NETHERITE_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.IRON_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE}, {Material.NETHERITE_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.IRON_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS}, {Material.NETHERITE_BOOTS, Material.DIAMOND_BOOTS, Material.IRON_BOOTS, Material.GOLDEN_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS}};
    protected static final Material[][] weaponCategories = new Material[][]{{Material.NETHERITE_SWORD, Material.DIAMOND_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.STONE_SWORD, Material.WOODEN_SWORD}, {Material.NETHERITE_AXE, Material.DIAMOND_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.STONE_AXE, Material.WOODEN_AXE}, {Material.NETHERITE_PICKAXE, Material.DIAMOND_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.STONE_PICKAXE, Material.WOODEN_PICKAXE}, {Material.NETHERITE_SHOVEL, Material.DIAMOND_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.STONE_SHOVEL, Material.WOODEN_SHOVEL}, {Material.NETHERITE_HOE, Material.DIAMOND_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.STONE_HOE, Material.WOODEN_HOE}, {Material.SHIELD}, {Material.TRIDENT}, {Material.CROSSBOW}};
    private static final Set<Material> weaponSet;
    private static final Set<Material> armorSet;
    private static final Set<Material> foodSet;
    private static final Set<Material> rawFoodSet;
    private static final Map<Material, Integer> foodValueMap;
    private static final Field DATA_WATCHER_OBJECT_FIELD;
    private static final Field DATA_WATCHER_ITEMS_FIELD;
    private static final Method DATA_WATCHER_ITEM_METHOD;
    private static final Field DATA_WATCHER_LOCK_FIELD;
    private static final Field ENTITY_ID_FIELD;
    private static final Field ENTITY_METADATA_FIELD;
    private Field ldbpt;
    private Random random;
    private NMSPhysics_v1_16_R2 nmsPhysics;

    public Handler_v1_16_R2() {
        try {
            this.ldbpt = EntityLiving.class.getDeclaredField("lastDamageByPlayerTime");
            this.ldbpt.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.random = new Random();
        this.nmsPhysics = new NMSPhysics_v1_16_R2();
        Bukkit.getPluginManager().getPlugin("Heroes").getLogger().info("Active physics handler: " + this.nmsPhysics.getClass().getSimpleName());
    }

    @Override
    public final double getPostArmorDamage(LivingEntity defender, double damage) {
        float var0 = (float)damage;
        float var1 = ((CraftLivingEntity)defender).getHandle().getArmorStrength();
        float var2 = this.minMaxHelper(var1, 0.0f, 20.0f);
        return var0 * (1.0f - var2 / 25.0f);
    }

    private float minMaxHelper(float var0, float var1, float var2) {
        if (var0 < var1) {
            return var1;
        }
        return Math.min(var0, var2);
    }

    @Override
    public float getAbsorptionHearts(Player player) {
        return (float)player.getAbsorptionAmount();
    }

    @Override
    public void setAbsorptionHearts(Player player, float hearts) {
        player.setAbsorptionAmount((double)hearts);
    }

    @Override
    @Deprecated
    public void injectAbsorptionHeartWatcher(Player player) {
    }

    @Override
    @Deprecated
    public void sendAbsorptionHearts(Player player, float hearts) {
    }

    @Override
    public void bukkit_setArrowDamage(Arrow arrow, double damage) {
        arrow.setDamage(damage);
    }

    @Override
    public void setPlayerExpZero(Player player) {
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
    }

    @Override
    public void knockBack(LivingEntity target, LivingEntity attacker, float knockbackStrength) {
        Location attackerLoc = attacker.getLocation();
        Location targetLoc = target.getLocation();
        double d0 = attackerLoc.getX() - targetLoc.getX();
        double d1 = attackerLoc.getZ() - targetLoc.getZ();
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        if (!(target instanceof Player)) {
            float yaw = (float)(Math.atan2(d1, d0) * 180.0 / 3.1415927410125732) - targetLoc.getYaw();
            target.setRotation(yaw, targetLoc.getPitch());
        }
        if ((knockbackStrength = (float)((double)knockbackStrength * (1.0 - target.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).getValue()))) > 0.0f) {
            Vector initialVec = target.getVelocity();
            Vector postVec = new Vector(d0, 0.0, d1);
            postVec = postVec.length() < 1.0E-4 ? new Vector() : postVec.normalize();
            postVec.multiply(knockbackStrength);
            Vector newVec = new Vector(initialVec.getX() / 2.0 - postVec.getX(), target.isOnGround() ? Math.min(0.4, initialVec.getY() / 2.0 + (double)knockbackStrength) : initialVec.getY(), initialVec.getZ() / 2.0 - postVec.getZ());
            target.setVelocity(newVec);
        }
    }

    @Override
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause, float knockback) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        int originalNoDamageTicks = target.getNoDamageTicks();
        target.setNoDamageTicks(0);
        EntityDamageByEntityEvent entityDamageEvent = new EntityDamageByEntityEvent((Entity)attacker, (Entity)target, cause, damage);
        Bukkit.getServer().getPluginManager().callEvent((Event)entityDamageEvent);
        if (entityDamageEvent.isCancelled()) {
            return false;
        }
        target.setLastDamageCause((EntityDamageEvent)entityDamageEvent);
        double remainingDamage = entityDamageEvent.getDamage();
        double oldShield = target.getAbsorptionAmount();
        double newShield = oldShield - remainingDamage;
        if (newShield < 0.0) {
            newShield = 0.0;
        }
        remainingDamage -= oldShield - newShield;
        double oldHealth = target.getHealth();
        double newHealth = oldHealth - remainingDamage;
        if (newHealth < 0.0) {
            newHealth = 0.0;
        }
        target.setHealth(newHealth);
        target.setAbsorptionAmount(newShield);
        target.setLastDamage(entityDamageEvent.getDamage());
        target.playEffect(EntityEffect.HURT);
        if (knockback > 0.0f) {
            this.knockBack(target, attacker, knockback);
        }
        if (newHealth > 0.0) {
            Mob mob;
            target.setNoDamageTicks(originalNoDamageTicks);
            if (target instanceof PigZombie) {
                PigZombie pz = (PigZombie)target;
                pz.setAngry(true);
            }
            if (target instanceof Mob && ((mob = (Mob)target).getTarget() == null || mob.getTarget().isDead())) {
                EntityTargetEvent targetEvent = new EntityTargetEvent((Entity)target, (Entity)attacker, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY);
                Bukkit.getServer().getPluginManager().callEvent((Event)targetEvent);
                if (!targetEvent.isCancelled()) {
                    mob.setTarget(attacker);
                }
                if (target instanceof Wolf) {
                    Wolf wolf = (Wolf)target;
                    wolf.setAngry(true);
                }
            }
        }
        return true;
    }

    @Override
    public void playInstantFirework(Firework firework, FireworkEffect fe, Location loc) {
        Firework spigotFirework = (Firework)loc.getWorld().spawn(loc, Firework.class);
        FireworkMeta meta = spigotFirework.getFireworkMeta();
        meta.addEffect(fe);
        spigotFirework.setFireworkMeta(meta);
        spigotFirework.detonate();
    }

    private SoundEffect getSoundEffect(EntityType type) {
        switch (type) {
            case BLAZE: {
                return SoundEffects.ENTITY_BLAZE_DEATH;
            }
            case CHICKEN: {
                return SoundEffects.ENTITY_CHICKEN_DEATH;
            }
            case CREEPER: {
                return SoundEffects.ENTITY_CREEPER_DEATH;
            }
            case MAGMA_CUBE: 
            case SLIME: {
                return SoundEffects.ENTITY_SLIME_DEATH;
            }
            case SKELETON: {
                return SoundEffects.ENTITY_SKELETON_DEATH;
            }
            case IRON_GOLEM: {
                return SoundEffects.ENTITY_IRON_GOLEM_DEATH;
            }
            case GHAST: {
                return SoundEffects.ENTITY_GHAST_DEATH;
            }
            case PIG: {
                return SoundEffects.ENTITY_PIG_DEATH;
            }
            case OCELOT: {
                return SoundEffects.ENTITY_CAT_DEATH;
            }
            case SHEEP: {
                return SoundEffects.ENTITY_SHEEP_DEATH;
            }
            case SPIDER: {
                return SoundEffects.ENTITY_SPIDER_DEATH;
            }
            case WOLF: {
                return SoundEffects.ENTITY_WOLF_DEATH;
            }
            case ZOMBIE: {
                return SoundEffects.ENTITY_ZOMBIE_DEATH;
            }
        }
        return SoundEffects.ENTITY_GENERIC_DEATH;
    }

    @Override
    protected float getSoundStrength(LivingEntity entity) {
        EntityLiving el = ((CraftLivingEntity)entity).getHandle();
        return el.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public void playClientEffect(Player player, Location startLocation, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        try {
            Particle particleEffect = Particle.valueOf((String)particle.toUpperCase());
            double offsetX = offset.getX() + 0.5;
            double offsetY = offset.getY() + 0.3;
            double offsetZ = offset.getZ() + 0.5;
            if (!sendToAll) {
                player.spawnParticle(particleEffect, player.getEyeLocation(), count, offsetX, offsetY, offsetZ, (double)speed);
            } else {
                player.getWorld().spawnParticle(particleEffect, player.getEyeLocation(), count, offsetX, offsetY, offsetZ, (double)speed);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void hidePlayerFromEntity(Player player, Entity entity) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (mob.getTarget() != null && mob.getTarget().equals(player)) {
            mob.setTarget(null);
        }
    }

    @Override
    public ICharacterAttribute createCharacterAttribute(String name, byte id) {
        return new CharacterAttribute_v1_16_R2(name, id);
    }

    @Override
    public NMSPhysics getNMSPhysics() {
        return this.nmsPhysics;
    }

    @Override
    public Material getUsedMaterial(Player player) {
        if (player.isSneaking() && player.getInventory().getItemInOffHand() != null && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
            return player.getInventory().getItemInOffHand().getType();
        }
        if (player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return player.getInventory().getItemInMainHand().getType();
        }
        if (player.getInventory().getItemInOffHand() != null && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
            return player.getInventory().getItemInOffHand().getType();
        }
        return Material.AIR;
    }

    @Override
    public boolean isDuplicateEvent(PlayerInteractEvent event) {
        return event.getHand() == EquipmentSlot.OFF_HAND && event.getPlayer().getInventory().getItemInMainHand() != null && event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR;
    }

    @Override
    public double getCooldownDamageMultiplier(Player player) {
        EntityPlayer eh = ((CraftPlayer)player).getHandle();
        long swingTime = 0L;
        swingTime = !player.hasMetadata("LastSwingTime") ? 0L : ((MetadataValue)player.getMetadata("LastSwingTime").get(0)).asLong();
        float swingToTicks = (float)(System.currentTimeMillis() - swingTime) / 50.0f;
        float T = eh.eQ();
        float f2 = MathHelper.a((float)((swingToTicks + 0.5f) / T), (float)0.0f, (float)1.0f);
        return 0.2f + f2 * f2 * 0.8f;
    }

    @Override
    public double getDefaultDamage(Material item) {
        switch (item) {
            case NETHERITE_PICKAXE: {
                return 6.0;
            }
            case NETHERITE_SHOVEL: {
                return 6.5;
            }
            case NETHERITE_AXE: {
                return 10.0;
            }
            case NETHERITE_SWORD: {
                return 8.0;
            }
        }
        return super.getDefaultDamage(item);
    }

    @Override
    public Material[][] getWeaponCategories() {
        return weaponCategories;
    }

    @Override
    public Material[][] getArmorCategories() {
        return armorCategories;
    }

    @Override
    public boolean isWeapon(Material type) {
        return weaponSet.contains(type);
    }

    @Override
    public boolean isArmor(Material type) {
        return armorSet.contains(type);
    }

    @Override
    public boolean isFood(Material type) {
        return foodSet.contains(type);
    }

    @Override
    public boolean isRawFood(Material type) {
        return rawFoodSet.contains(type);
    }

    @Override
    public int getFoodValue(Material type) {
        return foodValueMap.getOrDefault(type, 0);
    }

    @Override
    public ItemStack getItemInMainHand(PlayerInventory inventory) {
        return inventory.getItemInMainHand();
    }

    @Override
    public void setItemInMainHand(PlayerInventory inventory, ItemStack stack) {
        inventory.setItemInMainHand(stack);
    }

    @Override
    public ItemStack getItemInOffHand(@Nonnull PlayerInventory inventory) {
        return inventory.getItemInOffHand();
    }

    @Override
    public void setItemInOffHand(@Nonnull PlayerInventory inventory, ItemStack stack) {
        inventory.setItemInOffHand(stack);
    }

    static {
        HashSet<Material> set = new HashSet<Material>(NMSHandler.weaponSet);
        set.add(Material.CROSSBOW);
        set.add(Material.WARPED_FUNGUS_ON_A_STICK);
        set.add(Material.NETHERITE_SWORD);
        set.add(Material.NETHERITE_AXE);
        set.add(Material.NETHERITE_PICKAXE);
        set.add(Material.NETHERITE_SHOVEL);
        set.add(Material.NETHERITE_HOE);
        weaponSet = Collections.unmodifiableSet(set);
        set = new HashSet<Material>(NMSHandler.armorSet);
        set.add(Material.NETHERITE_HELMET);
        set.add(Material.NETHERITE_CHESTPLATE);
        set.add(Material.NETHERITE_LEGGINGS);
        set.add(Material.NETHERITE_BOOTS);
        armorSet = Collections.unmodifiableSet(set);
        set = new HashSet<Material>(NMSHandler.foodSet);
        set.add(Material.SUSPICIOUS_STEW);
        set.add(Material.SWEET_BERRIES);
        set.add(Material.HONEY_BOTTLE);
        foodSet = Collections.unmodifiableSet(set);
        set = new HashSet<Material>(NMSHandler.rawFoodSet);
        rawFoodSet = Collections.unmodifiableSet(set);
        HashMap<Material, Integer> map = new HashMap<Material, Integer>(NMSHandler.foodValueMap);
        map.put(Material.SUSPICIOUS_STEW, 6);
        map.put(Material.SWEET_BERRIES, 2);
        map.put(Material.HONEY_BOTTLE, 6);
        foodValueMap = Collections.unmodifiableMap(map);
        try {
            DATA_WATCHER_OBJECT_FIELD = EntityHuman.class.getDeclaredField("c");
            DATA_WATCHER_OBJECT_FIELD.setAccessible(true);
            DATA_WATCHER_ITEMS_FIELD = DataWatcher.class.getDeclaredField("entries");
            DATA_WATCHER_ITEMS_FIELD.setAccessible(true);
            DATA_WATCHER_ITEM_METHOD = DataWatcher.class.getDeclaredMethod("b", DataWatcherObject.class);
            DATA_WATCHER_ITEM_METHOD.setAccessible(true);
            DATA_WATCHER_LOCK_FIELD = DataWatcher.class.getDeclaredField("registrationLocked");
            DATA_WATCHER_LOCK_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            ENTITY_ID_FIELD = PacketPlayOutEntityMetadata.class.getDeclaredField("a");
            ENTITY_ID_FIELD.setAccessible(true);
            ENTITY_METADATA_FIELD = PacketPlayOutEntityMetadata.class.getDeclaredField("b");
            ENTITY_METADATA_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

