/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.attribute.ICharacterAttribute;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.versions.CharacterAttribute_v1_13_R2;
import com.herocraftonline.heroes.nms.versions.DataWatcherItem_v1_13_R2;
import com.herocraftonline.heroes.nms.versions.physics.NMSPhysics_v1_13_R2;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import net.minecraft.server.v1_13_R2.CombatMath;
import net.minecraft.server.v1_13_R2.DamageSource;
import net.minecraft.server.v1_13_R2.DataWatcher;
import net.minecraft.server.v1_13_R2.DataWatcherObject;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityFireworks;
import net.minecraft.server.v1_13_R2.EntityGolem;
import net.minecraft.server.v1_13_R2.EntityHuman;
import net.minecraft.server.v1_13_R2.EntityInsentient;
import net.minecraft.server.v1_13_R2.EntityLiving;
import net.minecraft.server.v1_13_R2.EntityMonster;
import net.minecraft.server.v1_13_R2.EntityPlayer;
import net.minecraft.server.v1_13_R2.EntityWolf;
import net.minecraft.server.v1_13_R2.MathHelper;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_13_R2.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_13_R2.SoundEffect;
import net.minecraft.server.v1_13_R2.SoundEffects;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Golem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class Handler_v1_13_R2
extends NMSHandler {
    protected static final Material[][] weaponCategories = new Material[][]{{Material.DIAMOND_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.STONE_SWORD, Material.WOODEN_SWORD}, {Material.DIAMOND_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.STONE_AXE, Material.WOODEN_AXE}, {Material.DIAMOND_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.STONE_PICKAXE, Material.WOODEN_PICKAXE}, {Material.DIAMOND_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.STONE_SHOVEL, Material.WOODEN_SHOVEL}, {Material.DIAMOND_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.STONE_HOE, Material.WOODEN_HOE}, {Material.SHIELD}, {Material.TRIDENT}};
    private static final Set<Material> weaponSet;
    private static final Set<Material> armorSet;
    private static final Set<Material> foodSet;
    private static final Set<Material> rawFoodSet;
    private static final Map<Material, Integer> foodValueMap;
    private static final Field DATA_WATCHER_OBJECT_FIELD;
    private static final Field DATA_WATCHER_ITEMS_FIELD;
    private static final Method DATA_WATCHER_ITEM_METHOD;
    private static final Field DATA_WATCHER_LOCK_FIELD;
    private static final Field ENTITY_ID_FIELD;
    private static final Field ENTITY_METADATA_FIELD;
    private Field ldbpt;
    private Random random;
    private NMSPhysics_v1_13_R2 nmsPhysics;

    public Handler_v1_13_R2() {
        try {
            this.ldbpt = EntityLiving.class.getDeclaredField("lastDamageByPlayerTime");
            this.ldbpt.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.random = new Random();
        this.nmsPhysics = new NMSPhysics_v1_13_R2();
        Bukkit.getPluginManager().getPlugin("Heroes").getLogger().info("Active physics handler: " + this.nmsPhysics.getClass().getSimpleName());
    }

    @Override
    public final double getPostArmorDamage(LivingEntity defender, double damage) {
        return CombatMath.a((float)((float)damage), (float)((CraftLivingEntity)defender).getHandle().getArmorStrength());
    }

    @Override
    public float getAbsorptionHearts(Player player) {
        return ((CraftPlayer)player).getHandle().getAbsorptionHearts();
    }

    @Override
    public void setAbsorptionHearts(Player player, float hearts) {
        ((CraftPlayer)player).getHandle().setAbsorptionHearts(hearts);
    }

    @Override
    public void injectAbsorptionHeartWatcher(Player player) {
        EntityPlayer entity = ((CraftPlayer)player).getHandle();
        DataWatcher watcher = entity.getDataWatcher();
        try {
            DataWatcherObject watcherObject = (DataWatcherObject)DATA_WATCHER_OBJECT_FIELD.get(entity);
            DataWatcher.Item item = (DataWatcher.Item)DATA_WATCHER_ITEM_METHOD.invoke((Object)watcher, watcherObject);
            DataWatcherItem_v1_13_R2<Float> newItem = new DataWatcherItem_v1_13_R2<Float>(watcherObject, (Float)item.b(), true);
            ReadWriteLock lock = (ReadWriteLock)DATA_WATCHER_LOCK_FIELD.get(watcher);
            lock.writeLock().lock();
            Map items = (Map)DATA_WATCHER_ITEMS_FIELD.get(watcher);
            items.put(watcherObject.a(), newItem);
            lock.writeLock().unlock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendAbsorptionHearts(Player player, float hearts) {
        EntityPlayer entity = ((CraftPlayer)player).getHandle();
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
        try {
            ENTITY_ID_FIELD.setInt(packet, player.getEntityId());
            DataWatcherObject watcherObject = (DataWatcherObject)DATA_WATCHER_OBJECT_FIELD.get(entity);
            ArrayList metadata = Lists.newArrayList();
            metadata.add(new DataWatcherItem_v1_13_R2<Float>(watcherObject, Float.valueOf(hearts), false));
            ENTITY_METADATA_FIELD.set(packet, metadata);
            entity.playerConnection.sendPacket((Packet)packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bukkit_setArrowDamage(Arrow arrow, double damage) {
        ((CraftArrow)arrow).getHandle().setDamage(damage);
    }

    @Override
    public void setPlayerExpZero(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        entityPlayer.exp = 0.0f;
        entityPlayer.expTotal = 0;
        entityPlayer.expLevel = 0;
    }

    @Override
    public void knockBack(LivingEntity target, LivingEntity attacker, float knockbackStrength) {
        EntityLiving mcTarget = ((CraftLivingEntity)target).getHandle();
        EntityLiving mcAttacker = ((CraftLivingEntity)attacker).getHandle();
        mcTarget.velocityChanged = true;
        double d0 = mcAttacker.locX - mcTarget.locX;
        double d1 = mcAttacker.locZ - mcTarget.locZ;
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        mcTarget.aD = (float)(Math.atan2(d1, d0) * 180.0 / 3.1415927410125732) - mcTarget.yaw;
        mcTarget.a((Entity)mcAttacker, knockbackStrength, d0, d1);
    }

    @Override
    public void sendPlayerUpdateHealthPacket(Player player, int foodLevel) {
        PacketPlayOutUpdateHealth packet = new PacketPlayOutUpdateHealth((float)player.getHealth(), foodLevel, player.getSaturation());
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause, float knockback) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        int originalNoDamageTicks = target.getNoDamageTicks();
        target.setNoDamageTicks(0);
        EntityDamageByEntityEvent edbe = new EntityDamageByEntityEvent((org.bukkit.entity.Entity)attacker, (org.bukkit.entity.Entity)target, cause, damage);
        Bukkit.getServer().getPluginManager().callEvent((Event)edbe);
        if (edbe.isCancelled()) {
            return false;
        }
        EntityLiving el = ((CraftLivingEntity)target).getHandle();
        target.setLastDamageCause((EntityDamageEvent)edbe);
        double remainingDamage = edbe.getDamage();
        double oldShield = el.getAbsorptionHearts();
        double newShield = oldShield - remainingDamage;
        if (newShield < 0.0) {
            newShield = 0.0;
        }
        remainingDamage -= oldShield - newShield;
        double oldHealth = target.getHealth();
        double newHealth = oldHealth - remainingDamage;
        if (newHealth < 0.0) {
            newHealth = 0.0;
        }
        el.lastDamage = (float)edbe.getDamage();
        el.aG = (float)oldHealth;
        el.aA = 10;
        el.hurtTicks = 10;
        el.aD = 0.0f;
        if (knockback > 0.0f) {
            this.knockBack(target, attacker, knockback);
        }
        el.world.broadcastEntityEffect((Entity)el, (byte)2);
        el.lastDamager = ((CraftLivingEntity)attacker).getHandle();
        if (attacker instanceof Player) {
            try {
                this.ldbpt.set(el, 60);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        el.setHealth((float)newHealth);
        el.setAbsorptionHearts((float)newShield);
        if (newHealth <= 0.0) {
            el.a(this.getSoundEffect(target.getType()), 1.0f, this.getSoundStrength(target));
            if (attacker instanceof Player) {
                EntityPlayer p = ((CraftPlayer)attacker).getHandle();
                el.killer = p;
                el.die(DamageSource.playerAttack((EntityHuman)p));
            } else {
                EntityLiving att = ((CraftLivingEntity)attacker).getHandle();
                el.die(DamageSource.mobAttack((EntityLiving)att));
            }
        } else {
            EntityWolf ew;
            target.setNoDamageTicks(originalNoDamageTicks);
            EntityLiving attackerEntity = ((CraftLivingEntity)attacker).getHandle();
            if (target instanceof PigZombie) {
                ((PigZombie)target).setAngry(true);
            }
            if (target instanceof Monster) {
                EntityMonster em = (EntityMonster)el;
                if (em.getGoalTarget() == null || !em.getGoalTarget().isAlive()) {
                    em.setGoalTarget(attackerEntity, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
                }
            } else if (target instanceof Golem && !(target instanceof Snowman)) {
                EntityGolem eg = (EntityGolem)el;
                if (eg.getGoalTarget() == null || !eg.getGoalTarget().isAlive()) {
                    eg.setGoalTarget(attackerEntity, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
                }
            } else if (target instanceof Wolf && ((Wolf)target).getTarget() == null && ((ew = (EntityWolf)el).getGoalTarget() == null || !ew.getGoalTarget().isAlive())) {
                ew.setAngry(true);
                ew.setGoalTarget(attackerEntity, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
        return true;
    }

    @Override
    public void playInstantFirework(Firework firework, FireworkEffect fe, Location loc) {
        Firework spigotFirework = firework;
        FireworkMeta meta = spigotFirework.getFireworkMeta();
        meta.addEffect(fe);
        spigotFirework.setFireworkMeta(meta);
        try {
            CraftFirework nmsFirework = (CraftFirework)spigotFirework;
            EntityFireworks nmsEntFireworks = nmsFirework.getHandle();
            for (int i = 0; i < nmsEntFireworks.expectedLifespan - 1; ++i) {
                nmsEntFireworks.inactiveTick();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private SoundEffect getSoundEffect(EntityType type) {
        switch (type) {
            case BLAZE: {
                return SoundEffects.ENTITY_BLAZE_DEATH;
            }
            case CHICKEN: {
                return SoundEffects.ENTITY_CHICKEN_DEATH;
            }
            case CREEPER: {
                return SoundEffects.ENTITY_CREEPER_DEATH;
            }
            case MAGMA_CUBE: 
            case SLIME: {
                return SoundEffects.ENTITY_SLIME_DEATH;
            }
            case SKELETON: {
                return SoundEffects.ENTITY_SKELETON_DEATH;
            }
            case IRON_GOLEM: {
                return SoundEffects.ENTITY_IRON_GOLEM_DEATH;
            }
            case GHAST: {
                return SoundEffects.ENTITY_GHAST_DEATH;
            }
            case PIG: {
                return SoundEffects.ENTITY_PIG_DEATH;
            }
            case OCELOT: {
                return SoundEffects.ENTITY_CAT_DEATH;
            }
            case SHEEP: {
                return SoundEffects.ENTITY_SHEEP_DEATH;
            }
            case SPIDER: {
                return SoundEffects.ENTITY_SPIDER_DEATH;
            }
            case WOLF: {
                return SoundEffects.ENTITY_WOLF_DEATH;
            }
            case ZOMBIE: {
                return SoundEffects.ENTITY_ZOMBIE_DEATH;
            }
        }
        return SoundEffects.ENTITY_GENERIC_DEATH;
    }

    @Override
    protected float getSoundStrength(LivingEntity entity) {
        EntityLiving el = ((CraftLivingEntity)entity).getHandle();
        return el.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public void playClientEffect(Player player, Location startLocation, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        if (!(player instanceof CraftPlayer)) {
            throw new IllegalArgumentException("The provided player is NOT a CraftPlayer!");
        }
        try {
            Particle particleEffect = Particle.valueOf((String)particle);
            double offsetX = offset.getX() + 0.5;
            double offsetY = offset.getY() + 0.3;
            double offsetZ = offset.getZ() + 0.5;
            if (!sendToAll) {
                player.getWorld().spawnParticle(particleEffect, player.getEyeLocation().getX(), player.getEyeLocation().getY(), player.getEyeLocation().getZ(), count, offsetX, offsetY, offsetZ, (double)speed);
            } else {
                player.getWorld().spawnParticle(particleEffect, player.getEyeLocation().getX(), player.getEyeLocation().getY(), player.getEyeLocation().getZ(), count, offsetX, offsetY, offsetZ, (double)speed);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void hidePlayerFromEntity(Player player, org.bukkit.entity.Entity entity) {
        if (entity instanceof CraftLivingEntity) {
            EntityLiving mcPlayer = ((CraftLivingEntity)player).getHandle();
            EntityLiving mcEntity = ((CraftLivingEntity)entity).getHandle();
            if (mcEntity instanceof EntityInsentient && ((EntityInsentient)mcEntity).getGoalTarget() != null && ((EntityInsentient)mcEntity).getGoalTarget().equals((Object)mcPlayer)) {
                EntityInsentient nmsInsentient = (EntityInsentient)mcEntity;
                nmsInsentient.setGoalTarget(null);
            }
        }
    }

    @Override
    public ICharacterAttribute createCharacterAttribute(String name, byte id) {
        return new CharacterAttribute_v1_13_R2(name, id);
    }

    @Override
    public NMSPhysics getNMSPhysics() {
        return this.nmsPhysics;
    }

    @Override
    public Material getUsedMaterial(Player player) {
        if (player.isSneaking() && player.getInventory().getItemInOffHand() != null && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
            return player.getInventory().getItemInOffHand().getType();
        }
        if (player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return player.getInventory().getItemInMainHand().getType();
        }
        if (player.getInventory().getItemInOffHand() != null && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
            return player.getInventory().getItemInOffHand().getType();
        }
        return Material.AIR;
    }

    @Override
    public boolean isDuplicateEvent(PlayerInteractEvent event) {
        return event.getHand() == EquipmentSlot.OFF_HAND && event.getPlayer().getInventory().getItemInMainHand() != null && event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR;
    }

    @Override
    public double getCooldownDamageMultiplier(Player player) {
        EntityPlayer eh = ((CraftPlayer)player).getHandle();
        long swingTime = 0L;
        swingTime = !player.hasMetadata("LastSwingTime") ? 0L : ((MetadataValue)player.getMetadata("LastSwingTime").get(0)).asLong();
        float swingToTicks = (float)(System.currentTimeMillis() - swingTime) / 50.0f;
        float f2 = MathHelper.a((float)((swingToTicks + 0.5f) / eh.dG()), (float)0.0f, (float)1.0f);
        return 0.2f + f2 * f2 * 0.8f;
    }

    @Override
    public Material[][] getWeaponCategories() {
        return weaponCategories;
    }

    @Override
    public boolean isWeapon(Material type) {
        return weaponSet.contains(type);
    }

    @Override
    public boolean isArmor(Material type) {
        return armorSet.contains(type);
    }

    @Override
    public boolean isFood(Material type) {
        return foodSet.contains(type);
    }

    @Override
    public boolean isRawFood(Material type) {
        return rawFoodSet.contains(type);
    }

    @Override
    public int getFoodValue(Material type) {
        return foodValueMap.containsKey(type) ? foodValueMap.get(type) : 0;
    }

    @Override
    public ItemStack getItemInMainHand(PlayerInventory inventory) {
        return inventory.getItemInMainHand();
    }

    @Override
    public void setItemInMainHand(PlayerInventory inventory, ItemStack stack) {
        inventory.setItemInMainHand(stack);
    }

    @Override
    public ItemStack getItemInOffHand(@Nonnull PlayerInventory inventory) {
        return inventory.getItemInOffHand();
    }

    @Override
    public void setItemInOffHand(@Nonnull PlayerInventory inventory, ItemStack stack) {
        inventory.setItemInOffHand(stack);
    }

    static {
        HashSet<Material> set = new HashSet<Material>(NMSHandler.weaponSet);
        weaponSet = Collections.unmodifiableSet(set);
        set = new HashSet<Material>(NMSHandler.armorSet);
        armorSet = Collections.unmodifiableSet(set);
        set = new HashSet<Material>(NMSHandler.foodSet);
        foodSet = Collections.unmodifiableSet(set);
        set = new HashSet<Material>(NMSHandler.rawFoodSet);
        rawFoodSet = Collections.unmodifiableSet(set);
        HashMap<Material, Integer> map = new HashMap<Material, Integer>(NMSHandler.foodValueMap);
        foodValueMap = Collections.unmodifiableMap(map);
        try {
            DATA_WATCHER_OBJECT_FIELD = EntityHuman.class.getDeclaredField("a");
            DATA_WATCHER_OBJECT_FIELD.setAccessible(true);
            DATA_WATCHER_ITEMS_FIELD = DataWatcher.class.getDeclaredField("d");
            DATA_WATCHER_ITEMS_FIELD.setAccessible(true);
            DATA_WATCHER_ITEM_METHOD = DataWatcher.class.getDeclaredMethod("b", DataWatcherObject.class);
            DATA_WATCHER_ITEM_METHOD.setAccessible(true);
            DATA_WATCHER_LOCK_FIELD = DataWatcher.class.getDeclaredField("e");
            DATA_WATCHER_LOCK_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            ENTITY_ID_FIELD = PacketPlayOutEntityMetadata.class.getDeclaredField("a");
            ENTITY_ID_FIELD.setAccessible(true);
            ENTITY_METADATA_FIELD = PacketPlayOutEntityMetadata.class.getDeclaredField("b");
            ENTITY_METADATA_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

