/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions;

import com.herocraftonline.heroes.nms.attribute.ICharacterAttribute;
import com.herocraftonline.heroes.nms.attribute.ICharacterAttributeModifier;
import com.herocraftonline.heroes.nms.versions.CharacterAttributeModifier_v1_16_R1;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;

public class CharacterAttribute_v1_16_R1
implements ICharacterAttribute {
    private ICharacterAttributeModifier valueMod;
    private ICharacterAttributeModifier balanceMod;

    public CharacterAttribute_v1_16_R1(String name, byte id) {
        this.valueMod = new CharacterAttributeModifier_v1_16_R1(UUID.nameUUIDFromBytes(new byte[]{8, 0, 3, id}), name);
        this.balanceMod = new CharacterAttributeModifier_v1_16_R1(UUID.nameUUIDFromBytes(new byte[]{8, 1, 3, id}), name + "$NEG");
    }

    @Override
    public double getValue() {
        return this.valueMod.getValue();
    }

    @Override
    public void setValue(double value) {
        this.valueMod.setValue(value);
        this.balanceMod.setValue(-value);
    }

    @Override
    public double loadOrCreate(LivingEntity entity, double altVal) {
        AttributeInstance instance = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        AttributeModifier current = this.getByUUID(instance, this.valueMod.getId());
        AttributeModifier currentBalance = this.getByUUID(instance, this.balanceMod.getId());
        if (current != null) {
            altVal = current.getAmount();
            instance.removeModifier(current);
            instance.removeModifier(currentBalance);
        }
        this.setValue(altVal);
        instance.addModifier((AttributeModifier)this.valueMod);
        instance.addModifier((AttributeModifier)this.balanceMod);
        return altVal;
    }

    private AttributeModifier getByUUID(AttributeInstance instance, UUID id) {
        return instance.getModifiers().stream().filter(m -> m.getUniqueId().equals(id)).findFirst().orElse(null);
    }
}

