/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.physics;

import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.FluidCollision;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.nms.physics.RayCastFlag;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public final class RayCastInfo {
    private static final NMSPhysics physics = NMSHandler.getInterface().getNMSPhysics();
    private Predicate<Block> blockFilter;
    private Predicate<Entity> entityFilter;
    private FluidCollision blockFluidCollision;
    private boolean blockIgnoreNonCollidable;
    private final EnumSet<RayCastFlag> flags;

    public RayCastInfo() {
        this.blockFilter = b -> true;
        this.entityFilter = t -> true;
        this.blockIgnoreNonCollidable = true;
        this.blockFluidCollision = NMSPhysics.DEFAULT_FLUID_COLLISION;
        this.flags = EnumSet.noneOf(RayCastFlag.class);
    }

    public RayCastInfo(RayCastInfo other) {
        this.blockFilter = other.blockFilter;
        this.entityFilter = other.entityFilter;
        this.blockIgnoreNonCollidable = other.getBlockIgnoreNonCollidable();
        this.flags = other.getFlagsCopy();
    }

    public Predicate<Block> getBlockFilter() {
        return this.blockFilter;
    }

    public RayCastInfo setBlockFilter(Predicate<Block> blockFilter) {
        this.blockFilter = blockFilter != null ? blockFilter : b -> true;
        return this;
    }

    public Predicate<Entity> getEntityFilter() {
        return this.entityFilter;
    }

    public RayCastInfo setEntityFilter(Predicate<Entity> entityFilter) {
        this.entityFilter = entityFilter != null ? entityFilter : e -> true;
        return this;
    }

    public FluidCollision getBlockFluidCollision() {
        return this.blockFluidCollision;
    }

    public RayCastInfo setBlockFluidCollision(FluidCollision blockFluidCollision) {
        this.blockFluidCollision = blockFluidCollision != null ? blockFluidCollision : NMSPhysics.DEFAULT_FLUID_COLLISION;
        return this;
    }

    public boolean getBlockIgnoreNonCollidable() {
        return this.blockIgnoreNonCollidable;
    }

    public RayCastInfo setBlockIgnoreNonCollidable(boolean blockIgnoreNonCollidable) {
        this.blockIgnoreNonCollidable = blockIgnoreNonCollidable;
        return this;
    }

    @Deprecated
    public EnumSet<RayCastFlag> getFlags() {
        return this.flags;
    }

    @Deprecated
    public EnumSet<RayCastFlag> getFlagsCopy() {
        return EnumSet.copyOf(this.flags);
    }

    @Deprecated
    public RayCastInfo setFlags(RayCastFlag ... flags) {
        this.flags.clear();
        for (RayCastFlag flag : flags) {
            this.addFlag(flag);
        }
        return this;
    }

    @Deprecated
    public RayCastInfo setFlags(Set<RayCastFlag> flags) {
        this.flags.clear();
        this.flags.addAll(flags);
        return this;
    }

    @Deprecated
    public RayCastInfo addFlag(RayCastFlag flag) {
        this.flags.add(flag);
        return this;
    }

    @Deprecated
    public RayCastInfo addFlags(RayCastFlag ... flags) {
        Collections.addAll(this.flags, flags);
        return this;
    }

    @Deprecated
    public RayCastInfo addFlags(Set<RayCastFlag> flags) {
        this.flags.addAll(flags);
        return this;
    }

    @Deprecated
    public RayCastInfo removeFlag(RayCastFlag flag) {
        this.flags.remove((Object)flag);
        return this;
    }

    @Deprecated
    public RayCastInfo removeFlags(RayCastFlag ... flags) {
        for (RayCastFlag flag : flags) {
            this.flags.remove((Object)flag);
        }
        return this;
    }

    @Deprecated
    public RayCastInfo removeFlags(Set<RayCastFlag> flags) {
        this.flags.removeAll(flags);
        return this;
    }

    public RayCastInfo copy() {
        return new RayCastInfo(this);
    }
}

