/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.physics;

import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.FluidCollision;
import com.herocraftonline.heroes.nms.physics.RayCastFlag;
import com.herocraftonline.heroes.nms.physics.RayCastHit;
import com.herocraftonline.heroes.nms.physics.RayCastInfo;
import com.herocraftonline.heroes.nms.physics.collision.AABB;
import com.herocraftonline.heroes.nms.physics.collision.Capsule;
import com.herocraftonline.heroes.nms.physics.collision.ColliderVolume;
import com.herocraftonline.heroes.nms.physics.collision.Sphere;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public abstract class NMSPhysics {
    public static final FluidCollision DEFAULT_FLUID_COLLISION = FluidCollision.ALWAYS;
    public static final boolean DEFAULT_IGNORE_NON_COLLIDABLE = true;

    public static NMSPhysics instance() {
        return NMSHandler.getInterface().getNMSPhysics();
    }

    public abstract AABB createAABB(double var1, double var3, double var5, double var7, double var9, double var11);

    public final AABB createAABB(Vector v1, Vector v2) {
        return this.createAABB(v1.getX(), v1.getY(), v1.getZ(), v2.getX(), v2.getY(), v2.getZ());
    }

    public final AABB createAABB(Vector center, double boundsX, double boundsY, double boundsZ) {
        return this.createAABB(center.getX() - boundsX, center.getY() - boundsY, center.getZ() - boundsZ, center.getX() + boundsX, center.getY() + boundsY, center.getZ() + boundsZ);
    }

    public final AABB createAABB(Vector center, double bounds) {
        return this.createAABB(center, bounds, bounds, bounds);
    }

    public abstract AABB getEntityAABB(Entity var1);

    public abstract List<AABB> getBlockAABB(Block var1);

    public abstract Sphere createSphere(double var1, double var3, double var5, double var7);

    public final Sphere createSphere(Vector center, double radius) {
        return this.createSphere(center.getX(), center.getY(), center.getZ(), radius);
    }

    public abstract Capsule createCapsule(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    public final Capsule createCapsule(Vector v1, Vector v2, double radius) {
        return this.createCapsule(v1.getX(), v1.getY(), v1.getZ(), v2.getX(), v2.getY(), v2.getZ(), radius);
    }

    public abstract RayCastHit rayCastBlock(Block var1, Vector var2, Vector var3, FluidCollision var4, boolean var5);

    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end, FluidCollision fluidCollision) {
        return this.rayCastBlock(block, start, end, fluidCollision, true);
    }

    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end, boolean ignoreNonCollidable) {
        return this.rayCastBlock(block, start, end, DEFAULT_FLUID_COLLISION, ignoreNonCollidable);
    }

    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end) {
        return this.rayCastBlock(block, start, end, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastBlock(block, start, end, info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    public abstract RayCastHit rayCastBlocks(World var1, Vector var2, Vector var3, Predicate<Block> var4, FluidCollision var5, boolean var6);

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, FluidCollision fluidCollision) {
        return this.rayCastBlocks(world, start, end, filter, fluidCollision, true);
    }

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, boolean ignoreNonCollidable) {
        return this.rayCastBlocks(world, start, end, filter, DEFAULT_FLUID_COLLISION, ignoreNonCollidable);
    }

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter) {
        return this.rayCastBlocks(world, start, end, filter, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, FluidCollision fluidCollision) {
        return this.rayCastBlocks(world, start, end, null, fluidCollision, true);
    }

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, boolean ignoreNonCollidable) {
        return this.rayCastBlocks(world, start, end, null, DEFAULT_FLUID_COLLISION, ignoreNonCollidable);
    }

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end) {
        return this.rayCastBlocks(world, start, end, null, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastBlocks(world, start, end, info.getBlockFilter(), info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    public abstract Iterator<RayCastHit> rayCastBlocksAll(World var1, Vector var2, Vector var3, Predicate<Block> var4, FluidCollision var5, boolean var6);

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Predicate<Block> filter, FluidCollision fluidCollision) {
        return this.rayCastBlocksAll(world, start, end, filter, fluidCollision, true);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Predicate<Block> filter, boolean ignoreNonCollidable) {
        return this.rayCastBlocksAll(world, start, end, filter, DEFAULT_FLUID_COLLISION, ignoreNonCollidable);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Predicate<Block> filter) {
        return this.rayCastBlocksAll(world, start, end, filter, DEFAULT_FLUID_COLLISION, true);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, FluidCollision fluidCollision, boolean ignoreNonCollidable) {
        return this.rayCastBlocksAll(world, start, end, null, fluidCollision, ignoreNonCollidable);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, FluidCollision fluidCollision) {
        return this.rayCastBlocksAll(world, start, end, null, fluidCollision, true);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, boolean ignoreNonCollidable) {
        return this.rayCastBlocksAll(world, start, end, null, DEFAULT_FLUID_COLLISION, ignoreNonCollidable);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end) {
        return this.rayCastBlocksAll(world, start, end, null, DEFAULT_FLUID_COLLISION, true);
    }

    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastBlocksAll(world, start, end, info.getBlockFilter(), info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    public final boolean isEntityInVolume(Entity entity, ColliderVolume volume) {
        return volume.overlapsWithAABB(this.getEntityAABB(entity));
    }

    public abstract List<Entity> getEntitiesInVolume(World var1, Entity var2, ColliderVolume var3, Predicate<Entity> var4);

    public final List<Entity> getEntitiesInVolume(World world, Entity source, ColliderVolume volume) {
        return this.getEntitiesInVolume(world, source, volume, null);
    }

    public final List<Entity> getEntitiesInVolume(World world, ColliderVolume volume, Predicate<Entity> filter) {
        return this.getEntitiesInVolume(world, null, volume, filter);
    }

    public final List<Entity> getEntitiesInVolume(World world, ColliderVolume volume) {
        return this.getEntitiesInVolume(world, null, volume, null);
    }

    public abstract RayCastHit rayCastEntity(Entity var1, Vector var2, Vector var3);

    public abstract RayCastHit rayCastEntities(World var1, Entity var2, Vector var3, Vector var4, Predicate<Entity> var5);

    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end) {
        return this.rayCastEntities(world, source, start, end, (Predicate<Entity>)null);
    }

    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, Predicate<Entity> filter) {
        return this.rayCastEntities(world, null, start, end, filter);
    }

    public final RayCastHit rayCastEntities(World world, Vector start, Vector end) {
        return this.rayCastEntities(world, null, start, end);
    }

    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastEntities(world, source, start, end, info.getEntityFilter());
    }

    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastEntities(world, start, end, info.getEntityFilter());
    }

    public abstract Iterator<RayCastHit> rayCastEntitiesAll(World var1, Entity var2, Vector var3, Vector var4, Predicate<Entity> var5);

    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end) {
        return this.rayCastEntitiesAll(world, source, start, end, (Predicate<Entity>)null);
    }

    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, Predicate<Entity> filter) {
        return this.rayCastEntitiesAll(world, null, start, end, filter);
    }

    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end) {
        return this.rayCastEntitiesAll(world, null, start, end);
    }

    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastEntitiesAll(world, source, start, end, info.getEntityFilter());
    }

    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastEntitiesAll(world, start, end, info.getEntityFilter());
    }

    public abstract RayCastHit rayCast(World var1, Entity var2, Vector var3, Vector var4, Predicate<Block> var5, Predicate<Entity> var6, FluidCollision var7, boolean var8);

    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision) {
        return this.rayCast(world, source, start, end, blockFilter, entityFilter, blockFluidCollision, true);
    }

    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, boolean blockIgnoreNonCollidable) {
        return this.rayCast(world, source, start, end, blockFilter, entityFilter, DEFAULT_FLUID_COLLISION, blockIgnoreNonCollidable);
    }

    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter) {
        return this.rayCast(world, source, start, end, blockFilter, entityFilter, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end) {
        return this.rayCast(world, source, start, end, null, null, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCast(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision, boolean blockIgnoreNonCollidable) {
        return this.rayCast(world, null, start, end, blockFilter, entityFilter, blockFluidCollision, blockIgnoreNonCollidable);
    }

    public final RayCastHit rayCast(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter) {
        return this.rayCast(world, start, end, blockFilter, entityFilter, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCast(World world, Vector start, Vector end) {
        return this.rayCast(world, start, end, null, null, DEFAULT_FLUID_COLLISION, true);
    }

    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, RayCastInfo info) {
        return this.rayCast(world, source, start, end, info.getBlockFilter(), info.getEntityFilter(), info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    public final RayCastHit rayCast(World world, Vector start, Vector end, RayCastInfo info) {
        return this.rayCast(world, start, end, info.getBlockFilter(), info.getEntityFilter(), info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    public abstract Iterator<RayCastHit> rayCastAll(World var1, Entity var2, Vector var3, Vector var4, Predicate<Block> var5, Predicate<Entity> var6, FluidCollision var7, boolean var8);

    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, FluidCollision blockFluidCollision) {
        return this.rayCastAll(world, source, start, end, blockFilter, entityFilter, blockFluidCollision, true);
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, boolean blockIgnoreNonCollidable) {
        return this.rayCastAll(world, source, start, end, blockFilter, entityFilter, DEFAULT_FLUID_COLLISION, blockIgnoreNonCollidable);
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter) {
        return this.rayCastAll(world, source, start, end, blockFilter, entityFilter, DEFAULT_FLUID_COLLISION, true);
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end) {
        return this.rayCastAll(world, source, start, end, null, null, DEFAULT_FLUID_COLLISION, true);
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter) {
        return this.rayCastAll(world, null, start, end, blockFilter, entityFilter, DEFAULT_FLUID_COLLISION, true);
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end) {
        return this.rayCastAll(world, null, start, end, null, null, DEFAULT_FLUID_COLLISION, true);
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastAll(world, source, start, end, info.getBlockFilter(), info.getEntityFilter(), info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastAll(world, null, start, end, info.getBlockFilter(), info.getEntityFilter(), info.getBlockFluidCollision(), info.getBlockIgnoreNonCollidable());
    }

    @Deprecated
    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end, boolean hitFluidSource, boolean ignoreNonSolid, boolean highDetail) {
        return this.rayCastBlock(block, start, end, hitFluidSource ? FluidCollision.SOURCE_ONLY : FluidCollision.NEVER, ignoreNonSolid);
    }

    @Deprecated
    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastBlock(block, start, end);
        }
        return this.rayCastBlock(block, start, end, flags.contains((Object)RayCastFlag.BLOCK_HIT_FLUID_SOURCE), flags.contains((Object)RayCastFlag.BLOCK_IGNORE_NON_SOLID), flags.contains((Object)RayCastFlag.BLOCK_HIGH_DETAIL));
    }

    @Deprecated
    public final RayCastHit rayCastBlock(Block block, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastBlock(block, start, end);
        }
        return this.rayCastBlock(block, start, end, EnumSet.of(flag, flags));
    }

    @Deprecated
    public boolean isEntityCollidable(Entity entity) {
        return false;
    }

    @Deprecated
    public final List<Entity> getEntitiesInVolume(World world, Entity source, ColliderVolume volume, Predicate<Entity> filter, boolean includeSpectators) {
        return this.getEntitiesInVolume(world, source, volume, filter);
    }

    @Deprecated
    public final List<Entity> getEntitiesInVolume(World world, Entity source, ColliderVolume volume, boolean includeSpectators) {
        return this.getEntitiesInVolume(world, source, volume);
    }

    @Deprecated
    public final List<Entity> getEntitiesInVolume(World world, ColliderVolume volume, Predicate<Entity> filter, boolean includeSpectators) {
        return this.getEntitiesInVolume(world, null, volume, filter);
    }

    @Deprecated
    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, boolean hitFluidSource, boolean ignoreNonSolid, boolean highDetail) {
        return this.rayCastBlocks(world, start, end, filter, hitFluidSource ? FluidCollision.SOURCE_ONLY : FluidCollision.NEVER, ignoreNonSolid);
    }

    @Deprecated
    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastBlocks(world, start, end, filter);
        }
        return this.rayCastBlocks(world, start, end, filter, flags.contains((Object)RayCastFlag.BLOCK_HIT_FLUID_SOURCE), flags.contains((Object)RayCastFlag.BLOCK_IGNORE_NON_SOLID), flags.contains((Object)RayCastFlag.BLOCK_HIGH_DETAIL));
    }

    @Deprecated
    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Predicate<Block> filter, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastBlocks(world, start, end, filter);
        }
        return this.rayCastBlocks(world, start, end, filter, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, boolean hitFluidSource, boolean ignoreNonSolid, boolean highDetail) {
        return this.rayCastBlocks(world, start, end, null, hitFluidSource, ignoreNonSolid, highDetail);
    }

    @Deprecated
    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastBlocks(world, start, end, null, flags);
    }

    @Deprecated
    public final RayCastHit rayCastBlocks(World world, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastBlocks(world, start, end, (Predicate<Block>)null, flag, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Predicate<Block> filter, boolean hitFluidSource, boolean ignoreNonSolid, boolean highDetail) {
        return this.rayCastBlocksAll(world, start, end, filter, hitFluidSource ? FluidCollision.SOURCE_ONLY : FluidCollision.NEVER, ignoreNonSolid);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Predicate<Block> filter, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastBlocksAll(world, start, end, filter);
        }
        return this.rayCastBlocksAll(world, start, end, filter, flags.contains((Object)RayCastFlag.BLOCK_HIT_FLUID_SOURCE), flags.contains((Object)RayCastFlag.BLOCK_IGNORE_NON_SOLID), flags.contains((Object)RayCastFlag.BLOCK_HIGH_DETAIL));
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Predicate<Block> filter, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastBlocksAll(world, start, end, filter);
        }
        return this.rayCastBlocksAll(world, start, end, filter, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, boolean hitFluidSource, boolean ignoreNonSolid, boolean highDetail) {
        return this.rayCastBlocksAll(world, start, end, null, hitFluidSource, ignoreNonSolid, highDetail);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastBlocksAll(world, start, end, null, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastBlocksAll(World world, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastBlocksAll(world, start, end, (Predicate<Block>)null, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntities(world, source, start, end, filter);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastEntities(world, source, start, end, filter);
        }
        return this.rayCastEntities(world, source, start, end, filter, flags.contains((Object)RayCastFlag.ENTITY_HIT_NON_COLLIDABLE), flags.contains((Object)RayCastFlag.ENTITY_HIT_SPECTATORS));
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastEntities(world, source, start, end, filter);
        }
        return this.rayCastEntities(world, source, start, end, filter, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntities(world, source, start, end, null, hitNonCollidable, hitSpectators);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastEntities(world, source, start, end, null, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Entity source, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastEntities(world, source, start, end, (Predicate<Entity>)null, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, Predicate<Entity> filter, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntities(world, null, start, end, filter, hitNonCollidable, hitSpectators);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, Predicate<Entity> filter, Set<RayCastFlag> flags) {
        return this.rayCastEntities(world, null, start, end, filter, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, Predicate<Entity> filter, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastEntities(world, null, start, end, filter, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntities(world, start, end, null, hitNonCollidable, hitSpectators);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastEntities(world, null, start, end, null, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntities(World world, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastEntities(world, (Entity)null, start, end, (Predicate<Entity>)null, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCastEntity(Entity entity, Vector start, Vector end, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntity(entity, start, end);
    }

    @Deprecated
    public final RayCastHit rayCastEntity(Entity entity, Vector start, Vector end, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastEntity(entity, start, end);
        }
        return this.rayCastEntity(entity, start, end, flags.contains((Object)RayCastFlag.ENTITY_HIT_NON_COLLIDABLE), flags.contains((Object)RayCastFlag.ENTITY_HIT_SPECTATORS));
    }

    @Deprecated
    public final RayCastHit rayCastEntity(Entity entity, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastEntity(entity, start, end);
        }
        return this.rayCastEntity(entity, start, end, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final RayCastHit rayCastEntity(Entity entity, Vector start, Vector end, RayCastInfo info) {
        return this.rayCastEntity(entity, start, end, info.getFlags());
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntitiesAll(world, source, start, end, filter);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastEntitiesAll(world, source, start, end, filter);
        }
        return this.rayCastEntitiesAll(world, source, start, end, filter, flags.contains((Object)RayCastFlag.ENTITY_HIT_NON_COLLIDABLE), flags.contains((Object)RayCastFlag.ENTITY_HIT_SPECTATORS));
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, Predicate<Entity> filter, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastEntitiesAll(world, source, start, end, filter);
        }
        return this.rayCastEntitiesAll(world, source, start, end, filter, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntitiesAll(world, source, start, end, null, hitNonCollidable, hitSpectators);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastEntitiesAll(world, source, start, end, null, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Entity source, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastEntitiesAll(world, source, start, end, (Predicate<Entity>)null, flag, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, Predicate<Entity> filter, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntitiesAll(world, null, start, end, filter, hitNonCollidable, hitSpectators);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, Predicate<Entity> filter, Set<RayCastFlag> flags) {
        return this.rayCastEntitiesAll(world, null, start, end, filter, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, Predicate<Entity> filter, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastEntitiesAll(world, null, start, end, filter, flag, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, boolean hitNonCollidable, boolean hitSpectators) {
        return this.rayCastEntitiesAll(world, start, end, null, hitNonCollidable, hitSpectators);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastEntitiesAll(world, null, start, end, null, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastEntitiesAll(World world, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastEntitiesAll(world, (Entity)null, start, end, (Predicate<Entity>)null, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCast(world, source, start, end, blockFilter, entityFilter, blockHitFluidSource ? FluidCollision.SOURCE_ONLY : FluidCollision.NEVER, blockIgnoreNonSolid);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCast(world, source, start, end, blockFilter, entityFilter);
        }
        return this.rayCast(world, source, start, end, blockFilter, entityFilter, flags.contains((Object)RayCastFlag.BLOCK_HIT_FLUID_SOURCE), flags.contains((Object)RayCastFlag.BLOCK_IGNORE_NON_SOLID), flags.contains((Object)RayCastFlag.BLOCK_HIGH_DETAIL), flags.contains((Object)RayCastFlag.ENTITY_HIT_NON_COLLIDABLE), flags.contains((Object)RayCastFlag.ENTITY_HIT_SPECTATORS));
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCast(world, source, start, end, blockFilter, entityFilter);
        }
        return this.rayCast(world, source, start, end, blockFilter, entityFilter, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCast(world, source, start, end, (Predicate<Block>)null, null, blockHitFluidSource, blockIgnoreNonSolid, blockHighDetail, entityHitNonCollidable, entityHitSpectators);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCast(world, source, start, end, (Predicate<Block>)null, null, flags);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Entity source, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCast(world, source, start, end, (Predicate<Block>)null, null, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCast(world, null, start, end, blockFilter, entityFilter, blockHitFluidSource, blockIgnoreNonSolid, blockHighDetail, entityHitNonCollidable, entityHitSpectators);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, Set<RayCastFlag> flags) {
        return this.rayCast(world, null, start, end, blockFilter, entityFilter, flags);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCast(world, null, start, end, blockFilter, entityFilter, flag, flags);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Vector start, Vector end, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCast(world, start, end, (Predicate<Block>)null, null, blockHitFluidSource, blockIgnoreNonSolid, blockHighDetail, entityHitNonCollidable, entityHitSpectators);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCast(world, null, start, end, flags);
    }

    @Deprecated
    public final RayCastHit rayCast(World world, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCast(world, null, start, end, flag, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCastAll(world, source, start, end, blockFilter, entityFilter, blockHitFluidSource ? FluidCollision.SOURCE_ONLY : FluidCollision.NEVER, blockIgnoreNonSolid);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, Set<RayCastFlag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this.rayCastAll(world, source, start, end, blockFilter, entityFilter);
        }
        return this.rayCastAll(world, source, start, end, blockFilter, entityFilter, flags.contains((Object)RayCastFlag.BLOCK_HIT_FLUID_SOURCE), flags.contains((Object)RayCastFlag.BLOCK_IGNORE_NON_SOLID), flags.contains((Object)RayCastFlag.BLOCK_HIGH_DETAIL), flags.contains((Object)RayCastFlag.ENTITY_HIT_NON_COLLIDABLE), flags.contains((Object)RayCastFlag.ENTITY_HIT_SPECTATORS));
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, RayCastFlag flag, RayCastFlag ... flags) {
        if (flag == null) {
            return this.rayCastAll(world, source, start, end, blockFilter, entityFilter);
        }
        return this.rayCastAll(world, source, start, end, blockFilter, entityFilter, EnumSet.of(flag, flags));
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCastAll(world, source, start, end, (Predicate<Block>)null, null, blockHitFluidSource, blockIgnoreNonSolid, blockHighDetail, entityHitNonCollidable, entityHitSpectators);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastAll(world, source, start, end, (Predicate<Block>)null, null, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Entity source, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastAll(world, source, start, end, (Predicate<Block>)null, null, flag, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCastAll(world, null, start, end, blockFilter, entityFilter, blockHitFluidSource, blockIgnoreNonSolid, blockHighDetail, entityHitNonCollidable, entityHitSpectators);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, Set<RayCastFlag> flags) {
        return this.rayCastAll(world, null, start, end, blockFilter, entityFilter, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, Predicate<Block> blockFilter, Predicate<Entity> entityFilter, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastAll(world, null, start, end, blockFilter, entityFilter, flag, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, boolean blockHitFluidSource, boolean blockIgnoreNonSolid, boolean blockHighDetail, boolean entityHitNonCollidable, boolean entityHitSpectators) {
        return this.rayCastAll(world, start, end, (Predicate<Block>)null, null, blockHitFluidSource, blockIgnoreNonSolid, blockHighDetail, entityHitNonCollidable, entityHitSpectators);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, Set<RayCastFlag> flags) {
        return this.rayCastAll(world, null, start, end, flags);
    }

    @Deprecated
    public final Iterator<RayCastHit> rayCastAll(World world, Vector start, Vector end, RayCastFlag flag, RayCastFlag ... flags) {
        return this.rayCastAll(world, null, start, end, flag, flags);
    }
}

