/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms;

import com.herocraftonline.heroes.nms.attribute.ICharacterAttribute;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public abstract class NMSHandler {
    private static NMSHandler activeInterface;
    private int patchVersion = 0;
    private int minorVersion = 0;
    protected static final Material[][] armorCategories;
    protected static final Material[][] weaponCategories;
    protected static final Set<Material> weaponSet;
    protected static final Set<Material> armorSet;
    protected static final Set<Material> foodSet;
    protected static final Set<Material> rawFoodSet;
    protected static final Map<Material, Integer> foodValueMap;

    protected static <T> T notImplemented() {
        throw new UnsupportedOperationException("Not implemented for " + Bukkit.getServer().getVersion());
    }

    public static NMSHandler getInterface() {
        if (activeInterface == null) {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String version = packageName.substring(packageName.lastIndexOf(46) + 1);
            if (version.equals("craftbukkit")) {
                version = "pre";
            }
            try {
                String interfaceVersion;
                Class<?> clazz;
                Pattern MINOR_MATCH_PATTERN = Pattern.compile("v1_([0-9]+)");
                Pattern PATCH_MATCH_PATTERN = Pattern.compile("_([0-9]+)_R");
                Matcher matcher = MINOR_MATCH_PATTERN.matcher(version);
                int minor = 0;
                int patch = 0;
                if (matcher.find()) {
                    minor = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = PATCH_MATCH_PATTERN.matcher(version)).find()) {
                    patch = Integer.parseInt(matcher.group(1));
                }
                if (NMSHandler.class.isAssignableFrom(clazz = Class.forName("com.herocraftonline.heroes.nms.versions.Handler_" + (interfaceVersion = minor >= 17 ? "vLATEST" : version)))) {
                    activeInterface = (NMSHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    activeInterface.setMinorVersion(minor);
                    activeInterface.setPatchVersion(patch);
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("You are attempting to load Heroes on version " + version + " which is not supported!");
            }
            catch (Exception e) {
                throw new RuntimeException("Unknown exception loading version handler", e);
            }
        }
        return activeInterface;
    }

    public final int getPatchVersion() {
        return this.patchVersion;
    }

    public final void setPatchVersion(int version) {
        this.patchVersion = version;
    }

    public final void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public abstract float getAbsorptionHearts(Player var1);

    public abstract void setAbsorptionHearts(Player var1, float var2);

    public abstract void injectAbsorptionHeartWatcher(Player var1);

    public abstract void sendAbsorptionHearts(Player var1, float var2);

    public abstract double getPostArmorDamage(LivingEntity var1, double var2);

    public abstract void setPlayerExpZero(Player var1);

    public void sendPlayerUpdateHealthPacket(Player player, int foodLevel) {
    }

    public void sendPlayerUpdateHealthPacket(Player player) {
        this.sendPlayerUpdateHealthPacket(player, player.getFoodLevel());
    }

    public void sendPlayerFakeNoSprintHunger(Player player) {
        this.sendPlayerUpdateHealthPacket(player, 2);
    }

    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause) {
        return this.damageEntity(target, attacker, damage, cause, 0.5f);
    }

    public abstract boolean damageEntity(LivingEntity var1, LivingEntity var2, double var3, EntityDamageEvent.DamageCause var5, float var6);

    public abstract void playInstantFirework(Firework var1, FireworkEffect var2, Location var3);

    @Deprecated
    public void playInstantFirework(FireworkEffect fe, Location loc) {
        Firework spigotFirework = (Firework)loc.getWorld().spawn(loc, Firework.class);
        this.playInstantFirework(spigotFirework, fe, loc);
    }

    public abstract void knockBack(LivingEntity var1, LivingEntity var2, float var3);

    @Deprecated
    public final void sendFakePotionEffectPacket(PotionEffect effect, Player player) {
    }

    @Deprecated
    public final void sendFakePotionEffectPackets(Set<PotionEffect> effects, Player player) {
    }

    @Deprecated
    public final void sendFakePotionEffectPackets(Collection<PotionEffect> effects, Player player) {
    }

    @Deprecated
    public final void removeFakePotionEffectPacket(PotionEffect effect, Player player) {
    }

    @Deprecated
    public final void removeFakePotionEffectPackets(Set<PotionEffect> effects, Player player) {
    }

    @Deprecated
    public final void removeFakePotionEffectPackets(Collection<PotionEffect> effects, Player player) {
    }

    public abstract void bukkit_setArrowDamage(Arrow var1, double var2);

    protected abstract float getSoundStrength(LivingEntity var1);

    @Deprecated
    public abstract void playClientEffect(Player var1, Location var2, String var3, Vector var4, float var5, int var6, boolean var7);

    public abstract void hidePlayerFromEntity(Player var1, Entity var2);

    public abstract ICharacterAttribute createCharacterAttribute(String var1, byte var2);

    public abstract NMSPhysics getNMSPhysics();

    public Material getUsedMaterial(Player player) {
        if (player.getItemInHand() != null) {
            return player.getItemInHand().getType();
        }
        return Material.AIR;
    }

    public boolean isDuplicateEvent(PlayerInteractEvent event) {
        return false;
    }

    public double getCooldownDamageMultiplier(Player player) {
        return 1.0;
    }

    public double getDefaultDamage(Material item) {
        return 1.0;
    }

    public Material[][] getWeaponCategories() {
        return weaponCategories;
    }

    public Material[][] getArmorCategories() {
        return armorCategories;
    }

    public boolean isWeapon(Material type) {
        return weaponSet.contains(type);
    }

    public boolean isArmor(Material type) {
        return armorSet.contains(type);
    }

    public boolean isFood(Material type) {
        return foodSet.contains(type);
    }

    public boolean isRawFood(Material type) {
        return rawFoodSet.contains(type);
    }

    public int getFoodValue(Material type) {
        return foodValueMap.containsKey(type) ? foodValueMap.get(type) : 0;
    }

    public ItemStack getItemInMainHand(PlayerInventory inventory) {
        return inventory.getItemInMainHand();
    }

    public void setItemInMainHand(PlayerInventory inventory, ItemStack stack) {
        inventory.setItemInMainHand(stack);
    }

    public ItemStack getItemInOffHand(@Nonnull PlayerInventory inventory) {
        return inventory.getItemInOffHand();
    }

    public void setItemInOffHand(@Nonnull PlayerInventory inventory, ItemStack stack) {
        inventory.setItemInOffHand(stack);
    }

    static {
        armorCategories = new Material[][]{{Material.DIAMOND_HELMET, Material.IRON_HELMET, Material.GOLDEN_HELMET, Material.CHAINMAIL_HELMET, Material.LEATHER_HELMET}, {Material.DIAMOND_CHESTPLATE, Material.IRON_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE}, {Material.DIAMOND_LEGGINGS, Material.IRON_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS}, {Material.DIAMOND_BOOTS, Material.IRON_BOOTS, Material.GOLDEN_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS}};
        weaponCategories = new Material[][]{{Material.DIAMOND_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.STONE_SWORD, Material.WOODEN_SWORD}, {Material.DIAMOND_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.STONE_AXE, Material.WOODEN_AXE}, {Material.DIAMOND_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.STONE_PICKAXE, Material.WOODEN_PICKAXE}, {Material.DIAMOND_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.STONE_SHOVEL, Material.WOODEN_SHOVEL}, {Material.DIAMOND_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.STONE_HOE, Material.WOODEN_HOE}, {Material.SHIELD}, {Material.TRIDENT}};
        HashSet<Material> set = new HashSet<Material>();
        set.add(Material.IRON_AXE);
        set.add(Material.IRON_HOE);
        set.add(Material.IRON_PICKAXE);
        set.add(Material.IRON_SHOVEL);
        set.add(Material.IRON_SWORD);
        set.add(Material.STONE_AXE);
        set.add(Material.STONE_HOE);
        set.add(Material.STONE_PICKAXE);
        set.add(Material.STONE_SHOVEL);
        set.add(Material.STONE_SWORD);
        set.add(Material.GOLDEN_AXE);
        set.add(Material.GOLDEN_HOE);
        set.add(Material.GOLDEN_PICKAXE);
        set.add(Material.GOLDEN_SHOVEL);
        set.add(Material.GOLDEN_SWORD);
        set.add(Material.WOODEN_AXE);
        set.add(Material.WOODEN_HOE);
        set.add(Material.WOODEN_PICKAXE);
        set.add(Material.WOODEN_SHOVEL);
        set.add(Material.WOODEN_SWORD);
        set.add(Material.DIAMOND_AXE);
        set.add(Material.DIAMOND_HOE);
        set.add(Material.DIAMOND_PICKAXE);
        set.add(Material.DIAMOND_SHOVEL);
        set.add(Material.DIAMOND_SWORD);
        set.add(Material.BOW);
        set.add(Material.FISHING_ROD);
        set.add(Material.CARROT_ON_A_STICK);
        set.add(Material.SHEARS);
        set.add(Material.BLAZE_ROD);
        set.add(Material.SHIELD);
        set.add(Material.TRIDENT);
        weaponSet = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(Material.TURTLE_HELMET);
        set.add(Material.LEATHER_HELMET);
        set.add(Material.LEATHER_LEGGINGS);
        set.add(Material.LEATHER_BOOTS);
        set.add(Material.LEATHER_CHESTPLATE);
        set.add(Material.IRON_HELMET);
        set.add(Material.IRON_LEGGINGS);
        set.add(Material.IRON_CHESTPLATE);
        set.add(Material.IRON_BOOTS);
        set.add(Material.CHAINMAIL_HELMET);
        set.add(Material.CHAINMAIL_LEGGINGS);
        set.add(Material.CHAINMAIL_BOOTS);
        set.add(Material.CHAINMAIL_CHESTPLATE);
        set.add(Material.GOLDEN_HELMET);
        set.add(Material.GOLDEN_LEGGINGS);
        set.add(Material.GOLDEN_CHESTPLATE);
        set.add(Material.GOLDEN_BOOTS);
        set.add(Material.DIAMOND_HELMET);
        set.add(Material.DIAMOND_LEGGINGS);
        set.add(Material.DIAMOND_CHESTPLATE);
        set.add(Material.DIAMOND_BOOTS);
        set.add(Material.ELYTRA);
        set.add(Material.SHIELD);
        armorSet = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(Material.APPLE);
        set.add(Material.BAKED_POTATO);
        set.add(Material.BEEF);
        set.add(Material.BEETROOT);
        set.add(Material.BEETROOT_SOUP);
        set.add(Material.BREAD);
        set.add(Material.CAKE);
        set.add(Material.CARROT);
        set.add(Material.CHICKEN);
        set.add(Material.CHORUS_FRUIT);
        set.add(Material.COD);
        set.add(Material.COOKED_BEEF);
        set.add(Material.COOKED_CHICKEN);
        set.add(Material.COOKED_COD);
        set.add(Material.COOKED_MUTTON);
        set.add(Material.COOKED_PORKCHOP);
        set.add(Material.COOKED_RABBIT);
        set.add(Material.COOKED_SALMON);
        set.add(Material.COOKIE);
        set.add(Material.DRIED_KELP);
        set.add(Material.GOLDEN_APPLE);
        set.add(Material.GOLDEN_CARROT);
        set.add(Material.MELON_SLICE);
        set.add(Material.MUSHROOM_STEW);
        set.add(Material.MUTTON);
        set.add(Material.POISONOUS_POTATO);
        set.add(Material.PORKCHOP);
        set.add(Material.POTATO);
        set.add(Material.PUFFERFISH);
        set.add(Material.PUMPKIN_PIE);
        set.add(Material.RABBIT);
        set.add(Material.RABBIT_STEW);
        set.add(Material.ROTTEN_FLESH);
        set.add(Material.SALMON);
        foodSet = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(Material.ROTTEN_FLESH);
        set.add(Material.BEEF);
        set.add(Material.CHICKEN);
        set.add(Material.COD);
        set.add(Material.SALMON);
        set.add(Material.PORKCHOP);
        set.add(Material.RABBIT);
        set.add(Material.MUTTON);
        set.add(Material.PUFFERFISH);
        set.add(Material.TROPICAL_FISH);
        rawFoodSet = Collections.unmodifiableSet(set);
        HashMap<Material, Integer> map = new HashMap<Material, Integer>();
        map.put(Material.APPLE, 4);
        map.put(Material.BAKED_POTATO, 5);
        map.put(Material.BEEF, 3);
        map.put(Material.BEETROOT, 1);
        map.put(Material.BEETROOT_SOUP, 6);
        map.put(Material.BREAD, 5);
        map.put(Material.CAKE, 2);
        map.put(Material.CARROT, 3);
        map.put(Material.CHICKEN, 2);
        map.put(Material.CHORUS_FRUIT, 4);
        map.put(Material.COD, 2);
        map.put(Material.COOKED_BEEF, 6);
        map.put(Material.COOKED_CHICKEN, 6);
        map.put(Material.COOKED_COD, 5);
        map.put(Material.COOKED_MUTTON, 6);
        map.put(Material.COOKED_PORKCHOP, 8);
        map.put(Material.COOKED_RABBIT, 5);
        map.put(Material.COOKED_SALMON, 6);
        map.put(Material.COOKIE, 2);
        map.put(Material.DRIED_KELP, 1);
        map.put(Material.ENCHANTED_GOLDEN_APPLE, 4);
        map.put(Material.GOLDEN_APPLE, 4);
        map.put(Material.GOLDEN_CARROT, 6);
        map.put(Material.MELON_SLICE, 2);
        map.put(Material.MUSHROOM_STEW, 6);
        map.put(Material.MUTTON, 2);
        map.put(Material.PORKCHOP, 3);
        map.put(Material.POTATO, 1);
        map.put(Material.SALMON, 2);
        map.put(Material.PUMPKIN_PIE, 8);
        map.put(Material.RABBIT, 3);
        map.put(Material.RABBIT_STEW, 10);
        map.put(Material.ROTTEN_FLESH, -1);
        map.put(Material.POISONOUS_POTATO, -1);
        map.put(Material.PUFFERFISH, -1);
        foodValueMap = Collections.unmodifiableMap(map);
    }
}

