/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class InternalSkillListener
implements Listener {
    private final Heroes heroes;

    public InternalSkillListener(Heroes heroes) {
        this.heroes = heroes;
    }

    @EventHandler
    public void classChange(ClassChangeEvent event) {
        Hero hero = event.getHero();
        Player player = hero.getPlayer();
        HeroClass from = event.getFrom();
        HeroClass to = event.getTo();
        if (from != null) {
            boolean isChangingToDefaultClass;
            HeroClass.ClassRunCommandsInfo onClassLossRunCommandsInfo = from.getOnClassLossRunCommandsInfo();
            boolean bl = isChangingToDefaultClass = from.isPrimary() && to.isDefault() || from.isSecondary() && to.isDefaultProf() || from.isRace() && to.isDefaultRace();
            if (!isChangingToDefaultClass || !onClassLossRunCommandsInfo.isIgnoreDefault()) {
                this.handleRunCommands(player, onClassLossRunCommandsInfo);
            }
        }
        boolean isPrimary = to.isPrimary();
        boolean isSecondary = to.isSecondary();
        boolean isRace = to.isRace();
        boolean firstGainedClass = true;
        for (HeroClass heroClass : this.heroes.getClassManager().getClasses()) {
            if (!(isPrimary && heroClass.isPrimary() && !heroClass.isDefault() || isSecondary && heroClass.isSecondary() && !heroClass.isDefaultProf()) && (!isRace || !heroClass.isRace() || heroClass.isDefaultRace()) || !(hero.getExperience(heroClass) > 0.0)) continue;
            firstGainedClass = false;
            break;
        }
        if (firstGainedClass) {
            HeroClass.ClassRunCommandsInfo onFirstClassGainRunCommandsInfo = to.getOnFirstClassGainRunCommandsInfo();
            if (!onFirstClassGainRunCommandsInfo.isOverride()) {
                this.handleRunCommands(player, to.getOnClassGainRunCommandsInfo());
            }
            this.handleRunCommands(player, onFirstClassGainRunCommandsInfo);
        } else {
            this.handleRunCommands(player, to.getOnClassGainRunCommandsInfo());
        }
    }

    private void handleRunCommands(Player player, HeroClass.ClassRunCommandsInfo classRunCommandsInfo) {
        Player commandSource = classRunCommandsInfo.isRunCommandsAsConsole() ? this.heroes.getServer().getConsoleSender() : player;
        List<String> commands = classRunCommandsInfo.getRunCommands();
        Bukkit.getScheduler().runTaskLater((Plugin)this.heroes, () -> this.lambda$handleRunCommands$0(commands, (CommandSender)commandSource, player), 5L);
    }

    private /* synthetic */ void lambda$handleRunCommands$0(List commands, CommandSender commandSource, Player player) {
        for (String command : commands) {
            this.heroes.getServer().dispatchCommand(commandSource, command.replace("{PLAYER_NAME}", player.getName()).replace("{player_name}", player.getName()));
        }
    }
}

