/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroRegainManaEvent;
import com.herocraftonline.heroes.api.events.HeroRegainStaminaEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.items.attributes.StaminaCostAttribute;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.equipment.EquipmentManager;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.ItemManager;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;

public class HStaminaListener
implements Listener {
    private Heroes heroes;
    private Set<UUID> playerSwingWeaponProcessedSet = new HashSet<UUID>();

    public HStaminaListener(Heroes heroes) {
        this.heroes = heroes;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!(event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK || this.playerSwingWeaponProcessedSet.contains(event.getPlayer().getUniqueId()))) {
            Player player = event.getPlayer();
            Hero hero = Heroes.getInstance().getCharacterManager().getHero(player);
            if (hero.isInCombat()) {
                int staminaCost = Heroes.properties.staminaSwingWeaponCost;
                ItemPlugin items = Heroes.getInstance().getItemPlugin();
                if (items != null && items.isEnabled()) {
                    Optional<StaminaCostAttribute> staminaCostAttributeOptional;
                    ItemManager itemManager = items.getItemManager();
                    EquipmentManager equipManager = items.getEquipmentManager();
                    Optional<Item> itemOptional = itemManager.getItem(player.getInventory().getItemInMainHand());
                    if (itemOptional.isPresent() && equipManager.isEquipped(player, itemOptional.get()) && (staminaCostAttributeOptional = itemOptional.get().getAttribute(StaminaCostAttribute.class)).isPresent()) {
                        staminaCost = staminaCostAttributeOptional.get().getStaminaCost();
                    }
                }
                if (staminaCost > 0) {
                    int changedStamina = Math.round(hero.getStamina() - staminaCost);
                    if (changedStamina < 0) {
                        event.setCancelled(true);
                        hero.getPlayer().sendMessage("You are to fatigued to swing your weapon!");
                        return;
                    }
                    hero.setStamina(changedStamina);
                }
                if (Heroes.properties.staminaStopRegenOnSwingWeapon) {
                    hero.addEffect(new ExpirableEffect(null, Heroes.getInstance(), "StaminaRegenCancel", player, Heroes.properties.staminaStopRegenOnSwingWeaponDuration));
                }
            }
        }
        this.playerSwingWeaponProcessedSet.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Hero hero = Heroes.getInstance().getCharacterManager().getHero(player);
            int staminaCost = Heroes.properties.staminaShootBowCost;
            ItemPlugin items = Heroes.getInstance().getItemPlugin();
            if (items != null && items.isEnabled()) {
                Optional<StaminaCostAttribute> staminaCostAttributeOptional;
                ItemManager itemManager = items.getItemManager();
                EquipmentManager equipManager = items.getEquipmentManager();
                Optional<Item> itemOptional = itemManager.getItem(event.getBow());
                if (itemOptional.isPresent() && equipManager.isEquipped(player, itemOptional.get()) && (staminaCostAttributeOptional = itemOptional.get().getAttribute(StaminaCostAttribute.class)).isPresent()) {
                    staminaCost = staminaCostAttributeOptional.get().getStaminaCost();
                }
            }
            if ((staminaCost = (int)((float)staminaCost * event.getForce())) > 0) {
                int changedStamina = hero.getStamina() - staminaCost;
                if (changedStamina < 0) {
                    event.setCancelled(true);
                    player.sendMessage("\u00a77You are to fatigued to fire a bow");
                    return;
                }
                hero.setStamina(changedStamina);
            }
            if (Heroes.properties.staminaStopRegenOnShootBow) {
                hero.addEffect(new ExpirableEffect(null, this.heroes, "StaminaRegenCancel", player, Heroes.properties.staminaStopRegenOnSwingWeaponDuration));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        Hero hero = Heroes.getInstance().getCharacterManager().getHero(player);
        if (event.isSprinting()) {
            int staminaCost = Heroes.properties.staminaSprintingCost;
            int changedStamina = hero.getStamina() - staminaCost;
            if (changedStamina < 0) {
                event.setCancelled(true);
                hero.getPlayer().sendMessage("\u00a77You are too fatigued to start sprinting!");
                return;
            }
            hero.setStamina(changedStamina);
            if (Heroes.properties.staminaStopRegenWhileSprinting) {
                hero.addEffect(new ExpirableEffect(null, Heroes.getInstance(), "StaminaRegenCancelSprinting", player, 3600000L));
            }
        } else {
            Effect e = hero.getEffect("StaminaRegenCancelSprinting");
            if (e != null) {
                hero.removeEffect(e);
                hero.addEffect(new ExpirableEffect(null, Heroes.getInstance(), "StaminaRegenCancel", player, Heroes.properties.staminaStopRegenWhileSprintingDuration));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (!(event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK || Skill.isSkillDamage())) {
            int staminaCost;
            if (event.getDamager() instanceof Player) {
                int changedStamina;
                Player dmgingPlayer = (Player)event.getDamager();
                Hero dmgingHero = Heroes.getInstance().getCharacterManager().getHero(dmgingPlayer);
                staminaCost = Heroes.properties.staminaSwingWeaponCost;
                ItemPlugin items = Heroes.getInstance().getItemPlugin();
                if (items != null && items.isEnabled()) {
                    Optional<StaminaCostAttribute> staminaCostAttributeOptional;
                    ItemManager itemManager = items.getItemManager();
                    EquipmentManager equipManager = items.getEquipmentManager();
                    Optional<Item> itemOptional = itemManager.getItem(dmgingPlayer.getInventory().getItemInMainHand());
                    if (itemOptional.isPresent() && equipManager.isEquipped(dmgingPlayer, itemOptional.get()) && (staminaCostAttributeOptional = itemOptional.get().getAttribute(StaminaCostAttribute.class)).isPresent()) {
                        staminaCost = staminaCostAttributeOptional.get().getStaminaCost();
                    }
                }
                if ((changedStamina = Math.round(dmgingHero.getStamina() - staminaCost)) < 0) {
                    event.setCancelled(true);
                    dmgingHero.getPlayer().sendMessage("You are to fatigued to swing your weapon!");
                    return;
                }
                dmgingHero.setStamina(changedStamina);
                if (Heroes.properties.staminaStopRegenOnSwingWeapon) {
                    dmgingHero.addEffect(new ExpirableEffect(null, Heroes.getInstance(), "StaminaRegenCancel", dmgingPlayer, Heroes.properties.staminaStopRegenOnSwingWeaponDuration));
                }
                this.playerSwingWeaponProcessedSet.add(dmgingPlayer.getUniqueId());
            }
            if (event.getEntity() instanceof Player) {
                Player dmgedPlayer = (Player)event.getEntity();
                Hero dmgedHero = Heroes.getInstance().getCharacterManager().getHero(dmgedPlayer);
                staminaCost = (int)Math.ceil(Heroes.properties.staminaPerDamageTakenCost * event.getDamage());
                if (staminaCost != 0) {
                    dmgedHero.setStamina(dmgedHero.getStamina() - staminaCost);
                }
                if (Heroes.properties.staminaStopRegenOnDamageTaken) {
                    dmgedHero.addEffect(new ExpirableEffect(null, Heroes.getInstance(), "StaminaRegenCancel", dmgedPlayer, Heroes.properties.staminaStopRegenOnDamageTakenDuration));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onManaRegen(HeroRegainManaEvent event) {
        Hero hero = event.getHero();
        int staminaCost = Heroes.properties.staminaManaRegenTickCost;
        int changedStamina = hero.getStamina() - staminaCost;
        if (changedStamina < 0) {
            event.setCancelled(true);
            return;
        }
        hero.setStamina(changedStamina);
        staminaCost = (int)Math.ceil(Heroes.properties.staminaPerManaPointRegenCost * (double)((Integer)event.getDelta()).intValue());
        changedStamina = hero.getStamina() - staminaCost;
        if (changedStamina < 0) {
            double costScale = (double)hero.getStamina() / (double)staminaCost;
            event.setDelta((int)Math.ceil((double)((Integer)event.getDelta()).intValue() * costScale));
            hero.setStamina(0);
        } else {
            hero.setStamina(changedStamina);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onStaminaRegain(HeroRegainStaminaEvent event) {
        Hero hero = event.getHero();
        if (hero.hasEffect("StaminaRegenCancel")) {
            event.setCancelled(true);
            return;
        }
        if (hero.hasEffect("StaminaRegenCancelSprinting")) {
            event.setCancelled(true);
            return;
        }
    }
}

