/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.api.events.HeroRegainHealthEvent;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.effects.PeriodicHealEffect;
import com.herocraftonline.heroes.characters.effects.common.FireworkImmunityEffect;
import com.herocraftonline.heroes.characters.effects.common.InvisibleEffect;
import com.herocraftonline.heroes.characters.effects.common.VanillaHungerEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.characters.skill.VisualEffect;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.nms.physics.NMSPhysics;
import com.herocraftonline.heroes.util.EquipmentUtil;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class HPlayerListener
implements Listener {
    private static final String sprintJumpMetaDataFlag = "ModifiedSprintJump";
    public final Heroes plugin;
    public final NMSPhysics physics;
    private final CharacterManager characterManager;

    public HPlayerListener(Heroes plugin) {
        this.plugin = plugin;
        this.physics = NMSHandler.getInterface().getNMSPhysics();
        this.characterManager = plugin.getCharacterManager();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        if (!(event.getOwner() instanceof Player)) {
            return;
        }
        Hero hero = this.characterManager.getHero((Player)event.getOwner());
        if (hero.hasParty()) {
            hero.getParty().gainExp(Heroes.properties.tameExp, HeroClass.ExperienceType.TAMING, event.getEntity().getLocation());
        } else if (hero.canGain(HeroClass.ExperienceType.TAMING)) {
            hero.gainExp(Heroes.properties.tameExp, HeroClass.ExperienceType.TAMING, event.getEntity().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBreed(EntityBreedEvent event) {
        if (!(event.getBreeder() instanceof Player)) {
            return;
        }
        Hero hero = this.characterManager.getHero((Player)event.getBreeder());
        if (hero.hasParty()) {
            hero.getParty().gainExp(Heroes.properties.breedingExp, HeroClass.ExperienceType.BREEDING, event.getEntity().getLocation());
        } else if (hero.canGain(HeroClass.ExperienceType.BREEDING)) {
            hero.gainExp(Heroes.properties.breedingExp, HeroClass.ExperienceType.BREEDING, event.getEntity().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        int amount = event.getAmount();
        if (amount == 0) {
            return;
        }
        Hero hero = this.characterManager.getHero(event.getPlayer());
        if (amount < 0) {
            hero.gainExp(event.getAmount(), HeroClass.ExperienceType.EXTERNAL, hero.getViewingLocation(1.0));
        }
        event.setAmount(0);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCastFishingRod(PlayerFishEvent event) {
        boolean usingOffhand;
        if (event.getState() != PlayerFishEvent.State.FISHING) {
            return;
        }
        Player player = event.getPlayer();
        Hero hero = this.characterManager.getHero(player);
        ItemStack itemInMainHand = NMSHandler.getInterface().getItemInMainHand(player.getInventory());
        ItemStack itemInOffHand = NMSHandler.getInterface().getItemInOffHand(player.getInventory());
        boolean usingMainHand = itemInMainHand != null && itemInMainHand.getType() == Material.FISHING_ROD;
        boolean bl = usingOffhand = itemInOffHand != null && itemInOffHand.getType() == Material.FISHING_ROD;
        if (!usingMainHand && !usingOffhand) {
            return;
        }
        if (usingMainHand && hero.canUseAsWeapon(Material.FISHING_ROD) || usingOffhand && hero.canUseAsOffhand(Material.FISHING_ROD)) {
            return;
        }
        if (Heroes.properties.showNotTrainedUseMessage) {
            player.sendMessage(EquipmentUtil.getAreNotTrainedItemUseMessage(hero, Material.FISHING_ROD, usingOffhand, false));
        }
        event.setCancelled(true);
        Util.syncInventory(player, this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        switch (event.getState()) {
            case CAUGHT_FISH: {
                if (event.getCaught() == null || !(event.getCaught() instanceof Item)) {
                    return;
                }
                ItemStack itemStack = ((Item)event.getCaught()).getItemStack();
                if (itemStack.getType() == Material.AIR) {
                    return;
                }
                Player player = event.getPlayer();
                Hero hero = this.characterManager.getHero(player);
                if (hero.hasParty()) {
                    hero.getParty().gainExp(Heroes.properties.fishingExp, HeroClass.ExperienceType.FISHING, event.getPlayer().getLocation());
                    break;
                }
                if (!hero.canGain(HeroClass.ExperienceType.FISHING)) break;
                hero.gainExp(Heroes.properties.fishingExp, HeroClass.ExperienceType.FISHING, hero.getViewingLocation(1.0));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        Properties properties = Heroes.properties;
        if (!properties.bedHeal) {
            return;
        }
        Hero hero = this.characterManager.getHero(event.getPlayer());
        long period = properties.healInterval * 1000;
        double tickHealPercent = (double)properties.healPercent / 100.0;
        BedHealEffect bhEffect = new BedHealEffect(this.plugin, period, tickHealPercent);
        hero.addEffect(bhEffect);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        if (!Heroes.properties.bedHeal) {
            return;
        }
        Hero hero = this.characterManager.getHero(event.getPlayer());
        if (hero.hasEffect("BedHeal")) {
            hero.removeEffect(hero.getEffect("BedHeal"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        boolean usingOffhand;
        Player player = event.getPlayer();
        Hero hero = this.characterManager.getHero(player);
        ItemStack itemInMainHand = NMSHandler.getInterface().getItemInMainHand(player.getInventory());
        ItemStack itemInOffHand = NMSHandler.getInterface().getItemInOffHand(player.getInventory());
        boolean usingMainHand = itemInMainHand != null && itemInMainHand.getType() == Material.SHEARS;
        boolean bl = usingOffhand = itemInOffHand != null && itemInOffHand.getType() == Material.SHEARS;
        if (!usingMainHand && !usingOffhand) {
            return;
        }
        if (usingMainHand && hero.canUseAsWeapon(Material.SHEARS) || usingOffhand && hero.canUseAsOffhand(Material.SHEARS)) {
            return;
        }
        if (Heroes.properties.showNotTrainedUseMessage) {
            player.sendMessage(EquipmentUtil.getAreNotTrainedItemUseMessage(hero, Material.SHEARS, usingOffhand, false));
        }
        event.setCancelled(true);
        Util.syncInventory(player, this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerShearForExp(PlayerShearEntityEvent event) {
        Hero hero = this.characterManager.getHero(event.getPlayer());
        if (hero.hasParty()) {
            hero.getParty().gainExp(Heroes.properties.shearExp, HeroClass.ExperienceType.SHEARING, event.getEntity().getLocation());
        } else if (hero.canGain(HeroClass.ExperienceType.SHEARING)) {
            hero.gainExp(Heroes.properties.shearExp, HeroClass.ExperienceType.SHEARING, event.getEntity().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFurnaceExtract(FurnaceExtractEvent event) {
        Material material = event.getItemType();
        if (!Heroes.properties.smeltingExp.containsKey(material)) {
            return;
        }
        int amountRetrieved = event.getItemAmount();
        double exp = (double)amountRetrieved * Heroes.properties.smeltingExp.get(material);
        Hero hero = this.characterManager.getHero(event.getPlayer());
        if (hero.hasParty()) {
            hero.getParty().gainExp(exp, HeroClass.ExperienceType.SMELTING, event.getBlock().getLocation());
        } else if (hero.canGain(HeroClass.ExperienceType.SMELTING)) {
            hero.gainExp(exp, HeroClass.ExperienceType.SMELTING, event.getBlock().getLocation().add(0.5, 0.0, 0.5));
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerInteractEvent(final PlayerInteractEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)Heroes.getInstance(), new Runnable(){

            @Override
            public void run() {
                event.getPlayer().setMetadata("LastSwingTime", (MetadataValue)new FixedMetadataValue((Plugin)Heroes.getInstance(), (Object)System.currentTimeMillis()));
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        LivingEntity target;
        CharacterDamageManager.EquippedWeaponStats stats;
        float reach;
        Player player = event.getPlayer();
        Hero hero = this.characterManager.getHero(player);
        Action action = event.getAction();
        if (NMSHandler.getInterface().isDuplicateEvent(event)) {
            return;
        }
        Material material = NMSHandler.getInterface().getUsedMaterial(player);
        if (action != Action.PHYSICAL && Util.isWeapon(material) && !hero.resolveWeapon()) {
            if (Heroes.properties.showNotTrainedUseMessage) {
                player.sendMessage(EquipmentUtil.getAreNotTrainedItemUseMessage(hero, material, false, false));
            }
            event.setCancelled(true);
            return;
        }
        if (hero.hasEffectType(EffectType.DISARM)) {
            if (Util.disarmCheck(hero, this.plugin)) {
                event.setCancelled(true);
                return;
            }
        } else if (hero.hasEffectType(EffectType.STUN)) {
            event.setCancelled(true);
            return;
        }
        if (hero.isInCombat() && Heroes.properties.noCombatMaterials.contains(material.name())) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + "You can't use that item in combat!");
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
            return;
        }
        if (Heroes.properties.useExperimentalFeatures && action == Action.LEFT_CLICK_AIR && (double)(reach = (stats = hero.getEquippedWeaponStats()).getReach()) > 3.0 && (target = Util.getTargetAtDistance(this.plugin, this.physics, hero, reach)) != null && target.getLocation().distance(player.getLocation()) > 3.0) {
            NMSHandler.getInterface().damageEntity(target, (LivingEntity)player, 1.0, EntityDamageEvent.DamageCause.ENTITY_ATTACK, stats.getKnockback());
            return;
        }
        boolean isBlockInteraction = false;
        if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock != null) {
                if (Util.interactableBlocks.contains(clickedBlock.getType())) {
                    isBlockInteraction = true;
                    hero.cancelDelayedSkill();
                } else if (action == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getType() == Material.CAKE) {
                    int value;
                    if (hero.isInCombat() && !Heroes.properties.foodConsumableInCombat) {
                        hero.getPlayer().sendMessage(ChatColor.GRAY + "You cannot use food in combat!");
                        event.setCancelled(true);
                        return;
                    }
                    if (hero.hasEffect("FoodHeal")) {
                        event.setCancelled(true);
                        return;
                    }
                    if (Heroes.properties.foodEnabled && player.getHealth() != player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && (value = Util.getFoodValue(Material.CAKE)) > 0) {
                        long duration = (long)value * (long)Heroes.properties.foodHealthTimeMult;
                        this.addHealthRegen(hero, duration);
                    }
                }
            }
        } else if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            hero.cancelDelayedSkill();
        }
        boolean isStealthy = false;
        if (event.hasItem() || player.getInventory().getItem(player.getInventory().getHeldItemSlot()) != null) {
            if (player.hasPermission("heroes.bind") && hero.hasBind(material)) {
                boolean isItemBindCast = false;
                if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
                    isItemBindCast = true;
                }
                if (isItemBindCast) {
                    String[] args = hero.getBind(material);
                    Skill s = this.plugin.getCommandHandler().dispatchSkill((CommandSender)player, args);
                    if (s == null) {
                        StringBuilder argString = new StringBuilder();
                        for (String arg : args) {
                            argString.append(arg);
                        }
                        player.sendMessage(ChatColor.RED + "Could not find skill for that bind. Please repair your /bind. (Tried skill: " + argString.toString() + ")");
                    } else {
                        isStealthy = s.isType(SkillType.STEALTHY);
                    }
                }
            }
            if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && Util.isFood(material) && (hero.isInCombat() && !Heroes.properties.foodConsumableInCombat || hero.hasEffect("FoodHeal"))) {
                event.setUseItemInHand(Event.Result.DENY);
            }
            if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && material == Material.FIREWORK_ROCKET) {
                ItemStack item = event.getItem();
                assert (item != null);
                FireworkMeta meta = (FireworkMeta)item.getItemMeta();
                assert (meta != null);
                int flightPower = meta.getPower();
                if (meta.hasEffects() && Heroes.properties.protectUserAndAlliesForFireworkDuration) {
                    FireworkImmunityEffect.applyToUserAndAllies(hero, flightPower, null, Heroes.properties.fireworkImmunityExpireMessage);
                }
            }
        }
        if (!isStealthy) {
            for (Effect effect : hero.getEffects()) {
                if (!effect.isType(EffectType.INVIS)) continue;
                hero.removeEffect(effect);
            }
        }
    }

    @EventHandler
    public void onPlayerPreJoin(AsyncPlayerPreLoginEvent event) {
        this.plugin.getStorageManager().getStorage().updatePlayerMetadata(event.getName(), event.getUniqueId(), event.getAddress());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        final Hero hero = this.characterManager.getHero(player);
        hero.setDisconnecting(false);
        this.validateHero(hero);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                hero.resolveMovementSpeed();
            }
        }, 20L);
        if (!player.hasPermission("heroes.admin.seeinvis")) {
            for (UUID id : InvisibleEffect.hiddenPlayers) {
                Player otherPlayer = Bukkit.getPlayer((UUID)id);
                if (otherPlayer == null) continue;
                player.hidePlayer(otherPlayer);
            }
        }
        player.setMaximumNoDamageTicks(Heroes.properties.noDamageTicks);
    }

    private void validateHero(final Hero hero) {
        hero.recalculateAttributesAndAllocationPoints();
        hero.rebuildAttributes();
        hero.resetMaxHP();
        if (!hero.hasEffect("Combat")) {
            hero.resetCombatEffect();
        }
        hero.syncExperience();
        if (Heroes.properties.prefixClassName) {
            hero.getPlayer().setDisplayName("[" + hero.getHeroClass().getName() + "]" + hero.getPlayer().getName());
        }
        if (System.currentTimeMillis() < Heroes.properties.expiration) {
            hero.getPlayer().sendMessage(Heroes.properties.bonusMessage);
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                HPlayerListener.this.characterManager.performSkillChecks(hero);
            }
        }, 4L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        Hero hero = this.characterManager.getHero(event.getPlayer());
        this.handleHeroLeaving(hero, CombatEffect.LeaveCombatReason.KICK);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Hero hero = this.characterManager.getHero(player);
        this.handleHeroLeaving(hero, CombatEffect.LeaveCombatReason.LOGOUT);
    }

    private void handleHeroLeaving(Hero hero, CombatEffect.LeaveCombatReason reason) {
        hero.setDisconnecting(true);
        Util.leaveParty(this.plugin, hero, HeroLeavePartyEvent.LeavePartyReason.DISCONNECT);
        hero.cancelDelayedSkill();
        hero.silentClearEffects(false);
        hero.clearSummons();
        hero.recheckCombat();
        if (hero.isInCombat()) {
            hero.leaveCombat(reason);
        }
        hero.getRecordBar().stop();
        ManagedScoreboard scoreboard = hero.getScoreboard();
        if (scoreboard != null) {
            scoreboard.destroy();
        }
        this.characterManager.saveHero(hero, true);
        this.characterManager.removeHero(hero);
        for (Command command : this.plugin.getCommandHandler().getCommands()) {
            if (!command.isInteractive()) continue;
            command.cancelInteraction((CommandSender)hero.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerSpawnStats(PlayerRespawnEvent event) {
        final Player player = event.getPlayer();
        final Hero hero = this.characterManager.getHero(player);
        if (Heroes.properties.respawnFeaturesEnabled) {
            hero.setShield((int)((double)hero.getMaxShield() * Heroes.properties.respawnShieldPercent));
            hero.setMana((int)((double)hero.getMaxMana() * Heroes.properties.respawnManaPercent));
            hero.setStamina((int)((double)hero.getMaxStamina() * Heroes.properties.respawnStaminaPercent));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * Math.min(1.0, Heroes.properties.respawnHealthPercent / 100.0));
                }
            }, 1L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    HPlayerListener.this.addHealthRegen(hero, (int)(Heroes.properties.respawnHealthRegenSeconds * 1000.0));
                }
            }, 10L);
        } else {
            player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
            hero.setShield(hero.getMaxShield());
            hero.setMana(hero.getMaxMana());
            hero.setStamina(hero.getMaxStamina());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Hero hero = this.characterManager.getHero(player);
        ManagedScoreboard scoreboard = hero.getScoreboard();
        if (scoreboard != null) {
            scoreboard.stop();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        final Hero hero = this.characterManager.getHero(player);
        hero.recalculateAttributesAndAllocationPoints();
        hero.rebuildAttributes();
        NMSHandler.getInterface().setPlayerExpZero(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                HPlayerListener.this.characterManager.performSkillChecks(hero);
                hero.resolveCurrentEquipment();
                hero.syncExperience();
                hero.renderVisualComponents();
            }
        }, 10L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            return;
        }
        final Hero hero = this.characterManager.getHero(event.getPlayer());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                HPlayerListener.this.characterManager.performSkillChecks(hero);
                hero.resolveMaxHealth();
                hero.resolveCurrentEquipment();
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        Hero hero = this.characterManager.getHero(event.getPlayer());
        for (Effect effect : hero.getEffects()) {
            if (effect.isPersistent() || effect.isType(EffectType.INTERNAL)) continue;
            hero.removeEffect(effect);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (event.getAmount() == 0.0 || !(event.getEntity() instanceof Player)) {
            return;
        }
        if (Heroes.properties.foodEnabled && event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        int delta = event.getFoodLevel() - player.getFoodLevel();
        if (delta < 0) {
            return;
        }
        if (Heroes.properties.foodEnabled) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        int value;
        if (event.getItem() == null) {
            return;
        }
        Player player = event.getPlayer();
        Material type = event.getItem().getType();
        if (!Util.isFood(type)) {
            return;
        }
        Hero hero = this.characterManager.getHero(player);
        if (hero.isInCombat() && Heroes.properties.noCombatMaterials.contains(type.name())) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + "You can't use that item in combat!");
            event.setCancelled(true);
            return;
        }
        if (hero.isInCombat() && !Heroes.properties.foodConsumableInCombat) {
            hero.getPlayer().sendMessage(ChatColor.GRAY + "You cannot use food in combat!");
            event.setCancelled(true);
            return;
        }
        if (hero.hasEffect("FoodHeal")) {
            event.setCancelled(true);
            return;
        }
        if (Heroes.properties.foodEnabled && player.getHealth() != player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && (value = Util.getFoodValue(type)) > 0) {
            long duration = value * Heroes.properties.foodHealthTimeMult;
            this.addHealthRegen(hero, duration);
            if (NMSHandler.getInterface().isRawFood(type)) {
                hero.addEffect(new VanillaHungerEffect(null, this.plugin, player, duration));
            }
        }
    }

    @EventHandler
    public void onHeroRegainHealth(HeroRegainHealthEvent event) {
        Hero hero = event.getHero();
        Player player = event.getHero().getPlayer();
        if (player.getHealth() >= player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && hero.hasEffect("FoodHeal")) {
            hero.removeEffect(hero.getEffect("FoodHeal"));
        }
        if (!event.isCancelled() && !hero.hasEffectType(EffectType.INVIS)) {
            Util.playClientEffect(player, "heart", new Vector(0, 0, 0), 1.0f, 10, true);
        }
    }

    @EventHandler
    public void onHeroChangeLevel(HeroChangeLevelEvent event) {
        if (event.getTo() <= event.getFrom()) {
            return;
        }
        Hero hero = event.getHero();
        Player player = hero.getPlayer();
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.5f, 1.0f);
        if (!Heroes.properties.showLevelUpEffect) {
            return;
        }
        HeroClass heroClass = event.getHeroClass();
        player.sendTitle(ChatColor.DARK_GREEN + ChatColor.BOLD + "LEVEL UP", ChatColor.GREEN + "Level " + hero.getHeroLevel(heroClass) + " " + heroClass.getName(), 10, 70, 20);
        FireworkEffect effect = FireworkEffect.builder().withColor(Color.GREEN).withTrail().build();
        VisualEffect.playInstantFirework(effect, player.getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerSprintJump(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!player.isSprinting() || player.isFlying() || player.getGameMode() == GameMode.SPECTATOR || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Location to = event.getTo();
        Location from = event.getFrom();
        if (to == null || to.getWorld() == null || to.toVector().equals((Object)from.toVector())) {
            return;
        }
        if (!to.getWorld().equals(from.getWorld())) {
            return;
        }
        if (player.isOnGround()) {
            if (player.hasMetadata(sprintJumpMetaDataFlag)) {
                player.removeMetadata(sprintJumpMetaDataFlag, (Plugin)this.plugin);
            }
            return;
        }
        if (from.getY() == to.getY() || (double)(0.2f - player.getWalkSpeed()) < 1.0E-4 || player.hasMetadata(sprintJumpMetaDataFlag)) {
            return;
        }
        float multiplier = player.getWalkSpeed() / 0.2f;
        Vector modifiedVelocity = player.getVelocity().clone().multiply(new Vector((double)multiplier, 0.5, (double)multiplier));
        player.setVelocity(modifiedVelocity);
        player.setMetadata(sprintJumpMetaDataFlag, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
    }

    private void addHealthRegen(Hero hero, long duration) {
        this.addHealthRegen(hero, 1000L, duration);
    }

    private void addHealthRegen(Hero hero, long period, long duration) {
        Player player = hero.getPlayer();
        double healthGain = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * Heroes.properties.foodHealPercent;
        FoodHealEffect effect = new FoodHealEffect(this.plugin, player, period, duration, healthGain);
        hero.addEffect(effect);
    }

    public class BedHealEffect
    extends PeriodicEffect {
        private final double tickHealPercent;

        public BedHealEffect(Heroes plugin, long period, double tickHealPercent) {
            super(plugin, "BedHeal", period);
            this.tickHealPercent = tickHealPercent;
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
            this.lastTickTime = System.currentTimeMillis();
        }

        @Override
        public void tickHero(Hero hero) {
            super.tickHero(hero);
            Player player = hero.getPlayer();
            double healAmount = Math.ceil(player.getMaxHealth() * this.tickHealPercent);
            hero.heal(healAmount);
        }
    }

    public class FoodHealEffect
    extends PeriodicHealEffect {
        public FoodHealEffect(Heroes plugin, Player applier, long period, long duration, double tickHeal) {
            super(null, plugin, "FoodHeal", applier, period, duration, tickHeal, null, null);
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
            hero.getPlayer().sendMessage(ChatColor.GRAY + "You are regenerating health.");
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
            hero.getPlayer().sendMessage(ChatColor.GRAY + "You have stopped regenerating health.");
        }
    }
}

