/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class HInventoryListener
implements Listener {
    private final Heroes plugin;
    private Map<Location, BrewingDetails> brewingDetailsForBrewingStandLocation = new HashMap<Location, BrewingDetails>();

    public HInventoryListener(Heroes heroes) {
        this.plugin = heroes;
    }

    private static boolean itemExists(ItemStack stack) {
        return stack != null && stack.getType() != Material.AIR;
    }

    private static boolean itemHasQuantity(ItemStack stack) {
        return HInventoryListener.itemExists(stack) && stack.getAmount() > 0;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.getInventory() == null) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.BREWING) {
            this.handleBrewing(event);
        } else if (event.getSlotType() == InventoryType.SlotType.RESULT) {
            switch (event.getInventory().getType()) {
                case CRAFTING: 
                case WORKBENCH: {
                    this.handleCrafting(event);
                    break;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBeforeBrewCompleteEvent(BrewEvent event) {
        BrewerInventory brewerInventory = event.getContents();
        Location brewEventLocation = brewerInventory.getHolder().getLocation();
        if (this.brewingDetailsForBrewingStandLocation.containsKey(brewEventLocation)) {
            BrewingDetails brewingDetails = this.brewingDetailsForBrewingStandLocation.get(brewEventLocation);
            Player brewer = Bukkit.getServer().getPlayer(brewingDetails.getBrewerUUID());
            if (brewer == null) {
                Heroes.log(Level.WARNING, "No player named " + brewingDetails.getBrewerName() + " (UUID " + brewingDetails.getBrewerUUID() + ") was found for brewing event. Are they still online?");
                this.brewingDetailsForBrewingStandLocation.remove(brewEventLocation);
                return;
            }
            ArrayList<ItemStack> potionSlotItemStacks = new ArrayList<ItemStack>();
            potionSlotItemStacks.add(brewerInventory.getItem(0));
            potionSlotItemStacks.add(brewerInventory.getItem(1));
            potionSlotItemStacks.add(brewerInventory.getItem(2));
            List<ItemStack> potionsInBrewingStand = this.getBrewingPotions(potionSlotItemStacks);
            if (potionsInBrewingStand.isEmpty()) {
                Heroes.log(Level.WARNING, "Brewing Event unexpectedly recorded a brewing event with no valid potions.");
                this.brewingDetailsForBrewingStandLocation.remove(brewEventLocation);
                return;
            }
            Hero hero = this.plugin.getCharacterManager().getHero(brewer);
            ItemStack ingredient = brewerInventory.getIngredient();
            ArrayList<ItemStack> brewingPotions = new ArrayList<ItemStack>();
            if (HInventoryListener.hasSamePotions(potionsInBrewingStand)) {
                ItemStack potion = potionsInBrewingStand.get(0);
                if (HInventoryListener.isValidRecipe(ingredient, potion)) {
                    brewingPotions.addAll(potionsInBrewingStand);
                }
            } else {
                for (ItemStack potionItemStack : potionsInBrewingStand) {
                    if (!HInventoryListener.isValidRecipe(ingredient, potionItemStack)) continue;
                    brewingPotions.add(potionItemStack);
                }
            }
            if (brewingPotions.isEmpty()) {
                Heroes.log(Level.WARNING, "Brewing Event unexpectedly recorded a brewing event with no valid potion recipes.");
                this.brewingDetailsForBrewingStandLocation.remove(brewEventLocation);
                return;
            }
            double exp = 0.0;
            if (HInventoryListener.hasSameMaterials(brewingPotions)) {
                ItemStack potion = (ItemStack)brewingPotions.get(0);
                exp = this.getPotionRecipeExp(ingredient, potion) * (double)brewingPotions.size();
            } else {
                for (ItemStack potion : brewingPotions) {
                    exp += this.getPotionRecipeExp(ingredient, potion);
                }
            }
            if (hero.hasParty()) {
                hero.getParty().gainExp(exp, HeroClass.ExperienceType.BREWING, brewEventLocation);
            } else if (hero.canGain(HeroClass.ExperienceType.BREWING)) {
                hero.gainExp(exp, HeroClass.ExperienceType.BREWING, brewEventLocation);
            }
            this.brewingDetailsForBrewingStandLocation.remove(brewEventLocation);
        }
    }

    private void handleCrafting(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerInventory inventory = player.getInventory();
        ItemStack toCraft = event.getCurrentItem();
        ItemStack toStore = event.getCursor();
        ClickType clickType = event.getClick();
        if (clickType.isKeyboardClick() && event.getHotbarButton() >= 0 && inventory.getItem(event.getHotbarButton()) != null) {
            return;
        }
        if (HInventoryListener.itemHasQuantity(toCraft)) {
            Hero hero = this.plugin.getCharacterManager().getHero(player);
            if (event.getAction() == InventoryAction.NOTHING && HInventoryListener.itemExists(toStore)) {
                player.sendMessage(ChatColor.RED + "Please have an empty cursor when grabbing the result.");
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (event.isShiftClick()) {
                this.schedulePostDetection(player, toCraft);
            } else if (this.isStackSumLegal(toCraft, toStore)) {
                this.handleCraftingExp(toCraft, player);
            }
        }
    }

    private List<HeroClass> findHeroClassesToCraft(Object o) {
        ArrayList<HeroClass> foundClass = new ArrayList<HeroClass>();
        if (o instanceof ItemStack && ((ItemStack)o).getType() == Material.MAP) {
            o = Material.MAP;
        }
        for (HeroClass heroClass : this.plugin.getClassManager().getClasses()) {
            if (heroClass.getCraftLevel(o) <= 0) continue;
            foundClass.add(heroClass);
        }
        return foundClass;
    }

    private boolean isStackSumLegal(ItemStack a, ItemStack b) {
        return a == null || b == null || a.getAmount() + b.getAmount() <= a.getType().getMaxStackSize();
    }

    private void schedulePostDetection(final Player player, final ItemStack compareItem) {
        final ItemStack[] preInv = player.getInventory().getContents();
        for (int i = 0; i < preInv.length; ++i) {
            preInv[i] = preInv[i] != null ? preInv[i].clone() : null;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ItemStack[] postInv = player.getInventory().getContents();
                int craftedItems = 0;
                for (int i = 0; i < preInv.length; ++i) {
                    ItemStack pre = preInv[i];
                    ItemStack post = postInv[i];
                    if (!HInventoryListener.this.isSameItem(compareItem, post) || !HInventoryListener.this.isSameItem(compareItem, pre) && pre != null) continue;
                    craftedItems += post.getAmount() - (pre != null ? pre.getAmount() : 0);
                }
                if (craftedItems > 0) {
                    HInventoryListener.this.handleCraftingExp(compareItem.getType(), craftedItems, player);
                }
            }
        });
    }

    private boolean isSameItem(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        return Objects.equals(a.getType(), b.getType()) && Objects.equals(a.getData(), b.getData()) && Objects.equals(a.getEnchantments(), b.getEnchantments());
    }

    private boolean handleCraftingExp(ItemStack item, Player crafter) {
        return this.handleCraftingExp(item.getType(), item.getAmount(), crafter);
    }

    private boolean handleCraftingExp(Material type, int amount, Player crafter) {
        Hero hero = this.plugin.getCharacterManager().getHero(crafter);
        if (Heroes.properties.craftingExp.containsKey(type)) {
            if (hero.hasParty()) {
                hero.getParty().gainExp(Heroes.properties.craftingExp.get(type) * (double)amount, HeroClass.ExperienceType.CRAFTING, crafter.getLocation());
                return true;
            }
            hero.gainExp(Heroes.properties.craftingExp.get(type) * (double)amount, HeroClass.ExperienceType.CRAFTING, hero.getViewingLocation(1.0));
            return true;
        }
        return true;
    }

    private void handleBrewing(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player) || event.getWhoClicked() == null) {
            return;
        }
        if (!(event.getInventory() instanceof BrewerInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getAction() == InventoryAction.NOTHING || event.getAction() == InventoryAction.UNKNOWN) {
            return;
        }
        this.schedulePostBrewingInventoryClickEvent(event, player);
    }

    private void schedulePostBrewingInventoryClickEvent(final InventoryClickEvent preEvent, final Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                BrewerInventory brewerInventory = (BrewerInventory)preEvent.getInventory();
                if (brewerInventory == null) {
                    Heroes.log(Level.WARNING, "Brewing inventory for brewing event no longer exists.");
                    return;
                }
                BrewingStand brewingStand = brewerInventory.getHolder();
                if (brewingStand == null) {
                    Heroes.log(Level.WARNING, "Brewing stand for brewing event no longer exists.");
                    return;
                }
                ItemStack fuelItemStack = brewerInventory.getFuel();
                ItemStack ingredientItemStack = brewerInventory.getIngredient();
                ArrayList<ItemStack> potionSlotItemStacks = new ArrayList<ItemStack>();
                potionSlotItemStacks.add(brewerInventory.getItem(0));
                potionSlotItemStacks.add(brewerInventory.getItem(1));
                potionSlotItemStacks.add(brewerInventory.getItem(2));
                List<ItemStack> brewingPotions = HInventoryListener.this.getBrewingPotions(potionSlotItemStacks);
                boolean brewerAlreadyStored = HInventoryListener.this.brewingDetailsForBrewingStandLocation.containsKey(brewingStand.getLocation());
                BrewingRecipeStateInfo brewingRecipeStateInfo = HInventoryListener.this.getBrewingRecipeState(brewingStand, fuelItemStack, ingredientItemStack, brewingPotions);
                if (brewingRecipeStateInfo.getState() == BrewingRecipeState.VALID_RECIPE) {
                    if (!brewerAlreadyStored) {
                        HInventoryListener.this.brewingDetailsForBrewingStandLocation.put(brewingStand.getLocation(), new BrewingDetails(player.getName(), player.getUniqueId(), brewingRecipeStateInfo.getValidRecipes()));
                    } else {
                        BrewingDetails brewingDetails = HInventoryListener.this.brewingDetailsForBrewingStandLocation.get(brewingStand.getLocation());
                        brewingDetails.setNumberOfPotionsBrewing(brewingRecipeStateInfo.getValidRecipes());
                        if (!player.getUniqueId().equals(brewingDetails.getBrewerUUID()) || !player.getName().equals(brewingDetails.getBrewerName())) {
                            brewingDetails.setBrewerUUID(player.getUniqueId());
                            brewingDetails.setBrewerName(player.getName());
                        }
                    }
                } else if (brewerAlreadyStored) {
                    HInventoryListener.this.brewingDetailsForBrewingStandLocation.remove(brewingStand.getLocation());
                }
            }
        }, 1L);
    }

    private double getPotionRecipeExp(ItemStack ingredient, ItemStack potion) {
        double exp = Heroes.properties.brewingPotionExp;
        if (potion.getType() == Material.LINGERING_POTION || ingredient.getType() == Material.DRAGON_BREATH && potion.getType() == Material.SPLASH_POTION) {
            exp = Heroes.properties.brewingLingeringPotionExp;
        } else if (potion.getType() == Material.SPLASH_POTION || ingredient.getType() == Material.GUNPOWDER && potion.getType() == Material.POTION) {
            exp = Heroes.properties.brewingSplashPotionExp;
        }
        return exp;
    }

    private BrewingRecipeStateInfo getBrewingRecipeState(BrewingStand brewingStand, ItemStack fuelItemStack, ItemStack ingredientItemStack, List<ItemStack> potionItemStacks) {
        if (brewingStand.getFuelLevel() <= 0 && (fuelItemStack == null || fuelItemStack.getType() != Material.BLAZE_POWDER)) {
            return new BrewingRecipeStateInfo(BrewingRecipeState.NO_FUEL, 0);
        }
        if (!HInventoryListener.itemHasQuantity(ingredientItemStack)) {
            return new BrewingRecipeStateInfo(BrewingRecipeState.NO_INGREDIENT, 0);
        }
        if (potionItemStacks.isEmpty()) {
            return new BrewingRecipeStateInfo(BrewingRecipeState.NO_POTIONS, 0);
        }
        boolean samePotions = HInventoryListener.hasSamePotions(potionItemStacks);
        int validRecipes = 0;
        if (samePotions) {
            ItemStack potion = potionItemStacks.get(0);
            if (HInventoryListener.isValidRecipe(ingredientItemStack, potion)) {
                validRecipes = potionItemStacks.size();
            }
        } else {
            for (ItemStack potionItemStack : potionItemStacks) {
                if (!HInventoryListener.isValidRecipe(ingredientItemStack, potionItemStack)) continue;
                ++validRecipes;
            }
        }
        BrewingRecipeState brewingRecipeState = validRecipes > 0 ? BrewingRecipeState.VALID_RECIPE : BrewingRecipeState.INVALID_RECIPE;
        return new BrewingRecipeStateInfo(brewingRecipeState, validRecipes);
    }

    private static boolean hasSameMaterials(List<ItemStack> itemStacks) {
        boolean sameMaterials = false;
        if (itemStacks.size() == 1) {
            sameMaterials = true;
        } else {
            boolean allMaterialsSame = true;
            ItemStack firstItemStack = itemStacks.get(0);
            for (int i = 1; i < itemStacks.size(); ++i) {
                ItemStack itemStack = itemStacks.get(i);
                allMaterialsSame = allMaterialsSame && itemStack.getType() == firstItemStack.getType();
            }
            sameMaterials = allMaterialsSame;
        }
        return sameMaterials;
    }

    private static boolean hasSamePotions(List<ItemStack> potionItemStacks) {
        boolean samePotionTypes = false;
        if (potionItemStacks.size() == 1) {
            samePotionTypes = true;
        } else {
            boolean allPotionsSame = true;
            ItemStack firstPotionItemStack = potionItemStacks.get(0);
            for (int i = 1; i < potionItemStacks.size(); ++i) {
                ItemStack potionItemStack = potionItemStacks.get(i);
                boolean samePotions = potionItemStack.getType() == firstPotionItemStack.getType() && HInventoryListener.getPotionTypeFromItemStack(potionItemStack) == HInventoryListener.getPotionTypeFromItemStack(firstPotionItemStack);
                allPotionsSame = allPotionsSame && samePotions;
            }
            samePotionTypes = allPotionsSame;
        }
        return samePotionTypes;
    }

    private static boolean isValidRecipe(ItemStack ingredient, ItemStack potion) {
        if (!HInventoryListener.itemHasQuantity(ingredient) || !HInventoryListener.itemHasQuantity(potion)) {
            return false;
        }
        Material ingredientType = ingredient.getType();
        Material potionMaterial = potion.getType();
        PotionData potionData = ((PotionMeta)potion.getItemMeta()).getBasePotionData();
        PotionType potionType = potionData.getType();
        if (ingredientType == Material.FERMENTED_SPIDER_EYE) {
            if (!(potionType != PotionType.SPEED && potionType != PotionType.JUMP || potionData.isUpgraded())) {
                return true;
            }
            if (potionType == PotionType.INSTANT_HEAL || potionType == PotionType.POISON) {
                return true;
            }
            return potionType == PotionType.NIGHT_VISION || potionType == PotionType.WATER;
        }
        if (ingredientType == Material.GUNPOWDER && potionMaterial == Material.POTION || ingredientType == Material.DRAGON_BREATH && potionMaterial == Material.SPLASH_POTION) {
            return true;
        }
        if (potionData.isExtended() || potionData.isUpgraded()) {
            return false;
        }
        if (ingredientType == Material.REDSTONE) {
            switch (potionType) {
                case WATER: 
                case SPEED: 
                case SLOWNESS: 
                case JUMP: 
                case STRENGTH: 
                case POISON: 
                case REGEN: 
                case FIRE_RESISTANCE: 
                case WATER_BREATHING: 
                case NIGHT_VISION: 
                case INVISIBILITY: 
                case WEAKNESS: {
                    return true;
                }
            }
            return false;
        }
        if (ingredientType == Material.GLOWSTONE_DUST) {
            switch (potionType) {
                case WATER: 
                case SPEED: 
                case SLOWNESS: 
                case JUMP: 
                case STRENGTH: 
                case POISON: 
                case REGEN: 
                case INSTANT_HEAL: 
                case INSTANT_DAMAGE: {
                    return true;
                }
            }
            return false;
        }
        if (potionType == PotionType.WATER) {
            switch (ingredientType) {
                case NETHER_WART: 
                case SPIDER_EYE: 
                case GHAST_TEAR: 
                case RABBIT_FOOT: 
                case BLAZE_POWDER: 
                case GLISTERING_MELON_SLICE: 
                case SUGAR: 
                case MAGMA_CREAM: {
                    return true;
                }
            }
            return false;
        }
        if (potionType == PotionType.AWKWARD) {
            switch (ingredientType) {
                case SPIDER_EYE: 
                case GHAST_TEAR: 
                case RABBIT_FOOT: 
                case BLAZE_POWDER: 
                case GLISTERING_MELON_SLICE: 
                case SUGAR: 
                case MAGMA_CREAM: 
                case GOLDEN_CARROT: 
                case PUFFERFISH: 
                case TURTLE_HELMET: 
                case PHANTOM_MEMBRANE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static PotionType getPotionTypeFromItemStack(ItemStack potion) {
        return ((PotionMeta)potion.getItemMeta()).getBasePotionData().getType();
    }

    private List<ItemStack> getBrewingPotions(List<ItemStack> potionSlotItemStacks) {
        ArrayList<ItemStack> potionItemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 3 && i < potionSlotItemStacks.size(); ++i) {
            ItemStack itemStack = potionSlotItemStacks.get(i);
            if (!HInventoryListener.itemHasQuantity(itemStack) || itemStack.getType() != Material.POTION && itemStack.getType() != Material.SPLASH_POTION && itemStack.getType() != Material.LINGERING_POTION) continue;
            potionItemStacks.add(itemStack);
        }
        return potionItemStacks;
    }

    private static String getSlotTypeString(InventoryType.SlotType slotType) {
        return switch (slotType) {
            case InventoryType.SlotType.FUEL -> "fuel";
            case InventoryType.SlotType.ARMOR -> "armor";
            case InventoryType.SlotType.RESULT -> "result";
            case InventoryType.SlotType.OUTSIDE -> "outside";
            case InventoryType.SlotType.CONTAINER -> "container";
            case InventoryType.SlotType.CRAFTING -> "crafting";
            case InventoryType.SlotType.QUICKBAR -> "quickbar";
            default -> "";
        };
    }

    private static String getActionString(InventoryAction action) {
        return switch (action) {
            case InventoryAction.NOTHING -> "nothing";
            case InventoryAction.UNKNOWN -> "unknown";
            case InventoryAction.PLACE_ALL, InventoryAction.PLACE_SOME, InventoryAction.PLACE_ONE -> "place";
            case InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_ONE -> "pickup";
            case InventoryAction.DROP_ALL_SLOT, InventoryAction.DROP_ONE_SLOT -> "drop_slot";
            case InventoryAction.DROP_ALL_CURSOR, InventoryAction.DROP_ONE_CURSOR -> "drop_cursor";
            case InventoryAction.SWAP_WITH_CURSOR -> "swap_with_cursor";
            case InventoryAction.COLLECT_TO_CURSOR -> "collect_to_cursor";
            case InventoryAction.CLONE_STACK -> "clone_stack";
            case InventoryAction.HOTBAR_SWAP -> "hotbar_swap";
            case InventoryAction.HOTBAR_MOVE_AND_READD -> "hotbar_move_and_read";
            case InventoryAction.MOVE_TO_OTHER_INVENTORY -> "move_to_other_inventory";
            default -> "";
        };
    }

    private class BrewingDetails {
        private String brewerName;
        private UUID brewerUUID = null;
        private int numberOfPotionsBrewing = 0;
        private int numberOfPotionsBrewed = 0;

        public BrewingDetails(String brewerName, UUID brewerUUID, int numberOfPotionsBrewing) {
            this.brewerName = brewerName;
            this.brewerUUID = brewerUUID;
            this.numberOfPotionsBrewing = numberOfPotionsBrewing;
        }

        public String getBrewerName() {
            return this.brewerName;
        }

        public void setBrewerName(String brewerName) {
            this.brewerName = brewerName;
        }

        public UUID getBrewerUUID() {
            return this.brewerUUID;
        }

        public void setBrewerUUID(UUID brewerUUID) {
            this.brewerUUID = brewerUUID;
        }

        public int getNumberOfPotionsBrewed() {
            return this.numberOfPotionsBrewed;
        }

        public void setNumberOfPotionsBrewed(int numberOfPotionsBrewed) {
            this.numberOfPotionsBrewed = numberOfPotionsBrewed;
        }

        public int getNumberOfPotionsBrewing() {
            return this.numberOfPotionsBrewing;
        }

        public void setNumberOfPotionsBrewing(int numberOfPotionsBrewing) {
            this.numberOfPotionsBrewing = numberOfPotionsBrewing;
        }
    }

    private class BrewingRecipeStateInfo {
        private BrewingRecipeState brewingRecipeState;
        private int validRecipes;

        public BrewingRecipeStateInfo(BrewingRecipeState brewingRecipeState, int validRecipes) {
            this.brewingRecipeState = brewingRecipeState;
            this.validRecipes = validRecipes;
        }

        public BrewingRecipeState getState() {
            return this.brewingRecipeState;
        }

        public void setBrewingRecipeState(BrewingRecipeState brewingRecipeState) {
            this.brewingRecipeState = brewingRecipeState;
        }

        public int getValidRecipes() {
            return this.validRecipes;
        }

        public void setValidRecipes(int validRecipes) {
            this.validRecipes = validRecipes;
        }
    }

    private static enum BrewingRecipeState {
        NONE,
        NO_FUEL,
        NO_INGREDIENT,
        NO_POTIONS,
        INVALID_RECIPE,
        VALID_RECIPE;

    }
}

