/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.api.events.CharacterRegainHealthEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.HeroRegainHealthEvent;
import com.herocraftonline.heroes.api.events.HeroRegainManaEvent;
import com.herocraftonline.heroes.api.events.HeroRegainShieldEvent;
import com.herocraftonline.heroes.api.events.HeroRegainStaminaEvent;
import com.herocraftonline.heroes.api.events.SkillCompleteEvent;
import com.herocraftonline.heroes.api.events.SkillUseEvent;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.interfaces.HealthRegainAmplifier;
import com.herocraftonline.heroes.characters.effects.common.interfaces.HealthRegainReduction;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.Listenable;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Util;
import java.util.ArrayList;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HEventListener
implements Listener {
    private final Heroes plugin;

    public HEventListener(Heroes heroes) {
        this.plugin = heroes;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHeroChangeLevel(HeroChangeLevelEvent event) {
        final Hero hero = event.getHero();
        final HeroClass heroClass = event.getHeroClass();
        Player player = hero.getPlayer();
        CharacterManager characterManager = this.plugin.getCharacterManager();
        int level = event.getTo();
        if (level > event.getFrom()) {
            for (Skill skill : this.plugin.getSkillManager().getSkills()) {
                if (!heroClass.hasSkill(skill.getName()) && (hero.getHeroClass() != heroClass || HeroClass.getGlobalSkillset() == null || !HeroClass.getGlobalSkillset().hasSkill(skill.getName())) || !hero.canUseSkill(skill) || (levelRequired = SkillConfigManager.getUseSetting(hero, skill, SkillSetting.LEVEL, 1, true)) != level) continue;
                if (skill instanceof Listenable) {
                    characterManager.performIndividualSkillCheck(hero, skill);
                }
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You now have the ability to use " + ChatColor.WHITE + skill.getName() + ChatColor.GRAY + ".");
            }
        } else {
            for (Skill skill : this.plugin.getSkillManager().getSkills()) {
                if (!heroClass.hasSkill(skill.getName()) && (hero.getHeroClass() != heroClass || HeroClass.getGlobalSkillset() == null || !HeroClass.getGlobalSkillset().hasSkill(skill.getName())) || (levelRequired = SkillConfigManager.getUseSetting(hero, skill, SkillSetting.LEVEL, 1, true)) <= level || levelRequired > event.getFrom()) continue;
                if (skill instanceof Listenable) {
                    characterManager.performIndividualSkillCheck(hero, skill);
                }
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You no longer have the ability to use " + ChatColor.WHITE + skill.getName() + ChatColor.GRAY + ".");
            }
        }
        if (level > event.getFrom()) {
            ArrayList<String> newWeaponNames = new ArrayList<String>();
            for (Material weapon : heroClass.getAllowedWeapons()) {
                if (!heroClass.isAllowedWeaponLevelRestricted(weapon) || heroClass.getAllowedWeaponLevel(weapon) != level) continue;
                newWeaponNames.add(MaterialUtil.getFriendlyName(weapon));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Material material : heroClass.getAllowedOffhand()) {
                if (!heroClass.isAllowedOffhandLevelRestricted(material) || heroClass.getAllowedOffhandLevel(material) != level) continue;
                arrayList.add(MaterialUtil.getFriendlyName(material));
            }
            ArrayList newArmorNames = new ArrayList();
            for (Material armor : heroClass.getAllowedArmor()) {
                if (!heroClass.isAllowedArmorLevelRestricted(armor) || heroClass.getAllowedArmorLevel(armor) != level) continue;
                newArmorNames.add(MaterialUtil.getFriendlyName(armor));
            }
            String string = ChatColor.GRAY + ", " + ChatColor.WHITE;
            if (!newWeaponNames.isEmpty()) {
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You now have the ability to use weapons: " + ChatColor.WHITE + String.join((CharSequence)string, newWeaponNames) + ChatColor.GRAY + ".");
            }
            if (!arrayList.isEmpty()) {
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You now have the ability to use offhand: " + ChatColor.WHITE + String.join((CharSequence)string, arrayList) + ChatColor.GRAY + ".");
            }
            if (!newArmorNames.isEmpty()) {
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You now have the ability to use armor: " + ChatColor.WHITE + String.join((CharSequence)string, newArmorNames) + ChatColor.GRAY + ".");
            }
        } else {
            int oldLevel = event.getFrom();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Material material : heroClass.getAllowedWeapons()) {
                int levelRequired;
                if (!heroClass.isAllowedWeaponLevelRestricted(material) || (levelRequired = heroClass.getAllowedWeaponLevel(material)) <= level || levelRequired > oldLevel) continue;
                arrayList.add(MaterialUtil.getFriendlyName(material));
            }
            ArrayList<String> newOffhandNames = new ArrayList<String>();
            for (Material offhand : heroClass.getAllowedOffhand()) {
                int levelRequired;
                if (!heroClass.isAllowedOffhandLevelRestricted(offhand) || (levelRequired = heroClass.getAllowedOffhandLevel(offhand)) <= level || levelRequired > oldLevel) continue;
                newOffhandNames.add(MaterialUtil.getFriendlyName(offhand));
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Material armor : heroClass.getAllowedArmor()) {
                int levelRequired;
                if (!heroClass.isAllowedArmorLevelRestricted(armor) || (levelRequired = heroClass.getAllowedArmorLevel(armor)) <= level || levelRequired > oldLevel) continue;
                arrayList2.add(MaterialUtil.getFriendlyName(armor));
            }
            String delimiter = ChatColor.GRAY + ", " + ChatColor.WHITE;
            if (!arrayList.isEmpty()) {
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You no longer have the ability to use weapons: " + ChatColor.WHITE + String.join((CharSequence)delimiter, arrayList) + ChatColor.GRAY + ".");
            }
            if (!newOffhandNames.isEmpty()) {
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You no longer have the ability to use offhand: " + ChatColor.WHITE + String.join((CharSequence)delimiter, newOffhandNames) + ChatColor.GRAY + ".");
            }
            if (!arrayList2.isEmpty()) {
                player.sendMessage(ChatComponents.GENERIC_LEVEL_UP + "You no longer have the ability to use armor: " + ChatColor.WHITE + String.join((CharSequence)delimiter, arrayList2) + ChatColor.GRAY + ".");
            }
        }
        if (heroClass.isPrimary()) {
            int levelDifference = event.getTo() - event.getFrom();
            if (levelDifference < 0) {
                double d = heroClass.getAllocationPointsPerLevel() * (level - 1);
                double d2 = hero.getTotalSpentAllocationPoints(heroClass);
                AttributeSet allocatedAttributes = hero.getAllocatedAttributes(heroClass);
                if (d2 > d) {
                    AttributeType workingType = null;
                    int currentReductionValue = 0;
                    boolean displayedMessage = false;
                    do {
                        int strength = allocatedAttributes.getStrengthValue();
                        int constitution = allocatedAttributes.getConstitutionValue();
                        int endurance = allocatedAttributes.getEnduranceValue();
                        int dexterity = allocatedAttributes.getDexterityValue();
                        int intellect = allocatedAttributes.getIntellectValue();
                        int wisdom = allocatedAttributes.getWisdomValue();
                        AttributeType lowestType = null;
                        int lowestValue = Integer.MAX_VALUE;
                        if (strength > 0 && strength <= lowestValue) {
                            lowestType = AttributeType.STRENGTH;
                            lowestValue = strength;
                        }
                        if (constitution > 0 && constitution <= lowestValue) {
                            lowestType = AttributeType.CONSTITUTION;
                            lowestValue = constitution;
                        }
                        if (endurance > 0 && endurance <= lowestValue) {
                            lowestType = AttributeType.ENDURANCE;
                            lowestValue = endurance;
                        }
                        if (dexterity > 0 && dexterity <= lowestValue) {
                            lowestType = AttributeType.DEXTERITY;
                            lowestValue = dexterity;
                        }
                        if (intellect > 0 && intellect <= lowestValue) {
                            lowestType = AttributeType.INTELLECT;
                            lowestValue = intellect;
                        }
                        if (wisdom > 0 && wisdom <= lowestValue) {
                            lowestType = AttributeType.WISDOM;
                            lowestValue = wisdom;
                        }
                        if (lowestType == null) break;
                        if (workingType == null) {
                            workingType = lowestType;
                        }
                        hero.setAllocatedAttribute(heroClass, lowestType, allocatedAttributes.getAttributeValue(lowestType) - 1);
                        d2 = hero.getTotalSpentAllocationPoints(heroClass);
                        if (!heroClass.equals(hero.getHeroClass())) continue;
                        if (lowestType == workingType) {
                            displayedMessage = false;
                            ++currentReductionValue;
                            continue;
                        }
                        if (currentReductionValue > 0) {
                            hero.getPlayer().sendMessage(ChatColor.GREEN + "Your " + ChatColor.WHITE + WordUtils.capitalizeFully((String)workingType.name()) + ChatColor.GREEN + " attribute has been reduced by " + ChatColor.WHITE + currentReductionValue + ChatColor.GREEN + "! It is now " + ChatColor.WHITE + hero.getAttributeValue(workingType));
                            displayedMessage = true;
                            currentReductionValue = 1;
                        }
                        workingType = lowestType;
                    } while (d < d2);
                    if (!displayedMessage && workingType != null) {
                        hero.getPlayer().sendMessage(ChatColor.GREEN + "Your " + ChatColor.WHITE + WordUtils.capitalizeFully((String)workingType.name()) + ChatColor.GREEN + " attribute has been reduced by " + ChatColor.WHITE + currentReductionValue + ChatColor.GREEN + "! It is now " + ChatColor.WHITE + hero.getAttributeValue(workingType));
                    }
                }
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    hero.recalculateAttributesAndAllocationPoints(heroClass, hero.getHeroLevel(heroClass));
                    hero.rebuildAttributes();
                }
            }, 2L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCharacterRegainHealth(CharacterRegainHealthEvent event) {
        CharacterTemplate character = event.getCharacter();
        double modifier = 0.0;
        for (Effect effect : character.getEffects()) {
            if (effect instanceof HealthRegainAmplifier) {
                modifier += ((Double)((HealthRegainAmplifier)((Object)effect)).getDelta()).doubleValue();
                continue;
            }
            if (!(effect instanceof HealthRegainReduction)) continue;
            modifier -= ((Double)((HealthRegainReduction)((Object)effect)).getDelta()).doubleValue();
        }
        event.setDelta((Double)event.getDelta() * (1.0 + modifier));
        if (!(event instanceof HeroRegainHealthEvent) || (Double)event.getDelta() <= 0.0) {
            return;
        }
        Hero hero = (Hero)character;
        if (hero.hasParty()) {
            HeroParty party = hero.getParty();
            party.update();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHeroRegainMana(HeroRegainManaEvent event) {
        if (event.shouldSkipEffectCheck()) {
            return;
        }
        for (Effect effect : event.getHero().getEffects()) {
            if (!effect.isType(EffectType.MANA_FREEZING)) continue;
            event.setCancelled(true);
            break;
        }
        if (event.isCancelled()) {
            Hero hero = event.getHero();
            Player player = hero.getPlayer();
            if (hero.isVerboseMana()) {
                player.sendMessage(ChatComponents.Bars.mana(hero.getMana(), hero.getMaxMana(), true));
            }
        } else if (!event.getHero().isInCombat()) {
            event.setDelta((int)Math.ceil((double)((Integer)event.getDelta()).intValue() * Heroes.properties.manaRegenMultiplierOutOfCombat));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHeroRegainStamina(HeroRegainStaminaEvent event) {
        if (event.shouldSkipEffectCheck()) {
            return;
        }
        for (Effect effect : event.getHero().getEffects()) {
            if (!effect.isType(EffectType.STAMINA_FREEZING)) continue;
            event.setCancelled(true);
            break;
        }
        if (event.isCancelled()) {
            Hero hero = event.getHero();
            Player player = hero.getPlayer();
            if (hero.isVerboseStamina()) {
                player.sendMessage(ChatComponents.Bars.stamina(hero.getStamina(), hero.getMaxStamina(), true));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHeroRegainShield(HeroRegainShieldEvent event) {
        if (event.shouldSkipEffectCheck()) {
            return;
        }
        for (Effect effect : event.getHero().getEffects()) {
            if (!effect.isType(EffectType.SHIELD_FREEZING)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSkillUse(SkillUseEvent event) {
        Hero hero = event.getHero();
        Player player = hero.getPlayer();
        Skill skill = event.getSkill();
        for (Effect effect : hero.getEffects()) {
            if ((effect.isType(EffectType.STUN) || effect.isType(EffectType.DISABLE)) && !skill.isType(SkillType.DISABLE_COUNTERING)) {
                player.sendMessage(ChatComponents.GENERIC_SKILL + "You can't use that skill while disabled!");
                event.setCancelled(true);
                return;
            }
            if (effect.isType(EffectType.SILENCE) && skill.isType(SkillType.SILENCEABLE)) {
                player.sendMessage(ChatComponents.GENERIC_SKILL + "You can't use that skill while silenced!");
                event.setCancelled(true);
                return;
            }
            if (effect.isType(EffectType.ROOT) && (skill.isType(SkillType.MOVEMENT_INCREASING) || skill.isType(SkillType.VELOCITY_INCREASING) || skill.isType(SkillType.TELEPORTING)) && !skill.isType(SkillType.MOVEMENT_PREVENTION_COUNTERING) && !skill.isType(SkillType.DISABLE_COUNTERING)) {
                player.sendMessage(ChatComponents.GENERIC_SKILL + "You can't use that skill while rooted!");
                event.setCancelled(true);
                return;
            }
            if (!effect.isType(EffectType.INVIS) || skill.isType(SkillType.STEALTHY)) continue;
            hero.removeEffect(effect);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSkillCompleted(SkillCompleteEvent event) {
        SkillResult.ResultType resultType = event.getResult().type;
        if (resultType != SkillResult.ResultType.NORMAL && resultType != SkillResult.ResultType.REMOVED_EFFECT) {
            return;
        }
        Hero hero = event.getHero();
        Player player = hero.getPlayer();
        Skill skill = event.getSkill();
        if (Heroes.properties.skillsCauseDamageToWeapons) {
            for (SkillType type : skill.getTypes()) {
                if (type != SkillType.DAMAGING && type != SkillType.AGGRESSIVE && type != SkillType.MULTI_GRESSIVE && type != SkillType.BUFFING && type != SkillType.HEALING) continue;
                Util.manuallyDamageWeaponDurability(player, 1);
                return;
            }
        }
    }
}

