/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.CharacterRegainHealthEvent;
import com.herocraftonline.heroes.api.events.HeroEnterCombatEvent;
import com.herocraftonline.heroes.api.events.HeroKillCharacterEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.CombustEffect;
import com.herocraftonline.heroes.characters.effects.common.interfaces.HealthRegainAmplifier;
import com.herocraftonline.heroes.characters.effects.common.interfaces.HealthRegainReduction;
import com.herocraftonline.heroes.characters.effects.common.interfaces.Summon;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.util.FireworkUtil;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class HEntityListener
implements Listener {
    private final Heroes plugin;

    public HEntityListener(Heroes plugin) {
        this.plugin = plugin;
    }

    private Player getAttackerPlayer(EntityDamageEvent event) {
        CharacterTemplate character;
        if (event == null) {
            return null;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            Player player;
            String fireworkCrossbowerName;
            Entity damager = ((EntityDamageByEntityEvent)event).getDamager();
            if (damager instanceof Player) {
                return (Player)damager;
            }
            if (damager instanceof Projectile) {
                CharacterTemplate character2;
                Projectile projectile = (Projectile)damager;
                if (projectile.getShooter() instanceof Player) {
                    return (Player)projectile.getShooter();
                }
                if (projectile.getShooter() instanceof Skeleton && (character2 = this.plugin.getCharacterManager().getCharacter((LivingEntity)projectile.getShooter())).hasEffectType(EffectType.SUMMON)) {
                    return this.getSummonerPlayer(character2);
                }
            } else if (damager instanceof LivingEntity) {
                Tameable tamed;
                if (damager instanceof Tameable && (tamed = (Tameable)damager).isTamed() && tamed.getOwner() instanceof Player) {
                    return (Player)tamed.getOwner();
                }
                CharacterTemplate character3 = this.plugin.getCharacterManager().getCharacter((LivingEntity)damager);
                if (character3.hasEffectType(EffectType.SUMMON)) {
                    return this.getSummonerPlayer(character3);
                }
            } else if (damager instanceof Firework && Properties.SUBVERSION > 13 && (fireworkCrossbowerName = FireworkUtil.getFireworkCrossbowerName((Firework)damager)) != null && (player = this.plugin.getServer().getPlayer(fireworkCrossbowerName)) != null) {
                return player;
            }
        } else if (event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK && event.getEntity() instanceof LivingEntity && (character = this.plugin.getCharacterManager().getCharacter((LivingEntity)event.getEntity())).hasEffect("Combust")) {
            return ((CombustEffect)character.getEffect("Combust")).getApplier();
        }
        return null;
    }

    private Player getSummonerPlayer(CharacterTemplate character) {
        for (Effect effect : character.getEffects()) {
            if (!(effect instanceof Summon)) continue;
            Summon summonEffect = (Summon)((Object)effect);
            return summonEffect.getSummoner().getPlayer();
        }
        Heroes.log(Level.WARNING, "HEntityListener: Tried to retrieve a summoned entity's owner hero, but could not find one. Heroes at risk for a possible null pointer exception.");
        return null;
    }

    private void awardKillExp(Hero attacker, LivingEntity defender) {
        if (defender == null) {
            return;
        }
        Properties prop = Heroes.properties;
        double addedExp = 0.0;
        HeroClass.ExperienceType experienceType = null;
        if (attacker.isAlliedTo(defender)) {
            return;
        }
        if (defender instanceof Player) {
            Util.deaths.put(defender.getName(), defender.getLocation());
            addedExp = prop.playerKillingExp;
            int aLevel = attacker.getTieredLevel(false);
            int dLevel = this.plugin.getCharacterManager().getHero((Player)defender).getTieredLevel(false);
            addedExp *= this.findExpAdjustment(aLevel, dLevel);
            experienceType = HeroClass.ExperienceType.PVP;
        } else {
            Monster monster = this.plugin.getCharacterManager().getMonster(defender);
            addedExp = monster.getExperience();
            if (addedExp == -1.0 && !prop.creatureKillingExp.containsKey(defender.getType())) {
                return;
            }
            if (addedExp == -1.0) {
                addedExp = prop.creatureKillingExp.get(defender.getType());
            }
            experienceType = HeroClass.ExperienceType.KILLING;
            if (prop.noSpawnCamp && monster.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                addedExp *= prop.spawnCampExpMult;
            }
        }
        if (experienceType != null && addedExp > 0.0) {
            if (attacker.hasParty()) {
                attacker.getParty().gainExp(addedExp, experienceType, defender.getLocation());
            } else if (attacker.canGain(experienceType)) {
                attacker.gainExp(addedExp, experienceType, defender.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity defender = event.getEntity();
        Player attacker = this.getAttackerPlayer(defender.getLastDamageCause());
        CharacterManager characterManager = this.plugin.getCharacterManager();
        CharacterTemplate defenderCT = characterManager.getCharacter(defender);
        event.setDroppedExp(0);
        if (attacker != null) {
            HeroKillCharacterEvent hkc = new HeroKillCharacterEvent(defenderCT, characterManager.getHero(attacker));
            Bukkit.getPluginManager().callEvent((Event)hkc);
        }
        if (attacker != null && !attacker.equals(defender)) {
            Hero hero = characterManager.getHero(attacker);
            this.awardKillExp(hero, defender);
        }
        defenderCT.silentClearEffects(false);
        if (defender instanceof Player) {
            Player player = (Player)defender;
            Hero heroDefender = (Hero)defenderCT;
            Util.deaths.put(player.getName(), event.getEntity().getLocation());
            heroDefender.cancelDelayedSkill();
            heroDefender.clearSummons();
            double multiplier = Heroes.properties.expLoss;
            if (attacker != null) {
                multiplier = Heroes.properties.pvpExpLossMultiplier;
            }
            if (heroDefender.isInCombat()) {
                if (defender.getLastDamageCause() != null && defender.getLastDamageCause().getCause() != EntityDamageEvent.DamageCause.SUICIDE) {
                    heroDefender.leaveCombat(CombatEffect.LeaveCombatReason.DEATH);
                } else {
                    heroDefender.leaveCombat(CombatEffect.LeaveCombatReason.SUICIDE);
                }
            }
            heroDefender.loseExpFromDeath(multiplier, attacker != null);
        } else {
            this.plugin.getCharacterManager().removeMonster(defenderCT.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        CharacterTemplate entityCT = this.plugin.getCharacterManager().getCharacter((LivingEntity)event.getEntity());
        if (entityCT.hasEffectType(EffectType.DISABLE)) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero((Player)event.getTarget());
        for (Effect effect : hero.getEffects()) {
            if (!effect.isType(EffectType.INVIS) && !effect.isType(EffectType.INVULNERABILITY)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        double modifier = 0.0;
        for (Effect effect : hero.getEffects()) {
            if (effect.isType(EffectType.HEALING_AMPLIFIER)) {
                if (!(effect instanceof HealthRegainAmplifier)) continue;
                modifier += ((Double)((HealthRegainAmplifier)((Object)effect)).getDelta()).doubleValue();
                continue;
            }
            if (!effect.isType(EffectType.HEALING_REDUCTION) || !(effect instanceof HealthRegainReduction)) continue;
            modifier -= ((Double)((HealthRegainReduction)((Object)effect)).getDelta()).doubleValue();
        }
        event.setAmount(event.getAmount() * (1.0 + modifier));
        if (!hero.hasParty()) {
            return;
        }
        HeroParty party = hero.getParty();
        if (event.getAmount() > 0.0) {
            party.update();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSelfHeal(CharacterRegainHealthEvent event) {
        if (event.getHealer() == null) {
            return;
        }
        if (event.getCharacter().getEntity().equals(event.getHealer().getEntity())) {
            event.setDelta(Heroes.properties.selfHeal * (Double)event.getDelta());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onDurabilityLossReduceArmorDamage(PlayerItemDamageEvent event) {
        if (event.getDamage() < 1 || !Util.armors.contains(event.getItem().getType().name())) {
            return;
        }
        if (Heroes.properties.armorDurabilityDamageReduction > 1) {
            int newDamage = event.getDamage() < Heroes.properties.armorDurabilityDamageReduction ? 1 : event.getDamage() / Heroes.properties.armorDurabilityDamageReduction;
            event.setDamage(newDamage);
        } else if (Heroes.properties.armorDurabilityDamageReduction < 0) {
            event.setDamage(0);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamageEarly(EntityDamageEvent event) {
        Entity damager;
        Entity entity;
        if (event.getEntity() instanceof LivingEntity) {
            this.plugin.getCharacterManager().getCharacter((LivingEntity)event.getEntity());
        }
        if (event instanceof EntityDamageByEntityEvent && (entity = ((EntityDamageByEntityEvent)event).getDamager()) instanceof LivingEntity) {
            this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        }
        if (event.getEntity() instanceof Player && event instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)event).getDamager()) instanceof Projectile && event.getEntity() == ((Projectile)damager).getShooter()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        CombatEffect.CombatReason reason;
        Hero hero;
        Entity entity = event.getEntity();
        if (event.getDamage() == 0.0 || entity.isDead() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity defender = (LivingEntity)entity;
        Player attacker = this.getAttackerPlayer(event);
        if (attacker != null) {
            hero = this.plugin.getCharacterManager().getHero(attacker);
            if (hero.isInCombatWith(defender)) {
                hero.refreshCombat();
            } else {
                reason = defender instanceof Player ? CombatEffect.CombatReason.ATTACKED_PLAYER : CombatEffect.CombatReason.ATTACKED_MOB;
                this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, defender, reason));
                hero.enterCombatWith(defender, reason);
            }
            if (hero.hasEffect("FoodHeal")) {
                hero.removeEffect(hero.getEffect("FoodHeal"));
            }
            if (hero.hasEffect("Root")) {
                hero.removeEffect(hero.getEffect("Root"));
            }
            if (attacker.isInsideVehicle()) {
                attacker.eject();
            }
        }
        if (defender instanceof Player) {
            hero = this.plugin.getCharacterManager().getHero((Player)defender);
            if (attacker != null) {
                if (hero.isInCombatWith((LivingEntity)attacker)) {
                    hero.refreshCombat();
                } else {
                    reason = CombatEffect.CombatReason.DAMAGED_BY_PLAYER;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, (LivingEntity)attacker, reason));
                    hero.enterCombatWith((LivingEntity)attacker, reason);
                }
            }
            if (hero.hasEffect("FoodHeal")) {
                hero.removeEffect(hero.getEffect("FoodHeal"));
            }
            if (defender.isInsideVehicle()) {
                defender.eject();
            }
        }
        if (event.getEntityType() == EntityType.HORSE) {
            for (Entity passenger : entity.getPassengers()) {
                if (!(passenger instanceof Player)) continue;
                AbstractHorse horse = (AbstractHorse)event.getEntity();
                if (!(event.getFinalDamage() > 0.5 * horse.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())) break;
                passenger.sendMessage("Your mount has suffered too much damage and has fled.");
                entity.eject();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreatureSpawnEarly(CreatureSpawnEvent event) {
        Monster.applyHealthChanges(event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawnLate(CreatureSpawnEvent event) {
        LivingEntity living = event.getEntity();
        living.setMetadata("Heroes: Spawn Reason", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getSpawnReason()));
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            ((LivingEntity)event.getEntity()).setMaximumNoDamageTicks(Heroes.properties.noDamageTicks);
        }
    }

    private double findExpAdjustment(int aLevel, int dLevel) {
        int diff = aLevel - dLevel;
        if (Math.abs(diff) <= Heroes.properties.pvpExpRange) {
            return 1.0;
        }
        if (diff >= Heroes.properties.pvpMaxExpRange) {
            return 0.0;
        }
        if (diff <= -Heroes.properties.pvpMaxExpRange) {
            return 2.0;
        }
        if (diff > 0) {
            return 1.0 - (double)((diff - Heroes.properties.pvpExpRange) / Heroes.properties.pvpMaxExpRange);
        }
        if (diff < 0) {
            return 1.0 + (double)((Math.abs(diff) - Heroes.properties.pvpExpRange) / Heroes.properties.pvpMaxExpRange);
        }
        return 1.0;
    }
}

