/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.HeroAttackDamageCause;
import com.herocraftonline.heroes.api.HeroDamageCause;
import com.herocraftonline.heroes.api.HeroSkillDamageCause;
import com.herocraftonline.heroes.api.SkillUseInfo;
import com.herocraftonline.heroes.api.events.CharacterDamageEvent;
import com.herocraftonline.heroes.api.events.SkillDamageEvent;
import com.herocraftonline.heroes.api.events.WeaponDamageEvent;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.CustomNameManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.interfaces.Burning;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.characters.skill.VisualEffect;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.ui.EntityHealthDisplay;
import com.herocraftonline.heroes.util.ArmorUtil;
import com.herocraftonline.heroes.util.FireworkUtil;
import com.herocraftonline.heroes.util.Pair;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.RegionUtil;
import com.herocraftonline.heroes.util.Util;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class HDamageListener
implements Listener {
    public static final String FIRED_BOW_META_KEY = "hero-fired-bow";
    public static final String PROJECTILE_FORCE_META_KEY = "hero-fired-bow-force";
    public static final String PROJECTILE_DAMAGE_META_KEY = "hero-original-damage";
    public static final String FOOD_HEAL_EFFECT = "FoodHeal";
    private final Heroes plugin;
    private final CharacterDamageManager dm;
    private final Map<EntityDamageEvent.DamageCause, DamageCauseHandler> handlers;
    private final InvulnTickChecker invulnChecker;
    private final DamageCauseHandler skillHandler;
    private final DamageCauseHandler unhandled;
    private String durabilityPrefix;

    public HDamageListener(final Heroes plugin) {
        this.plugin = plugin;
        this.dm = plugin.getDamageManager();
        this.invulnChecker = new InvulnTickChecker();
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)this.invulnChecker, 1L, 1L);
        this.handlers = new EnumMap<EntityDamageEvent.DamageCause, DamageCauseHandler>(EntityDamageEvent.DamageCause.class);
        BasicHandler flatHandler = new BasicHandler(false);
        this.handlers.put(EntityDamageEvent.DamageCause.CONTACT, flatHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.LIGHTNING, new BasicHandler(false, EffectType.RESIST_LIGHTNING));
        this.handlers.put(EntityDamageEvent.DamageCause.POISON, new BasicHandler(false, EffectType.RESIST_POISON));
        this.handlers.put(EntityDamageEvent.DamageCause.WITHER, new BasicHandler(false, EffectType.RESIST_WITHER));
        final BasicHandler percentHandler = new BasicHandler(true);
        this.handlers.put(EntityDamageEvent.DamageCause.DROWNING, new BasicHandler(true, EffectType.WATER_BREATHING));
        this.handlers.put(EntityDamageEvent.DamageCause.MELTING, percentHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.SUFFOCATION, percentHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.VOID, percentHandler);
        ScaledHandler scaledHandler = new ScaledHandler(new EffectType[0]);
        this.handlers.put(EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, scaledHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, new ScaledHandler(new EffectType[0]){

            @Override
            public void handle(EntityDamageEvent event) {
                if (event.getEntity() instanceof LivingEntity && event instanceof EntityDamageByEntityEvent) {
                    EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)event;
                    Entity damager = entityDamageByEntityEvent.getDamager();
                    if (damager instanceof Creeper && plugin.getDamageManager().isCreeperDamageOverridden()) {
                        Creeper creeper = (Creeper)damager;
                        Monster monster = plugin.getCharacterManager().getMonster((LivingEntity)creeper);
                        event.setDamage(monster.getDamage());
                        return;
                    }
                    if (damager instanceof Firework) {
                        String fireworkCrossbowerName;
                        LivingEntity defender = (LivingEntity)event.getEntity();
                        Firework firework = (Firework)damager;
                        boolean fireworkFromDispenser = FireworkUtil.fireworkWasDispensed(firework);
                        CharacterTemplate targetCT = plugin.getCharacterManager().getCharacter(defender);
                        if (targetCT.hasEffectType(EffectType.RESIST_FIREWORK_EXPLOSION) && !fireworkFromDispenser) {
                            event.setCancelled(true);
                            return;
                        }
                        Hero attacker = null;
                        if (Properties.SUBVERSION > 13 && !fireworkFromDispenser && (fireworkCrossbowerName = FireworkUtil.getFireworkCrossbowerName(firework)) != null) {
                            attacker = HDamageListener.this.getHeroFromPlayerName(plugin, fireworkCrossbowerName);
                        }
                        Double damage = null;
                        if (attacker != null) {
                            Double projectileDamage = HDamageListener.this.dm.getHighestProjectileDamage(attacker, CharacterDamageManager.ProjectileType.CROSSBOW_FIREWORK_ROCKET, !(defender instanceof Player), event.getDamage());
                            if (projectileDamage != null) {
                                damage = projectileDamage;
                            }
                        } else {
                            damage = plugin.getDamageManager().getItemDamage(Material.FIREWORK_ROCKET);
                        }
                        if (damage == null || damage <= 0.0) {
                            event.setCancelled(true);
                        } else {
                            event.setDamage(damage.doubleValue());
                        }
                        return;
                    }
                }
                super.handle(event);
            }
        });
        this.handlers.put(EntityDamageEvent.DamageCause.FALL, new ScaledHandler(EffectType.SAFEFALL));
        this.handlers.put(EntityDamageEvent.DamageCause.FALLING_BLOCK, scaledHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.MAGIC, scaledHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.THORNS, scaledHandler);
        this.handlers.put(EntityDamageEvent.DamageCause.FIRE, new PercentFireHandler(EntityDamageEvent.DamageCause.FIRE_TICK));
        this.handlers.put(EntityDamageEvent.DamageCause.FIRE_TICK, new FireTickHandler());
        this.handlers.put(EntityDamageEvent.DamageCause.LAVA, new PercentFireHandler(EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK));
        this.handlers.put(EntityDamageEvent.DamageCause.STARVATION, new DamageCauseHandler(false){

            @Override
            public void handle(EntityDamageEvent event) {
                if (Heroes.properties.foodEnabled) {
                    event.setCancelled(true);
                } else {
                    percentHandler.handle(event);
                }
            }
        });
        this.handlers.put(EntityDamageEvent.DamageCause.SUICIDE, new DamageCauseHandler(false){

            @Override
            public void handle(EntityDamageEvent event) {
                if (event.getEntity() instanceof Player) {
                    Player player = (Player)event.getEntity();
                    if (player.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
                        Entity lastDamager = ((EntityDamageByEntityEvent)player.getLastDamageCause()).getDamager();
                        player.setLastDamageCause((EntityDamageEvent)new EntityDamageByEntityEvent(lastDamager, (Entity)player, EntityDamageEvent.DamageCause.ENTITY_ATTACK, player.getHealth()));
                        player.damage(player.getHealth(), lastDamager);
                        event.setCancelled(true);
                    } else {
                        event.setDamage(player.getHealth());
                    }
                }
            }
        });
        DamageCauseHandler direct = new DamageCauseHandler(true){

            @Override
            public void handle(EntityDamageEvent event) {
                Projectile projectile;
                if (event.getDamage() == 0.0) {
                    return;
                }
                Entity attacker = null;
                Entity defender = null;
                if (event instanceof EntityDamageByEntityEvent) {
                    attacker = ((EntityDamageByEntityEvent)event).getDamager();
                    defender = event.getEntity();
                }
                CharacterDamageManager.EquippedWeaponStats equippedWeapon = null;
                CharacterTemplate character = null;
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    character = plugin.getCharacterManager().getCharacter((LivingEntity)player);
                    Hero hero = (Hero)character;
                    equippedWeapon = hero.getEquippedWeaponStats();
                    float reach = equippedWeapon.getReach();
                    if (Heroes.properties.useExperimentalFeatures && (double)reach < 3.0 && attacker.getLocation().distance(defender.getLocation()) > (double)reach) {
                        event.setCancelled(true);
                        event.setDamage(0.0);
                        return;
                    }
                    if (!(defender instanceof LivingEntity)) {
                        return;
                    }
                    if (hero.isAlliedTo((LivingEntity)defender)) {
                        return;
                    }
                    if (character.hasEffect(HDamageListener.FOOD_HEAL_EFFECT)) {
                        character.removeEffect(character.getEffect(HDamageListener.FOOD_HEAL_EFFECT));
                    }
                    if (hero.hasEffectType(EffectType.STUN) || !hero.resolveWeapon()) {
                        event.setCancelled(true);
                        return;
                    }
                    ItemStack mainhand = player.getInventory().getItemInMainHand();
                    Double newDamage = equippedWeapon.getFinalDamage();
                    newDamage = newDamage + HDamageListener.this.getExtraEnchantDamage(mainhand, (LivingEntity)defender);
                    newDamage = newDamage * HDamageListener.this.dm.getHighestMultiplier(hero, !(defender instanceof Player));
                    if (Heroes.properties.considerWeaponSwingCooldownForDamage) {
                        newDamage = newDamage * NMSHandler.getInterface().getCooldownDamageMultiplier((Player)attacker);
                    }
                    event.setDamage(newDamage.doubleValue());
                } else if (attacker instanceof LivingEntity) {
                    character = plugin.getCharacterManager().getMonster((LivingEntity)attacker);
                    double monsterDamage = ((Monster)character).getDamage();
                    event.setDamage(monsterDamage);
                } else if (attacker instanceof Projectile && (projectile = (Projectile)attacker).getShooter() instanceof LivingEntity) {
                    attacker = (Entity)projectile.getShooter();
                    character = plugin.getCharacterManager().getCharacter((LivingEntity)attacker);
                    if (attacker instanceof Player) {
                        boolean fromCrossbow;
                        Double projectileDamage;
                        if (character.hasEffect(HDamageListener.FOOD_HEAL_EFFECT)) {
                            character.removeEffect(character.getEffect(HDamageListener.FOOD_HEAL_EFFECT));
                        }
                        ItemStack weapon = projectile.hasMetadata(HDamageListener.FIRED_BOW_META_KEY) ? (ItemStack)((MetadataValue)projectile.getMetadata(HDamageListener.FIRED_BOW_META_KEY).get(0)).value() : null;
                        double extraDamage = 0.0;
                        if (weapon != null && weapon.getType().equals((Object)Material.BOW)) {
                            extraDamage = HDamageListener.this.getExtraBowDamage(weapon);
                        }
                        if ((projectileDamage = HDamageListener.this.dm.getHighestProjectileDamage((Hero)character, CharacterDamageManager.ProjectileType.valueOf((Entity)projectile, fromCrossbow = weapon != null && Properties.SUBVERSION > 13 && weapon.getType().equals((Object)Material.CROSSBOW)), !(event.getEntity() instanceof Player), event.getDamage())) != null) {
                            projectileDamage = projectileDamage + extraDamage;
                            float force = projectile.hasMetadata(HDamageListener.PROJECTILE_FORCE_META_KEY) ? ((Float)((MetadataValue)projectile.getMetadata(HDamageListener.PROJECTILE_FORCE_META_KEY).get(0)).value()).floatValue() : 1.0f;
                            event.setDamage((double)force * projectileDamage);
                        }
                    } else if (projectile.getType() != EntityType.ARROW) {
                        event.setDamage(((Monster)character).getDamage());
                    }
                }
                double rawDamage = event.getDamage();
                double penetrationAmount = 0.0;
                if (Heroes.properties.useExperimentalFeatures) {
                    if (attacker instanceof Player) {
                        float penetration = equippedWeapon.getPenetration();
                        if (penetration > 0.0f && defender instanceof LivingEntity) {
                            penetrationAmount = rawDamage * (double)penetration;
                            event.setDamage(rawDamage - penetrationAmount);
                        }
                    } else if (attacker instanceof Projectile) {
                        Projectile projectile2 = (Projectile)attacker;
                        attacker = (Entity)projectile2.getShooter();
                    }
                }
                if (defender instanceof LivingEntity) {
                    LivingEntity livingDefender = (LivingEntity)event.getEntity();
                    if (Heroes.properties.mitigationEnabled && ArmorUtil.isGlobalMitigationOverrideApplicableTo(event.getCause())) {
                        event.setDamage(event.getDamage() - ArmorUtil.getCustomArmorMitigation(livingDefender, event));
                    }
                    event.setDamage(event.getDamage() - ArmorUtil.getEnchantMitigation(livingDefender, event.getCause()) + penetrationAmount);
                }
                if (character != null && !event.isCancelled()) {
                    WeaponDamageEvent weaponDamageEvent = new WeaponDamageEvent(rawDamage, (EntityDamageByEntityEvent)event, character);
                    plugin.getServer().getPluginManager().callEvent((Event)weaponDamageEvent);
                    if (weaponDamageEvent.isCancelled()) {
                        event.setCancelled(true);
                        return;
                    }
                    event.setDamage(weaponDamageEvent.getDamage());
                }
                if (defender instanceof Player) {
                    Hero hero = plugin.getCharacterManager().getHero((Player)event.getEntity());
                    hero.setLastDamageCause(new HeroAttackDamageCause(event.getDamage(), event.getCause(), attacker));
                }
            }

            private double getPreviousDamageModifiers(double originalEventDamage, double currentEventDamage, String s) {
                if (originalEventDamage > 0.0 && originalEventDamage != currentEventDamage) {
                    double modifier = currentEventDamage / originalEventDamage;
                    Heroes.log(Level.INFO, s + modifier);
                    return modifier;
                }
                return 1.0;
            }
        };
        this.handlers.put(EntityDamageEvent.DamageCause.ENTITY_ATTACK, direct);
        this.handlers.put(EntityDamageEvent.DamageCause.PROJECTILE, direct);
        this.skillHandler = new DamageCauseHandler(true){

            @Override
            public void handle(EntityDamageEvent event) {
                Entity defender = event.getEntity();
                EntityDamageEvent.DamageCause cause = event.getCause();
                Skill skill = HDamageListener.this.dm.getSpellTargetInfo(defender).getSkill();
                boolean isDirect = cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK || cause == EntityDamageEvent.DamageCause.PROJECTILE;
                boolean isPiercing = skill.isType(SkillType.ARMOR_PIERCING);
                if (isDirect && event.getDamage() == 0.0) {
                    return;
                }
                SkillUseInfo skillInfo = HDamageListener.this.dm.removeSpellTarget(defender);
                CharacterTemplate defenderCT = null;
                if (defender instanceof LivingEntity) {
                    defenderCT = plugin.getCharacterManager().getCharacter((LivingEntity)defender);
                }
                if (defender instanceof Player && !isDirect && !isPiercing) {
                    event.setDamage(event.getDamage() * (1.0 - ((Hero)defenderCT).getMagicResistsValue()));
                }
                if (event instanceof EntityDamageByEntityEvent) {
                    if (defender instanceof LivingEntity && HDamageListener.this.resistanceCheck(defenderCT, skill)) {
                        if (defenderCT.hasEffectType(EffectType.SILENT_ACTIONS)) {
                            if (defender instanceof Player) {
                                defender.sendMessage(ChatColor.WHITE + CustomNameManager.getName(defender) + ChatColor.GRAY + " has resisted " + ChatColor.WHITE + skill.getName());
                            }
                        } else {
                            skill.broadcast(defender.getLocation(), "$1 has resisted $2", CustomNameManager.getName(defender), skill.getName());
                        }
                        event.setCancelled(true);
                        return;
                    }
                    SkillDamageEvent skillDamageEvent = new SkillDamageEvent(event.getDamage(), defender, skillInfo);
                    plugin.getServer().getPluginManager().callEvent((Event)skillDamageEvent);
                    if (skillDamageEvent.isCancelled()) {
                        event.setCancelled(true);
                        return;
                    }
                    event.setDamage(skillDamageEvent.getDamage());
                    if (defender instanceof LivingEntity) {
                        if (!isPiercing) {
                            LivingEntity defenderLE = (LivingEntity)defender;
                            if (Heroes.properties.mitigationEnabled && ArmorUtil.isGlobalMitigationOverrideApplicableTo(event.getCause())) {
                                event.setDamage(event.getDamage() - ArmorUtil.getCustomArmorMitigation(defenderLE, event));
                            } else if (isDirect) {
                                event.setDamage(NMSHandler.getInterface().getPostArmorDamage((LivingEntity)defender, event.getDamage()));
                            }
                            event.setDamage(event.getDamage() - ArmorUtil.getEnchantMitigation(defenderLE, event.getCause()));
                        }
                        if (defender instanceof Player) {
                            HeroSkillDamageCause damageCause = new HeroSkillDamageCause(event.getDamage(), cause, (Entity)skillInfo.getCharacter().getEntity(), skill);
                            ((Hero)defenderCT).setLastDamageCause(damageCause);
                        }
                    }
                    if (Heroes.properties.skillsCauseDamageToArmor && defender instanceof Player) {
                        Player defenderPlayer = (Player)defender;
                        for (ItemStack armorPiece : defenderPlayer.getInventory().getArmorContents()) {
                            if (armorPiece == null || !Util.armors.contains(armorPiece.getType().name())) continue;
                            Util.manuallyDamageItemDurability(defenderPlayer, armorPiece, 1);
                        }
                    }
                }
            }
        };
        if (Properties.SUBVERSION >= 9) {
            this.handlers.put(EntityDamageEvent.DamageCause.DRAGON_BREATH, direct);
            this.handlers.put(EntityDamageEvent.DamageCause.FLY_INTO_WALL, scaledHandler);
        }
        if (Properties.SUBVERSION >= 10) {
            this.handlers.put(EntityDamageEvent.DamageCause.HOT_FLOOR, new PercentFireHandler(new EntityDamageEvent.DamageCause[0]));
        }
        if (Properties.SUBVERSION >= 11) {
            this.handlers.put(EntityDamageEvent.DamageCause.CRAMMING, percentHandler);
        }
        if (Properties.SUBVERSION > 12) {
            this.handlers.put(EntityDamageEvent.DamageCause.DRYOUT, new BasicHandler(false));
        }
        this.unhandled = new DamageCauseHandler(false){

            @Override
            public void handle(EntityDamageEvent event) {
            }
        };
    }

    @Nullable
    private Hero getHeroFromPlayerName(Heroes plugin, String fireworkCrossbowerName) {
        Hero hero = null;
        Player player = plugin.getServer().getPlayer(fireworkCrossbowerName);
        if (player != null) {
            hero = plugin.getCharacterManager().getHero(player);
        }
        return hero;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFireworkDispensed(BlockDispenseEvent event) {
        if (event.getItem().getType() != Material.FIREWORK_ROCKET) {
            return;
        }
        ItemStack itemStack = event.getItem();
        FireworkUtil.setFireworkFromDispenser(itemStack);
        event.setItem(itemStack);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFireworkDamage(EntityDamageByEntityEvent event) {
        Firework firework;
        if (event.getDamager() instanceof Firework && VisualEffect.isInstantFirework(firework = (Firework)event.getDamager())) {
            event.setDamage(0.0);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        LivingEntity defender;
        Entity entity = event.getEntity();
        EntityDamageEvent.DamageCause cause = event.getCause();
        boolean cancelled = event.isCancelled();
        DamageCauseHandler handler = this.dm.isSpellTarget(entity) ? this.skillHandler : this.handlers.getOrDefault(cause, this.unhandled);
        handler.handle(event);
        if (event.isCancelled()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            defender = (LivingEntity)entity;
        } else if (entity instanceof ComplexEntityPart) {
            defender = ((ComplexEntityPart)entity).getParent();
        } else {
            return;
        }
        double originalLastDamage = defender.getLastDamage();
        if (defender.isDead() || defender.getHealth() <= 0.0) {
            event.setCancelled(true);
            return;
        }
        LivingEntity attacker = null;
        if (event instanceof EntityDamageByEntityEvent && (attacker = this.getAttacker(event)) != null) {
            Monster attackerMonster;
            CharacterTemplate attackerCT = this.plugin.getCharacterManager().getCharacter(attacker);
            if (attackerCT.isAlliedTo(defender)) {
                cancelled = true;
            } else if (attackerCT instanceof Monster && defender instanceof Player && (attackerMonster = (Monster)attackerCT).isSummonedMob() && (RegionUtil.IsNoPvPRegion(defender) || RegionUtil.IsNoPvPRegion(attacker)) && !attackerMonster.getSummoner().isInCombatWith(defender)) {
                attackerMonster.setTargetIfAble(null, false);
                cancelled = true;
            }
        }
        if (!cancelled && defender instanceof Player) {
            Player defenderPlayer = (Player)defender;
            if (defenderPlayer.getGameMode() == GameMode.CREATIVE) {
                cancelled = true;
            }
            Hero defenderHero = this.plugin.getCharacterManager().getHero(defenderPlayer);
            defenderHero.resolveCurrentEquipment();
            if (!cancelled && defenderHero.hasEffectType(EffectType.INVULNERABILITY)) {
                cancelled = true;
            }
            Hero attackerHero = null;
            if (!cancelled && event instanceof EntityDamageByEntityEvent && attacker instanceof Player) {
                int heroLevel;
                attackerHero = this.plugin.getCharacterManager().getHero((Player)attacker);
                int aLevel = attackerHero.getTieredLevel(false);
                if (Math.abs(aLevel - (heroLevel = defenderHero.getTieredLevel(false))) > Heroes.properties.pvpLevelRange) {
                    attacker.sendMessage(ChatColor.GRAY + "That player is outside of your level range!");
                    cancelled = true;
                }
                if (!cancelled && heroLevel < Heroes.properties.minPvpLevel || aLevel < Heroes.properties.minPvpLevel) {
                    attacker.sendMessage(ChatColor.GRAY + "You or your target is not a high enough level to PvP!");
                    cancelled = true;
                }
            }
            if (!cancelled && !handler.handlesApi()) {
                CharacterDamageEvent damageEvent = new CharacterDamageEvent(entity, cause, event.getDamage());
                Bukkit.getPluginManager().callEvent((Event)damageEvent);
                if (damageEvent.isCancelled()) {
                    cancelled = true;
                } else {
                    event.setDamage(damageEvent.getDamage() < 0.0 ? 0.0 : damageEvent.getDamage());
                }
            }
            if (defender.getNoDamageTicks() > defender.getMaximumNoDamageTicks() / 2) {
                if (event.getDamage() > defender.getLastDamage()) {
                    cancelled = true;
                } else {
                    event.setDamage(defender.getLastDamage() - event.getDamage());
                }
            }
            if (!cancelled && event.getDamage() > 0.0) {
                if (defenderHero.hasEffect(FOOD_HEAL_EFFECT)) {
                    defenderHero.removeEffect(defenderHero.getEffect(FOOD_HEAL_EFFECT));
                }
                if (!defender.equals(attacker)) {
                    for (Effect effect : defenderHero.getEffects()) {
                        if (!effect.isType(EffectType.ROOT) && !effect.isType(EffectType.INVIS) || effect.isType(EffectType.UNBREAKABLE)) continue;
                        defenderHero.removeEffect(effect);
                    }
                }
                if (!handler.handlesApi()) {
                    defenderHero.setLastDamageCause(new HeroDamageCause(event.getDamage(), cause));
                }
                defenderHero.setLastDamageTaken(System.currentTimeMillis());
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (!defenderHero.getPlayer().isDead()) {
                        defenderHero.renderVisualComponents();
                    }
                    if (defenderHero.getParty() != null) {
                        defenderHero.getParty().update();
                    }
                });
            }
        } else if (attacker != null) {
            Monster defenderMonster = this.plugin.getCharacterManager().getMonster(defender);
            if (defenderMonster.isSummonedMob() && RegionUtil.IsNoPvPRegion(attacker) && !defenderMonster.getSummoner().isInCombatWith(attacker)) {
                cancelled = true;
            }
            if (defender.getNoDamageTicks() > defender.getMaximumNoDamageTicks() / 2) {
                if (event.getDamage() > defender.getLastDamage()) {
                    cancelled = true;
                } else {
                    event.setDamage(defender.getLastDamage() - event.getDamage());
                }
            }
        }
        if (!cancelled && attacker instanceof Player) {
            Hero attackerHero = this.plugin.getCharacterManager().getHero((Player)attacker);
            for (Monster summon : attackerHero.getSummons()) {
                summon.setTargetIfAble(defender);
            }
        }
        if (!cancelled && Heroes.properties.displayEntityHealth) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> EntityHealthDisplay.render(defender));
        }
        event.setCancelled(cancelled);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void handleFinalEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Hero attackerHero;
        float knockback;
        if (!Heroes.properties.useExperimentalFeatures || event.isCancelled()) {
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause cause = event.getCause();
        if ((cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK || cause == EntityDamageEvent.DamageCause.PROJECTILE) && defender.getType() != EntityType.ARMOR_STAND && !this.dm.isSpellTarget(defender) && attacker instanceof Player && defender instanceof LivingEntity && (knockback = (attackerHero = this.plugin.getCharacterManager().getHero((Player)attacker)).getCurrentEquippedWeapon().getKnockback() * (Heroes.properties.considerWeaponSwingCooldownForDamage ? (float)NMSHandler.getInterface().getCooldownDamageMultiplier((Player)attacker) : 1.0f)) != 0.5f && defender.getLocation().distance(attacker.getLocation()) <= 3.0) {
            defender.setVelocity(Util.calculateDifferentialKnockback((LivingEntity)defender, (LivingEntity)attacker, knockback));
        }
    }

    private LivingEntity getAttacker(EntityDamageEvent event) {
        Player player;
        String fireworkCrossbowerName;
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return null;
        }
        EntityDamageByEntityEvent actualEvent = (EntityDamageByEntityEvent)event;
        Entity attacker = actualEvent.getDamager();
        if (attacker instanceof Projectile && ((Projectile)attacker).getShooter() instanceof LivingEntity) {
            attacker = (Entity)((Projectile)attacker).getShooter();
        } else if (attacker instanceof Firework && Properties.SUBVERSION > 13 && (fireworkCrossbowerName = FireworkUtil.getFireworkCrossbowerName((Firework)attacker)) != null && (player = this.plugin.getServer().getPlayer(fireworkCrossbowerName)) != null) {
            attacker = player;
        }
        if (!(attacker instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)attacker;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onShootArrow(EntityShootBowEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        ItemStack bowItem = event.getBow();
        if (bowItem != null && Properties.SUBVERSION > 13 && bowItem.getType().equals((Object)Material.CROSSBOW) && event.getProjectile() instanceof Firework) {
            FireworkUtil.setFireworkFromCrossbower((Firework)event.getProjectile(), (Player)event.getEntity());
        }
        event.getProjectile().setMetadata(FIRED_BOW_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)bowItem));
        event.getProjectile().setMetadata(PROJECTILE_FORCE_META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Float.valueOf(event.getForce())));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Arrow projectile;
        double damage;
        if (event.getEntityType() != EntityType.ARROW || event.getEntityType() != EntityType.TRIDENT) {
            return;
        }
        EntityType entityType = event.getEntityType();
        if (entityType == EntityType.ARROW) {
            Arrow arrow = (Arrow)event.getEntity();
            damage = arrow.getDamage();
            projectile = arrow;
        } else {
            Trident trident = (Trident)event.getEntity();
            damage = trident.getDamage();
            projectile = trident;
        }
        ProjectileSource source = event.getEntity().getShooter();
        if (source instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)source;
            boolean handled = true;
            switch (shooter.getType()) {
                case PLAYER: {
                    return;
                }
                case SKELETON: 
                case STRAY: 
                case ZOMBIE: 
                case ZOMBIE_VILLAGER: 
                case HUSK: 
                case DROWNED: {
                    damage = this.plugin.getCharacterManager().getMonster(shooter).getDamage();
                    break;
                }
                default: {
                    handled = false;
                }
            }
            if (!handled) {
                switch (shooter.getType().name()) {
                    case "PILLAGER": 
                    case "ILLUSIONER": 
                    case "PIG_ZOMBIE": 
                    case "ZOMBIFIED_PIGLIN": 
                    case "PIGLIN": {
                        damage = this.plugin.getCharacterManager().getMonster(shooter).getDamage();
                        break;
                    }
                }
            }
        } else {
            Double environmental = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.PROJECTILE);
            if (environmental != null) {
                damage = environmental;
            }
        }
        if (entityType == EntityType.ARROW) {
            projectile.setDamage(damage);
        } else if (entityType == EntityType.TRIDENT) {
            ((Trident)projectile).setDamage(damage);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        if (event.getAffectedEntities().isEmpty() || !(event.getPotion().getShooter() instanceof Player)) {
            return;
        }
        if (!Heroes.properties.modifySplashPotionsEffectedEntitiesEnabled) {
            return;
        }
        boolean remove = false;
        boolean positive = false;
        for (PotionEffect effect : event.getPotion().getEffects()) {
            switch (effect.getType().getId()) {
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 28: {
                    positive = true;
                    remove = true;
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 15: 
                case 18: 
                case 19: {
                    remove = true;
                    break;
                }
            }
        }
        if (remove) {
            boolean protectThrower = Heroes.properties.modifySplashPotionsProtectThrower;
            boolean protectAllies = Heroes.properties.modifySplashPotionsProtectAllies;
            boolean allyOnlyPositiveEffects = Heroes.properties.modifySplashPotionsAllyOnlyPositiveEffects;
            Player thrower = (Player)event.getPotion().getShooter();
            Hero hero = this.plugin.getCharacterManager().getHero(thrower);
            for (LivingEntity le : event.getAffectedEntities()) {
                if (!positive && thrower.equals(le)) {
                    if (!protectThrower && !protectAllies) continue;
                    event.setIntensity(le, 0.0);
                    continue;
                }
                if (!positive && hero.isAlliedTo(le)) {
                    if (!protectAllies) continue;
                    event.setIntensity(le, 0.0);
                    continue;
                }
                if (allyOnlyPositiveEffects && positive && !hero.isAlliedTo(le)) {
                    event.setIntensity(le, 0.0);
                    continue;
                }
                if (Skill.damageCheck(thrower, le)) continue;
                event.setIntensity(le, 0.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        double amount = event.getAmount();
        Player player = (Player)event.getEntity();
        double maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        switch (event.getRegainReason()) {
            case SATIATED: {
                double healPercent = Heroes.properties.foodHealPercent;
                amount = Math.ceil(maxHealth * healPercent);
                break;
            }
            case MAGIC: {
                double healPercent = amount / 6.0;
                amount = Math.ceil(healPercent * Heroes.properties.potHealthPerTier * maxHealth);
                break;
            }
            case CUSTOM: {
                double healPercent = amount / 20.0;
                amount = Math.ceil(maxHealth * healPercent);
                break;
            }
        }
        event.setAmount(amount);
    }

    private boolean resistanceCheck(CharacterTemplate character, Skill skill) {
        if (character.hasEffectType(EffectType.RESIST_FIRE) && skill.isType(SkillType.ABILITY_PROPERTY_FIRE)) {
            return true;
        }
        if (character.hasEffectType(EffectType.RESIST_DARK) && skill.isType(SkillType.ABILITY_PROPERTY_DARK)) {
            return true;
        }
        if (character.hasEffectType(EffectType.RESIST_LIGHT) && skill.isType(SkillType.ABILITY_PROPERTY_LIGHT)) {
            return true;
        }
        if (character.hasEffectType(EffectType.RESIST_LIGHTNING) && skill.isType(SkillType.ABILITY_PROPERTY_LIGHTNING)) {
            return true;
        }
        return character.hasEffectType(EffectType.RESIST_ICE) && skill.isType(SkillType.ABILITY_PROPERTY_ICE);
    }

    private double getExtraEnchantDamage(ItemStack item, LivingEntity target) {
        int amount = 0;
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            Double val = this.dm.getEnchantmentDamage((Enchantment)entry.getKey());
            if (val == null) continue;
            boolean shouldAddExtra = false;
            Enchantment enchantment = (Enchantment)entry.getKey();
            boolean handled = true;
            switch (target.getType().name()) {
                case "DROWNED": 
                case "PIG_ZOMBIE": 
                case "ZOMBIFIED_PIGLIN": 
                case "ZOGLIN": {
                    shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_UNDEAD) || enchantment.equals((Object)Enchantment.DAMAGE_ALL) || enchantment.equals((Object)Enchantment.FIRE_ASPECT) && !target.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                    break;
                }
                case "STRIDER": {
                    shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_ALL);
                    break;
                }
                case "BEE": {
                    shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_ARTHROPODS) || enchantment.equals((Object)Enchantment.DAMAGE_ALL) || enchantment.equals((Object)Enchantment.FIRE_ASPECT) && !target.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                    break;
                }
                default: {
                    handled = false;
                }
            }
            if (!handled) {
                switch (target.getType()) {
                    case BLAZE: {
                        shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_ALL);
                        break;
                    }
                    case CAVE_SPIDER: 
                    case SPIDER: 
                    case SILVERFISH: 
                    case ENDERMITE: {
                        shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_ARTHROPODS) || enchantment.equals((Object)Enchantment.DAMAGE_ALL) || enchantment.equals((Object)Enchantment.FIRE_ASPECT) && !target.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                        break;
                    }
                    case SKELETON: 
                    case STRAY: 
                    case ZOMBIE: 
                    case ZOMBIE_VILLAGER: 
                    case HUSK: 
                    case ZOMBIE_HORSE: 
                    case PHANTOM: {
                        shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_UNDEAD) || enchantment.equals((Object)Enchantment.DAMAGE_ALL) || enchantment.equals((Object)Enchantment.FIRE_ASPECT) && !target.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                        break;
                    }
                    case WITHER_SKELETON: 
                    case WITHER: {
                        shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_UNDEAD) || enchantment.equals((Object)Enchantment.DAMAGE_ALL);
                        break;
                    }
                    default: {
                        boolean bl = shouldAddExtra = enchantment.equals((Object)Enchantment.DAMAGE_ALL) || enchantment.equals((Object)Enchantment.FIRE_ASPECT) && !target.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                    }
                }
            }
            if (!shouldAddExtra) continue;
            amount = (int)((double)amount + val * (double)((Integer)entry.getValue()).intValue());
        }
        return amount;
    }

    private double getExtraBowDamage(ItemStack item) {
        if (item.getType() != Material.BOW) {
            return 0.0;
        }
        double amount = 0.0;
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            Double val = this.dm.getEnchantmentDamage((Enchantment)entry.getKey());
            if (val == null || !((Enchantment)entry.getKey()).equals((Object)Enchantment.ARROW_DAMAGE)) continue;
            amount += val * (double)((Integer)entry.getValue()).intValue();
        }
        return amount;
    }

    private class InvulnTickChecker
    implements Runnable {
        Queue<Pair<LivingEntity, EntityDamageEvent>> queue = new ConcurrentLinkedQueue<Pair<LivingEntity, EntityDamageEvent>>();

        InvulnTickChecker() {
        }

        @Override
        public void run() {
            while (!this.queue.isEmpty()) {
                Pair<LivingEntity, EntityDamageEvent> pair = this.queue.poll();
                if (pair == null || pair.getLeft() == null) continue;
                LivingEntity entity = pair.getLeft();
                EntityDamageEvent event = pair.getRight();
                if (event.isCancelled() || entity.getNoDamageTicks() != entity.getMaximumNoDamageTicks()) continue;
                entity.setNoDamageTicks(0);
            }
        }
    }

    private class BasicHandler
    extends DamageCauseHandler {
        private final boolean isPercentBased;
        private final EffectType[] resists;
        private final EntityDamageEvent.DamageCause[] sharedInvulnCauses;

        public BasicHandler(boolean isPercentBased) {
            this(isPercentBased, new EffectType[0], new EntityDamageEvent.DamageCause[0]);
        }

        public BasicHandler(boolean isPercentBased, EffectType ... resists) {
            this(isPercentBased, resists, new EntityDamageEvent.DamageCause[0]);
        }

        public BasicHandler(boolean isPercentBased, EntityDamageEvent.DamageCause ... sharedInvulnCauses) {
            this(isPercentBased, new EffectType[0], sharedInvulnCauses);
        }

        public BasicHandler(boolean isPercentBased, EffectType[] resists, EntityDamageEvent.DamageCause[] sharedInvulnCauses) {
            super(false);
            this.isPercentBased = isPercentBased;
            this.resists = resists;
            this.sharedInvulnCauses = sharedInvulnCauses;
        }

        @Override
        public void handle(EntityDamageEvent event) {
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            LivingEntity targetLE = (LivingEntity)event.getEntity();
            if (this.isCurrentlyInvuln(event, targetLE)) {
                event.setCancelled(true);
                return;
            }
            EntityDamageEvent.DamageCause cause = event.getCause();
            Double damage = HDamageListener.this.dm.getEnvironmentalDamage(cause);
            if (damage != null) {
                if (damage > 0.0) {
                    this.setDamage(event, targetLE, damage);
                    this.addInvulnFlags(event, targetLE);
                    HDamageListener.this.invulnChecker.queue.add(new Pair<LivingEntity, EntityDamageEvent>(targetLE, event));
                } else {
                    event.setDamage(0.0);
                }
            }
        }

        private void addInvulnFlags(EntityDamageEvent event, LivingEntity targetLE) {
            long currentTime = System.currentTimeMillis();
            String primaryInvulnFlag = this.getInvulnFlagFor(event.getCause());
            targetLE.setMetadata(primaryInvulnFlag, (MetadataValue)new FixedMetadataValue((Plugin)HDamageListener.this.plugin, (Object)currentTime));
            for (EntityDamageEvent.DamageCause otherCause : this.sharedInvulnCauses) {
                String sharedInvulnFlag = this.getInvulnFlagFor(otherCause);
                targetLE.setMetadata(sharedInvulnFlag, (MetadataValue)new FixedMetadataValue((Plugin)HDamageListener.this.plugin, (Object)(currentTime + 51L)));
            }
        }

        private boolean isCurrentlyInvuln(EntityDamageEvent event, LivingEntity targetLE) {
            if (this.isInvulnToCause(targetLE, event.getCause())) {
                return true;
            }
            if (this.resists.length > 0) {
                CharacterTemplate targetCT = HDamageListener.this.plugin.getCharacterManager().getCharacter(targetLE);
                for (EffectType resist : this.resists) {
                    if (!targetCT.hasEffectType(resist)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isInvulnToCause(LivingEntity targetLE, EntityDamageEvent.DamageCause cause) {
            List metaData;
            String invulnFlag = this.getInvulnFlagFor(cause);
            if (targetLE.hasMetadata(invulnFlag) && !(metaData = targetLE.getMetadata(invulnFlag)).isEmpty()) {
                long noDamageMillis;
                long appliedAtMillis = ((MetadataValue)metaData.get(0)).asLong();
                long expireTimeMillis = appliedAtMillis + (noDamageMillis = (long)targetLE.getMaximumNoDamageTicks() * 50L);
                if (expireTimeMillis < System.currentTimeMillis()) {
                    targetLE.removeMetadata(invulnFlag, (Plugin)HDamageListener.this.plugin);
                } else {
                    return true;
                }
            }
            return false;
        }

        protected String getInvulnFlagFor(EntityDamageEvent.DamageCause cause) {
            return cause.name() + "-TickInvuln";
        }

        protected void setDamage(EntityDamageEvent event, LivingEntity entity, double damage) {
            event.setDamage(this.isPercentBased ? damage * entity.getMaxHealth() : (damage -= ArmorUtil.getEnchantMitigation(entity, event.getCause())));
        }
    }

    public class ScaledHandler
    extends BasicHandler {
        public ScaledHandler(EffectType ... resists) {
            super(true, resists);
        }

        @Override
        protected void setDamage(EntityDamageEvent event, LivingEntity entity, double percent) {
            event.setDamage(event.getDamage() * percent * entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        }
    }

    private class PercentFireHandler
    extends BasicHandler {
        public PercentFireHandler(EntityDamageEvent.DamageCause ... sharedInvulnCauses) {
            super(true, new EffectType[]{EffectType.RESIST_FIRE}, sharedInvulnCauses);
        }
    }

    private class FireTickHandler
    extends BasicHandler {
        public FireTickHandler() {
            super(false, EffectType.RESIST_FIRE);
        }

        @Override
        protected void setDamage(EntityDamageEvent event, LivingEntity entity, double damage) {
            damage -= ArmorUtil.getEnchantMitigation(entity, event.getCause());
            CharacterTemplate targetCT = HDamageListener.this.plugin.getCharacterManager().getCharacter(entity);
            for (Effect effect : targetCT.getEffects()) {
                if (!(effect instanceof Burning)) continue;
                Burning burning = (Burning)((Object)effect);
                damage *= burning.getDamageMultiplier();
            }
            event.setDamage(damage);
        }
    }

    public abstract class DamageCauseHandler {
        private final boolean handlesApi;

        public DamageCauseHandler(boolean handlesApi) {
            this.handlesApi = handlesApi;
        }

        public boolean handlesApi() {
            return this.handlesApi;
        }

        public abstract void handle(EntityDamageEvent var1);
    }
}

