/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.util.Properties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class HBlockListener
implements Listener {
    private final Heroes plugin;
    private int blockTrackingDuration = 0;
    public static Map<Location, Long> placedBlocks;

    public HBlockListener(Heroes plugin) {
        this.plugin = plugin;
        this.init();
    }

    public void init() {
        final int maxTrackedBlocks = Heroes.properties.maxTrackedBlocks;
        this.blockTrackingDuration = Heroes.properties.blockTrackingDuration;
        placedBlocks = new LinkedHashMap<Location, Long>(){
            private static final long serialVersionUID = 2623620773233514414L;
            private final int MAX_ENTRIES;
            {
                this.MAX_ENTRIES = maxTrackedBlocks;
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<Location, Long> eldest) {
                return this.size() > this.MAX_ENTRIES || eldest.getValue() + (long)HBlockListener.this.blockTrackingDuration <= System.currentTimeMillis();
            }
        };
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        double newExp;
        Properties prop = Heroes.properties;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        double addedExp = 0.0;
        HeroClass.ExperienceType et = null;
        if (prop.miningExp.containsKey(block.getType())) {
            addedExp = prop.miningExp.get(block.getType());
            et = HeroClass.ExperienceType.MINING;
        }
        if (prop.farmingExp.containsKey(block.getType()) && (newExp = prop.farmingExp.get(block.getType()).doubleValue()) > addedExp) {
            addedExp = newExp;
            et = HeroClass.ExperienceType.FARMING;
        }
        if (prop.loggingExp.containsKey(block.getType()) && (newExp = prop.loggingExp.get(block.getType()).doubleValue()) > addedExp) {
            addedExp = newExp;
            et = HeroClass.ExperienceType.LOGGING;
        }
        if (addedExp == 0.0) {
            return;
        }
        if (this.wasBlockPlaced(block)) {
            if (hero.isVerboseExp() && hero.hasExperienceType(et)) {
                player.sendMessage(ChatColor.GRAY + "No experience gained - block placed too recently.");
            }
            placedBlocks.remove(block.getLocation());
            return;
        }
        if (hero.hasParty()) {
            hero.getParty().gainExp(addedExp, et, block.getLocation());
        } else if (hero.canGain(et)) {
            hero.gainExp(addedExp, et, block.getLocation().add(0.5, 0.0, 0.5));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        ArrayList<Location> movedBlocks = new ArrayList<Location>();
        for (Block block : event.getBlocks()) {
            if (!placedBlocks.containsKey(block.getLocation())) continue;
            movedBlocks.add(block.getLocation());
        }
        int x = event.getDirection().getModX();
        int y = event.getDirection().getModY();
        int z = event.getDirection().getModZ();
        Long time = System.currentTimeMillis();
        for (Location loc : movedBlocks) {
            placedBlocks.put(loc.clone().add((double)x, (double)y, (double)z), time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Location loc = event.getBlock().getLocation();
        if (placedBlocks.containsKey(loc)) {
            placedBlocks.remove(loc);
            placedBlocks.put(event.getBlock().getRelative(event.getDirection()).getLocation(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Material material = block.getType();
        Properties prop = Heroes.properties;
        if (prop.buildingExp.containsKey(material)) {
            Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
            if (hero.hasExperienceType(HeroClass.ExperienceType.BUILDING) && !hero.hasParty()) {
                hero.gainExp(prop.buildingExp.get(material), HeroClass.ExperienceType.BUILDING, block.getLocation().add(0.5, 1.0, 0.5));
            } else if (hero.hasParty()) {
                hero.getParty().gainExp(prop.buildingExp.get(material), HeroClass.ExperienceType.BUILDING, block.getLocation());
            }
        }
        if (prop.miningExp.containsKey(material) || prop.loggingExp.containsKey(material) || prop.farmingExp.containsKey(material)) {
            placedBlocks.put(block.getLocation().clone(), System.currentTimeMillis());
        }
    }

    private boolean wasBlockPlaced(Block block) {
        Location location = block.getLocation();
        if (placedBlocks.containsKey(location)) {
            long timePlaced = placedBlocks.get(location);
            if (timePlaced + (long)this.blockTrackingDuration > System.currentTimeMillis()) {
                return true;
            }
            placedBlocks.remove(location);
            return false;
        }
        return false;
    }
}

