/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ExperienceChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.common.ExpBoostEffect;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permission;

public class ExpBoostListener
implements Listener {
    private static final String BASE_NODE = "heroes.premium.exp-boost.";
    private static final int[] BOOST_PERCENTAGE_VALUES = new int[]{5, 10, 15, 25, 35, 50, 75, 100, 150, 200, 250, 500, 1000};
    private static final Map<UUID, Double> multipliers;

    @Deprecated
    public static double getCurrentBoost(Player player) {
        return multipliers.getOrDefault(player.getUniqueId(), 1.0);
    }

    public static double getCurrentBoost(Hero hero) {
        return ExpBoostListener.getCurrentBoost(hero, true);
    }

    public static double getCurrentBoost(Hero hero, boolean includeTransient) {
        Player player = hero.getPlayer();
        double multiplier = multipliers.getOrDefault(player.getUniqueId(), 1.0);
        if (includeTransient && hero.hasEffect(ExpBoostEffect.getEffectName())) {
            ExpBoostEffect effect = (ExpBoostEffect)hero.getEffect(ExpBoostEffect.getEffectName());
            assert (effect != null);
            if (effect.shouldStack()) {
                multiplier *= effect.getExpMultiplier();
            } else if (multiplier < effect.getExpMultiplier()) {
                multiplier = effect.getExpMultiplier();
            }
        }
        return multiplier;
    }

    public static boolean hasTransientBoost(Hero hero) {
        return hero.hasEffect(ExpBoostEffect.getEffectName());
    }

    @Nullable
    public static ExpBoostEffect getTransientBoostEffect(Hero hero) {
        return (ExpBoostEffect)hero.getEffect(ExpBoostEffect.getEffectName());
    }

    public static void reloadBoost(Player player) {
        double multiplier = 1.0;
        for (int i = 0; i < BOOST_PERCENTAGE_VALUES.length; ++i) {
            if (!player.hasPermission(BASE_NODE + BOOST_PERCENTAGE_VALUES[i])) continue;
            multiplier = 1.0 + (double)BOOST_PERCENTAGE_VALUES[i] / 100.0;
        }
        multipliers.put(player.getUniqueId(), multiplier);
    }

    public static void reloadAllBoosts() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            ExpBoostListener.reloadBoost(player);
        }
    }

    public ExpBoostListener(Heroes plugin) {
        for (int percentageValue : BOOST_PERCENTAGE_VALUES) {
            plugin.getServer().getPluginManager().addPermission(new Permission(BASE_NODE + percentageValue));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        ExpBoostListener.reloadBoost(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onExperienceChange(ExperienceChangeEvent event) {
        if (event.getExpChange() > 0.0) {
            Hero hero = event.getHero();
            try {
                if (multipliers.isEmpty()) {
                    return;
                }
                double multiplier = 1.0;
                UUID key = hero.getPlayer().getUniqueId();
                if (multipliers.containsKey(key)) {
                    multiplier *= multipliers.get(key).doubleValue();
                }
                if (hero.hasEffect(ExpBoostEffect.getEffectName())) {
                    ExpBoostEffect effect = (ExpBoostEffect)hero.getEffect(ExpBoostEffect.getEffectName());
                    assert (effect != null);
                    if (effect.shouldStack()) {
                        multiplier *= effect.getExpMultiplier();
                    } else if (multiplier < effect.getExpMultiplier()) {
                        multiplier = effect.getExpMultiplier();
                    }
                }
                if (multiplier > 1.0) {
                    event.setExpGain(event.getExpChange() * multiplier);
                }
            }
            catch (Exception e) {
                String reasonString = "Other";
                if (hero == null) {
                    reasonString = "null Hero";
                } else if (hero.getPlayer() == null) {
                    reasonString = "null Player";
                } else if (hero.getPlayer().getUniqueId() == null) {
                    reasonString = "null UUID";
                }
                Heroes.log(Level.WARNING, "Could not apply boost to player. Reason: " + reasonString);
                e.printStackTrace();
            }
        }
    }

    static {
        Arrays.sort(BOOST_PERCENTAGE_VALUES);
        multipliers = new HashMap<UUID, Double>();
    }
}

