/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.items.ComplexItemMatcher;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class DurabilityConfig
implements ConfigurationSerializable {
    public static final String MATCHER_SERIALIZATION_KEY = "matcher";
    public static final String MAX_DURABILITY_SERIALIZATION_KEY = "max-durability";
    private final ComplexItemMatcher matcher;
    private final int maxDurability;

    public DurabilityConfig(ComplexItemMatcher matcher, int maxDurability) {
        this.matcher = matcher;
        this.maxDurability = maxDurability;
    }

    public DurabilityConfig(Map<String, Object> serialized) {
        this.matcher = (ComplexItemMatcher)serialized.getOrDefault(MATCHER_SERIALIZATION_KEY, new ComplexItemMatcher("", ""));
        this.maxDurability = (Integer)serialized.getOrDefault(MAX_DURABILITY_SERIALIZATION_KEY, 0);
    }

    public ComplexItemMatcher getMatcher() {
        return this.matcher;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> mapSerializer = new HashMap<String, Object>();
        mapSerializer.put(MATCHER_SERIALIZATION_KEY, this.matcher.serialize());
        mapSerializer.put(MAX_DURABILITY_SERIALIZATION_KEY, this.maxDurability);
        return mapSerializer;
    }
}

