/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.listeners.DurabilityConfig;
import com.herocraftonline.heroes.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomDurabilityManager
implements Listener {
    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern DURABILITY_MATCH_PATTERN = Pattern.compile("([0-9]+) / ([0-9]+)");
    private static final String DURABILITY_PREFIX = "Durability: ";
    private static final String HIDDEN_DURABILITY_PREFIX = CustomDurabilityManager.hideText("Durability: ");
    private final Heroes plugin;
    private final boolean isCustomDurabilityHidden;
    private final boolean syncWithVanillaDurability;
    private final HashMap<Integer, List<DurabilityConfig>> configMap = new HashMap();

    public CustomDurabilityManager(Heroes plugin) {
        this.plugin = plugin;
        this.isCustomDurabilityHidden = !Heroes.properties.showCustomDurabilityText;
        this.syncWithVanillaDurability = Heroes.properties.syncWithMinecraftDurability;
        List<DurabilityConfig> configs = Heroes.properties.durabilityMatchConfigs;
        if (configs == null) {
            Heroes.log(Level.WARNING, "Custom Heroes Durability Management is enabled but no match item match configuration was found in config.yml");
            configs = new ArrayList<DurabilityConfig>();
        } else {
            Heroes.log(Level.WARNING, "Initializing Custom Durability Listener. Config Count: " + configs.size());
        }
        this.configMap.put(0, configs.stream().filter(x -> x.getMatcher().hasBothMatches()).collect(Collectors.toList()));
        this.configMap.put(1, configs.stream().filter(x -> x.getMatcher().hasNameMatch()).collect(Collectors.toList()));
        this.configMap.put(2, configs.stream().filter(x -> x.getMatcher().hasTypeMatch()).collect(Collectors.toList()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void applyCustomDurability(PlayerItemDamageEvent event) {
        this.updateCustomDurability(event);
    }

    public int getMaxDurabilityForItem(ItemStack item) {
        for (int i = 0; i < this.configMap.size(); ++i) {
            for (DurabilityConfig config : this.configMap.get(i)) {
                if (!config.getMatcher().isAMatch(item)) continue;
                return config.getMaxDurability();
            }
        }
        return Math.max(item.getType().getMaxDurability(), Heroes.properties.defaultCustomMaxDurability);
    }

    public void updateCustomDurability(PlayerItemDamageEvent event) {
        int newDurability;
        int maxDurability;
        if (event.getDamage() < 1) {
            return;
        }
        ItemStack item = event.getItem();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ArrayList<String> allLore = itemMeta.getLore();
        if (allLore == null) {
            allLore = new ArrayList<String>();
        }
        int durabilityLoreIndex = -1;
        for (String lore : allLore) {
            if (!lore.contains(HIDDEN_DURABILITY_PREFIX) && !lore.contains(DURABILITY_PREFIX)) continue;
            durabilityLoreIndex = allLore.indexOf(lore);
            break;
        }
        boolean isBreakingItem = false;
        if (durabilityLoreIndex > -1) {
            String duraLoreString = this.parseLore((String)allLore.get(durabilityLoreIndex));
            Matcher matcher = DURABILITY_MATCH_PATTERN.matcher(duraLoreString);
            if (matcher.find()) {
                String duraMatch = matcher.group(1);
                String maxMatch = matcher.group(2);
                int currDurability = Integer.parseInt(duraMatch);
                maxDurability = Integer.parseInt(maxMatch);
                newDurability = currDurability - event.getDamage();
            } else {
                maxDurability = this.getMaxDurabilityForItem(item);
                newDurability = maxDurability - event.getDamage();
            }
            durabilityString = this.buildDurabilityString(newDurability, maxDurability);
            allLore.set(durabilityLoreIndex, durabilityString);
        } else {
            maxDurability = this.getMaxDurabilityForItem(item);
            double vanillaPercent = (double)this.getVanillaDurability(item) / (double)item.getType().getMaxDurability();
            newDurability = (int)((double)maxDurability * vanillaPercent) - event.getDamage();
            durabilityString = this.buildDurabilityString(newDurability, maxDurability);
            allLore.add(durabilityString);
        }
        if (newDurability < 1) {
            isBreakingItem = true;
        }
        if (isBreakingItem) {
            event.setDamage(999);
            int vanillaDurability = this.getVanillaDurability(item);
            if (vanillaDurability <= 0) {
                Util.forcefullyBreakItem(item);
            }
            return;
        }
        if (this.syncWithVanillaDurability) {
            int adjustedVanillaDurability;
            double customDuraPercent = (double)newDurability / (double)maxDurability;
            short vanillaMax = item.getType().getMaxDurability();
            int vanillaItemDamage = vanillaMax - (adjustedVanillaDurability = (int)(customDuraPercent * (double)vanillaMax)) - event.getDamage();
            if (vanillaItemDamage > vanillaMax) {
                vanillaItemDamage = vanillaMax - 1;
            }
            if (itemMeta instanceof Damageable && ((Damageable)itemMeta).getDamage() != vanillaItemDamage) {
                ((Damageable)itemMeta).setDamage(vanillaItemDamage);
            }
        } else if (itemMeta instanceof Damageable && ((Damageable)itemMeta).getDamage() != 0) {
            ((Damageable)itemMeta).setDamage(0);
        }
        itemMeta.setLore(allLore);
        item.setItemMeta(itemMeta);
    }

    public boolean repairItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        return this.repairItem(item, itemMeta);
    }

    public boolean repairItem(ItemStack item, @Nonnull ItemMeta itemMeta) {
        ArrayList<String> allLore = itemMeta.getLore();
        if (allLore == null) {
            allLore = new ArrayList<String>();
        }
        int durabilityLoreIndex = -1;
        for (String lore : allLore) {
            if (!lore.contains(HIDDEN_DURABILITY_PREFIX) && !lore.contains(DURABILITY_PREFIX)) continue;
            durabilityLoreIndex = allLore.indexOf(lore);
            break;
        }
        if (durabilityLoreIndex > -1) {
            int maxDurability;
            String duraLoreString = this.parseLore((String)allLore.get(durabilityLoreIndex));
            Matcher matcher = DURABILITY_MATCH_PATTERN.matcher(duraLoreString);
            if (matcher.find()) {
                String maxMatch = matcher.group(2);
                maxDurability = Integer.parseInt(maxMatch);
            } else {
                maxDurability = this.getMaxDurabilityForItem(item);
            }
            int newDurability = maxDurability;
            String durabilityString = this.buildDurabilityString(newDurability, maxDurability);
            allLore.set(durabilityLoreIndex, durabilityString);
        } else {
            int maxDurability;
            int newDurability = maxDurability = this.getMaxDurabilityForItem(item);
            String durabilityString = this.buildDurabilityString(newDurability, maxDurability);
            allLore.add(durabilityString);
        }
        if (itemMeta instanceof Damageable && ((Damageable)itemMeta).getDamage() != 0) {
            ((Damageable)itemMeta).setDamage(0);
        }
        itemMeta.setLore(allLore);
        item.setItemMeta(itemMeta);
        return true;
    }

    private String parseLore(String loreString) {
        if (this.isCustomDurabilityHidden) {
            return CustomDurabilityManager.stripColor(loreString);
        }
        return loreString;
    }

    @Nonnull
    private String buildDurabilityString(int newDurability, int maxDurability) {
        String durabilityText = DURABILITY_PREFIX + newDurability + " / " + maxDurability;
        if (this.isCustomDurabilityHidden) {
            return CustomDurabilityManager.hideText(durabilityText);
        }
        return ChatColor.GRAY + durabilityText;
    }

    @Nonnull
    private static String hideText(String input) {
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            builder.append('\u00a7').append(c);
        }
        return builder.toString();
    }

    @Nonnull
    private static String stripColor(String input) {
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (c == '\u00a7') continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private int getVanillaDurability(ItemStack item) {
        return item.getType().getMaxDurability() - ((Damageable)item.getItemMeta()).getDamage();
    }
}

