/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class StaminaRegenAttribute
extends BaseStatAttribute<StaminaRegenAttribute> {
    private static final HealthStatType STAT_TYPE = new HealthStatType();
    private Value<Integer> appliedStaminaRegen;

    public StaminaRegenAttribute(Item item, String name, Value<Integer> appliedStaminaRegen) {
        super(item, name, HeroAttributeTypes.STAMINA_REGEN, STAT_TYPE);
        this.appliedStaminaRegen = appliedStaminaRegen;
    }

    public int getAppliedStaminaRegen() {
        return this.appliedStaminaRegen.getValue();
    }

    @Override
    public StatSpecifier<StaminaRegenAttribute> getStatSpecifier() {
        return new StatSpecifier.All<StaminaRegenAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.appliedStaminaRegen.saveToNBT(compound);
    }

    private static class HealthStatType
    implements StatType<StaminaRegenAttribute> {
        private HealthStatType() {
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.TOP;
        }

        @Override
        public StatTotal<StaminaRegenAttribute> newTotal(StatSpecifier<StaminaRegenAttribute> statSpecifier) {
            return new StatTotal<StaminaRegenAttribute>(statSpecifier){
                private int appliedStaminaRegen;

                @Override
                public void addStat(StaminaRegenAttribute healthAttribute) {
                    this.appliedStaminaRegen += healthAttribute.getAppliedStaminaRegen();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + ChatColor.YELLOW + (this.appliedStaminaRegen < 0 ? "-" : "") + this.appliedStaminaRegen + "Stamina Regen");
                }

                @Override
                public boolean shouldAddLore() {
                    return this.appliedStaminaRegen != 0;
                }
            };
        }

        @Override
        public void addTo(List<String> list, Map<StatSpecifier<StaminaRegenAttribute>, StatTotal<StaminaRegenAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(list, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<StaminaRegenAttribute> {
        private static final StoredValue<Integer> APPLIED_STAMINA_REGEN = new StoredValue<Integer>("applied-stamina-regen", StoredValue.INTEGER, 0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public StaminaRegenAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Integer> appliedStaminaRegen = APPLIED_STAMINA_REGEN.loadFromConfig(item, config);
            return new StaminaRegenAttribute(item, name, appliedStaminaRegen);
        }

        @Override
        public StaminaRegenAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Integer> appliedStaminaRegen = APPLIED_STAMINA_REGEN.loadFromNBT(item, compound);
            return new StaminaRegenAttribute(item, name, appliedStaminaRegen);
        }
    }
}

