/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class StaminaCostAttribute
extends BaseStatAttribute<StaminaCostAttribute> {
    public static final int MIN_STAMINA_COST = 0;
    private static final StaminaStatType STAT_TYPE = new StaminaStatType();
    private Value<Integer> staminaCost;

    public StaminaCostAttribute(Item item, String name, Value<Integer> staminaCost) {
        super(item, name, HeroAttributeTypes.STAMINA_COST, STAT_TYPE);
        this.staminaCost = staminaCost;
    }

    public int getStaminaCost() {
        return this.staminaCost.getValue();
    }

    @Override
    public StatSpecifier<StaminaCostAttribute> getStatSpecifier() {
        return new StatSpecifier.All<StaminaCostAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.staminaCost.saveToNBT(compound);
    }

    public static class StaminaStatType
    implements StatType<StaminaCostAttribute> {
        @Override
        public StatType.Position getPosition() {
            return StatType.Position.BOTTOM;
        }

        @Override
        public StatTotal<StaminaCostAttribute> newTotal(StatSpecifier<StaminaCostAttribute> statSpecifier) {
            return new StatTotal<StaminaCostAttribute>(statSpecifier){
                private int staminaCost;

                @Override
                public void addStat(StaminaCostAttribute stat) {
                    this.staminaCost += stat.getStaminaCost();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + ChatColor.YELLOW + "Stamina Cost: " + this.staminaCost);
                }

                @Override
                public boolean shouldAddLore() {
                    return this.staminaCost > 0;
                }
            };
        }

        @Override
        public void addTo(List<String> lore, Map<StatSpecifier<StaminaCostAttribute>, StatTotal<StaminaCostAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(lore, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<StaminaCostAttribute> {
        private static final StoredValue<Integer> STAMINA_COST = new StoredValue<Integer>("stamina-cost", StoredValue.INTEGER, 0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public StaminaCostAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Integer> staminaCost = STAMINA_COST.loadFromConfig(item, config);
            return new StaminaCostAttribute(item, name, staminaCost);
        }

        @Override
        public StaminaCostAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Integer> staminaCost = STAMINA_COST.loadFromNBT(item, compound);
            return new StaminaCostAttribute(item, name, staminaCost);
        }
    }
}

