/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class StaminaAttribute
extends BaseStatAttribute<StaminaAttribute> {
    private static final StaminaStatType STAT_TYPE = new StaminaStatType();
    private Value<Integer> appliedStamina;

    public StaminaAttribute(Item item, String name, Value<Integer> appliedStamina) {
        super(item, name, HeroAttributeTypes.STAMINA, STAT_TYPE);
        this.appliedStamina = appliedStamina;
    }

    public int getAppliedStamina() {
        return this.appliedStamina.getValue();
    }

    @Override
    public StatSpecifier<StaminaAttribute> getStatSpecifier() {
        return new StatSpecifier.All<StaminaAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.appliedStamina.saveToNBT(compound);
    }

    private static class StaminaStatType
    implements StatType<StaminaAttribute> {
        private StaminaStatType() {
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.TOP;
        }

        @Override
        public StatTotal<StaminaAttribute> newTotal(StatSpecifier<StaminaAttribute> statSpecifier) {
            return new StatTotal<StaminaAttribute>(statSpecifier){
                private int appliedStamina;

                @Override
                public void addStat(StaminaAttribute healthAttribute) {
                    this.appliedStamina += healthAttribute.getAppliedStamina();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + ChatColor.YELLOW + (this.appliedStamina < 0 ? "-" : "") + this.appliedStamina + "Stamina");
                }

                @Override
                public boolean shouldAddLore() {
                    return this.appliedStamina != 0;
                }
            };
        }

        @Override
        public void addTo(List<String> list, Map<StatSpecifier<StaminaAttribute>, StatTotal<StaminaAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(list, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<StaminaAttribute> {
        private static final StoredValue<Integer> APPLIED_STAMINA = new StoredValue<Integer>("applied-stamina", StoredValue.INTEGER, 0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public StaminaAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Integer> appliedStamina = APPLIED_STAMINA.loadFromConfig(item, config);
            return new StaminaAttribute(item, name, appliedStamina);
        }

        @Override
        public StaminaAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Integer> appliedStamina = APPLIED_STAMINA.loadFromNBT(item, compound);
            return new StaminaAttribute(item, name, appliedStamina);
        }
    }
}

