/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class ManaRegenAttribute
extends BaseStatAttribute<ManaRegenAttribute> {
    private static final ManaRegenStatType STAT_TYPE = new ManaRegenStatType();
    private Value<Integer> appliedManaRegen;

    public ManaRegenAttribute(Item item, String name, Value<Integer> appliedManaRegen) {
        super(item, name, HeroAttributeTypes.MANA_REGEN, STAT_TYPE);
        this.appliedManaRegen = appliedManaRegen;
    }

    public int getAppliedManaRegen() {
        return this.appliedManaRegen.getValue();
    }

    @Override
    public StatSpecifier<ManaRegenAttribute> getStatSpecifier() {
        return new StatSpecifier.All<ManaRegenAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.appliedManaRegen.saveToNBT(compound);
    }

    private static class ManaRegenStatType
    implements StatType<ManaRegenAttribute> {
        private ManaRegenStatType() {
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.TOP;
        }

        @Override
        public StatTotal<ManaRegenAttribute> newTotal(StatSpecifier<ManaRegenAttribute> statSpecifier) {
            return new StatTotal<ManaRegenAttribute>(statSpecifier){
                private int appliedManaRegen;

                @Override
                public void addStat(ManaRegenAttribute healthAttribute) {
                    this.appliedManaRegen += healthAttribute.getAppliedManaRegen();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + ChatColor.BLUE + (this.appliedManaRegen < 0 ? "-" : "") + this.appliedManaRegen + "Mana Regen");
                }

                @Override
                public boolean shouldAddLore() {
                    return this.appliedManaRegen != 0;
                }
            };
        }

        @Override
        public void addTo(List<String> list, Map<StatSpecifier<ManaRegenAttribute>, StatTotal<ManaRegenAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(list, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<ManaRegenAttribute> {
        private static final StoredValue<Integer> APPLIED_MANA_REGEN = new StoredValue<Integer>("applied-mana-regen", StoredValue.INTEGER, 0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public ManaRegenAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Integer> appliedManaRegen = APPLIED_MANA_REGEN.loadFromConfig(item, config);
            return new ManaRegenAttribute(item, name, appliedManaRegen);
        }

        @Override
        public ManaRegenAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Integer> appliedManaRegen = APPLIED_MANA_REGEN.loadFromNBT(item, compound);
            return new ManaRegenAttribute(item, name, appliedManaRegen);
        }
    }
}

