/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class ManaAttribute
extends BaseStatAttribute<ManaAttribute> {
    private static final ManaStatType STAT_TYPE = new ManaStatType();
    private Value<Integer> appliedMana;

    public ManaAttribute(Item item, String name, Value<Integer> appliedMana) {
        super(item, name, HeroAttributeTypes.MANA, STAT_TYPE);
        this.appliedMana = appliedMana;
    }

    public int getAppliedMana() {
        return this.appliedMana.getValue();
    }

    @Override
    public StatSpecifier<ManaAttribute> getStatSpecifier() {
        return new StatSpecifier.All<ManaAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.appliedMana.saveToNBT(compound);
    }

    private static class ManaStatType
    implements StatType<ManaAttribute> {
        private ManaStatType() {
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.TOP;
        }

        @Override
        public StatTotal<ManaAttribute> newTotal(StatSpecifier<ManaAttribute> statSpecifier) {
            return new StatTotal<ManaAttribute>(statSpecifier){
                private int appliedMana;

                @Override
                public void addStat(ManaAttribute healthAttribute) {
                    this.appliedMana += healthAttribute.getAppliedMana();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + ChatColor.BLUE + (this.appliedMana < 0 ? "-" : "") + this.appliedMana + "Mana");
                }

                @Override
                public boolean shouldAddLore() {
                    return this.appliedMana != 0;
                }
            };
        }

        @Override
        public void addTo(List<String> list, Map<StatSpecifier<ManaAttribute>, StatTotal<ManaAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(list, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<ManaAttribute> {
        private static final StoredValue<Integer> APPLIED_MANA = new StoredValue<Integer>("applied-mana", StoredValue.INTEGER, 0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public ManaAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Integer> appliedMana = APPLIED_MANA.loadFromConfig(item, config);
            return new ManaAttribute(item, name, appliedMana);
        }

        @Override
        public ManaAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Integer> appliedHealth = APPLIED_MANA.loadFromNBT(item, compound);
            return new ManaAttribute(item, name, appliedHealth);
        }
    }
}

