/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class HealthAttribute
extends BaseStatAttribute<HealthAttribute> {
    private static final HealthStatType STAT_TYPE = new HealthStatType();
    private Value<Double> appliedHealth;

    public HealthAttribute(Item item, String name, Value<Double> appliedHealth) {
        super(item, name, HeroAttributeTypes.HEALTH, STAT_TYPE);
        this.appliedHealth = appliedHealth;
    }

    public double getAppliedHealth() {
        return this.appliedHealth.getValue();
    }

    @Override
    public StatSpecifier<HealthAttribute> getStatSpecifier() {
        return new StatSpecifier.All<HealthAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.appliedHealth.saveToNBT(compound);
    }

    private static class HealthStatType
    implements StatType<HealthAttribute> {
        private HealthStatType() {
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.TOP;
        }

        @Override
        public StatTotal<HealthAttribute> newTotal(StatSpecifier<HealthAttribute> statSpecifier) {
            return new StatTotal<HealthAttribute>(statSpecifier){
                private double appliedHealth;

                @Override
                public void addStat(HealthAttribute healthAttribute) {
                    this.appliedHealth += healthAttribute.getAppliedHealth();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    lore.add(prefix + ChatColor.RED + (this.appliedHealth < 0.0 ? "-" : "") + this.appliedHealth + "Health");
                }

                @Override
                public boolean shouldAddLore() {
                    return this.appliedHealth != 0.0;
                }
            };
        }

        @Override
        public void addTo(List<String> list, Map<StatSpecifier<HealthAttribute>, StatTotal<HealthAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(list, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<HealthAttribute> {
        private static final StoredValue<Double> APPLIED_HEALTH = new StoredValue<Double>("applied-health", StoredValue.DOUBLE, 0.0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public HealthAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Double> appliedHealth = APPLIED_HEALTH.loadFromConfig(item, config);
            return new HealthAttribute(item, name, appliedHealth);
        }

        @Override
        public HealthAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Double> appliedHealth = APPLIED_HEALTH.loadFromNBT(item, compound);
            return new HealthAttribute(item, name, appliedHealth);
        }
    }
}

