/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class DamageAttribute
extends BaseStatAttribute<DamageAttribute> {
    private static HeroDamageStatType STAT_TYPE = new HeroDamageStatType();
    private Value<Double> damage;
    private Value<Double> maxDamage;

    public DamageAttribute(Item item, String name, Value<Double> damage, Value<Double> maxDamage) {
        super(item, name, HeroAttributeTypes.DAMAGE, STAT_TYPE);
        this.damage = damage;
        this.maxDamage = maxDamage;
    }

    public double getDamage() {
        return this.damage.getValue();
    }

    public OptionalDouble getMaxDamage() {
        return this.maxDamage != null ? OptionalDouble.of(this.maxDamage.getValue()) : OptionalDouble.empty();
    }

    @Override
    public StatSpecifier<DamageAttribute> getStatSpecifier() {
        return new StatSpecifier.All<DamageAttribute>();
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        this.damage.saveToNBT(compound);
        if (this.maxDamage != null) {
            this.maxDamage.saveToNBT(compound);
        }
    }

    private static class HeroDamageStatType
    implements StatType<DamageAttribute> {
        private HeroDamageStatType() {
        }

        @Override
        public StatType.Position getPosition() {
            return StatType.Position.TOP;
        }

        @Override
        public StatTotal<DamageAttribute> newTotal(StatSpecifier<DamageAttribute> statSpecifier) {
            return new StatTotal<DamageAttribute>(statSpecifier){
                private double damage;
                private double maxDamage;

                @Override
                public void addStat(DamageAttribute damageAttribute) {
                    double damage = damageAttribute.getDamage();
                    double maxDamage = damageAttribute.getMaxDamage().orElse(damage);
                    if (maxDamage < damage) {
                        maxDamage = damage;
                    }
                    this.damage += damage;
                    this.maxDamage += maxDamage;
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    if (this.damage == this.maxDamage) {
                        lore.add(prefix + ChatColor.BLUE + "Damage: " + this.damage);
                    } else {
                        lore.add(prefix + ChatColor.BLUE + "Damage: " + this.damage + "-" + this.maxDamage);
                    }
                }

                @Override
                public boolean shouldAddLore() {
                    return this.damage > 0.0 || this.maxDamage > 0.0;
                }
            };
        }

        @Override
        public void addTo(List<String> lore, Map<StatSpecifier<DamageAttribute>, StatTotal<DamageAttribute>> stats) {
            stats.values().forEach(total -> total.addTo(lore, ""));
        }
    }

    public static class Factory
    extends BaseAttributeFactory<DamageAttribute> {
        private static final StoredValue<Double> DAMAGE = new StoredValue<Double>("damage", StoredValue.DOUBLE, 0.0);
        private static final StoredValue<Double> MAX_DAMAGE = new StoredValue<Double>("max-damage", StoredValue.DOUBLE, 0.0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public DamageAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            Value<Double> damage = DAMAGE.loadFromConfig(item, config);
            Value<Double> maxDamage = null;
            if (config.contains("max-damage")) {
                maxDamage = MAX_DAMAGE.loadFromConfig(item, config);
            }
            return new DamageAttribute(item, name, damage, maxDamage);
        }

        @Override
        public DamageAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            Value<Double> damage = DAMAGE.loadFromNBT(item, compound);
            Value<Double> maxDamage = null;
            if (compound.hasKey("max-damage")) {
                maxDamage = MAX_DAMAGE.loadFromNBT(item, compound);
            }
            return new DamageAttribute(item, name, damage, maxDamage);
        }
    }
}

