/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.requirements.Requirement;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.nbt.NBTTagList;
import com.herocraftonline.items.api.storage.nbt.NBTTagString;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ClassRequirementAttribute
extends BaseAttribute<ClassRequirementAttribute>
implements Requirement<ClassRequirementAttribute> {
    private Collection<String> classes;

    public ClassRequirementAttribute(Item item, String name, Collection<String> classes) {
        super(item, name, HeroAttributeTypes.CLASS_REQUIREMENT);
        this.classes = classes;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    @Override
    public boolean test(Player player, Item item) {
        Hero hero = Heroes.getInstance().getCharacterManager().getHero(player);
        if (hero == null) {
            return false;
        }
        Collection<String> classes = this.getClasses();
        if (classes.isEmpty()) {
            return true;
        }
        String primary = hero.getHeroClass().getName();
        HeroClass secondary = hero.getSecondaryClass();
        return classes.contains(primary) || secondary != null && classes.contains(secondary.getName());
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        Collection<String> classes = this.getClasses();
        NBTTagList classList = NBTTagList.create();
        for (String className : classes) {
            classList.addBase(NBTTagString.create(className));
        }
        compound.setBase("classes", classList);
    }

    public static class Factory
    extends BaseAttributeFactory<ClassRequirementAttribute> {
        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public ClassRequirementAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            HashSet<String> classes = new HashSet<String>();
            if (config.isString("class")) {
                classes.add(config.getString("class"));
            } else if (config.isString("classes")) {
                classes.add(config.getString("classes"));
            } else if (config.isList("classes")) {
                classes.addAll(config.getStringList("classes"));
            }
            return new ClassRequirementAttribute(item, name, classes);
        }

        @Override
        public ClassRequirementAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            HashSet<String> classes = new HashSet<String>();
            NBTTagList classList = compound.getList("classes", 8);
            for (int i = 0; i < classList.size(); ++i) {
                classes.add(classList.getString(i));
            }
            return new ClassRequirementAttribute(item, name, classes);
        }
    }
}

