/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items.attributes;

import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.items.HeroAttributeTypes;
import com.herocraftonline.items.api.ItemPlugin;
import com.herocraftonline.items.api.item.Item;
import com.herocraftonline.items.api.item.attribute.attributes.base.BaseAttributeFactory;
import com.herocraftonline.items.api.item.attribute.attributes.stats.BaseStatAttribute;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatSpecifier;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatTotal;
import com.herocraftonline.items.api.item.attribute.attributes.stats.StatType;
import com.herocraftonline.items.api.storage.nbt.NBTTagCompound;
import com.herocraftonline.items.api.storage.value.StoredValue;
import com.herocraftonline.items.api.storage.value.Value;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class AttributeAttribute
extends BaseStatAttribute<AttributeAttribute> {
    private static final AttributeStatType STAT_TYPE = new AttributeStatType();
    private AttributeType attributeType;
    private Value<Integer> attributeValue;

    public AttributeAttribute(Item item, String name, AttributeType attributeType, Value<Integer> attributeValue) {
        super(item, name, HeroAttributeTypes.ATTRIBUTE, STAT_TYPE);
        this.attributeType = attributeType;
        this.attributeValue = attributeValue;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public int getAttributeValue() {
        return this.attributeValue.getValue();
    }

    @Override
    public StatSpecifier<AttributeAttribute> getStatSpecifier() {
        return new HeroAttributeStatSpecifier(this.attributeType);
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        super.saveToNBT(compound);
        compound.setString("attribute-type", this.attributeType.name());
        this.attributeValue.saveToNBT(compound);
    }

    public static class AttributeStatType
    implements StatType<AttributeAttribute> {
        @Override
        public StatType.Position getPosition() {
            return StatType.Position.BOTTOM;
        }

        @Override
        public StatTotal<AttributeAttribute> newTotal(StatSpecifier<AttributeAttribute> specifier) {
            return new StatTotal<AttributeAttribute>(specifier){
                int attributeValue;
                {
                    super(arg0);
                    this.attributeValue = 0;
                }

                @Override
                public void addStat(AttributeAttribute stat) {
                    this.attributeValue += stat.getAttributeValue();
                }

                @Override
                public void addTo(List<String> lore, String prefix) {
                    HeroAttributeStatSpecifier specifier = (HeroAttributeStatSpecifier)this.getStatSpecifier();
                    lore.add(prefix + ChatColor.BLUE + (this.attributeValue > 0 ? "+" : "") + this.attributeValue + " " + WordUtils.capitalizeFully((String)specifier.getAttributeType().toString()));
                }

                @Override
                public boolean shouldAddLore() {
                    return this.attributeValue != 0;
                }
            };
        }

        @Override
        public void addTo(List<String> lore, Map<StatSpecifier<AttributeAttribute>, StatTotal<AttributeAttribute>> stats) {
            lore.add(ChatColor.GRAY + "Attributes when equipped:");
            stats.values().forEach(total -> total.addTo(lore, "  "));
        }
    }

    private static class HeroAttributeStatSpecifier
    implements StatSpecifier<AttributeAttribute> {
        private final AttributeType attributeType;

        public HeroAttributeStatSpecifier(AttributeType attributeType) {
            this.attributeType = attributeType;
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public int hashCode() {
            return this.attributeType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HeroAttributeStatSpecifier)) {
                return false;
            }
            HeroAttributeStatSpecifier other = (HeroAttributeStatSpecifier)obj;
            return this.attributeType == other.attributeType;
        }
    }

    public static class Factory
    extends BaseAttributeFactory<AttributeAttribute> {
        private static final StoredValue<Integer> ATTRIBUTE_VALUE = new StoredValue<Integer>("attribute-value", StoredValue.INTEGER, 0);

        public Factory(ItemPlugin plugin) {
            super(plugin);
        }

        @Override
        public AttributeAttribute loadFromConfig(Item item, String name, ConfigurationSection config) {
            String attributeTypeName = Objects.requireNonNull(config.getString("attribute-type"), "`attribute-type` not found");
            AttributeType attributeType = AttributeType.getAttribute(attributeTypeName);
            if (attributeType == null) {
                throw new RuntimeException("`" + attributeTypeName + "` does not represent an attribute type");
            }
            Value<Integer> attributeValue = ATTRIBUTE_VALUE.loadFromConfig(item, config);
            return new AttributeAttribute(item, name, attributeType, attributeValue);
        }

        @Override
        public AttributeAttribute loadFromNBT(Item item, String name, NBTTagCompound compound) {
            AttributeType attributeType = AttributeType.getAttribute(compound.getString("attribute-type"));
            Value<Integer> attributeValue = ATTRIBUTE_VALUE.loadFromNBT(item, compound);
            return new AttributeAttribute(item, name, attributeType, attributeValue);
        }
    }
}

